/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.meta.HotSpotConstantFieldProvider;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.SnippetCounter;

public class HotSpotGraalConstantFieldProvider
extends HotSpotConstantFieldProvider {
    private volatile List<ResolvedJavaField> nonEmbeddableFields;
    private final MetaAccessProvider metaAccess;
    private ResolvedJavaType cachedHotSpotVMConfigType;
    private ResolvedJavaType cachedSnippetCounterType;
    private ResolvedJavaType cachedNodeClassType;

    public HotSpotGraalConstantFieldProvider(GraalHotSpotVMConfig config, MetaAccessProvider metaAccess) {
        super(config, metaAccess);
        this.metaAccess = metaAccess;
    }

    @Override
    protected boolean isStaticFieldConstant(ResolvedJavaField field, OptionValues options) {
        return super.isStaticFieldConstant(field, options) && (GraalOptions.ImmutableCode.getValue(options) == false || this.isEmbeddableField(field));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEmbeddableField(ResolvedJavaField field) {
        if (!Services.IS_IN_NATIVE_IMAGE && (Services.IS_BUILDING_NATIVE_IMAGE || this.nonEmbeddableFields == null)) {
            HotSpotGraalConstantFieldProvider hotSpotGraalConstantFieldProvider = this;
            synchronized (hotSpotGraalConstantFieldProvider) {
                if (this.nonEmbeddableFields == null) {
                    ArrayList<ResolvedJavaField> fields = new ArrayList<ResolvedJavaField>();
                    try {
                        fields.add(this.metaAccess.lookupJavaField(Boolean.class.getDeclaredField("TRUE")));
                        fields.add(this.metaAccess.lookupJavaField(Boolean.class.getDeclaredField("FALSE")));
                        Class<?> characterCacheClass = Character.class.getDeclaredClasses()[0];
                        assert ("java.lang.Character$CharacterCache".equals(characterCacheClass.getName()));
                        fields.add(this.metaAccess.lookupJavaField(characterCacheClass.getDeclaredField("cache")));
                        Class<?> byteCacheClass = Byte.class.getDeclaredClasses()[0];
                        assert ("java.lang.Byte$ByteCache".equals(byteCacheClass.getName()));
                        fields.add(this.metaAccess.lookupJavaField(byteCacheClass.getDeclaredField("cache")));
                        Class<?> shortCacheClass = Short.class.getDeclaredClasses()[0];
                        assert ("java.lang.Short$ShortCache".equals(shortCacheClass.getName()));
                        fields.add(this.metaAccess.lookupJavaField(shortCacheClass.getDeclaredField("cache")));
                        Class<?> integerCacheClass = Integer.class.getDeclaredClasses()[0];
                        assert ("java.lang.Integer$IntegerCache".equals(integerCacheClass.getName()));
                        fields.add(this.metaAccess.lookupJavaField(integerCacheClass.getDeclaredField("cache")));
                        Class<?> longCacheClass = Long.class.getDeclaredClasses()[0];
                        assert ("java.lang.Long$LongCache".equals(longCacheClass.getName()));
                        fields.add(this.metaAccess.lookupJavaField(longCacheClass.getDeclaredField("cache")));
                        fields.add(this.metaAccess.lookupJavaField(Throwable.class.getDeclaredField("UNASSIGNED_STACK")));
                        fields.add(this.metaAccess.lookupJavaField(Throwable.class.getDeclaredField("SUPPRESSED_SENTINEL")));
                    }
                    catch (NoSuchFieldException | SecurityException e) {
                        throw new GraalError(e);
                    }
                    this.nonEmbeddableFields = fields;
                }
            }
        }
        return !this.nonEmbeddableFields.contains(field);
    }

    @Override
    protected boolean isFinalFieldValueConstant(ResolvedJavaField field, JavaConstant value, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        if (super.isFinalFieldValueConstant(field, value, tool)) {
            return true;
        }
        if (!field.isStatic()) {
            JavaConstant receiver = tool.getReceiver();
            if (this.getSnippetCounterType().isInstance(receiver) || this.getNodeClassType().isInstance(receiver)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isStableFieldValueConstant(ResolvedJavaField field, JavaConstant value, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        if (super.isStableFieldValueConstant(field, value, tool)) {
            return true;
        }
        if (!field.isStatic()) {
            JavaConstant receiver = tool.getReceiver();
            if (this.getHotSpotVMConfigType().isInstance(receiver)) {
                return true;
            }
        }
        return false;
    }

    private ResolvedJavaType getHotSpotVMConfigType() {
        if (this.cachedHotSpotVMConfigType == null) {
            this.cachedHotSpotVMConfigType = this.metaAccess.lookupJavaType(GraalHotSpotVMConfig.class);
        }
        return this.cachedHotSpotVMConfigType;
    }

    private ResolvedJavaType getSnippetCounterType() {
        if (this.cachedSnippetCounterType == null) {
            this.cachedSnippetCounterType = this.metaAccess.lookupJavaType(SnippetCounter.class);
        }
        return this.cachedSnippetCounterType;
    }

    private ResolvedJavaType getNodeClassType() {
        if (this.cachedNodeClassType == null) {
            this.cachedNodeClassType = this.metaAccess.lookupJavaType(NodeClass.class);
        }
        return this.cachedNodeClassType;
    }
}

