/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.util.function.Supplier;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotCompilationIdentifier;
import org.graalvm.compiler.hotspot.nodes.CurrentJavaThreadNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.word.LocationIdentity;
import sun.misc.Unsafe;

public final class HotSpotExceptionDispatchPlugin
implements NodePlugin {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    private final GraalHotSpotVMConfig config;
    private final JavaKind wordKind;
    private static final LocationIdentity JAVA_THREAD_SHOULD_POST_ON_EXCEPTIONS_FLAG_LOCATION = NamedLocationIdentity.mutable("JavaThread::_should_post_on_exceptions_flag");

    public HotSpotExceptionDispatchPlugin(GraalHotSpotVMConfig config, JavaKind wordKind) {
        this.config = config;
        this.wordKind = wordKind;
    }

    @Override
    public FixedWithNextNode instrumentExceptionDispatch(StructuredGraph graph, FixedWithNextNode afterExceptionLoaded, Supplier<FrameState> frameStateFunction) {
        CompilationIdentifier id = graph.compilationId();
        if (id instanceof HotSpotCompilationIdentifier && this.config.jvmciCompileStateCanPostOnExceptionsOffset != Integer.MIN_VALUE && this.config.javaThreadShouldPostOnExceptionsFlagOffset != Integer.MIN_VALUE) {
            long compileState;
            boolean canPostOnExceptions = Options.HotSpotPostOnExceptions.getValue(graph.getOptions());
            HotSpotCompilationRequest request = ((HotSpotCompilationIdentifier)id).getRequest();
            if (request != null && (compileState = request.getJvmciEnv()) != 0L) {
                long canPostOnExceptionsOffset = compileState + (long)this.config.jvmciCompileStateCanPostOnExceptionsOffset;
                boolean bl = canPostOnExceptions = UNSAFE.getByte(canPostOnExceptionsOffset) != 0;
            }
            if (canPostOnExceptions) {
                CurrentJavaThreadNode thread = graph.unique(new CurrentJavaThreadNode(this.wordKind));
                ValueNode offset = graph.unique(ConstantNode.forLong(this.config.javaThreadShouldPostOnExceptionsFlagOffset));
                AddressNode address = graph.unique(new OffsetAddressNode(thread, offset));
                ReadNode shouldPostException = graph.add(new ReadNode(address, JAVA_THREAD_SHOULD_POST_ON_EXCEPTIONS_FLAG_LOCATION, StampFactory.intValue(), OnHeapMemoryAccess.BarrierType.NONE));
                afterExceptionLoaded.setNext(shouldPostException);
                ValueNode zero = graph.unique(ConstantNode.forInt(0));
                LogicNode cond = graph.unique(new IntegerEqualsNode(shouldPostException, zero));
                FixedGuardNode check = graph.add(new FixedGuardNode(cond, DeoptimizationReason.TransferToInterpreter, DeoptimizationAction.None, false));
                FrameState fs = frameStateFunction.get();
                assert (fs.stackSize() == 1 && fs.rethrowException()) : "expected rethrow exception FrameState";
                check.setStateBefore(fs);
                shouldPostException.setNext(check);
                return check;
            }
        }
        return afterExceptionLoaded;
    }

    public static class Options {
        @Option(help={"Testing only option that forces deopts for exception throws"}, type=OptionType.Expert)
        public static final OptionKey<Boolean> HotSpotPostOnExceptions = new OptionKey<Boolean>(false);
    }
}

