/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotMathIntrinsicOp;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;

@NodeInfo(nameTemplate="X87MathIntrinsic#{p#operation/s}", cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_1)
public final class AMD64X87MathIntrinsicNode
extends UnaryNode
implements LIRLowerable {
    public static final NodeClass<AMD64X87MathIntrinsicNode> TYPE = NodeClass.create(AMD64X87MathIntrinsicNode.class);
    protected final UnaryMathIntrinsicNode.UnaryOperation operation;

    protected AMD64X87MathIntrinsicNode(ValueNode value, UnaryMathIntrinsicNode.UnaryOperation op) {
        super(TYPE, op.computeStamp(value.stamp(NodeView.DEFAULT)), value);
        assert (value.stamp(NodeView.DEFAULT) instanceof FloatStamp && PrimitiveStamp.getBits(value.stamp(NodeView.DEFAULT)) == 64);
        this.operation = op;
    }

    @Override
    public Stamp foldStamp(Stamp valueStamp) {
        return this.operation.computeStamp(valueStamp);
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        LIRGeneratorTool gen = generator.getLIRGeneratorTool();
        Value input = generator.operand(this.getValue());
        Variable result = gen.newVariable(LIRKind.combine(input));
        int wordSize = gen.target().wordSize;
        int slots = NumUtil.roundUp(AMD64Kind.DOUBLE.getSizeInBytes(), wordSize) / wordSize;
        VirtualStackSlot stack = gen.allocateStackSlots(slots);
        switch (this.operation) {
            case SIN: 
            case COS: 
            case TAN: 
            case LOG: 
            case LOG10: {
                gen.append(new AMD64HotSpotMathIntrinsicOp(this.operation, (Value)result, (Value)gen.asAllocatable(input), (Value)stack));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        generator.setResult(this, (Value)result);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue.isConstant()) {
            return ConstantNode.forDouble(this.operation.compute(forValue.asJavaConstant().asDouble()));
        }
        return this;
    }

    @Node.NodeIntrinsic
    public static native double compute(double var0, @Node.ConstantNodeParameter UnaryMathIntrinsicNode.UnaryOperation var2);
}

