/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public final class AMD64HotSpotLoadAddressOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64HotSpotLoadAddressOp> TYPE = LIRInstructionClass.create(AMD64HotSpotLoadAddressOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue result;
    private final Constant constant;
    private final Object note;

    public AMD64HotSpotLoadAddressOp(AllocatableValue result, Constant constant, Object note) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.result = result;
        this.constant = constant;
        this.note = note;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        crb.recordInlineDataInCodeWithNote(this.constant, this.note);
        AMD64Kind kind = (AMD64Kind)this.result.getPlatformKind();
        switch (kind) {
            case DWORD: {
                masm.movl(ValueUtil.asRegister((Value)this.result), masm.getPlaceholder(-1));
                break;
            }
            case QWORD: {
                masm.movq(ValueUtil.asRegister((Value)this.result), masm.getPlaceholder(-1));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("unexpected kind: " + kind);
            }
        }
    }
}

