/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotMarkId;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public final class AArch64HotSpotLoadConfigValueOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64HotSpotLoadConfigValueOp> TYPE = LIRInstructionClass.create(AArch64HotSpotLoadConfigValueOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue result;
    private final HotSpotMarkId markId;

    public AArch64HotSpotLoadConfigValueOp(HotSpotMarkId markId, AllocatableValue result) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.result = result;
        this.markId = markId;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        if (GraalOptions.GeneratePIC.getValue(crb.getOptions()).booleanValue()) {
            AArch64Kind kind = (AArch64Kind)this.result.getPlatformKind();
            Register reg = ValueUtil.asRegister((Value)this.result);
            masm.adrpAdd(reg);
            switch (kind) {
                case BYTE: {
                    masm.ldrs(32, 8, reg, AArch64Address.createBaseRegisterOnlyAddress(reg));
                    break;
                }
                case WORD: {
                    masm.ldrs(32, 16, reg, AArch64Address.createBaseRegisterOnlyAddress(reg));
                    break;
                }
                case DWORD: {
                    masm.ldr(32, reg, AArch64Address.createBaseRegisterOnlyAddress(reg));
                    break;
                }
                case QWORD: {
                    masm.ldr(64, reg, AArch64Address.createBaseRegisterOnlyAddress(reg));
                    break;
                }
                default: {
                    throw GraalError.unimplemented();
                }
            }
        } else {
            throw GraalError.unimplemented();
        }
        masm.nop();
        crb.recordMark(this.markId);
    }
}

