/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import java.lang.reflect.Modifier;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotSentinelConstant;
import jdk.vm.ci.hotspot.aarch64.AArch64HotSpotRegisterConfig;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.asm.BranchTargetOutOfBoundsException;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.aarch64.AArch64NodeMatchRules;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.alloc.RegisterAllocationConfig;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.gen.LIRGenerationProvider;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotDataBuilder;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotHostBackend;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerationResult;
import org.graalvm.compiler.hotspot.HotSpotMarkId;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotMove;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotNodeLIRBuilder;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotRegisterAllocationConfig;
import org.graalvm.compiler.hotspot.meta.HotSpotConstantLoadAction;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.aarch64.AArch64Call;
import org.graalvm.compiler.lir.aarch64.AArch64FrameMap;
import org.graalvm.compiler.lir.aarch64.AArch64FrameMapBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.framemap.FrameMapBuilder;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

public class AArch64HotSpotBackend
extends HotSpotHostBackend
implements LIRGenerationProvider {
    public AArch64HotSpotBackend(GraalHotSpotVMConfig config, HotSpotGraalRuntimeProvider runtime, HotSpotProviders providers) {
        super(config, runtime, providers);
    }

    @Override
    protected FrameMapBuilder newFrameMapBuilder(RegisterConfig registerConfig) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        AArch64FrameMap frameMap = new AArch64FrameMap(this.getCodeCache(), registerConfigNonNull, this);
        return new AArch64FrameMapBuilder(frameMap, this.getCodeCache(), registerConfigNonNull);
    }

    @Override
    public LIRGeneratorTool newLIRGenerator(LIRGenerationResult lirGenRes) {
        return new AArch64HotSpotLIRGenerator(this.getProviders(), this.config, lirGenRes);
    }

    @Override
    public NodeLIRBuilderTool newNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool lirGen) {
        return new AArch64HotSpotNodeLIRBuilder(graph, lirGen, new AArch64NodeMatchRules(lirGen));
    }

    @Override
    protected void bangStackWithOffset(CompilationResultBuilder crb, int bangOffset) {
        AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
        boolean allowOverwrite = false;
        try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
            Register scratch = sc.getRegister();
            AArch64Address address = masm.makeAddress(AArch64.sp, -bangOffset, scratch, 8, allowOverwrite);
            masm.str(64, AArch64.zr, address);
        }
    }

    @Override
    public InstalledCode createInstalledCode(DebugContext debug, ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult, InstalledCode predefinedInstalledCode, boolean isDefault, Object[] context) {
        boolean isStub = method == null;
        boolean isAOT = compilationResult.isImmutablePIC();
        if (!isStub && !isAOT) assert (this.hasInvalidatePlaceholder(compilationResult));
        return super.createInstalledCode(debug, method, compilationRequest, compilationResult, predefinedInstalledCode, isDefault, context);
    }

    private boolean hasInvalidatePlaceholder(CompilationResult compilationResult) {
        byte[] targetCode = compilationResult.getTargetCode();
        int verifiedEntryOffset = 0;
        for (CompilationResult.CodeMark mark : compilationResult.getMarks()) {
            if (mark.id != HotSpotMarkId.VERIFIED_ENTRY && mark.id != HotSpotMarkId.OSR_ENTRY) continue;
            verifiedEntryOffset = mark.pcOffset;
            break;
        }
        Unsafe unsafe = GraalUnsafeAccess.getUnsafe();
        int instruction = unsafe.getIntVolatile(targetCode, unsafe.arrayBaseOffset(byte[].class) + verifiedEntryOffset);
        AArch64MacroAssembler masm = new AArch64MacroAssembler(this.getTarget());
        masm.nop();
        return instruction == masm.getInt(0);
    }

    @Override
    public CompilationResultBuilder newCompilationResultBuilder(LIRGenerationResult lirGenRen, FrameMap frameMap, CompilationResult compilationResult, CompilationResultBuilderFactory factory) {
        HotSpotLIRGenerationResult gen = (HotSpotLIRGenerationResult)lirGenRen;
        LIR lir = gen.getLIR();
        assert (gen.getDeoptimizationRescueSlot() == null || frameMap.frameNeedsAllocating()) : "method that can deoptimize must have a frame";
        Stub stub = gen.getStub();
        AArch64MacroAssembler masm = new AArch64MacroAssembler(this.getTarget());
        HotSpotFrameContext frameContext = new HotSpotFrameContext(stub != null);
        HotSpotDataBuilder dataBuilder = new HotSpotDataBuilder(this.getCodeCache().getTarget());
        CompilationResultBuilder crb = factory.createBuilder(this.getProviders(), frameMap, masm, dataBuilder, frameContext, lir.getOptions(), lir.getDebug(), compilationResult, Register.None);
        crb.setTotalFrameSize(frameMap.totalFrameSize());
        crb.setMaxInterpreterFrameSize(gen.getMaxInterpreterFrameSize());
        StackSlot deoptimizationRescueSlot = gen.getDeoptimizationRescueSlot();
        if (deoptimizationRescueSlot != null && stub == null) {
            crb.compilationResult.setCustomStackAreaOffset(deoptimizationRescueSlot);
        }
        if (stub != null) {
            this.updateStub(stub, gen, frameMap);
        }
        return crb;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, LIR lir, ResolvedJavaMethod installedCodeOwner) {
        Label verifiedStub = new Label();
        crb.buildLabelOffsets(lir);
        try {
            this.emitCode(crb, lir, installedCodeOwner, verifiedStub);
        }
        catch (BranchTargetOutOfBoundsException e) {
            crb.setConservativeLabelRanges();
            crb.resetForEmittingCode();
            lir.resetLabels();
            verifiedStub.reset();
            this.emitCode(crb, lir, installedCodeOwner, verifiedStub);
        }
    }

    private void emitCode(CompilationResultBuilder crb, LIR lir, ResolvedJavaMethod installedCodeOwner, Label verifiedStub) {
        AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
        FrameMap frameMap = crb.frameMap;
        RegisterConfig regConfig = frameMap.getRegisterConfig();
        this.emitCodePrefix(crb, installedCodeOwner, masm, regConfig, verifiedStub);
        AArch64HotSpotBackend.emitCodeBody(crb, lir, masm);
        this.emitCodeSuffix(crb, masm, frameMap);
    }

    private void emitCodePrefix(CompilationResultBuilder crb, ResolvedJavaMethod installedCodeOwner, AArch64MacroAssembler masm, RegisterConfig regConfig, Label verifiedStub) {
        HotSpotProviders providers = this.getProviders();
        if (installedCodeOwner != null && !Modifier.isStatic(installedCodeOwner.getModifiers())) {
            crb.recordMark(HotSpotMarkId.UNVERIFIED_ENTRY);
            CallingConvention cc = regConfig.getCallingConvention((CallingConvention.Type)HotSpotCallingConventionType.JavaCallee, null, new JavaType[]{providers.getMetaAccess().lookupJavaType(Object.class)}, (ValueKindFactory)this);
            Register inlineCacheKlass = AArch64HotSpotRegisterConfig.inlineCacheRegister;
            Register receiver = ValueUtil.asRegister((Value)cc.getArgument(0));
            int transferSize = this.config.useCompressedClassPointers ? 4 : 8;
            AArch64Address klassAddress = masm.makeAddress(receiver, this.config.hubOffset, transferSize);
            Register klass = AArch64.r10;
            if (this.config.useCompressedClassPointers) {
                masm.ldr(32, klass, klassAddress);
                AArch64HotSpotMove.decodeKlassPointer(crb, masm, klass, klass, this.config.getKlassEncoding());
            } else {
                masm.ldr(64, klass, klassAddress);
            }
            masm.cmp(64, inlineCacheKlass, klass);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, verifiedStub);
            AArch64Call.directJmp(crb, masm, this.getForeignCalls().lookupForeignCall(IC_MISS_HANDLER));
        }
        masm.align(this.config.codeEntryAlignment);
        masm.bind(verifiedStub);
        crb.recordMark(crb.compilationResult.getEntryBCI() != -1 ? HotSpotMarkId.OSR_ENTRY : HotSpotMarkId.VERIFIED_ENTRY);
        if (GraalOptions.GeneratePIC.getValue(crb.getOptions()).booleanValue()) {
            HotSpotFrameContext frameContext = (HotSpotFrameContext)crb.frameContext;
            if (!frameContext.isStub) {
                crb.recordInlineDataInCodeWithNote((Constant)new HotSpotSentinelConstant((ValueKind)LIRKind.value((PlatformKind)AArch64Kind.QWORD), JavaKind.Long), (Object)HotSpotConstantLoadAction.MAKE_NOT_ENTRANT);
                try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                    Register scratch = sc.getRegister();
                    masm.adrpAdd(scratch);
                    masm.ldr(64, scratch, AArch64Address.createBaseRegisterOnlyAddress(scratch));
                    Label noCall = new Label();
                    masm.cbz(64, scratch, noCall);
                    AArch64Call.directJmp(crb, masm, this.getForeignCalls().lookupForeignCall(WRONG_METHOD_HANDLER));
                    masm.bind(noCall);
                }
            }
        }
    }

    private static void emitCodeBody(CompilationResultBuilder crb, LIR lir, AArch64MacroAssembler masm) {
        AArch64HotSpotBackend.emitInvalidatePlaceholder(crb, masm);
        crb.emit(lir);
    }

    public static void emitInvalidatePlaceholder(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        if (!GraalOptions.GeneratePIC.getValue(crb.getOptions()).booleanValue()) {
            crb.blockComment("[nop for method invalidation]");
            masm.nop();
        }
    }

    private void emitCodeSuffix(CompilationResultBuilder crb, AArch64MacroAssembler masm, FrameMap frameMap) {
        HotSpotProviders providers = this.getProviders();
        HotSpotFrameContext frameContext = (HotSpotFrameContext)crb.frameContext;
        if (!frameContext.isStub) {
            Register scratch2;
            Throwable throwable;
            AArch64MacroAssembler.ScratchRegister sc;
            HotSpotHostForeignCallsProvider foreignCalls = providers.getForeignCalls();
            if (crb.getPendingImplicitExceptionList() != null) {
                sc = masm.getScratchRegister();
                throwable = null;
                try {
                    scratch2 = sc.getRegister();
                    for (CompilationResultBuilder.PendingImplicitException pendingImplicitException : crb.getPendingImplicitExceptionList()) {
                        int pos = masm.position();
                        Register thread = this.getProviders().getRegisters().getThreadRegister();
                        int dwordSizeInBits = AArch64Kind.DWORD.getSizeInBytes() * 8;
                        AArch64Address pendingDeoptimization = AArch64Address.createImmediateAddress(dwordSizeInBits, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, thread, this.config.pendingDeoptimizationOffset);
                        masm.mov(scratch2, pendingImplicitException.state.deoptReasonAndAction.asInt());
                        masm.str(dwordSizeInBits, scratch2, pendingDeoptimization);
                        JavaConstant deoptSpeculation = pendingImplicitException.state.deoptSpeculation;
                        if (deoptSpeculation.getJavaKind() == JavaKind.Long) {
                            int qwordSizeInBits = AArch64Kind.QWORD.getSizeInBytes() * 8;
                            AArch64Address pendingSpeculation = AArch64Address.createImmediateAddress(qwordSizeInBits, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, thread, this.config.pendingFailedSpeculationOffset);
                            masm.mov(scratch2, pendingImplicitException.state.deoptSpeculation.asLong());
                            masm.str(qwordSizeInBits, scratch2, pendingSpeculation);
                        } else {
                            assert (deoptSpeculation.getJavaKind() == JavaKind.Int);
                            AArch64Address pendingSpeculation = AArch64Address.createImmediateAddress(dwordSizeInBits, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, thread, this.config.pendingFailedSpeculationOffset);
                            masm.mov(scratch2, pendingImplicitException.state.deoptSpeculation.asInt());
                            masm.str(dwordSizeInBits, scratch2, pendingSpeculation);
                        }
                        ForeignCallLinkage uncommonTrapBlob = foreignCalls.lookupForeignCall(DEOPT_BLOB_UNCOMMON_TRAP);
                        Register helper = AArch64Call.isNearCall(uncommonTrapBlob) ? null : scratch2;
                        AArch64Call.directCall(crb, masm, uncommonTrapBlob, helper, pendingImplicitException.state);
                        crb.recordImplicitException(pendingImplicitException.codeOffset, pos, pendingImplicitException.state);
                    }
                }
                catch (Throwable scratch2) {
                    throwable = scratch2;
                    throw scratch2;
                }
                finally {
                    if (sc != null) {
                        if (throwable != null) {
                            try {
                                sc.close();
                            }
                            catch (Throwable scratch2) {
                                throwable.addSuppressed(scratch2);
                            }
                        } else {
                            sc.close();
                        }
                    }
                }
            }
            sc = masm.getScratchRegister();
            throwable = null;
            try {
                scratch2 = sc.getRegister();
                crb.recordMark(HotSpotMarkId.EXCEPTION_HANDLER_ENTRY);
                ForeignCallLinkage linkage = foreignCalls.lookupForeignCall(EXCEPTION_HANDLER);
                Register helper = AArch64Call.isNearCall(linkage) ? null : scratch2;
                AArch64Call.directCall(crb, masm, linkage, helper, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sc != null) {
                    if (throwable != null) {
                        try {
                            sc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        sc.close();
                    }
                }
            }
            crb.recordMark(HotSpotMarkId.DEOPT_HANDLER_ENTRY);
            ForeignCallLinkage linkage = foreignCalls.lookupForeignCall(DEOPT_BLOB_UNPACK);
            masm.adr(AArch64.lr, 0);
            AArch64Call.directJmp(crb, masm, linkage);
            if (this.config.supportsMethodHandleDeoptimizationEntry() && crb.needsMHDeoptHandler()) {
                crb.recordMark(HotSpotMarkId.DEOPT_MH_HANDLER_ENTRY);
                masm.adr(AArch64.lr, 0);
                AArch64Call.directJmp(crb, masm, linkage);
            }
        } else assert (!frameMap.accessesCallerFrame());
    }

    @Override
    public RegisterAllocationConfig newRegisterAllocationConfig(RegisterConfig registerConfig, String[] allocationRestrictedTo) {
        RegisterConfig registerConfigNonNull = registerConfig == null ? this.getCodeCache().getRegisterConfig() : registerConfig;
        return new AArch64HotSpotRegisterAllocationConfig(registerConfigNonNull, allocationRestrictedTo);
    }

    @Override
    public EconomicSet<Register> translateToCallerRegisters(EconomicSet<Register> calleeRegisters) {
        return calleeRegisters;
    }

    private class HotSpotFrameContext
    implements FrameContext {
        final boolean isStub;

        HotSpotFrameContext(boolean isStub) {
            this.isStub = isStub;
        }

        @Override
        public void enter(CompilationResultBuilder crb) {
            FrameMap frameMap = crb.frameMap;
            int frameSize = frameMap.frameSize();
            int totalFrameSize = frameMap.totalFrameSize();
            assert (frameSize + 2 * crb.target.arch.getWordSize() == totalFrameSize) : "total framesize should be framesize + 2 words";
            AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
            if (!this.isStub) {
                AArch64HotSpotBackend.this.emitStackOverflowCheck(crb);
            }
            crb.blockComment("[method prologue]");
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                int wordSize = 8;
                Register scratch = sc.getRegister();
                assert (totalFrameSize > 0);
                AArch64Address.AddressingMode addressingMode = AArch64Address.AddressingMode.IMMEDIATE_PAIR_SIGNED_SCALED;
                if (AArch64Address.isValidImmediateAddress(64, addressingMode, frameSize)) {
                    masm.sub(64, AArch64.sp, AArch64.sp, totalFrameSize);
                    masm.stp(64, AArch64HotSpotRegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress(64, addressingMode, AArch64.sp, frameSize));
                } else {
                    int frameRecordSize = 2 * wordSize;
                    masm.stp(64, AArch64HotSpotRegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_PAIR_PRE_INDEXED, AArch64.sp, -frameRecordSize));
                    masm.sub(64, AArch64.sp, AArch64.sp, totalFrameSize - frameRecordSize, scratch);
                }
            }
            if (HotSpotMarkId.FRAME_COMPLETE.isAvailable()) {
                crb.recordMark(HotSpotMarkId.FRAME_COMPLETE);
            }
            if (GraalOptions.ZapStackOnMethodEntry.getValue(crb.getOptions()).booleanValue()) {
                sc = masm.getScratchRegister();
                var7_7 = null;
                try {
                    Register scratch = sc.getRegister();
                    int longSize = 8;
                    masm.mov(64, scratch, AArch64.sp);
                    AArch64Address address = AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, scratch, longSize);
                    try (AArch64MacroAssembler.ScratchRegister sc2 = masm.getScratchRegister();){
                        Register value = sc2.getRegister();
                        masm.mov(value, 841573668843749358L);
                        for (int i = 0; i < frameSize; i += longSize) {
                            masm.str(64, value, address);
                        }
                    }
                }
                catch (Throwable throwable) {
                    var7_7 = throwable;
                    throw throwable;
                }
                finally {
                    if (sc != null) {
                        if (var7_7 != null) {
                            try {
                                sc.close();
                            }
                            catch (Throwable throwable) {
                                var7_7.addSuppressed(throwable);
                            }
                        } else {
                            sc.close();
                        }
                    }
                }
            }
            crb.blockComment("[code body]");
        }

        @Override
        public void leave(CompilationResultBuilder crb) {
            AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
            FrameMap frameMap = crb.frameMap;
            int totalFrameSize = frameMap.totalFrameSize();
            crb.blockComment("[method epilogue]");
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                int wordSize = 8;
                Register scratch = sc.getRegister();
                int frameSize = frameMap.frameSize();
                assert (totalFrameSize > 0);
                AArch64Address.AddressingMode addressingMode = AArch64Address.AddressingMode.IMMEDIATE_PAIR_SIGNED_SCALED;
                if (AArch64Address.isValidImmediateAddress(64, addressingMode, frameSize)) {
                    masm.ldp(64, AArch64HotSpotRegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress(64, addressingMode, AArch64.sp, frameSize));
                    masm.add(64, AArch64.sp, AArch64.sp, totalFrameSize);
                } else {
                    int frameRecordSize = 2 * wordSize;
                    masm.add(64, AArch64.sp, AArch64.sp, totalFrameSize - frameRecordSize, scratch);
                    masm.ldp(64, AArch64HotSpotRegisterConfig.fp, AArch64.lr, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_PAIR_POST_INDEXED, AArch64.sp, frameRecordSize));
                }
            }
        }

        @Override
        public void returned(CompilationResultBuilder crb) {
        }

        @Override
        public boolean hasFrame() {
            return true;
        }
    }
}

