/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JVMCIVersionCheck {
    private static final Version JVMCI_MIN_VERSION = new Version3(20, 2, 1);
    public static final String JVMCI8_RELEASES_URL = "https://github.com/graalvm/graal-jvmci-8/releases";
    public static final String JVMCI11_RELEASES_URL = "https://github.com/graalvm/labs-openjdk-11/releases";
    private final String javaSpecVersion;
    private final String vmVersion;
    private final Map<String, String> props;

    private void failVersionCheck(boolean exit, String reason, Object ... args) {
        Formatter errorMessage = new Formatter().format(reason, args);
        String javaHome = this.props.get("java.home");
        String vmName = this.props.get("java.vm.name");
        errorMessage.format("Set the JVMCI_VERSION_CHECK environment variable to \"ignore\" to suppress ", new Object[0]);
        errorMessage.format("this error or to \"warn\" to emit a warning and continue execution.%n", new Object[0]);
        errorMessage.format("Currently used Java home directory is %s.%n", javaHome);
        errorMessage.format("Currently used VM configuration is: %s%n", vmName);
        if (this.javaSpecVersion.compareTo("1.9") < 0) {
            errorMessage.format("Download the latest JVMCI JDK 8 from https://github.com/graalvm/graal-jvmci-8/releases", new Object[0]);
        } else if (this.javaSpecVersion.compareTo("11") == 0 && this.vmVersion.contains("-jvmci-")) {
            errorMessage.format("Download the latest Labs OpenJDK 11 from https://github.com/graalvm/labs-openjdk-11/releases", new Object[0]);
        } else {
            errorMessage.format("Download JDK 11 or later.", new Object[0]);
        }
        String value = System.getenv("JVMCI_VERSION_CHECK");
        if ("warn".equals(value)) {
            System.err.println(errorMessage.toString());
        } else {
            if ("ignore".equals(value)) {
                return;
            }
            if (exit) {
                System.err.println(errorMessage.toString());
                System.exit(-1);
            } else {
                throw new InternalError(errorMessage.toString());
            }
        }
    }

    private JVMCIVersionCheck(Map<String, String> props, String javaSpecVersion, String vmVersion) {
        this.props = props;
        this.javaSpecVersion = javaSpecVersion;
        this.vmVersion = vmVersion;
    }

    static void check(Map<String, String> props, boolean exitOnFailure) {
        JVMCIVersionCheck checker = new JVMCIVersionCheck(props, props.get("java.specification.version"), props.get("java.vm.version"));
        checker.run(exitOnFailure, JVMCI_MIN_VERSION);
    }

    public static void check(Map<String, String> props, Version minVersion, String javaSpecVersion, String javaVmVersion, boolean exitOnFailure) {
        JVMCIVersionCheck checker = new JVMCIVersionCheck(props, javaSpecVersion, javaVmVersion);
        checker.run(exitOnFailure, minVersion);
    }

    private void run(boolean exitOnFailure, Version minVersion) {
        if (this.javaSpecVersion.compareTo("1.9") < 0) {
            Version v = Version.parse(this.vmVersion);
            if (v != null) {
                if (v.isLessThan(minVersion)) {
                    this.failVersionCheck(exitOnFailure, "The VM does not support the minimum JVMCI API version required by Graal: %s < %s.%n", v, minVersion);
                }
                return;
            }
            this.failVersionCheck(exitOnFailure, "The VM does not support the minimum JVMCI API version required by Graal.%nCannot read JVMCI version from java.vm.version property: %s.%n", this.vmVersion);
        } else if (this.javaSpecVersion.compareTo("11") < 0) {
            this.failVersionCheck(exitOnFailure, "Graal is not compatible with the JVMCI API in JDK 9 and 10.%n", new Object[0]);
        } else {
            if (this.vmVersion.contains("SNAPSHOT")) {
                return;
            }
            if (this.vmVersion.contains("internal")) {
                return;
            }
            if (this.vmVersion.contains("-jvmci-")) {
                Version v = Version.parse(this.vmVersion);
                if (v != null) {
                    if (v.isLessThan(minVersion)) {
                        this.failVersionCheck(exitOnFailure, "The VM does not support the minimum JVMCI API version required by Graal: %s < %s.%n", v, minVersion);
                    }
                    return;
                }
                this.failVersionCheck(exitOnFailure, "The VM does not support the minimum JVMCI API version required by Graal.%nCannot read JVMCI version from java.vm.version property: %s.%n", this.vmVersion);
            }
        }
    }

    public static void main(String[] args) {
        Properties sprops = System.getProperties();
        HashMap<String, String> props = new HashMap<String, String>(sprops.size());
        for (String name : sprops.stringPropertyNames()) {
            props.put(name, sprops.getProperty(name));
        }
        JVMCIVersionCheck.check(props, true);
    }

    public static class Version3
    implements Version {
        private final int major;
        private final int minor;
        private final int build;

        public Version3(int major, int minor, int build) {
            this.major = major;
            this.minor = minor;
            this.build = build;
        }

        @Override
        public boolean isLessThan(Version other) {
            if (other.getClass() == Version2.class) {
                return false;
            }
            Version3 o = (Version3)other;
            if (this.major < o.major) {
                return true;
            }
            if (this.major == o.major) {
                if (this.minor < o.minor) {
                    return true;
                }
                if (this.minor == o.minor && this.build < o.build) {
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Version3) {
                Version3 that = (Version3)obj;
                return this.major == that.major && this.minor == that.minor && this.build == that.build;
            }
            return false;
        }

        public int hashCode() {
            return this.major ^ this.minor ^ this.build;
        }

        public String toString() {
            return String.format("%d.%d-b%02d", this.major, this.minor, this.build);
        }
    }

    public static class Version2
    implements Version {
        private final int major;
        private final int minor;

        public Version2(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        @Override
        public boolean isLessThan(Version other) {
            if (other.getClass() == Version3.class) {
                return true;
            }
            Version2 o = (Version2)other;
            if (this.major < o.major) {
                return true;
            }
            return this.major == o.major && this.minor < o.minor;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Version2) {
                Version2 that = (Version2)obj;
                return this.major == that.major && this.minor == that.minor;
            }
            return false;
        }

        public int hashCode() {
            return this.major ^ this.minor;
        }

        public String toString() {
            if (this.major >= 19) {
                return String.format("%d-b%02d", this.major, this.minor);
            }
            return String.format("%d.%d", this.major, this.minor);
        }
    }

    public static interface Version {
        public boolean isLessThan(Version var1);

        default public boolean isGreaterThan(Version other) {
            if (!this.isLessThan(other)) {
                return !this.equals(other);
            }
            return false;
        }

        public static Version parse(String vmVersion) {
            Matcher m = Pattern.compile(".*-jvmci-(\\d+)\\.(\\d+)-b(\\d+).*").matcher(vmVersion);
            if (m.matches()) {
                try {
                    int major = Integer.parseInt(m.group(1));
                    int minor = Integer.parseInt(m.group(2));
                    int build = Integer.parseInt(m.group(3));
                    return new Version3(major, minor, build);
                }
                catch (NumberFormatException major) {
                    // empty catch block
                }
            }
            if ((m = Pattern.compile(".*-jvmci-(\\d+)(?:\\.|-b)(\\d+).*").matcher(vmVersion)).matches()) {
                try {
                    int major = Integer.parseInt(m.group(1));
                    int minor = Integer.parseInt(m.group(2));
                    return new Version2(major, minor);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

