/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.ArrayList;
import jdk.vm.ci.code.Location;
import jdk.vm.ci.code.ReferenceMap;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotReferenceMap;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.framemap.ReferenceMapBuilder;

public final class HotSpotReferenceMapBuilder
extends ReferenceMapBuilder {
    private int maxRegisterSize;
    private final ArrayList<Value> objectValues;
    private int objectCount;
    private final int totalFrameSize;
    private final int maxOopMapStackOffset;
    private final int uncompressedReferenceSize;
    private static final Location[] NO_LOCATIONS = new Location[0];
    private static final int[] NO_SIZES = new int[0];

    public HotSpotReferenceMapBuilder(int totalFrameSize, int maxOopMapStackOffset, int uncompressedReferenceSize) {
        this.uncompressedReferenceSize = uncompressedReferenceSize;
        this.objectValues = new ArrayList();
        this.objectCount = 0;
        this.maxOopMapStackOffset = maxOopMapStackOffset;
        this.totalFrameSize = totalFrameSize;
    }

    @Override
    public void addLiveValue(Value v) {
        int size;
        if (LIRValueUtil.isJavaConstant(v)) {
            return;
        }
        LIRKind lirKind = (LIRKind)v.getValueKind();
        if (!lirKind.isValue()) {
            this.objectValues.add(v);
            this.objectCount = lirKind.isUnknownReference() ? ++this.objectCount : (this.objectCount += lirKind.getReferenceCount());
        }
        if (ValueUtil.isRegister((Value)v) && (size = lirKind.getPlatformKind().getSizeInBytes()) > this.maxRegisterSize) {
            this.maxRegisterSize = size;
        }
    }

    @Override
    public ReferenceMap finish(LIRFrameState state) {
        int[] sizeInBytes;
        Location[] derivedBase;
        Location[] objects;
        if (this.objectCount == 0) {
            objects = NO_LOCATIONS;
            derivedBase = NO_LOCATIONS;
            sizeInBytes = NO_SIZES;
        } else {
            objects = new Location[this.objectCount];
            derivedBase = new Location[this.objectCount];
            sizeInBytes = new int[this.objectCount];
        }
        int idx = 0;
        for (Value obj : this.objectValues) {
            LIRKind kind = (LIRKind)obj.getValueKind();
            int bytes = HotSpotReferenceMapBuilder.bytesPerElement(kind);
            if (kind.isUnknownReference()) {
                throw GraalError.shouldNotReachHere(String.format("unknown reference alive across safepoint: %s", obj));
            }
            Location base = null;
            if (kind.isDerivedReference()) {
                Variable baseVariable = LIRValueUtil.asVariable((Value)kind.getDerivedReferenceBase());
                Value baseValue = state.getLiveBasePointers().get(baseVariable.index);
                assert (baseValue.getPlatformKind().getVectorLength() == 1 && ((LIRKind)baseValue.getValueKind()).isReference(0) && !((LIRKind)baseValue.getValueKind()).isDerivedReference());
                base = this.toLocation(baseValue, 0);
            }
            for (int i = 0; i < kind.getPlatformKind().getVectorLength(); ++i) {
                if (!kind.isReference(i)) continue;
                assert (!kind.isCompressedReference(i) ? bytes == this.uncompressedReferenceSize : bytes < this.uncompressedReferenceSize);
                objects[idx] = this.toLocation(obj, i * bytes);
                derivedBase[idx] = base;
                sizeInBytes[idx] = bytes;
                ++idx;
            }
        }
        return new HotSpotReferenceMap(objects, derivedBase, sizeInBytes, this.maxRegisterSize);
    }

    private static int bytesPerElement(LIRKind kind) {
        PlatformKind platformKind = kind.getPlatformKind();
        return platformKind.getSizeInBytes() / platformKind.getVectorLength();
    }

    private Location toLocation(Value v, int offset) {
        if (ValueUtil.isRegister((Value)v)) {
            return Location.subregister((Register)ValueUtil.asRegister((Value)v), (int)offset);
        }
        StackSlot s = ValueUtil.asStackSlot((Value)v);
        int totalOffset = s.getOffset(this.totalFrameSize) + offset;
        if (totalOffset > this.maxOopMapStackOffset) {
            throw new PermanentBailoutException("stack offset %d for oopmap is greater than encoding limit %d", totalOffset, this.maxOopMapStackOffset);
        }
        return Location.stack((int)totalOffset);
    }
}

