/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.Arrays;
import jdk.vm.ci.meta.AllocatableValue;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.framemap.FrameMapBuilder;

public class HotSpotLockStack
extends LIRInstruction {
    public static final LIRInstructionClass<HotSpotLockStack> TYPE = LIRInstructionClass.create(HotSpotLockStack.class);
    private static final AllocatableValue[] EMPTY = new AllocatableValue[0];
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.STACK})
    private AllocatableValue[] locks;
    private final FrameMapBuilder frameMapBuilder;
    private final LIRKind slotKind;

    public HotSpotLockStack(FrameMapBuilder frameMapBuilder, LIRKind slotKind) {
        super(TYPE);
        this.frameMapBuilder = frameMapBuilder;
        this.slotKind = slotKind;
        this.locks = EMPTY;
    }

    public VirtualStackSlot makeLockSlot(int lockDepth) {
        if (this.locks == EMPTY) {
            this.locks = new AllocatableValue[lockDepth + 1];
        } else if (this.locks.length < lockDepth + 1) {
            this.locks = Arrays.copyOf(this.locks, lockDepth + 1);
        }
        if (this.locks[lockDepth] == null) {
            this.locks[lockDepth] = this.frameMapBuilder.allocateSpillSlot(this.slotKind);
        }
        return (VirtualStackSlot)this.locks[lockDepth];
    }

    @Override
    public void emitCode(CompilationResultBuilder crb) {
    }
}

