/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.io.PrintStream;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.hotspot.HotSpotCompilationRequestResult;
import jdk.vm.ci.hotspot.HotSpotInstalledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.CompilationPrinter;
import org.graalvm.compiler.core.CompilationWrapper;
import org.graalvm.compiler.core.GraalCompilerOptions;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.phases.HighTier;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugDumpScope;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.hotspot.CompilationStatistics;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotCompilationIdentifier;
import org.graalvm.compiler.hotspot.HotSpotGraalCompiler;
import org.graalvm.compiler.hotspot.HotSpotGraalCompilerFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;

public class CompilationTask {
    private final HotSpotJVMCIRuntime jvmciRuntime;
    private final HotSpotGraalCompiler compiler;
    private final HotSpotCompilationIdentifier compilationId;
    private HotSpotInstalledCode installedCode;
    private final boolean installAsDefault;
    private final boolean useProfilingInfo;
    private final boolean shouldRetainLocalVariables;
    public static final TimerKey CompilationTime = DebugContext.timer("CompilationTime").doc("Time spent in compilation and code installation.");
    private static final CounterKey CompiledBytecodes = DebugContext.counter("CompiledBytecodes");
    public static final CounterKey CompiledAndInstalledBytecodes = DebugContext.counter("CompiledAndInstalledBytecodes");
    private static final CounterKey InstalledCodeSize = DebugContext.counter("InstalledCodeSize");
    public static final TimerKey CodeInstallationTime = DebugContext.timer("CodeInstallation");

    public CompilationTask(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalCompiler compiler, HotSpotCompilationRequest request, boolean useProfilingInfo, boolean installAsDefault) {
        this(jvmciRuntime, compiler, request, useProfilingInfo, false, installAsDefault);
    }

    public CompilationTask(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalCompiler compiler, HotSpotCompilationRequest request, boolean useProfilingInfo, boolean shouldRetainLocalVariables, boolean installAsDefault) {
        this.jvmciRuntime = jvmciRuntime;
        this.compiler = compiler;
        this.compilationId = new HotSpotCompilationIdentifier(request);
        this.useProfilingInfo = useProfilingInfo;
        this.shouldRetainLocalVariables = shouldRetainLocalVariables;
        this.installAsDefault = installAsDefault;
    }

    public OptionValues filterOptions(OptionValues options) {
        HotSpotGraalRuntimeProvider graalRuntime = this.compiler.getGraalRuntime();
        GraalHotSpotVMConfig config = graalRuntime.getVMConfig();
        OptionValues newOptions = options;
        if (!config.inline) {
            EconomicMap<OptionKey<?>, Object> m = OptionValues.newOptionMap();
            if (HighTier.Options.Inline.getValue(options).booleanValue() && !HighTier.Options.Inline.hasBeenSet(options)) {
                m.put(HighTier.Options.Inline, (Object)false);
            }
            if (BytecodeParserOptions.InlineDuringParsing.getValue(options).booleanValue() && !BytecodeParserOptions.InlineDuringParsing.hasBeenSet(options)) {
                m.put(BytecodeParserOptions.InlineDuringParsing, (Object)false);
            }
            if (!m.isEmpty()) {
                newOptions = new OptionValues(options, (UnmodifiableEconomicMap<OptionKey<?>, Object>)m);
            }
        }
        return newOptions;
    }

    public HotSpotResolvedJavaMethod getMethod() {
        return this.getRequest().getMethod();
    }

    CompilationIdentifier getCompilationIdentifier() {
        return this.compilationId;
    }

    public int getId() {
        return this.getRequest().getId();
    }

    public int getEntryBCI() {
        return this.getRequest().getEntryBCI();
    }

    public String getIdString() {
        if (this.getEntryBCI() != -1) {
            return this.getId() + "%";
        }
        return Integer.toString(this.getId());
    }

    public HotSpotInstalledCode getInstalledCode() {
        return this.installedCode;
    }

    public HotSpotCompilationRequestResult runCompilation(OptionValues initialOptions) {
        OptionValues options = this.filterOptions(initialOptions);
        HotSpotGraalRuntimeProvider graalRuntime = this.compiler.getGraalRuntime();
        try (DebugContext debug = graalRuntime.openDebugContext(options, this.compilationId, this.getMethod(), this.compiler.getDebugHandlersFactories(), DebugContext.getDefaultLogStream());){
            HotSpotCompilationRequestResult hotSpotCompilationRequestResult = this.runCompilation(debug);
            return hotSpotCompilationRequestResult;
        }
    }

    /*
     * Loose catch block
     */
    public HotSpotCompilationRequestResult runCompilation(DebugContext debug) {
        HotSpotGraalRuntimeProvider graalRuntime = this.compiler.getGraalRuntime();
        GraalHotSpotVMConfig config = graalRuntime.getVMConfig();
        int entryBCI = this.getEntryBCI();
        boolean isOSR = entryBCI != -1;
        HotSpotResolvedJavaMethod method = this.getMethod();
        if (this.installAsDefault || isOSR) {
            if (method.hasCodeAtLevel(entryBCI, config.compilationLevelFullOptimization)) {
                return HotSpotCompilationRequestResult.failure((String)"Already compiled", (boolean)false);
            }
            if (HotSpotGraalCompilerFactory.shouldExclude(method)) {
                return HotSpotCompilationRequestResult.failure((String)"GraalCompileOnly excluded", (boolean)false);
            }
        }
        HotSpotCompilationWrapper compilation = new HotSpotCompilationWrapper();
        try {
            try (DebugCloseable a = CompilationTime.start(debug);){
                HotSpotCompilationRequestResult hotSpotCompilationRequestResult = (HotSpotCompilationRequestResult)compilation.run(debug);
                return hotSpotCompilationRequestResult;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                int compiledBytecodes = 0;
                int codeSize = 0;
                if (compilation.result != null) {
                    compiledBytecodes = compilation.result.getBytecodeSize();
                    CompiledBytecodes.add(debug, compiledBytecodes);
                    if (this.installedCode != null) {
                        codeSize = this.installedCode.getSize();
                        CompiledAndInstalledBytecodes.add(debug, compiledBytecodes);
                        InstalledCodeSize.add(debug, codeSize);
                    }
                }
            }
            catch (Throwable t) {
                return compilation.handleException(t);
            }
        }
    }

    private void installMethod(DebugContext debug, StructuredGraph graph, CompilationResult compResult) {
        CodeCacheProvider codeCache = this.jvmciRuntime.getHostJVMCIBackend().getCodeCache();
        HotSpotBackend backend = this.compiler.getGraalRuntime().getHostBackend();
        this.installedCode = null;
        Object[] context = new Object[]{new DebugDumpScope(this.getIdString(), true), codeCache, this.getMethod(), compResult};
        try (DebugContext.Scope s = debug.scope("CodeInstall", context, graph);){
            HotSpotCompilationRequest request = this.getRequest();
            this.installedCode = (HotSpotInstalledCode)backend.createInstalledCode(debug, (ResolvedJavaMethod)request.getMethod(), (CompilationRequest)request, compResult, null, this.installAsDefault, context);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    public String toString() {
        return "Compilation[id=" + this.getId() + ", " + this.getMethod().format("%H.%n(%p)") + (this.getEntryBCI() == -1 ? "" : "@" + this.getEntryBCI()) + "]";
    }

    private HotSpotCompilationRequest getRequest() {
        return this.compilationId.getRequest();
    }

    final class HotSpotCompilationWrapper
    extends CompilationWrapper<HotSpotCompilationRequestResult> {
        CompilationResult result;

        HotSpotCompilationWrapper() {
            super(CompilationTask.this.compiler.getGraalRuntime().getOutputDirectory(), CompilationTask.this.compiler.getGraalRuntime().getCompilationProblemsPerAction());
        }

        @Override
        protected DebugContext createRetryDebugContext(DebugContext initialDebug, OptionValues retryOptions, PrintStream logStream) {
            SnippetReflectionProvider snippetReflection = CompilationTask.this.compiler.getGraalRuntime().getHostProviders().getSnippetReflection();
            DebugContext.Description description = initialDebug.getDescription();
            GraalDebugHandlersFactory factory = new GraalDebugHandlersFactory(snippetReflection);
            return new DebugContext.Builder(retryOptions, factory).globalMetrics(initialDebug.getGlobalMetrics()).description(description).logStream(logStream).build();
        }

        @Override
        protected void exitHostVM(int status) {
            HotSpotGraalServices.exit(status, CompilationTask.this.jvmciRuntime);
        }

        @Override
        public String toString() {
            return CompilationTask.this.getMethod().format("%H.%n(%p) @ " + CompilationTask.this.getEntryBCI());
        }

        @Override
        protected HotSpotCompilationRequestResult handleException(Throwable t) {
            if (t instanceof BailoutException) {
                BailoutException bailout = (BailoutException)t;
                return HotSpotCompilationRequestResult.failure((String)bailout.getMessage(), (!bailout.isPermanent() ? 1 : 0) != 0);
            }
            return HotSpotCompilationRequestResult.failure((String)t.toString(), (boolean)false);
        }

        @Override
        protected CompilationWrapper.ExceptionAction lookupAction(OptionValues values, Throwable cause) {
            if (cause instanceof BailoutException) {
                BailoutException bailout = (BailoutException)cause;
                if (bailout.isPermanent() && !GraalCompilerOptions.CompilationBailoutAsFailure.hasBeenSet(values) && CompilationTask.this.compiler.getGraalRuntime().isBootstrapping()) {
                    return CompilationWrapper.ExceptionAction.Diagnose;
                }
                if (!GraalCompilerOptions.CompilationBailoutAsFailure.getValue(values).booleanValue()) {
                    return super.lookupAction(values, cause);
                }
            }
            if (!GraalCompilerOptions.CompilationFailureAction.hasBeenSet(values) && CompilationTask.this.compiler.getGraalRuntime().isBootstrapping()) {
                return CompilationWrapper.ExceptionAction.ExitVM;
            }
            return super.lookupAction(values, cause);
        }

        @Override
        protected HotSpotCompilationRequestResult performCompilation(DebugContext debug) {
            StructuredGraph graph;
            Throwable throwable;
            HotSpotResolvedJavaMethod method = CompilationTask.this.getMethod();
            int entryBCI = CompilationTask.this.getEntryBCI();
            boolean isOSR = entryBCI != -1;
            CompilationStatistics stats = CompilationStatistics.create(debug.getOptions(), method, isOSR);
            CompilationPrinter printer = CompilationPrinter.begin(debug.getOptions(), CompilationTask.this.compilationId, (JavaMethod)method, entryBCI);
            try {
                throwable = null;
                try (DebugContext.Scope s = debug.scope((Object)"Compiling", new DebugDumpScope(CompilationTask.this.getIdString(), true));){
                    graph = CompilationTask.this.compiler.createGraph((ResolvedJavaMethod)method, entryBCI, CompilationTask.this.useProfilingInfo, CompilationTask.this.compilationId, debug.getOptions(), debug);
                    this.result = CompilationTask.this.compiler.compile(graph, (ResolvedJavaMethod)method, entryBCI, CompilationTask.this.useProfilingInfo, CompilationTask.this.shouldRetainLocalVariables, CompilationTask.this.compilationId, debug);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
            if (this.result != null) {
                throwable = null;
                try (DebugCloseable b = CodeInstallationTime.start(debug);){
                    CompilationTask.this.installMethod(debug, graph, this.result);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                printer.finish(this.result);
            }
            stats.finish(method, CompilationTask.this.installedCode);
            if (this.result != null) {
                ResolvedJavaMethod rootMethod = this.result.getMethods()[0];
                int inlinedBytecodes = this.result.getBytecodeSize() - rootMethod.getCodeSize();
                assert (inlinedBytecodes >= 0) : rootMethod + " " + method;
                return HotSpotCompilationRequestResult.success((int)inlinedBytecodes);
            }
            return null;
        }
    }
}

