/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;

class TypedGraphNodeIterator<T extends IterableNodeType>
implements Iterator<T> {
    private final Graph graph;
    private final int[] ids;
    private final Node[] current;
    private int currentIdIndex;
    private boolean needsForward;

    TypedGraphNodeIterator(NodeClass<?> clazz, Graph graph) {
        this.graph = graph;
        this.ids = clazz.iterableIds();
        this.currentIdIndex = 0;
        this.current = new Node[this.ids.length];
        this.needsForward = true;
    }

    private Node findNext() {
        if (this.needsForward) {
            this.forward();
        } else {
            Node c = this.current();
            Node afterDeleted = this.graph.getIterableNodeNext(c);
            if (afterDeleted == null) {
                this.needsForward = true;
            } else if (c != afterDeleted) {
                this.setCurrent(afterDeleted);
            }
        }
        if (this.needsForward) {
            return null;
        }
        return this.current();
    }

    private void forward() {
        Node next;
        this.needsForward = false;
        int startIdx = this.currentIdIndex;
        while ((next = this.current() == null ? this.graph.getIterableNodeStart(this.ids[this.currentIdIndex]) : this.graph.getIterableNodeNext(this.current().typeCacheNext)) == null) {
            ++this.currentIdIndex;
            if (this.currentIdIndex >= this.ids.length) {
                this.currentIdIndex = 0;
            }
            if (this.currentIdIndex != startIdx) continue;
            this.needsForward = true;
            return;
        }
        this.setCurrent(next);
    }

    private Node current() {
        return this.current[this.currentIdIndex];
    }

    private void setCurrent(Node n) {
        this.current[this.currentIdIndex] = n;
    }

    @Override
    public boolean hasNext() {
        return this.findNext() != null;
    }

    @Override
    public T next() {
        Node result = this.findNext();
        if (result == null) {
            throw new NoSuchElementException();
        }
        this.needsForward = true;
        return (T)((IterableNodeType)((Object)result));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

