/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import org.graalvm.collections.Pair;
import org.graalvm.compiler.debug.AbstractKey;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;

class CounterKeyImpl
extends AbstractKey
implements CounterKey {
    CounterKeyImpl(String format, Object arg1, Object arg2) {
        super(format, arg1, arg2);
    }

    @Override
    public void increment(DebugContext debug) {
        this.add(debug, 1L);
    }

    @Override
    public Pair<String, String> toCSVFormat(long value) {
        return Pair.create((Object)String.valueOf(value), (Object)"");
    }

    @Override
    public String toHumanReadableFormat(long value) {
        return Long.toString(value);
    }

    @Override
    public void add(DebugContext debug, long value) {
        if (debug.isCounterEnabled(this)) {
            this.addToCurrentValue(debug, value);
        }
    }

    @Override
    public boolean isEnabled(DebugContext debug) {
        return debug.isCounterEnabled(this);
    }

    @Override
    public CounterKey doc(String doc) {
        this.setDoc(doc);
        return this;
    }
}

