/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.sparc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.compiler.core.gen.NodeMatchRules;
import org.graalvm.compiler.core.match.ComplexMatchResult;
import org.graalvm.compiler.core.match.MatchGenerator;
import org.graalvm.compiler.core.match.MatchPattern;
import org.graalvm.compiler.core.match.MatchRuleRegistry;
import org.graalvm.compiler.core.match.MatchStatement;
import org.graalvm.compiler.core.match.MatchStatementSet;
import org.graalvm.compiler.core.sparc.SPARCNodeMatchRules;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.FloatEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.PointerEqualsNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.java.LogicCompareAndSwapNode;
import org.graalvm.compiler.nodes.memory.AddressableMemoryAccess;
import org.graalvm.compiler.nodes.memory.FloatingReadNode;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.VolatileReadNode;

public class SPARCNodeMatchRules_MatchStatementSet
implements MatchStatementSet {
    private static final String[] signExtend_arguments = new String[]{"root", "access"};
    private static final String[] ifCompareLogicCas_arguments = new String[]{"root", "compare", "value", "cas"};
    private static final String[] zeroExtend_arguments = new String[]{"root", "access"};

    @Override
    public Class<? extends NodeMatchRules> forClass() {
        return SPARCNodeMatchRules.class;
    }

    @Override
    public List<MatchStatement> statements() {
        Position[] ZeroExtendNode_positions = MatchRuleRegistry.findPositions(ZeroExtendNode.TYPE, new String[]{"value"});
        Position[] FloatEqualsNode_positions = MatchRuleRegistry.findPositions(FloatEqualsNode.TYPE, new String[]{"x", "y"});
        Position[] PointerEqualsNode_positions = MatchRuleRegistry.findPositions(PointerEqualsNode.TYPE, new String[]{"x", "y"});
        Position[] IfNode_positions = MatchRuleRegistry.findPositions(IfNode.TYPE, new String[]{"condition"});
        Position[] ObjectEqualsNode_positions = MatchRuleRegistry.findPositions(ObjectEqualsNode.TYPE, new String[]{"x", "y"});
        Position[] IntegerEqualsNode_positions = MatchRuleRegistry.findPositions(IntegerEqualsNode.TYPE, new String[]{"x", "y"});
        Position[] SignExtendNode_positions = MatchRuleRegistry.findPositions(SignExtendNode.TYPE, new String[]{"value"});
        List<MatchStatement> statements = Collections.unmodifiableList(Arrays.asList(new MatchStatement("signExtend", new MatchPattern(SignExtendNode.class, null, new MatchPattern(ReadNode.class, "access", true, true, false), SignExtendNode_positions, true, true, true), MatchGenerator_signExtend.instance, signExtend_arguments), new MatchStatement("signExtend", new MatchPattern(SignExtendNode.class, null, new MatchPattern(FloatingReadNode.class, "access", true, true, false), SignExtendNode_positions, true, true, true), MatchGenerator_signExtend.instance, signExtend_arguments), new MatchStatement("signExtend", new MatchPattern(SignExtendNode.class, null, new MatchPattern(VolatileReadNode.class, "access", true, true, false), SignExtendNode_positions, true, true, true), MatchGenerator_signExtend.instance, signExtend_arguments), new MatchStatement("zeroExtend", new MatchPattern(ZeroExtendNode.class, null, new MatchPattern(ReadNode.class, "access", true, true, false), ZeroExtendNode_positions, true, true, true), MatchGenerator_zeroExtend.instance, zeroExtend_arguments), new MatchStatement("zeroExtend", new MatchPattern(ZeroExtendNode.class, null, new MatchPattern(FloatingReadNode.class, "access", true, true, false), ZeroExtendNode_positions, true, true, true), MatchGenerator_zeroExtend.instance, zeroExtend_arguments), new MatchStatement("zeroExtend", new MatchPattern(ZeroExtendNode.class, null, new MatchPattern(VolatileReadNode.class, "access", true, true, false), ZeroExtendNode_positions, true, true, true), MatchGenerator_zeroExtend.instance, zeroExtend_arguments), new MatchStatement("ifCompareLogicCas", new MatchPattern(IfNode.class, null, new MatchPattern(ObjectEqualsNode.class, "compare", new MatchPattern("value", false, false, false), new MatchPattern(LogicCompareAndSwapNode.class, "cas", true, true, false), ObjectEqualsNode_positions, true, true, true), IfNode_positions, true, true, false), MatchGenerator_ifCompareLogicCas.instance, ifCompareLogicCas_arguments), new MatchStatement("ifCompareLogicCas", new MatchPattern(IfNode.class, null, new MatchPattern(ObjectEqualsNode.class, "compare", new MatchPattern(LogicCompareAndSwapNode.class, "cas", true, true, false), new MatchPattern("value", false, false, false), ObjectEqualsNode_positions, true, true, true), IfNode_positions, true, true, false), MatchGenerator_ifCompareLogicCas.instance, ifCompareLogicCas_arguments), new MatchStatement("ifCompareLogicCas", new MatchPattern(IfNode.class, null, new MatchPattern(PointerEqualsNode.class, "compare", new MatchPattern("value", false, false, false), new MatchPattern(LogicCompareAndSwapNode.class, "cas", true, true, false), PointerEqualsNode_positions, true, true, true), IfNode_positions, true, true, false), MatchGenerator_ifCompareLogicCas.instance, ifCompareLogicCas_arguments), new MatchStatement("ifCompareLogicCas", new MatchPattern(IfNode.class, null, new MatchPattern(PointerEqualsNode.class, "compare", new MatchPattern(LogicCompareAndSwapNode.class, "cas", true, true, false), new MatchPattern("value", false, false, false), PointerEqualsNode_positions, true, true, true), IfNode_positions, true, true, false), MatchGenerator_ifCompareLogicCas.instance, ifCompareLogicCas_arguments), new MatchStatement("ifCompareLogicCas", new MatchPattern(IfNode.class, null, new MatchPattern(FloatEqualsNode.class, "compare", new MatchPattern("value", false, false, false), new MatchPattern(LogicCompareAndSwapNode.class, "cas", true, true, false), FloatEqualsNode_positions, true, true, true), IfNode_positions, true, true, false), MatchGenerator_ifCompareLogicCas.instance, ifCompareLogicCas_arguments), new MatchStatement("ifCompareLogicCas", new MatchPattern(IfNode.class, null, new MatchPattern(FloatEqualsNode.class, "compare", new MatchPattern(LogicCompareAndSwapNode.class, "cas", true, true, false), new MatchPattern("value", false, false, false), FloatEqualsNode_positions, true, true, true), IfNode_positions, true, true, false), MatchGenerator_ifCompareLogicCas.instance, ifCompareLogicCas_arguments), new MatchStatement("ifCompareLogicCas", new MatchPattern(IfNode.class, null, new MatchPattern(IntegerEqualsNode.class, "compare", new MatchPattern("value", false, false, false), new MatchPattern(LogicCompareAndSwapNode.class, "cas", true, true, false), IntegerEqualsNode_positions, true, true, true), IfNode_positions, true, true, false), MatchGenerator_ifCompareLogicCas.instance, ifCompareLogicCas_arguments), new MatchStatement("ifCompareLogicCas", new MatchPattern(IfNode.class, null, new MatchPattern(IntegerEqualsNode.class, "compare", new MatchPattern(LogicCompareAndSwapNode.class, "cas", true, true, false), new MatchPattern("value", false, false, false), IntegerEqualsNode_positions, true, true, true), IfNode_positions, true, true, false), MatchGenerator_ifCompareLogicCas.instance, ifCompareLogicCas_arguments)));
        return statements;
    }

    private static final class MatchGenerator_zeroExtend
    implements MatchGenerator {
        static final MatchGenerator instance = new MatchGenerator_zeroExtend();

        private MatchGenerator_zeroExtend() {
        }

        @Override
        public ComplexMatchResult match(NodeMatchRules nodeMatchRules, Object ... args) {
            return ((SPARCNodeMatchRules)nodeMatchRules).zeroExtend((ZeroExtendNode)args[0], (AddressableMemoryAccess)args[1]);
        }

        @Override
        public String getName() {
            return "zeroExtend";
        }
    }

    private static final class MatchGenerator_ifCompareLogicCas
    implements MatchGenerator {
        static final MatchGenerator instance = new MatchGenerator_ifCompareLogicCas();

        private MatchGenerator_ifCompareLogicCas() {
        }

        @Override
        public ComplexMatchResult match(NodeMatchRules nodeMatchRules, Object ... args) {
            return ((SPARCNodeMatchRules)nodeMatchRules).ifCompareLogicCas((IfNode)args[0], (CompareNode)args[1], (ValueNode)args[2], (LogicCompareAndSwapNode)args[3]);
        }

        @Override
        public String getName() {
            return "ifCompareLogicCas";
        }
    }

    private static final class MatchGenerator_signExtend
    implements MatchGenerator {
        static final MatchGenerator instance = new MatchGenerator_signExtend();

        private MatchGenerator_signExtend() {
        }

        @Override
        public ComplexMatchResult match(NodeMatchRules nodeMatchRules, Object ... args) {
            return ((SPARCNodeMatchRules)nodeMatchRules).signExtend((SignExtendNode)args[0], (AddressableMemoryAccess)args[1]);
        }

        @Override
        public String getName() {
            return "signExtend";
        }
    }
}

