/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.sparc;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import jdk.vm.ci.sparc.SPARC;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.sparc.SPARCArithmeticLIRGenerator;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.SwitchStrategy;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGenerator;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.sparc.SPARCAddressValue;
import org.graalvm.compiler.lir.sparc.SPARCArrayEqualsOp;
import org.graalvm.compiler.lir.sparc.SPARCByteSwapOp;
import org.graalvm.compiler.lir.sparc.SPARCCall;
import org.graalvm.compiler.lir.sparc.SPARCControlFlow;
import org.graalvm.compiler.lir.sparc.SPARCFloatCompareOp;
import org.graalvm.compiler.lir.sparc.SPARCImmediateAddressValue;
import org.graalvm.compiler.lir.sparc.SPARCJumpOp;
import org.graalvm.compiler.lir.sparc.SPARCLoadConstantTableBaseOp;
import org.graalvm.compiler.lir.sparc.SPARCMove;
import org.graalvm.compiler.lir.sparc.SPARCOP3Op;
import org.graalvm.compiler.lir.sparc.SPARCPauseOp;
import org.graalvm.compiler.phases.util.Providers;

public abstract class SPARCLIRGenerator
extends LIRGenerator {
    private SPARCLoadConstantTableBaseOp loadConstantTableBaseOp;
    private final ConstantTableBaseProvider constantTableBaseProvider;

    public SPARCLIRGenerator(LIRKindTool lirKindTool, SPARCArithmeticLIRGenerator arithmeticLIRGen, LIRGeneratorTool.MoveFactory moveFactory, Providers providers, LIRGenerationResult lirGenRes, ConstantTableBaseProvider constantTableBaseProvider) {
        super(lirKindTool, arithmeticLIRGen, moveFactory, providers, lirGenRes);
        this.constantTableBaseProvider = constantTableBaseProvider;
    }

    @Override
    protected JavaConstant zapValueForKind(PlatformKind kind) {
        long dead = -2401018187971961171L;
        switch ((SPARCKind)kind) {
            case BYTE: {
                return JavaConstant.forByte((byte)((byte)dead));
            }
            case HWORD: {
                return JavaConstant.forShort((short)((short)dead));
            }
            case WORD: {
                return JavaConstant.forInt((int)((int)dead));
            }
            case XWORD: {
                return JavaConstant.forLong((long)dead);
            }
            case SINGLE: 
            case V32_BYTE: 
            case V32_HWORD: {
                return JavaConstant.forFloat((float)Float.intBitsToFloat((int)dead));
            }
            case DOUBLE: 
            case V64_BYTE: 
            case V64_HWORD: 
            case V64_WORD: {
                return JavaConstant.forDouble((double)Double.longBitsToDouble(dead));
            }
        }
        throw new IllegalArgumentException(kind.toString());
    }

    @Override
    public <K extends ValueKind<K>> K toRegisterKind(K kind) {
        switch ((SPARCKind)kind.getPlatformKind()) {
            case BYTE: 
            case HWORD: {
                return (K)kind.changeType((PlatformKind)SPARCKind.WORD);
            }
        }
        return kind;
    }

    public SPARCAddressValue asAddressValue(Value address) {
        long displacement;
        if (address instanceof SPARCAddressValue) {
            return (SPARCAddressValue)address;
        }
        ValueKind kind = address.getValueKind();
        if (address instanceof JavaConstant && SPARCAssembler.isSimm13(displacement = ((JavaConstant)address).asLong())) {
            return new SPARCImmediateAddressValue(kind, (AllocatableValue)SPARC.g0.asValue(kind), (int)displacement);
        }
        return new SPARCImmediateAddressValue(kind, this.asAllocatable(address), 0);
    }

    @Override
    public Variable emitAddress(AllocatableValue stackslot) {
        Variable result = this.newVariable(LIRKind.value(this.target().arch.getWordKind()));
        this.append(new SPARCMove.StackLoadAddressOp(result, stackslot));
        return result;
    }

    @Override
    public void emitReturn(JavaKind javaKind, Value input) {
        AllocatableValue operand = Value.ILLEGAL;
        if (input != null) {
            operand = this.resultOperandFor(javaKind, input.getValueKind());
            this.emitMove(operand, input);
        }
        this.append(new SPARCControlFlow.ReturnOp((Value)operand));
    }

    @Override
    public void emitJump(LabelRef label) {
        this.append(new SPARCJumpOp(label));
    }

    @Override
    public void emitCompareBranch(PlatformKind cmpKind, Value x, Value y, Condition cond, boolean unorderedIsTrue, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
        Condition actualCondition;
        Value right;
        Variable left;
        if (LIRValueUtil.isJavaConstant(x)) {
            left = this.load(y);
            right = this.loadSimm13(x);
            actualCondition = cond.mirror();
        } else {
            left = this.load(x);
            right = this.loadSimm13(y);
            actualCondition = cond;
        }
        SPARCKind actualCmpKind = (SPARCKind)cmpKind;
        if (actualCmpKind.isInteger()) {
            assert (actualCmpKind.equals((Object)SPARCKind.XWORD) || actualCmpKind.equals((Object)SPARCKind.WORD)) : "SPARC does not support compare of: " + actualCmpKind;
            this.append(new SPARCControlFlow.CompareBranchOp(left, right, actualCondition, trueDestination, falseDestination, actualCmpKind, unorderedIsTrue, trueDestinationProbability));
        } else if (actualCmpKind.isFloat()) {
            this.emitFloatCompare(actualCmpKind, x, y, SPARCAssembler.CC.Fcc0);
            SPARCAssembler.ConditionFlag cf = SPARCControlFlow.fromCondition(false, cond, unorderedIsTrue);
            this.append(new SPARCControlFlow.BranchOp(cf, trueDestination, falseDestination, actualCmpKind, trueDestinationProbability));
        } else {
            throw GraalError.shouldNotReachHere();
        }
    }

    @Override
    public void emitOverflowCheckBranch(LabelRef overflow, LabelRef noOverflow, LIRKind cmpLIRKind, double overflowProbability) {
        SPARCKind cmpKind = (SPARCKind)cmpLIRKind.getPlatformKind();
        this.append(new SPARCControlFlow.BranchOp(SPARCAssembler.ConditionFlag.OverflowSet, overflow, noOverflow, cmpKind, overflowProbability));
    }

    @Override
    public void emitIntegerTestBranch(Value left, Value right, LabelRef trueDestination, LabelRef falseDestination, double trueDestinationProbability) {
        this.emitIntegerTest(left, right);
        this.append(new SPARCControlFlow.BranchOp(SPARCAssembler.ConditionFlag.Equal, trueDestination, falseDestination, (SPARCKind)left.getPlatformKind(), trueDestinationProbability));
    }

    private void emitIntegerTest(Value a, Value b) {
        assert (((SPARCKind)a.getPlatformKind()).isInteger());
        if (LIRValueUtil.isVariable(b)) {
            this.append(SPARCOP3Op.newBinaryVoid(SPARCAssembler.Op3s.Andcc, this.load(b), this.loadSimm13(a)));
        } else {
            this.append(SPARCOP3Op.newBinaryVoid(SPARCAssembler.Op3s.Andcc, this.load(a), this.loadSimm13(b)));
        }
    }

    private Value loadSimm11(Value value) {
        JavaConstant c;
        if (LIRValueUtil.isJavaConstant(value) && ((c = LIRValueUtil.asJavaConstant(value)).isNull() || SPARCAssembler.isSimm11(c))) {
            return value;
        }
        return this.load(value);
    }

    public Value loadSimm13(Value value) {
        JavaConstant c;
        if (LIRValueUtil.isJavaConstant(value) && ((c = LIRValueUtil.asJavaConstant(value)).isNull() || SPARCAssembler.isSimm13(c))) {
            return value;
        }
        return this.load(value);
    }

    @Override
    public Value loadNonConst(Value value) {
        throw GraalError.shouldNotReachHere("This operation is not available for SPARC.");
    }

    @Override
    public Variable emitConditionalMove(PlatformKind cmpKind, Value left, Value right, Condition cond, boolean unorderedIsTrue, Value trueValue, Value falseValue) {
        SPARCAssembler.SPARCOp cmove;
        SPARCKind cmpSPARCKind = (SPARCKind)cmpKind;
        boolean mirrored = this.emitCompare(cmpSPARCKind, left, right);
        Object actualTrueValue = trueValue;
        Object actualFalseValue = falseValue;
        SPARCKind valueKind = (SPARCKind)trueValue.getPlatformKind();
        if (valueKind.isFloat()) {
            actualTrueValue = this.load(trueValue);
            actualFalseValue = this.load(falseValue);
            cmove = valueKind.equals((Object)SPARCKind.SINGLE) ? SPARCAssembler.FMOVSCC : SPARCAssembler.FMOVDCC;
        } else if (valueKind.isInteger()) {
            actualTrueValue = this.loadSimm11(trueValue);
            actualFalseValue = this.loadSimm11(falseValue);
            cmove = SPARCAssembler.MOVICC;
        } else {
            throw GraalError.shouldNotReachHere();
        }
        Variable result = this.newVariable(trueValue.getValueKind());
        SPARCAssembler.ConditionFlag finalCondition = SPARCControlFlow.fromCondition(cmpSPARCKind.isInteger(), mirrored ? cond.mirror() : cond, unorderedIsTrue);
        SPARCAssembler.CC cc = SPARCAssembler.CC.forKind((PlatformKind)cmpSPARCKind);
        this.append(new SPARCControlFlow.CondMoveOp((SPARCAssembler.CMOV)((Object)cmove), cc, finalCondition, (Value)actualTrueValue, (Value)actualFalseValue, (Value)result));
        return result;
    }

    protected boolean emitCompare(SPARCKind cmpKind, Value a, Value b) {
        boolean mirrored;
        if (cmpKind.isInteger()) {
            mirrored = this.emitIntegerCompare(cmpKind, a, b);
        } else if (cmpKind.isFloat()) {
            mirrored = false;
            this.emitFloatCompare(cmpKind, a, b, SPARCAssembler.CC.Fcc0);
        } else {
            throw GraalError.shouldNotReachHere();
        }
        return mirrored;
    }

    private boolean emitIntegerCompare(SPARCKind cmpKind, Value a, Value b) {
        boolean mirrored;
        Value right;
        Variable left;
        assert (cmpKind.isInteger());
        if (LIRValueUtil.isVariable(b)) {
            left = this.load(b);
            right = this.loadSimm13(a);
            mirrored = true;
        } else {
            left = this.load(a);
            right = this.loadSimm13(b);
            mirrored = false;
        }
        int compareBytes = cmpKind.getSizeInBytes();
        if (compareBytes < left.getPlatformKind().getSizeInBytes()) {
            left = this.asAllocatable(this.arithmeticLIRGen.emitSignExtend((Value)left, cmpKind.getSizeInBits(), SPARCKind.XWORD.getSizeInBits()));
        }
        if (compareBytes < right.getPlatformKind().getSizeInBytes()) {
            right = this.arithmeticLIRGen.emitSignExtend(right, cmpKind.getSizeInBits(), SPARCKind.XWORD.getSizeInBits());
        }
        this.append(SPARCOP3Op.newBinaryVoid(SPARCAssembler.Op3s.Subcc, left, right));
        return mirrored;
    }

    private void emitFloatCompare(SPARCKind cmpJavaKind, Value a, Value b, SPARCAssembler.CC cc) {
        SPARCAssembler.Opfs floatCompareOpcode;
        assert (cmpJavaKind.isFloat());
        switch (cmpJavaKind) {
            case DOUBLE: {
                floatCompareOpcode = SPARCAssembler.Opfs.Fcmpd;
                break;
            }
            case SINGLE: {
                floatCompareOpcode = SPARCAssembler.Opfs.Fcmps;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        this.append(new SPARCFloatCompareOp(floatCompareOpcode, cc, this.load(a), this.load(b)));
    }

    @Override
    public Variable emitIntegerTestMove(Value left, Value right, Value trueValue, Value falseValue) {
        this.emitIntegerTest(left, right);
        Variable result = this.newVariable(trueValue.getValueKind());
        SPARCAssembler.ConditionFlag flag = SPARCControlFlow.fromCondition(true, Condition.EQ, false);
        SPARCAssembler.CC cc = SPARCAssembler.CC.forKind(left.getPlatformKind());
        this.append(new SPARCControlFlow.CondMoveOp(SPARCAssembler.MOVICC, cc, flag, this.loadSimm11(trueValue), this.loadSimm11(falseValue), (Value)result));
        return result;
    }

    @Override
    protected void emitForeignCallOp(ForeignCallLinkage linkage, Value targetAddress, Value result, Value[] arguments, Value[] temps, LIRFrameState info) {
        long maxOffset = linkage.getMaxCallTargetOffset();
        if (SPARCAssembler.isWordDisp30(maxOffset)) {
            this.append(new SPARCCall.DirectNearForeignCallOp(linkage, result, arguments, temps, info));
        } else {
            this.append(new SPARCCall.DirectFarForeignCallOp(linkage, result, arguments, temps, info));
        }
    }

    @Override
    public void emitStrategySwitch(SwitchStrategy strategy, Variable key, LabelRef[] keyTargets, LabelRef defaultTarget) {
        Variable scratchValue = this.newVariable(key.getValueKind());
        AllocatableValue base = AllocatableValue.ILLEGAL;
        for (Constant c : strategy.getKeyConstants()) {
            if (this.getMoveFactory().canInlineConstant(c)) continue;
            base = this.constantTableBaseProvider.getConstantTableBase();
            break;
        }
        this.append(this.createStrategySwitchOp(base, strategy, keyTargets, defaultTarget, key, scratchValue));
    }

    protected SPARCControlFlow.StrategySwitchOp createStrategySwitchOp(AllocatableValue base, SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, Variable key, Variable scratchValue) {
        return new SPARCControlFlow.StrategySwitchOp((Value)base, strategy, keyTargets, defaultTarget, key, scratchValue);
    }

    @Override
    protected void emitTableSwitch(int lowKey, LabelRef defaultTarget, LabelRef[] targets, Value key) {
        Variable tmp = this.newVariable(key.getValueKind());
        this.emitMove(tmp, key);
        this.append(new SPARCControlFlow.TableSwitchOp(lowKey, defaultTarget, targets, tmp, this.newVariable(LIRKind.value(this.target().arch.getWordKind()))));
    }

    protected SPARC getArchitecture() {
        return (SPARC)this.target().arch;
    }

    @Override
    public Variable emitByteSwap(Value input) {
        Variable result = this.newVariable(LIRKind.combine(input));
        this.append(new SPARCByteSwapOp(this, result, this.asAllocatable(input)));
        return result;
    }

    @Override
    public Variable emitArrayEquals(JavaKind kind, Value array1, Value array2, Value length, boolean directPointers) {
        Variable result = this.newVariable(LIRKind.value((PlatformKind)SPARCKind.WORD));
        this.append(new SPARCArrayEqualsOp(this, kind, result, this.load(array1), this.load(array2), this.asAllocatable(length), directPointers));
        return result;
    }

    @Override
    public void emitMembar(int barriers) {
        int necessaryBarriers = this.target().arch.requiredBarriers(barriers);
        if (this.target().isMP && necessaryBarriers != 0) {
            this.append(new SPARCMove.MembarOp(necessaryBarriers));
        }
    }

    @Override
    public void emitDeoptimize(Value actionAndReason, Value speculation, LIRFrameState state) {
        this.append(new SPARCControlFlow.ReturnOp((Value)Value.ILLEGAL));
    }

    public Value emitSignExtendLoad(LIRKind kind, LIRKind resultKind, Value address, LIRFrameState state) {
        SPARCAddressValue loadAddress = this.asAddressValue(address);
        Variable result = this.newVariable(resultKind);
        this.append(new SPARCMove.LoadOp(kind.getPlatformKind(), result, loadAddress, state, true));
        return result;
    }

    public Value emitZeroExtendLoad(LIRKind kind, LIRKind resultKind, Value address, LIRFrameState state) {
        SPARCAddressValue loadAddress = this.asAddressValue(address);
        Variable result = this.newVariable(resultKind);
        this.append(new SPARCMove.LoadOp(kind.getPlatformKind(), result, loadAddress, state));
        return result;
    }

    @Override
    public void emitNullCheck(Value address, LIRFrameState state) {
        PlatformKind kind = address.getPlatformKind();
        assert (kind == SPARCKind.XWORD) : address + " - " + kind + " not an object!";
        this.append(new SPARCMove.NullCheckOp(this.asAddressValue(address), state));
    }

    public void emitLoadConstantTableBase() {
        this.constantTableBaseProvider.constantTableBase = this.newVariable(LIRKind.value((PlatformKind)SPARCKind.XWORD));
        int nextPosition = this.getResult().getLIR().getLIRforBlock(this.getCurrentBlock()).size();
        StandardOp.NoOp placeHolder = this.append(new StandardOp.NoOp(this.getCurrentBlock(), nextPosition));
        this.loadConstantTableBaseOp = new SPARCLoadConstantTableBaseOp(this.constantTableBaseProvider.constantTableBase, placeHolder);
    }

    @Override
    public void beforeRegisterAllocation() {
        LIR lir = this.getResult().getLIR();
        this.loadConstantTableBaseOp.setAlive(lir, this.constantTableBaseProvider.useConstantTableBase);
    }

    @Override
    public void emitPause() {
        this.append(new SPARCPauseOp());
    }

    @Override
    public void emitSpeculationFence() {
        throw GraalError.unimplemented();
    }

    public static final class ConstantTableBaseProvider {
        private Variable constantTableBase;
        private boolean useConstantTableBase = false;

        public Variable getConstantTableBase() {
            this.useConstantTableBase = true;
            return this.constantTableBase;
        }
    }
}

