/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.sparc;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import jdk.vm.ci.sparc.SPARC;
import jdk.vm.ci.sparc.SPARCKind;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.sparc.SPARCLIRGenerator;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGenerator;
import org.graalvm.compiler.lir.sparc.SPARCAddressValue;
import org.graalvm.compiler.lir.sparc.SPARCArithmetic;
import org.graalvm.compiler.lir.sparc.SPARCBitManipulationOp;
import org.graalvm.compiler.lir.sparc.SPARCMove;
import org.graalvm.compiler.lir.sparc.SPARCOP3Op;
import org.graalvm.compiler.lir.sparc.SPARCOPFOp;

public class SPARCArithmeticLIRGenerator
extends ArithmeticLIRGenerator {
    @Override
    public SPARCLIRGenerator getLIRGen() {
        return (SPARCLIRGenerator)super.getLIRGen();
    }

    public Variable emitBitCount(Value operand) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(operand).changeType((PlatformKind)SPARCKind.WORD));
        AllocatableValue usedOperand = this.asAllocatable(this.emitZeroExtend(operand));
        this.getLIRGen().append(new SPARCOP3Op(SPARCAssembler.Op3s.Popc, (AllocatableValue)SPARC.g0.asValue(), (Value)usedOperand, result));
        return result;
    }

    public Variable emitBitScanForward(Value operand) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(operand).changeType((PlatformKind)SPARCKind.WORD));
        this.getLIRGen().append(new SPARCBitManipulationOp(SPARCBitManipulationOp.IntrinsicOpcode.BSF, result, this.asAllocatable(operand), this.getLIRGen()));
        return result;
    }

    public Variable emitBitScanReverse(Value operand) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(operand).changeType((PlatformKind)SPARCKind.WORD));
        if (operand.getPlatformKind() == SPARCKind.XWORD) {
            this.getLIRGen().append(new SPARCBitManipulationOp(SPARCBitManipulationOp.IntrinsicOpcode.LBSR, result, this.asAllocatable(operand), this.getLIRGen()));
        } else {
            this.getLIRGen().append(new SPARCBitManipulationOp(SPARCBitManipulationOp.IntrinsicOpcode.IBSR, result, this.asAllocatable(operand), this.getLIRGen()));
        }
        return result;
    }

    @Override
    public Value emitMathAbs(Value inputValue) {
        SPARCAssembler.Opfs opf;
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(inputValue));
        SPARCKind kind = (SPARCKind)inputValue.getPlatformKind();
        switch (kind) {
            case SINGLE: {
                opf = SPARCAssembler.Opfs.Fabss;
                break;
            }
            case DOUBLE: {
                opf = SPARCAssembler.Opfs.Fabsd;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("Input kind: " + kind);
            }
        }
        this.getLIRGen().append(new SPARCOPFOp(opf, (AllocatableValue)SPARC.g0.asValue(), this.asAllocatable(inputValue), result));
        return result;
    }

    @Override
    public Value emitMathSqrt(Value inputValue) {
        SPARCAssembler.Opfs opf;
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(inputValue));
        SPARCKind kind = (SPARCKind)inputValue.getPlatformKind();
        switch (kind) {
            case SINGLE: {
                opf = SPARCAssembler.Opfs.Fsqrts;
                break;
            }
            case DOUBLE: {
                opf = SPARCAssembler.Opfs.Fsqrtd;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("Input kind: " + kind);
            }
        }
        this.getLIRGen().append(new SPARCOPFOp(opf, (AllocatableValue)SPARC.g0.asValue(), this.asAllocatable(inputValue), result));
        return result;
    }

    @Override
    public Value emitNegate(Value input) {
        PlatformKind inputKind = input.getPlatformKind();
        if (this.isNumericInteger(inputKind)) {
            return this.emitUnary(SPARCAssembler.Op3s.Sub, input);
        }
        return this.emitUnary(inputKind.equals(SPARCKind.DOUBLE) ? SPARCAssembler.Opfs.Fnegd : SPARCAssembler.Opfs.Fnegs, input);
    }

    @Override
    public Value emitNot(Value input) {
        return this.emitUnary(SPARCAssembler.Op3s.Xnor, input);
    }

    private Variable emitUnary(SPARCAssembler.Opfs opf, Value inputValue) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(inputValue));
        this.getLIRGen().append(new SPARCOPFOp(opf, (AllocatableValue)SPARC.g0.asValue(), this.asAllocatable(inputValue), result));
        return result;
    }

    private Variable emitUnary(SPARCAssembler.Op3s op3, Value input) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(input));
        this.getLIRGen().append(SPARCOP3Op.newUnary(op3, this.getLIRGen().loadSimm13(input), result));
        return result;
    }

    private Variable emitBinary(ValueKind<?> resultKind, SPARCAssembler.Opfs opf, Value a, Value b) {
        return this.emitBinary(resultKind, opf, a, b, null);
    }

    private Variable emitBinary(ValueKind<?> resultKind, SPARCAssembler.Opfs opf, Value a, Value b, LIRFrameState state) {
        Variable result = this.getLIRGen().newVariable(resultKind);
        this.getLIRGen().append(new SPARCOPFOp(opf, this.asAllocatable(a), this.asAllocatable(b), result, state));
        return result;
    }

    private Variable emitBinary(ValueKind<?> resultKind, SPARCAssembler.Op3s op3, Value a, int b) {
        return this.emitBinary(resultKind, op3, a, (Value)new ConstantValue(LIRKind.value((PlatformKind)SPARCKind.WORD), (Constant)JavaConstant.forInt((int)b)));
    }

    private Variable emitBinary(ValueKind<?> resultKind, SPARCAssembler.Op3s op3, Value a, Value b) {
        return this.emitBinary(resultKind, op3, a, b, null);
    }

    private Variable emitBinary(ValueKind<?> resultKind, SPARCAssembler.Op3s op3, Value a, Value b, LIRFrameState state) {
        Variable result = this.getLIRGen().newVariable(resultKind);
        if (op3.isCommutative() && LIRValueUtil.isJavaConstant(a) && this.getLIRGen().getMoveFactory().canInlineConstant((Constant)LIRValueUtil.asJavaConstant(a))) {
            this.getLIRGen().append(new SPARCOP3Op(op3, this.getLIRGen().load(b), this.getLIRGen().loadSimm13(a), result, state));
        } else {
            this.getLIRGen().append(new SPARCOP3Op(op3, this.getLIRGen().load(a), this.getLIRGen().loadSimm13(b), result, state));
        }
        return result;
    }

    @Override
    protected boolean isNumericInteger(PlatformKind kind) {
        return ((SPARCKind)kind).isInteger();
    }

    @Override
    public Variable emitAdd(LIRKind resultKind, Value a, Value b, boolean setFlags) {
        if (this.isNumericInteger(a.getPlatformKind())) {
            return this.emitBinary(resultKind, setFlags ? SPARCAssembler.Op3s.Addcc : SPARCAssembler.Op3s.Add, a, b);
        }
        boolean isDouble = a.getPlatformKind().equals(SPARCKind.DOUBLE);
        return this.emitBinary(resultKind, isDouble ? SPARCAssembler.Opfs.Faddd : SPARCAssembler.Opfs.Fadds, a, b);
    }

    @Override
    public Variable emitSub(LIRKind resultKind, Value a, Value b, boolean setFlags) {
        if (this.isNumericInteger(a.getPlatformKind())) {
            return this.emitBinary(resultKind, setFlags ? SPARCAssembler.Op3s.Subcc : SPARCAssembler.Op3s.Sub, a, b);
        }
        boolean isDouble = a.getPlatformKind().equals(SPARCKind.DOUBLE);
        return this.emitBinary(resultKind, isDouble ? SPARCAssembler.Opfs.Fsubd : SPARCAssembler.Opfs.Fsubs, a, b);
    }

    public Variable emitMul(Value a, Value b, boolean setFlags) {
        LIRKind resultKind = LIRKind.combine(a, b);
        PlatformKind aKind = a.getPlatformKind();
        if (this.isNumericInteger(aKind)) {
            if (setFlags) {
                Variable result = this.getLIRGen().newVariable(LIRKind.combine(a, b));
                if (aKind == SPARCKind.XWORD) {
                    this.getLIRGen().append(new SPARCArithmetic.SPARCLMulccOp(result, this.getLIRGen().load(a), this.getLIRGen().load(b), this.getLIRGen()));
                } else if (aKind == SPARCKind.WORD) {
                    this.getLIRGen().append(new SPARCArithmetic.SPARCIMulccOp(result, this.getLIRGen().load(a), this.getLIRGen().load(b)));
                } else {
                    throw GraalError.shouldNotReachHere();
                }
                return result;
            }
            return this.emitBinary(resultKind, SPARCAssembler.Op3s.Mulx, a, b);
        }
        boolean isDouble = a.getPlatformKind().equals(SPARCKind.DOUBLE);
        return this.emitBinary(resultKind, isDouble ? SPARCAssembler.Opfs.Fmuld : SPARCAssembler.Opfs.Fmuls, a, b);
    }

    @Override
    public Value emitMulHigh(Value a, Value b) {
        SPARCArithmetic.MulHighOp.MulHigh opcode;
        switch ((SPARCKind)a.getPlatformKind()) {
            case WORD: {
                opcode = SPARCArithmetic.MulHighOp.MulHigh.IMUL;
                break;
            }
            case XWORD: {
                opcode = SPARCArithmetic.MulHighOp.MulHigh.LMUL;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return this.emitMulHigh(opcode, a, b);
    }

    @Override
    public Value emitUMulHigh(Value a, Value b) {
        switch ((SPARCKind)a.getPlatformKind()) {
            case WORD: {
                Variable result = this.emitBinary(LIRKind.combine(a, b), SPARCAssembler.Op3s.Mulx, this.emitZeroExtend(a), this.emitZeroExtend(b));
                return this.emitBinary(LIRKind.combine(a, b), SPARCAssembler.Op3s.Srax, (Value)result, SPARCKind.WORD.getSizeInBits());
            }
            case XWORD: {
                return this.emitBinary(LIRKind.combine(a, b), SPARCAssembler.Opfs.UMulxhi, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    private Value emitMulHigh(SPARCArithmetic.MulHighOp.MulHigh opcode, Value a, Value b) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(a, b));
        SPARCArithmetic.MulHighOp mulHigh = new SPARCArithmetic.MulHighOp(opcode, this.getLIRGen().load(a), this.getLIRGen().load(b), result, this.getLIRGen().newVariable(LIRKind.combine(a, b)));
        this.getLIRGen().append(mulHigh);
        return result;
    }

    @Override
    public Value emitDiv(Value a, Value b, LIRFrameState state) {
        LIRKind resultKind = LIRKind.combine(a, b);
        if (LIRValueUtil.isJavaConstant(b) && LIRValueUtil.asJavaConstant(b).isDefaultForKind()) {
            RegisterValue zero = SPARC.g0.asValue((ValueKind)LIRKind.value((PlatformKind)SPARCKind.WORD));
            return this.emitBinary(resultKind, SPARCAssembler.Op3s.Sdivx, (Value)zero, (Value)zero, state);
        }
        if (this.isNumericInteger(a.getPlatformKind())) {
            return this.emitBinary(resultKind, SPARCAssembler.Op3s.Sdivx, this.emitSignExtend(a), this.emitSignExtend(b), state);
        }
        boolean isDouble = a.getPlatformKind() == SPARCKind.DOUBLE;
        return this.emitBinary(resultKind, isDouble ? SPARCAssembler.Opfs.Fdivd : SPARCAssembler.Opfs.Fdivs, a, b, state);
    }

    @Override
    public Value emitRem(Value a, Value b, LIRFrameState state) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(a, b));
        switch ((SPARCKind)a.getPlatformKind()) {
            case WORD: {
                Value as = this.emitSignExtend(a);
                Value bs = this.emitSignExtend(b);
                Variable q1 = this.emitBinary(as.getValueKind(), SPARCAssembler.Op3s.Sdivx, as, bs, state);
                Variable q2 = this.emitBinary(as.getValueKind(), SPARCAssembler.Op3s.Mulx, (Value)q1, bs);
                result = this.emitSub(as, (Value)q2, false);
                break;
            }
            case XWORD: {
                Variable q1 = this.emitBinary(result.getValueKind(), SPARCAssembler.Op3s.Sdivx, a, b, state);
                Variable q2 = this.emitBinary(result.getValueKind(), SPARCAssembler.Op3s.Mulx, (Value)q1, b);
                result = this.emitSub(a, (Value)q2, false);
                break;
            }
            case SINGLE: {
                ForeignCallLinkage fremCall = this.getLIRGen().getForeignCalls().lookupForeignCall(Backend.ARITHMETIC_FREM);
                result = this.getLIRGen().emitForeignCall(fremCall, state, a, b);
                break;
            }
            case DOUBLE: {
                ForeignCallLinkage dremCall = this.getLIRGen().getForeignCalls().lookupForeignCall(Backend.ARITHMETIC_DREM);
                result = this.getLIRGen().emitForeignCall(dremCall, state, a, b);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("missing: " + a.getPlatformKind());
            }
        }
        return result;
    }

    @Override
    public Value emitURem(Value a, Value b, LIRFrameState state) {
        SPARCArithmetic.RemOp.Rem opcode;
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(a, b));
        Variable scratch1 = this.getLIRGen().newVariable(LIRKind.combine(a, b));
        Variable scratch2 = this.getLIRGen().newVariable(LIRKind.combine(a, b));
        switch ((SPARCKind)a.getPlatformKind()) {
            case WORD: {
                opcode = SPARCArithmetic.RemOp.Rem.IUREM;
                break;
            }
            case XWORD: {
                opcode = SPARCArithmetic.RemOp.Rem.LUREM;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        this.getLIRGen().append(new SPARCArithmetic.RemOp(opcode, result, (Value)this.asAllocatable(a), (Value)this.asAllocatable(b), scratch1, scratch2, state));
        return result;
    }

    @Override
    public Value emitUDiv(Value a, Value b, LIRFrameState state) {
        return this.emitBinary(LIRKind.combine(a, b), SPARCAssembler.Op3s.Udivx, this.emitZeroExtend(a), this.emitZeroExtend(b), state);
    }

    public Variable emitAnd(Value a, Value b) {
        LIRKind resultKind = LIRKind.combine(a, b);
        return this.emitBinary(resultKind, SPARCAssembler.Op3s.And, a, b);
    }

    public Variable emitOr(Value a, Value b) {
        LIRKind resultKind = LIRKind.combine(a, b);
        return this.emitBinary(resultKind, SPARCAssembler.Op3s.Or, a, b);
    }

    public Variable emitXor(Value a, Value b) {
        LIRKind resultKind = LIRKind.combine(a, b);
        return this.emitBinary(resultKind, SPARCAssembler.Op3s.Xor, a, b);
    }

    public Variable emitShl(Value a, Value b) {
        SPARCAssembler.Op3s op;
        SPARCKind aKind = (SPARCKind)a.getPlatformKind();
        LIRKind resultKind = LIRKind.combine(a, b).changeType((PlatformKind)aKind);
        switch (aKind) {
            case WORD: {
                op = SPARCAssembler.Op3s.Sll;
                break;
            }
            case XWORD: {
                op = SPARCAssembler.Op3s.Sllx;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere(String.format("Unsupported kind %s", aKind));
            }
        }
        return this.emitBinary(resultKind, op, a, b);
    }

    public Variable emitShr(Value a, Value b) {
        SPARCAssembler.Op3s op;
        SPARCKind aKind = (SPARCKind)a.getPlatformKind();
        LIRKind resultKind = LIRKind.combine(a, b).changeType((PlatformKind)aKind);
        switch (aKind) {
            case WORD: {
                op = SPARCAssembler.Op3s.Sra;
                break;
            }
            case XWORD: {
                op = SPARCAssembler.Op3s.Srax;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return this.emitBinary(resultKind, op, a, b);
    }

    public Variable emitUShr(Value a, Value b) {
        SPARCAssembler.Op3s op;
        SPARCKind aKind = (SPARCKind)a.getPlatformKind();
        LIRKind resultKind = LIRKind.combine(a, b).changeType((PlatformKind)aKind);
        switch (aKind) {
            case WORD: {
                op = SPARCAssembler.Op3s.Srl;
                break;
            }
            case XWORD: {
                op = SPARCAssembler.Op3s.Srlx;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return this.emitBinary(resultKind, op, a, b);
    }

    private AllocatableValue emitConvertMove(LIRKind kind, AllocatableValue input) {
        Variable result = this.getLIRGen().newVariable(kind);
        this.getLIRGen().emitMove(result, (Value)input);
        return result;
    }

    @Override
    public Value emitFloatConvert(FloatConvert op, Value inputValue) {
        Variable result;
        AllocatableValue inputAllocatable = this.asAllocatable(inputValue);
        switch (op) {
            case D2F: {
                result = this.getLIRGen().newVariable(LIRKind.combine(inputValue).changeType((PlatformKind)SPARCKind.SINGLE));
                this.getLIRGen().append(new SPARCOPFOp(SPARCAssembler.Opfs.Fdtos, inputAllocatable, result));
                break;
            }
            case F2D: {
                result = this.getLIRGen().newVariable(LIRKind.combine(inputValue).changeType((PlatformKind)SPARCKind.DOUBLE));
                this.getLIRGen().append(new SPARCOPFOp(SPARCAssembler.Opfs.Fstod, inputAllocatable, result));
                break;
            }
            case I2F: {
                Variable intEncodedFloatReg = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{inputAllocatable}).changeType((PlatformKind)SPARCKind.SINGLE));
                result = this.getLIRGen().newVariable(intEncodedFloatReg.getValueKind());
                this.moveBetweenFpGp(intEncodedFloatReg, inputAllocatable);
                this.getLIRGen().append(new SPARCOPFOp(SPARCAssembler.Opfs.Fitos, intEncodedFloatReg, result));
                break;
            }
            case I2D: {
                Variable convertedFloatReg = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{inputAllocatable}).changeType((PlatformKind)SPARCKind.SINGLE));
                result = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{inputAllocatable}).changeType((PlatformKind)SPARCKind.DOUBLE));
                this.moveBetweenFpGp(convertedFloatReg, inputAllocatable);
                this.getLIRGen().append(new SPARCOPFOp(SPARCAssembler.Opfs.Fitod, convertedFloatReg, result));
                break;
            }
            case L2D: {
                Variable longEncodedDoubleReg = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{inputAllocatable}).changeType((PlatformKind)SPARCKind.DOUBLE));
                this.moveBetweenFpGp(longEncodedDoubleReg, inputAllocatable);
                Variable convertedDoubleReg = this.getLIRGen().newVariable(longEncodedDoubleReg.getValueKind());
                this.getLIRGen().append(new SPARCOPFOp(SPARCAssembler.Opfs.Fxtod, longEncodedDoubleReg, convertedDoubleReg));
                result = convertedDoubleReg;
                break;
            }
            case D2I: {
                Variable convertedFloatReg = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{inputAllocatable}).changeType((PlatformKind)SPARCKind.SINGLE));
                this.getLIRGen().append(new SPARCArithmetic.FloatConvertOp(SPARCArithmetic.FloatConvertOp.FloatConvert.D2I, (Value)inputAllocatable, convertedFloatReg));
                Variable convertedIntReg = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{convertedFloatReg}).changeType((PlatformKind)SPARCKind.WORD));
                this.moveBetweenFpGp(convertedIntReg, convertedFloatReg);
                result = convertedIntReg;
                break;
            }
            case F2L: {
                Variable convertedDoubleReg = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{inputAllocatable}).changeType((PlatformKind)SPARCKind.DOUBLE));
                this.getLIRGen().append(new SPARCArithmetic.FloatConvertOp(SPARCArithmetic.FloatConvertOp.FloatConvert.F2L, (Value)inputAllocatable, convertedDoubleReg));
                Variable convertedLongReg = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{convertedDoubleReg}).changeType((PlatformKind)SPARCKind.XWORD));
                this.moveBetweenFpGp(convertedLongReg, convertedDoubleReg);
                result = convertedLongReg;
                break;
            }
            case F2I: {
                Variable convertedFloatReg = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{inputAllocatable}).changeType((PlatformKind)SPARCKind.SINGLE));
                this.getLIRGen().append(new SPARCArithmetic.FloatConvertOp(SPARCArithmetic.FloatConvertOp.FloatConvert.F2I, (Value)inputAllocatable, convertedFloatReg));
                Variable convertedIntReg = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{convertedFloatReg}).changeType((PlatformKind)SPARCKind.WORD));
                this.moveBetweenFpGp(convertedIntReg, convertedFloatReg);
                result = convertedIntReg;
                break;
            }
            case D2L: {
                Variable convertedDoubleReg = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{inputAllocatable}).changeType((PlatformKind)SPARCKind.DOUBLE));
                this.getLIRGen().append(new SPARCArithmetic.FloatConvertOp(SPARCArithmetic.FloatConvertOp.FloatConvert.D2L, (Value)inputAllocatable, convertedDoubleReg));
                Variable convertedLongReg = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{convertedDoubleReg}).changeType((PlatformKind)SPARCKind.XWORD));
                this.moveBetweenFpGp(convertedLongReg, convertedDoubleReg);
                result = convertedLongReg;
                break;
            }
            case L2F: {
                Variable convertedDoubleReg = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{inputAllocatable}).changeType((PlatformKind)SPARCKind.DOUBLE));
                result = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{inputAllocatable}).changeType((PlatformKind)SPARCKind.SINGLE));
                this.moveBetweenFpGp(convertedDoubleReg, inputAllocatable);
                this.getLIRGen().append(new SPARCOPFOp(SPARCAssembler.Opfs.Fxtos, convertedDoubleReg, result));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return result;
    }

    protected VirtualStackSlot getTempSlot(LIRKind kind) {
        return this.getLIRGen().getResult().getFrameMapBuilder().allocateSpillSlot(kind);
    }

    private void moveBetweenFpGp(AllocatableValue dst, AllocatableValue src) {
        PlatformKind dstKind = dst.getPlatformKind();
        PlatformKind srcKind = src.getPlatformKind();
        VirtualStackSlot tempSlot = !(!this.getLIRGen().getArchitecture().getFeatures().contains(SPARC.CPUFeature.VIS3) || srcKind == SPARCKind.WORD && dstKind == SPARCKind.SINGLE || srcKind == SPARCKind.SINGLE && dstKind == SPARCKind.WORD) ? AllocatableValue.ILLEGAL : this.getTempSlot(LIRKind.value((PlatformKind)SPARCKind.XWORD));
        this.getLIRGen().append(new SPARCMove.MoveFpGp(dst, src, tempSlot));
    }

    @Override
    public Value emitNarrow(Value inputVal, int bits) {
        if (inputVal.getPlatformKind() == SPARCKind.XWORD && bits <= 32) {
            LIRKind resultKind = LIRKind.combine(inputVal).changeType((PlatformKind)SPARCKind.WORD);
            Variable result = this.getLIRGen().newVariable(resultKind);
            this.getLIRGen().emitMove(result, inputVal);
            return result;
        }
        return inputVal;
    }

    private Value emitSignExtend(Value inputValue) {
        int inputBits = inputValue.getPlatformKind().getSizeInBytes() * 8;
        return this.emitNarrow(this.emitSignExtend(inputValue, inputBits, SPARCKind.XWORD.getSizeInBits()), inputBits);
    }

    @Override
    public Value emitSignExtend(Value inputVal, int fromBits, int toBits) {
        assert (fromBits <= toBits && toBits <= SPARCKind.XWORD.getSizeInBits());
        LIRKind shiftKind = LIRKind.value((PlatformKind)SPARCKind.WORD);
        LIRKind resultKind = LIRKind.combine(inputVal).changeType((PlatformKind)(toBits > 32 ? SPARCKind.XWORD : SPARCKind.WORD));
        int shiftCount = SPARCKind.XWORD.getSizeInBits() - fromBits;
        if (fromBits == toBits) {
            return inputVal;
        }
        if (LIRValueUtil.isJavaConstant(inputVal)) {
            JavaConstant javaConstant = LIRValueUtil.asJavaConstant(inputVal);
            long constant = javaConstant.isNull() ? 0L : javaConstant.asLong();
            return new ConstantValue(resultKind, (Constant)JavaConstant.forLong((long)(constant << shiftCount >> shiftCount)));
        }
        AllocatableValue inputAllocatable = this.asAllocatable(inputVal);
        Variable result = this.getLIRGen().newVariable(resultKind);
        if (fromBits == SPARCKind.WORD.getSizeInBits() && toBits == SPARCKind.XWORD.getSizeInBits()) {
            this.getLIRGen().append(new SPARCOP3Op(SPARCAssembler.Op3s.Sra, inputAllocatable, (Value)SPARC.g0.asValue((ValueKind)LIRKind.value((PlatformKind)SPARCKind.WORD)), result));
        } else {
            Variable tmp = this.getLIRGen().newVariable(resultKind.changeType((PlatformKind)SPARCKind.XWORD));
            this.getLIRGen().append(new SPARCOP3Op(SPARCAssembler.Op3s.Sllx, inputAllocatable, new ConstantValue(shiftKind, (Constant)JavaConstant.forInt((int)shiftCount)), tmp));
            this.getLIRGen().append(new SPARCOP3Op(SPARCAssembler.Op3s.Srax, tmp, new ConstantValue(shiftKind, (Constant)JavaConstant.forInt((int)shiftCount)), result));
        }
        return result;
    }

    private Value emitZeroExtend(Value inputValue) {
        int inputBits = inputValue.getPlatformKind().getSizeInBytes() * 8;
        return this.emitNarrow(this.emitZeroExtend(inputValue, inputBits, SPARCKind.XWORD.getSizeInBits()), inputBits);
    }

    @Override
    public Value emitZeroExtend(Value inputValue, int fromBits, int toBits) {
        assert (fromBits <= toBits && toBits <= 64);
        if (fromBits == toBits) {
            return inputValue;
        }
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(inputValue).changeType((PlatformKind)(toBits > SPARCKind.WORD.getSizeInBits() ? SPARCKind.XWORD : SPARCKind.WORD)));
        AllocatableValue inputAllocatable = this.asAllocatable(inputValue);
        if (fromBits == 32) {
            this.getLIRGen().append(new SPARCOP3Op(SPARCAssembler.Op3s.Srl, inputAllocatable, (Value)SPARC.g0.asValue(), result));
        } else {
            Value mask = this.getLIRGen().emitConstant(LIRKind.value((PlatformKind)SPARCKind.XWORD), (Constant)JavaConstant.forLong((long)CodeUtil.mask((int)fromBits)));
            this.getLIRGen().append(new SPARCOP3Op(SPARCAssembler.Op3s.And, inputAllocatable, mask, result));
        }
        return result;
    }

    public AllocatableValue emitReinterpret(LIRKind to, Value inputVal) {
        SPARCKind fromKind = (SPARCKind)inputVal.getPlatformKind();
        SPARCKind toKind = (SPARCKind)to.getPlatformKind();
        AllocatableValue input = this.asAllocatable(inputVal);
        Variable result = this.getLIRGen().newVariable(to);
        if (fromKind.isFloat() != toKind.isFloat()) {
            this.moveBetweenFpGp(result, input);
            return result;
        }
        return this.emitConvertMove(to, input);
    }

    @Override
    public Variable emitLoad(LIRKind kind, Value address, LIRFrameState state) {
        SPARCAddressValue loadAddress = this.getLIRGen().asAddressValue(address);
        Variable result = this.getLIRGen().newVariable(this.getLIRGen().toRegisterKind(kind));
        this.getLIRGen().append(new SPARCMove.LoadOp(kind.getPlatformKind(), result, loadAddress, state));
        return result;
    }

    @Override
    public Variable emitVolatileLoad(LIRKind kind, Value address, LIRFrameState state) {
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public void emitVolatileStore(ValueKind<?> kind, Value address, Value input, LIRFrameState state) {
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public void emitStore(ValueKind<?> kind, Value address, Value inputVal, LIRFrameState state) {
        JavaConstant c;
        SPARCAddressValue storeAddress = this.getLIRGen().asAddressValue(address);
        if (LIRValueUtil.isJavaConstant(inputVal) && (c = LIRValueUtil.asJavaConstant(inputVal)).isDefaultForKind()) {
            this.getLIRGen().append(new SPARCMove.StoreConstantOp(kind.getPlatformKind(), storeAddress, c, state));
            return;
        }
        Variable input = this.getLIRGen().load(inputVal);
        this.getLIRGen().append(new SPARCMove.StoreOp(kind.getPlatformKind(), storeAddress, input, state));
    }
}

