/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.type;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.MemoryAccessProvider;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.ArithmeticStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;

public abstract class PrimitiveStamp
extends ArithmeticStamp {
    private final int bits;

    protected PrimitiveStamp(int bits, ArithmeticOpTable ops) {
        super(ops);
        this.bits = bits;
    }

    @Override
    public void accept(SpeculationReasonGroup.SpeculationContextObject.Visitor v) {
        v.visitInt(this.bits);
    }

    public int getBits() {
        return this.bits;
    }

    public static int getBits(Stamp stamp) {
        if (stamp instanceof PrimitiveStamp) {
            return ((PrimitiveStamp)stamp).getBits();
        }
        return 0;
    }

    @Override
    public Constant readConstant(MemoryAccessProvider provider, Constant base, long displacement) {
        try {
            return provider.readPrimitiveConstant(this.getStackKind(), base, displacement, this.getBits());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.bits;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PrimitiveStamp)) {
            return false;
        }
        PrimitiveStamp other = (PrimitiveStamp)obj;
        if (this.bits != other.bits) {
            return false;
        }
        return super.equals(obj);
    }
}

