/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.type;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.type.ArithmeticStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.util.CollectionsUtil;

public final class ArithmeticOpTable {
    private final UnaryOp<UnaryOp.Neg> neg;
    private final BinaryOp<BinaryOp.Add> add;
    private final BinaryOp<BinaryOp.Sub> sub;
    private final BinaryOp<BinaryOp.Mul> mul;
    private final BinaryOp<BinaryOp.MulHigh> mulHigh;
    private final BinaryOp<BinaryOp.UMulHigh> umulHigh;
    private final BinaryOp<BinaryOp.Div> div;
    private final BinaryOp<BinaryOp.Rem> rem;
    private final UnaryOp<UnaryOp.Not> not;
    private final BinaryOp<BinaryOp.And> and;
    private final BinaryOp<BinaryOp.Or> or;
    private final BinaryOp<BinaryOp.Xor> xor;
    private final ShiftOp<ShiftOp.Shl> shl;
    private final ShiftOp<ShiftOp.Shr> shr;
    private final ShiftOp<ShiftOp.UShr> ushr;
    private final UnaryOp<UnaryOp.Abs> abs;
    private final UnaryOp<UnaryOp.Sqrt> sqrt;
    private final IntegerConvertOp<IntegerConvertOp.ZeroExtend> zeroExtend;
    private final IntegerConvertOp<IntegerConvertOp.SignExtend> signExtend;
    private final IntegerConvertOp<IntegerConvertOp.Narrow> narrow;
    private final BinaryOp<BinaryOp.Max> max;
    private final BinaryOp<BinaryOp.Min> min;
    private final FloatConvertOp[] floatConvert;
    private final int hash;
    public static final ArithmeticOpTable EMPTY = new ArithmeticOpTable(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new FloatConvertOp[0]);

    public static ArithmeticOpTable forStamp(Stamp s) {
        if (s instanceof ArithmeticStamp) {
            return ((ArithmeticStamp)s).getOps();
        }
        return EMPTY;
    }

    public BinaryOp<?>[] getBinaryOps() {
        return new BinaryOp[]{this.add, this.sub, this.mul, this.mulHigh, this.umulHigh, this.div, this.rem, this.and, this.or, this.xor, this.max, this.min};
    }

    public UnaryOp<?>[] getUnaryOps() {
        return new UnaryOp[]{this.neg, this.not, this.abs, this.sqrt};
    }

    public ShiftOp<?>[] getShiftOps() {
        return new ShiftOp[]{this.shl, this.shr, this.ushr};
    }

    public IntegerConvertOp<?>[] getIntegerConvertOps() {
        return new IntegerConvertOp[]{this.zeroExtend, this.signExtend, this.narrow};
    }

    private static <T> T wrapIfNonNull(Function<T, T> wrapper, T obj) {
        if (obj == null) {
            return null;
        }
        return wrapper.apply(obj);
    }

    public static ArithmeticOpTable wrap(ArithmeticOpWrapper wrapper, ArithmeticOpTable inner) {
        UnaryOp<UnaryOp.Neg> neg = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapUnaryOp, inner.getNeg());
        BinaryOp<BinaryOp.Add> add = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapBinaryOp, inner.getAdd());
        BinaryOp<BinaryOp.Sub> sub = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapBinaryOp, inner.getSub());
        BinaryOp<BinaryOp.Mul> mul = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapBinaryOp, inner.getMul());
        BinaryOp<BinaryOp.MulHigh> mulHigh = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapBinaryOp, inner.getMulHigh());
        BinaryOp<BinaryOp.UMulHigh> umulHigh = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapBinaryOp, inner.getUMulHigh());
        BinaryOp<BinaryOp.Div> div = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapBinaryOp, inner.getDiv());
        BinaryOp<BinaryOp.Rem> rem = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapBinaryOp, inner.getRem());
        UnaryOp<UnaryOp.Not> not = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapUnaryOp, inner.getNot());
        BinaryOp<BinaryOp.And> and = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapBinaryOp, inner.getAnd());
        BinaryOp<BinaryOp.Or> or = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapBinaryOp, inner.getOr());
        BinaryOp<BinaryOp.Xor> xor = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapBinaryOp, inner.getXor());
        ShiftOp<ShiftOp.Shl> shl = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapShiftOp, inner.getShl());
        ShiftOp<ShiftOp.Shr> shr = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapShiftOp, inner.getShr());
        ShiftOp<ShiftOp.UShr> ushr = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapShiftOp, inner.getUShr());
        UnaryOp<UnaryOp.Abs> abs = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapUnaryOp, inner.getAbs());
        UnaryOp<UnaryOp.Sqrt> sqrt = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapUnaryOp, inner.getSqrt());
        IntegerConvertOp<IntegerConvertOp.ZeroExtend> zeroExtend = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapIntegerConvertOp, inner.getZeroExtend());
        IntegerConvertOp<IntegerConvertOp.SignExtend> signExtend = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapIntegerConvertOp, inner.getSignExtend());
        IntegerConvertOp<IntegerConvertOp.Narrow> narrow = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapIntegerConvertOp, inner.getNarrow());
        BinaryOp<BinaryOp.Max> max = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapBinaryOp, inner.getMax());
        BinaryOp<BinaryOp.Min> min = ArithmeticOpTable.wrapIfNonNull(wrapper::wrapBinaryOp, inner.getMin());
        FloatConvertOp[] floatConvert = CollectionsUtil.filterAndMapToArray(inner.floatConvert, Objects::nonNull, wrapper::wrapFloatConvertOp, FloatConvertOp[]::new);
        return new ArithmeticOpTable(neg, add, sub, mul, mulHigh, umulHigh, div, rem, not, and, or, xor, shl, shr, ushr, abs, sqrt, zeroExtend, signExtend, narrow, max, min, floatConvert);
    }

    protected ArithmeticOpTable(UnaryOp<UnaryOp.Neg> neg, BinaryOp<BinaryOp.Add> add, BinaryOp<BinaryOp.Sub> sub, BinaryOp<BinaryOp.Mul> mul, BinaryOp<BinaryOp.MulHigh> mulHigh, BinaryOp<BinaryOp.UMulHigh> umulHigh, BinaryOp<BinaryOp.Div> div, BinaryOp<BinaryOp.Rem> rem, UnaryOp<UnaryOp.Not> not, BinaryOp<BinaryOp.And> and, BinaryOp<BinaryOp.Or> or, BinaryOp<BinaryOp.Xor> xor, ShiftOp<ShiftOp.Shl> shl, ShiftOp<ShiftOp.Shr> shr, ShiftOp<ShiftOp.UShr> ushr, UnaryOp<UnaryOp.Abs> abs, UnaryOp<UnaryOp.Sqrt> sqrt, IntegerConvertOp<IntegerConvertOp.ZeroExtend> zeroExtend, IntegerConvertOp<IntegerConvertOp.SignExtend> signExtend, IntegerConvertOp<IntegerConvertOp.Narrow> narrow, BinaryOp<BinaryOp.Max> max, BinaryOp<BinaryOp.Min> min, FloatConvertOp ... floatConvert) {
        this.neg = neg;
        this.add = add;
        this.sub = sub;
        this.mul = mul;
        this.mulHigh = mulHigh;
        this.umulHigh = umulHigh;
        this.div = div;
        this.rem = rem;
        this.not = not;
        this.and = and;
        this.or = or;
        this.xor = xor;
        this.shl = shl;
        this.shr = shr;
        this.ushr = ushr;
        this.abs = abs;
        this.sqrt = sqrt;
        this.zeroExtend = zeroExtend;
        this.signExtend = signExtend;
        this.narrow = narrow;
        this.max = max;
        this.min = min;
        this.floatConvert = new FloatConvertOp[FloatConvert.values().length];
        FloatConvertOp[] floatConvertOpArray = floatConvert;
        int n = floatConvertOpArray.length;
        for (int i = 0; i < n; ++i) {
            FloatConvertOp op;
            this.floatConvert[op.getFloatConvert().ordinal()] = op = floatConvertOpArray[i];
        }
        this.hash = Objects.hash(neg, add, sub, mul, div, rem, not, and, or, xor, shl, shr, ushr, abs, sqrt, zeroExtend, signExtend, narrow, max, min);
    }

    public int hashCode() {
        return this.hash;
    }

    public UnaryOp<UnaryOp.Neg> getNeg() {
        return this.neg;
    }

    public BinaryOp<BinaryOp.Add> getAdd() {
        return this.add;
    }

    public BinaryOp<BinaryOp.Sub> getSub() {
        return this.sub;
    }

    public BinaryOp<BinaryOp.Mul> getMul() {
        return this.mul;
    }

    public BinaryOp<BinaryOp.MulHigh> getMulHigh() {
        return this.mulHigh;
    }

    public BinaryOp<BinaryOp.UMulHigh> getUMulHigh() {
        return this.umulHigh;
    }

    public BinaryOp<BinaryOp.Div> getDiv() {
        return this.div;
    }

    public BinaryOp<BinaryOp.Rem> getRem() {
        return this.rem;
    }

    public UnaryOp<UnaryOp.Not> getNot() {
        return this.not;
    }

    public BinaryOp<BinaryOp.And> getAnd() {
        return this.and;
    }

    public BinaryOp<BinaryOp.Or> getOr() {
        return this.or;
    }

    public BinaryOp<BinaryOp.Xor> getXor() {
        return this.xor;
    }

    public ShiftOp<ShiftOp.Shl> getShl() {
        return this.shl;
    }

    public ShiftOp<ShiftOp.Shr> getShr() {
        return this.shr;
    }

    public ShiftOp<ShiftOp.UShr> getUShr() {
        return this.ushr;
    }

    public UnaryOp<UnaryOp.Abs> getAbs() {
        return this.abs;
    }

    public UnaryOp<UnaryOp.Sqrt> getSqrt() {
        return this.sqrt;
    }

    public IntegerConvertOp<IntegerConvertOp.ZeroExtend> getZeroExtend() {
        return this.zeroExtend;
    }

    public IntegerConvertOp<IntegerConvertOp.SignExtend> getSignExtend() {
        return this.signExtend;
    }

    public IntegerConvertOp<IntegerConvertOp.Narrow> getNarrow() {
        return this.narrow;
    }

    public BinaryOp<BinaryOp.Max> getMax() {
        return this.max;
    }

    public BinaryOp<BinaryOp.Min> getMin() {
        return this.min;
    }

    public FloatConvertOp getFloatConvert(FloatConvert op) {
        return this.floatConvert[op.ordinal()];
    }

    public static String toString(Op ... ops) {
        return CollectionsUtil.mapAndJoin(ops, o -> o == null ? "null" : ((Op)o).operator + "{" + MetaUtil.getSimpleName(o.getClass(), (boolean)false) + "}", ",");
    }

    private boolean opsEquals(ArithmeticOpTable that) {
        return Objects.equals(this.neg, that.neg) && Objects.equals(this.add, that.add) && Objects.equals(this.sub, that.sub) && Objects.equals(this.mul, that.mul) && Objects.equals(this.mulHigh, that.mulHigh) && Objects.equals(this.umulHigh, that.umulHigh) && Objects.equals(this.div, that.div) && Objects.equals(this.rem, that.rem) && Objects.equals(this.not, that.not) && Objects.equals(this.and, that.and) && Objects.equals(this.or, that.or) && Objects.equals(this.xor, that.xor) && Objects.equals(this.shl, that.shl) && Objects.equals(this.shr, that.shr) && Objects.equals(this.ushr, that.ushr) && Objects.equals(this.abs, that.abs) && Objects.equals(this.sqrt, that.sqrt) && Objects.equals(this.zeroExtend, that.zeroExtend) && Objects.equals(this.signExtend, that.signExtend) && Objects.equals(this.narrow, that.narrow) && Objects.equals(this.max, that.max) && Objects.equals(this.min, that.min);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArithmeticOpTable that = (ArithmeticOpTable)obj;
        return this.opsEquals(that) && Arrays.equals(this.floatConvert, that.floatConvert);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + ArithmeticOpTable.toString(this.neg, this.add, this.sub, this.mul, this.mulHigh, this.umulHigh, this.div, this.rem, this.not, this.and, this.or, this.xor, this.shl, this.shr, this.ushr, this.abs, this.sqrt, this.zeroExtend, this.signExtend, this.narrow, this.max, this.min) + ",floatConvert[" + ArithmeticOpTable.toString(this.floatConvert) + "]]";
    }

    public static abstract class IntegerConvertOp<T>
    extends Op {
        protected IntegerConvertOp(String op) {
            super(op);
        }

        public abstract Constant foldConstant(int var1, int var2, Constant var3);

        public abstract Stamp foldStamp(int var1, int var2, Stamp var3);

        public IntegerConvertOp<T> unwrap() {
            return this;
        }

        public abstract Stamp invertStamp(int var1, int var2, Stamp var3);

        public static abstract class Narrow
        extends IntegerConvertOp<Narrow> {
            protected Narrow() {
                super("Narrow");
            }

            @Override
            public Stamp invertStamp(int inputBits, int resultBits, Stamp outStamp) {
                return null;
            }
        }

        public static abstract class SignExtend
        extends IntegerConvertOp<SignExtend> {
            protected SignExtend() {
                super("SignExtend");
            }
        }

        public static abstract class ZeroExtend
        extends IntegerConvertOp<ZeroExtend> {
            protected ZeroExtend() {
                super("ZeroExtend");
            }
        }
    }

    public static abstract class FloatConvertOp
    extends UnaryOp<FloatConvertOp> {
        private final FloatConvert op;

        protected FloatConvertOp(FloatConvert op) {
            super(op.name());
            this.op = op;
        }

        public FloatConvert getFloatConvert() {
            return this.op;
        }

        public FloatConvertOp unwrap() {
            return this;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            return 31 * super.hashCode() + this.op.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FloatConvertOp that = (FloatConvertOp)obj;
            return this.op == that.op;
        }
    }

    public static abstract class ShiftOp<OP>
    extends Op {
        protected ShiftOp(String operation) {
            super(operation);
        }

        public abstract Constant foldConstant(Constant var1, int var2);

        public abstract Stamp foldStamp(Stamp var1, IntegerStamp var2);

        public abstract int getShiftAmountMask(Stamp var1);

        public static abstract class UShr
        extends ShiftOp<UShr> {
            public UShr() {
                super(">>>");
            }
        }

        public static abstract class Shr
        extends ShiftOp<Shr> {
            public Shr() {
                super(">>");
            }
        }

        public static abstract class Shl
        extends ShiftOp<Shl> {
            public Shl() {
                super("<<");
            }
        }
    }

    public static abstract class BinaryOp<T>
    extends Op {
        private final boolean associative;
        private final boolean commutative;

        protected BinaryOp(String operation, boolean associative, boolean commutative) {
            super(operation);
            this.associative = associative;
            this.commutative = commutative;
        }

        public abstract Constant foldConstant(Constant var1, Constant var2);

        public abstract Stamp foldStamp(Stamp var1, Stamp var2);

        public final boolean isAssociative() {
            return this.associative;
        }

        public final boolean isCommutative() {
            return this.commutative;
        }

        public boolean isNeutral(Constant n) {
            return false;
        }

        public Constant getZero(Stamp stamp) {
            return null;
        }

        public BinaryOp<T> unwrap() {
            return this;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.associative ? 1231 : 1237);
            result = 31 * result + (this.commutative ? 1231 : 1237);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BinaryOp that = (BinaryOp)obj;
            if (this.associative != that.associative) {
                return false;
            }
            return this.commutative == that.commutative;
        }

        @Override
        public String toString() {
            if (this.associative) {
                if (this.commutative) {
                    return super.toString() + "[AC]";
                }
                return super.toString() + "[A]";
            }
            if (this.commutative) {
                return super.toString() + "[C]";
            }
            return super.toString();
        }

        public static abstract class Min
        extends BinaryOp<Min> {
            protected Min(boolean associative, boolean commutative) {
                super("MIN", associative, commutative);
            }
        }

        public static abstract class Max
        extends BinaryOp<Max> {
            protected Max(boolean associative, boolean commutative) {
                super("MAX", associative, commutative);
            }
        }

        public static abstract class Xor
        extends BinaryOp<Xor> {
            protected Xor(boolean associative, boolean commutative) {
                super("^", associative, commutative);
            }
        }

        public static abstract class Or
        extends BinaryOp<Or> {
            protected Or(boolean associative, boolean commutative) {
                super("|", associative, commutative);
            }
        }

        public static abstract class And
        extends BinaryOp<And> {
            protected And(boolean associative, boolean commutative) {
                super("&", associative, commutative);
            }
        }

        public static abstract class Rem
        extends BinaryOp<Rem> {
            protected Rem(boolean associative, boolean commutative) {
                super("%", associative, commutative);
            }
        }

        public static abstract class Div
        extends BinaryOp<Div> {
            protected Div(boolean associative, boolean commutative) {
                super("/", associative, commutative);
            }
        }

        public static abstract class UMulHigh
        extends BinaryOp<UMulHigh> {
            protected UMulHigh(boolean associative, boolean commutative) {
                super("|*H|", associative, commutative);
            }
        }

        public static abstract class MulHigh
        extends BinaryOp<MulHigh> {
            protected MulHigh(boolean associative, boolean commutative) {
                super("*H", associative, commutative);
            }
        }

        public static abstract class Mul
        extends BinaryOp<Mul> {
            protected Mul(boolean associative, boolean commutative) {
                super("*", associative, commutative);
            }
        }

        public static abstract class Sub
        extends BinaryOp<Sub> {
            protected Sub(boolean associative, boolean commutative) {
                super("-", associative, commutative);
            }
        }

        public static abstract class Add
        extends BinaryOp<Add> {
            protected Add(boolean associative, boolean commutative) {
                super("+", associative, commutative);
            }
        }
    }

    public static abstract class UnaryOp<T>
    extends Op {
        protected UnaryOp(String operation) {
            super(operation);
        }

        public abstract Constant foldConstant(Constant var1);

        public abstract Stamp foldStamp(Stamp var1);

        public UnaryOp<T> unwrap() {
            return this;
        }

        public static abstract class Sqrt
        extends UnaryOp<Sqrt> {
            protected Sqrt() {
                super("SQRT");
            }
        }

        public static abstract class Abs
        extends UnaryOp<Abs> {
            protected Abs() {
                super("ABS");
            }
        }

        public static abstract class Not
        extends UnaryOp<Not> {
            protected Not() {
                super("~");
            }
        }

        public static abstract class Neg
        extends UnaryOp<Neg> {
            protected Neg() {
                super("-");
            }
        }
    }

    public static abstract class Op {
        private final String operator;

        protected Op(String operator) {
            this.operator = operator;
        }

        public String toString() {
            return this.operator;
        }

        public int hashCode() {
            return this.operator.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Op that = (Op)obj;
            if (this.operator.equals(that.operator)) {
                return true;
            }
            return true;
        }
    }

    public static interface ArithmeticOpWrapper {
        public <OP> UnaryOp<OP> wrapUnaryOp(UnaryOp<OP> var1);

        public <OP> BinaryOp<OP> wrapBinaryOp(BinaryOp<OP> var1);

        public <OP> ShiftOp<OP> wrapShiftOp(ShiftOp<OP> var1);

        public <OP> IntegerConvertOp<OP> wrapIntegerConvertOp(IntegerConvertOp<OP> var1);

        public FloatConvertOp wrapFloatConvertOp(FloatConvertOp var1);
    }
}

