/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.cfg;

import java.util.Comparator;
import org.graalvm.compiler.core.common.cfg.Loop;

public abstract class AbstractBlockBase<T extends AbstractBlockBase<T>> {
    protected int id = -1;
    protected int domDepth;
    protected T[] predecessors;
    protected T[] successors;
    private T dominator;
    private T firstDominated;
    private T dominatedSibling;
    private int domNumber = -1;
    private int maxChildDomNumber = -1;
    private boolean align;
    private int linearScanNumber = -1;
    public static final BlockIdComparator BLOCK_ID_COMPARATOR = new BlockIdComparator();

    protected AbstractBlockBase() {
    }

    public void setDominatorNumber(int domNumber) {
        this.domNumber = domNumber;
    }

    public void setMaxChildDomNumber(int maxChildDomNumber) {
        this.maxChildDomNumber = maxChildDomNumber;
    }

    public int getDominatorNumber() {
        return this.domNumber;
    }

    public int getMaxChildDominatorNumber() {
        return this.maxChildDomNumber;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public T[] getPredecessors() {
        return this.predecessors;
    }

    public void setPredecessors(T[] predecessors) {
        this.predecessors = predecessors;
    }

    public T[] getSuccessors() {
        return this.successors;
    }

    public void setSuccessors(T[] successors) {
        this.successors = successors;
    }

    public T getDominator() {
        return this.dominator;
    }

    public T getDominatorSkipLoops() {
        T d = this.getDominator();
        if (d == null) {
            return null;
        }
        if (this.isLoopHeader()) {
            assert (((AbstractBlockBase)d).getLoopDepth() == this.getLoopDepth() - 1);
            assert (((AbstractBlockBase)d).getLoop() != this.getLoop());
            return d;
        }
        while (((AbstractBlockBase)d).getLoop() != this.getLoop()) {
            d = ((AbstractBlockBase)d).getDominator();
        }
        assert (((AbstractBlockBase)d).getLoopDepth() <= this.getLoopDepth());
        return d;
    }

    public void setDominator(T dominator) {
        this.dominator = dominator;
        this.domDepth = ((AbstractBlockBase)dominator).domDepth + 1;
    }

    public int getDominatorDepth() {
        return this.domDepth;
    }

    public T getFirstDominated() {
        return this.firstDominated;
    }

    public void setFirstDominated(T block) {
        this.firstDominated = block;
    }

    public T getDominatedSibling() {
        return this.dominatedSibling;
    }

    public void setDominatedSibling(T block) {
        this.dominatedSibling = block;
    }

    public String toString() {
        return "B" + this.id;
    }

    public int getPredecessorCount() {
        return this.getPredecessors().length;
    }

    public int getSuccessorCount() {
        return this.getSuccessors().length;
    }

    public int getLinearScanNumber() {
        return this.linearScanNumber;
    }

    public void setLinearScanNumber(int linearScanNumber) {
        this.linearScanNumber = linearScanNumber;
    }

    public boolean isAligned() {
        return this.align;
    }

    public void setAlign(boolean align) {
        this.align = align;
    }

    public abstract boolean isExceptionEntry();

    public abstract Loop<T> getLoop();

    public abstract int getLoopDepth();

    public abstract void delete();

    public abstract boolean isLoopEnd();

    public abstract boolean isLoopHeader();

    public abstract T getPostdominator();

    public abstract double getRelativeFrequency();

    public abstract T getDominator(int var1);

    public int hashCode() {
        return this.id;
    }

    public static class BlockIdComparator
    implements Comparator<AbstractBlockBase<?>> {
        @Override
        public int compare(AbstractBlockBase<?> o1, AbstractBlockBase<?> o2) {
            return Integer.compare(o1.getId(), o2.getId());
        }
    }
}

