/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.amd64;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.framemap.FrameMapBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

public abstract class AMD64MoveFactoryBase
implements LIRGeneratorTool.MoveFactory {
    private final BackupSlotProvider backupSlotProvider;

    public AMD64MoveFactoryBase(BackupSlotProvider backupSlotProvider) {
        this.backupSlotProvider = backupSlotProvider;
    }

    @Override
    public final AMD64LIRInstruction createStackMove(AllocatableValue result, AllocatableValue input) {
        AMD64Kind kind = (AMD64Kind)result.getPlatformKind();
        switch (kind.getSizeInBytes()) {
            case 2: {
                return new AMD64Move.AMD64PushPopStackMove(AMD64BaseAssembler.OperandSize.WORD, result, input);
            }
            case 8: {
                return new AMD64Move.AMD64PushPopStackMove(AMD64BaseAssembler.OperandSize.QWORD, result, input);
            }
        }
        RegisterBackupPair backup = this.backupSlotProvider.getScratchRegister(input.getPlatformKind());
        Register scratchRegister = backup.register;
        VirtualStackSlot backupSlot = backup.backupSlot;
        return this.createStackMove(result, input, scratchRegister, backupSlot);
    }

    public abstract AMD64LIRInstruction createStackMove(AllocatableValue var1, AllocatableValue var2, Register var3, AllocatableValue var4);

    public static final class BackupSlotProvider {
        private final FrameMapBuilder frameMapBuilder;
        private EconomicMap<PlatformKind.Key, RegisterBackupPair> categorized;

        public BackupSlotProvider(FrameMapBuilder frameMapBuilder) {
            this.frameMapBuilder = frameMapBuilder;
        }

        protected RegisterBackupPair getScratchRegister(PlatformKind kind) {
            PlatformKind.Key key = kind.getKey();
            if (this.categorized == null) {
                this.categorized = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            } else if (this.categorized.containsKey((Object)key)) {
                return (RegisterBackupPair)this.categorized.get((Object)key);
            }
            RegisterConfig registerConfig = this.frameMapBuilder.getRegisterConfig();
            RegisterArray availableRegister = registerConfig.filterAllocatableRegisters(kind, registerConfig.getAllocatableRegisters());
            assert (availableRegister != null && availableRegister.size() > 1);
            Register scratchRegister = availableRegister.get(0);
            Architecture arch = this.frameMapBuilder.getCodeCache().getTarget().arch;
            LIRKind largestKind = LIRKind.value(arch.getLargestStorableKind(scratchRegister.getRegisterCategory()));
            VirtualStackSlot backupSlot = this.frameMapBuilder.allocateSpillSlot(largestKind);
            RegisterBackupPair value = new RegisterBackupPair(scratchRegister, backupSlot);
            this.categorized.put((Object)key, (Object)value);
            return value;
        }
    }

    private static class RegisterBackupPair {
        public final Register register;
        public final VirtualStackSlot backupSlot;

        RegisterBackupPair(Register register, VirtualStackSlot backupSlot) {
            this.register = register;
            this.backupSlot = backupSlot;
        }
    }
}

