/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.VMConstant;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.amd64.AMD64LIRGenerator;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.amd64.AMD64Arithmetic;
import org.graalvm.compiler.lir.amd64.AMD64ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.lir.amd64.AMD64Binary;
import org.graalvm.compiler.lir.amd64.AMD64BinaryConsumer;
import org.graalvm.compiler.lir.amd64.AMD64ClearRegisterOp;
import org.graalvm.compiler.lir.amd64.AMD64MathCosOp;
import org.graalvm.compiler.lir.amd64.AMD64MathExpOp;
import org.graalvm.compiler.lir.amd64.AMD64MathLog10Op;
import org.graalvm.compiler.lir.amd64.AMD64MathLogOp;
import org.graalvm.compiler.lir.amd64.AMD64MathPowOp;
import org.graalvm.compiler.lir.amd64.AMD64MathSinOp;
import org.graalvm.compiler.lir.amd64.AMD64MathTanOp;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.amd64.AMD64MulDivOp;
import org.graalvm.compiler.lir.amd64.AMD64ShiftOp;
import org.graalvm.compiler.lir.amd64.AMD64SignExtendOp;
import org.graalvm.compiler.lir.amd64.AMD64Ternary;
import org.graalvm.compiler.lir.amd64.AMD64Unary;
import org.graalvm.compiler.lir.amd64.vector.AMD64VectorBinary;
import org.graalvm.compiler.lir.amd64.vector.AMD64VectorUnary;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGenerator;

public class AMD64ArithmeticLIRGenerator
extends ArithmeticLIRGenerator
implements AMD64ArithmeticLIRGeneratorTool {
    private static final RegisterValue RCX_I = AMD64.rcx.asValue((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.DWORD));
    private final AllocatableValue nullRegisterValue;

    public AMD64ArithmeticLIRGenerator(AllocatableValue nullRegisterValue) {
        this.nullRegisterValue = nullRegisterValue;
    }

    public Variable emitNegate(Value inputVal) {
        AllocatableValue input = this.asAllocatable(inputVal);
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{input}));
        boolean isAvx = this.supportAVX();
        switch ((AMD64Kind)input.getPlatformKind()) {
            case DWORD: {
                this.getLIRGen().append(new AMD64Unary.MOp(AMD64Assembler.AMD64MOp.NEG, AMD64BaseAssembler.OperandSize.DWORD, result, input));
                break;
            }
            case QWORD: {
                this.getLIRGen().append(new AMD64Unary.MOp(AMD64Assembler.AMD64MOp.NEG, AMD64BaseAssembler.OperandSize.QWORD, result, input));
                break;
            }
            case SINGLE: {
                PrimitiveConstant floatMask = JavaConstant.forFloat((float)Float.intBitsToFloat(Integer.MIN_VALUE));
                if (isAvx) {
                    this.getLIRGen().append(new AMD64VectorBinary.AVXBinaryOp(AMD64Assembler.VexRVMOp.VXORPS, AMD64ArithmeticLIRGenerator.getRegisterSize((Value)result), result, this.asAllocatable((Value)input), this.asAllocatable(this.getLIRGen().emitJavaConstant((JavaConstant)floatMask))));
                    break;
                }
                this.getLIRGen().append(new AMD64Binary.DataTwoOp(AMD64Assembler.SSEOp.XOR, AMD64BaseAssembler.OperandSize.PS, result, input, (JavaConstant)floatMask, 16));
                break;
            }
            case DOUBLE: {
                PrimitiveConstant doubleMask = JavaConstant.forDouble((double)Double.longBitsToDouble(Long.MIN_VALUE));
                if (isAvx) {
                    this.getLIRGen().append(new AMD64VectorBinary.AVXBinaryOp(AMD64Assembler.VexRVMOp.VXORPD, AMD64ArithmeticLIRGenerator.getRegisterSize((Value)result), result, this.asAllocatable((Value)input), this.asAllocatable(this.getLIRGen().emitJavaConstant((JavaConstant)doubleMask))));
                    break;
                }
                this.getLIRGen().append(new AMD64Binary.DataTwoOp(AMD64Assembler.SSEOp.XOR, AMD64BaseAssembler.OperandSize.PD, result, input, (JavaConstant)doubleMask, 16));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere(input.getPlatformKind().toString());
            }
        }
        return result;
    }

    public Variable emitNot(Value inputVal) {
        AllocatableValue input = this.asAllocatable(inputVal);
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{input}));
        switch ((AMD64Kind)input.getPlatformKind()) {
            case DWORD: {
                this.getLIRGen().append(new AMD64Unary.MOp(AMD64Assembler.AMD64MOp.NOT, AMD64BaseAssembler.OperandSize.DWORD, result, input));
                break;
            }
            case QWORD: {
                this.getLIRGen().append(new AMD64Unary.MOp(AMD64Assembler.AMD64MOp.NOT, AMD64BaseAssembler.OperandSize.QWORD, result, input));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return result;
    }

    private Variable emitBinary(LIRKind resultKind, AMD64Assembler.AMD64BinaryArithmetic op, AMD64BaseAssembler.OperandSize size, boolean commutative, Value a, Value b, boolean setFlags) {
        if (LIRValueUtil.isJavaConstant(b)) {
            return this.emitBinaryConst(resultKind, op, size, commutative, this.asAllocatable(a), LIRValueUtil.asConstantValue(b), setFlags);
        }
        if (commutative && LIRValueUtil.isJavaConstant(a)) {
            return this.emitBinaryConst(resultKind, op, size, commutative, this.asAllocatable(b), LIRValueUtil.asConstantValue(a), setFlags);
        }
        return this.emitBinaryVar(resultKind, op.getRMOpcode(size), size, commutative, this.asAllocatable(a), this.asAllocatable(b));
    }

    private Variable emitBinary(LIRKind resultKind, AMD64Assembler.AMD64RMOp op, AMD64BaseAssembler.OperandSize size, boolean commutative, Value a, Value b) {
        if (LIRValueUtil.isJavaConstant(b)) {
            return this.emitBinaryConst(resultKind, op, size, this.asAllocatable(a), LIRValueUtil.asJavaConstant(b));
        }
        if (commutative && LIRValueUtil.isJavaConstant(a)) {
            return this.emitBinaryConst(resultKind, op, size, this.asAllocatable(b), LIRValueUtil.asJavaConstant(a));
        }
        return this.emitBinaryVar(resultKind, op, size, commutative, this.asAllocatable(a), this.asAllocatable(b));
    }

    private Variable emitBinaryConst(LIRKind resultKind, AMD64Assembler.AMD64BinaryArithmetic op, AMD64BaseAssembler.OperandSize size, boolean commutative, AllocatableValue a, ConstantValue b, boolean setFlags) {
        long value = b.getJavaConstant().asLong();
        if (NumUtil.isInt(value)) {
            AMD64Assembler.AMD64MOp mop;
            Variable result = this.getLIRGen().newVariable(resultKind);
            int constant = (int)value;
            if (!setFlags && (mop = AMD64ArithmeticLIRGenerator.getMOp(op, constant)) != null) {
                this.getLIRGen().append(new AMD64Unary.MOp(mop, size, result, a));
                return result;
            }
            this.getLIRGen().append(new AMD64Binary.ConstOp(op, size, (AllocatableValue)result, a, constant));
            return result;
        }
        return this.emitBinaryVar(resultKind, op.getRMOpcode(size), size, commutative, a, this.asAllocatable(b));
    }

    private static AMD64Assembler.AMD64MOp getMOp(AMD64Assembler.AMD64BinaryArithmetic op, int constant) {
        if (constant == 1) {
            if (op.equals(AMD64Assembler.AMD64BinaryArithmetic.ADD)) {
                return AMD64Assembler.AMD64MOp.INC;
            }
            if (op.equals(AMD64Assembler.AMD64BinaryArithmetic.SUB)) {
                return AMD64Assembler.AMD64MOp.DEC;
            }
        } else if (constant == -1) {
            if (op.equals(AMD64Assembler.AMD64BinaryArithmetic.ADD)) {
                return AMD64Assembler.AMD64MOp.DEC;
            }
            if (op.equals(AMD64Assembler.AMD64BinaryArithmetic.SUB)) {
                return AMD64Assembler.AMD64MOp.INC;
            }
        }
        return null;
    }

    private Variable emitBinaryConst(LIRKind resultKind, AMD64Assembler.AMD64RMOp op, AMD64BaseAssembler.OperandSize size, AllocatableValue a, JavaConstant b) {
        Variable result = this.getLIRGen().newVariable(resultKind);
        this.getLIRGen().append(new AMD64Binary.DataTwoOp(op, size, result, a, b));
        return result;
    }

    private Variable emitBinaryVar(LIRKind resultKind, AMD64Assembler.AMD64RMOp op, AMD64BaseAssembler.OperandSize size, boolean commutative, AllocatableValue a, AllocatableValue b) {
        Variable result = this.getLIRGen().newVariable(resultKind);
        if (commutative) {
            this.getLIRGen().append(new AMD64Binary.CommutativeTwoOp(op, size, result, a, b));
        } else {
            this.getLIRGen().append(new AMD64Binary.TwoOp(op, size, result, a, b));
        }
        return result;
    }

    @Override
    protected boolean isNumericInteger(PlatformKind kind) {
        return ((AMD64Kind)kind).isInteger();
    }

    private Variable emitBaseOffsetLea(LIRKind resultKind, Value base, int offset, AMD64BaseAssembler.OperandSize size) {
        Variable result = this.getLIRGen().newVariable(resultKind);
        AMD64AddressValue address = new AMD64AddressValue(resultKind, this.asAllocatable(base), offset);
        this.getLIRGen().append(new AMD64Move.LeaOp(result, address, size));
        return result;
    }

    @Override
    public Variable emitAdd(LIRKind resultKind, Value a, Value b, boolean setFlags) {
        boolean isAvx = this.supportAVX();
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                long displacement;
                if (LIRValueUtil.isJavaConstant(b) && !setFlags && NumUtil.isInt(displacement = LIRValueUtil.asJavaConstant(b).asLong()) && displacement != 1L && displacement != -1L) {
                    return this.emitBaseOffsetLea(resultKind, a, (int)displacement, AMD64BaseAssembler.OperandSize.DWORD);
                }
                return this.emitBinary(resultKind, AMD64Assembler.AMD64BinaryArithmetic.ADD, AMD64BaseAssembler.OperandSize.DWORD, true, a, b, setFlags);
            }
            case QWORD: {
                long displacement;
                if (LIRValueUtil.isJavaConstant(b) && !setFlags && NumUtil.isInt(displacement = LIRValueUtil.asJavaConstant(b).asLong()) && displacement != 1L && displacement != -1L) {
                    return this.emitBaseOffsetLea(resultKind, a, (int)displacement, AMD64BaseAssembler.OperandSize.QWORD);
                }
                return this.emitBinary(resultKind, AMD64Assembler.AMD64BinaryArithmetic.ADD, AMD64BaseAssembler.OperandSize.QWORD, true, a, b, setFlags);
            }
            case SINGLE: {
                if (isAvx) {
                    return this.emitBinary(resultKind, AMD64Assembler.VexRVMOp.VADDSS, a, b);
                }
                return this.emitBinary(resultKind, AMD64Assembler.SSEOp.ADD, AMD64BaseAssembler.OperandSize.SS, true, a, b);
            }
            case DOUBLE: {
                if (isAvx) {
                    return this.emitBinary(resultKind, AMD64Assembler.VexRVMOp.VADDSD, a, b);
                }
                return this.emitBinary(resultKind, AMD64Assembler.SSEOp.ADD, AMD64BaseAssembler.OperandSize.SD, true, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public Variable emitSub(LIRKind resultKind, Value a, Value b, boolean setFlags) {
        boolean isAvx = this.supportAVX();
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                return this.emitBinary(resultKind, AMD64Assembler.AMD64BinaryArithmetic.SUB, AMD64BaseAssembler.OperandSize.DWORD, false, a, b, setFlags);
            }
            case QWORD: {
                return this.emitBinary(resultKind, AMD64Assembler.AMD64BinaryArithmetic.SUB, AMD64BaseAssembler.OperandSize.QWORD, false, a, b, setFlags);
            }
            case SINGLE: {
                if (isAvx) {
                    return this.emitBinary(resultKind, AMD64Assembler.VexRVMOp.VSUBSS, a, b);
                }
                return this.emitBinary(resultKind, AMD64Assembler.SSEOp.SUB, AMD64BaseAssembler.OperandSize.SS, false, a, b);
            }
            case DOUBLE: {
                if (isAvx) {
                    return this.emitBinary(resultKind, AMD64Assembler.VexRVMOp.VSUBSD, a, b);
                }
                return this.emitBinary(resultKind, AMD64Assembler.SSEOp.SUB, AMD64BaseAssembler.OperandSize.SD, false, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    private Variable emitIMULConst(AMD64BaseAssembler.OperandSize size, AllocatableValue a, ConstantValue b) {
        long value = b.getJavaConstant().asLong();
        if (NumUtil.isInt(value)) {
            int imm = (int)value;
            AMD64Assembler.AMD64RMIOp op = NumUtil.isByte(imm) ? AMD64Assembler.AMD64RMIOp.IMUL_SX : AMD64Assembler.AMD64RMIOp.IMUL;
            Variable ret = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{a, b}));
            this.getLIRGen().append(new AMD64Binary.RMIOp(op, size, ret, a, imm));
            return ret;
        }
        return this.emitBinaryVar(LIRKind.combine(new Value[]{a, b}), AMD64Assembler.AMD64RMOp.IMUL, size, true, a, this.asAllocatable(b));
    }

    private Variable emitIMUL(AMD64BaseAssembler.OperandSize size, Value a, Value b) {
        if (LIRValueUtil.isJavaConstant(b)) {
            return this.emitIMULConst(size, this.asAllocatable(a), LIRValueUtil.asConstantValue(b));
        }
        if (LIRValueUtil.isJavaConstant(a)) {
            return this.emitIMULConst(size, this.asAllocatable(b), LIRValueUtil.asConstantValue(a));
        }
        return this.emitBinaryVar(LIRKind.combine(a, b), AMD64Assembler.AMD64RMOp.IMUL, size, true, this.asAllocatable(a), this.asAllocatable(b));
    }

    public Variable emitMul(Value a, Value b, boolean setFlags) {
        boolean isAvx = this.supportAVX();
        LIRKind resultKind = LIRKind.combine(a, b);
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                return this.emitIMUL(AMD64BaseAssembler.OperandSize.DWORD, a, b);
            }
            case QWORD: {
                return this.emitIMUL(AMD64BaseAssembler.OperandSize.QWORD, a, b);
            }
            case SINGLE: {
                if (isAvx) {
                    return this.emitBinary(resultKind, AMD64Assembler.VexRVMOp.VMULSS, a, b);
                }
                return this.emitBinary(resultKind, AMD64Assembler.SSEOp.MUL, AMD64BaseAssembler.OperandSize.SS, true, a, b);
            }
            case DOUBLE: {
                if (isAvx) {
                    return this.emitBinary(resultKind, AMD64Assembler.VexRVMOp.VMULSD, a, b);
                }
                return this.emitBinary(resultKind, AMD64Assembler.SSEOp.MUL, AMD64BaseAssembler.OperandSize.SD, true, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    private RegisterValue moveToReg(Register reg, Value v) {
        RegisterValue ret = reg.asValue(v.getValueKind());
        this.getLIRGen().emitMove((AllocatableValue)ret, v);
        return ret;
    }

    private Value emitMulHigh(AMD64Assembler.AMD64MOp opcode, AMD64BaseAssembler.OperandSize size, Value a, Value b) {
        AMD64MulDivOp mulHigh = this.getLIRGen().append(new AMD64MulDivOp(opcode, size, LIRKind.combine(a, b), (AllocatableValue)this.moveToReg(AMD64.rax, a), this.asAllocatable(b)));
        return this.getLIRGen().emitMove((Value)mulHigh.getHighResult());
    }

    @Override
    public Value emitMulHigh(Value a, Value b) {
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                return this.emitMulHigh(AMD64Assembler.AMD64MOp.IMUL, AMD64BaseAssembler.OperandSize.DWORD, a, b);
            }
            case QWORD: {
                return this.emitMulHigh(AMD64Assembler.AMD64MOp.IMUL, AMD64BaseAssembler.OperandSize.QWORD, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public Value emitUMulHigh(Value a, Value b) {
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                return this.emitMulHigh(AMD64Assembler.AMD64MOp.MUL, AMD64BaseAssembler.OperandSize.DWORD, a, b);
            }
            case QWORD: {
                return this.emitMulHigh(AMD64Assembler.AMD64MOp.MUL, AMD64BaseAssembler.OperandSize.QWORD, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public Value emitBinaryMemory(AMD64Assembler.VexRVMOp op, AMD64BaseAssembler.OperandSize size, AllocatableValue a, AMD64AddressValue location, LIRFrameState state) {
        assert (size.isXmmType() && this.supportAVX());
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{a}));
        this.getLIRGen().append(new AMD64VectorBinary.AVXBinaryMemoryOp(op, AMD64ArithmeticLIRGenerator.getRegisterSize((Value)result), result, a, location, state));
        return result;
    }

    public Value emitBinaryMemory(AMD64Assembler.AMD64RMOp op, AMD64BaseAssembler.OperandSize size, AllocatableValue a, AMD64AddressValue location, LIRFrameState state) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(new Value[]{a}));
        this.getLIRGen().append(new AMD64Binary.MemoryTwoOp(op, size, result, a, location, state));
        return result;
    }

    protected Value emitConvertMemoryOp(PlatformKind kind, AMD64Assembler.AMD64RMOp op, AMD64BaseAssembler.OperandSize size, AMD64AddressValue address, LIRFrameState state) {
        Variable result = this.getLIRGen().newVariable(LIRKind.value(kind));
        this.getLIRGen().append(new AMD64Unary.MemoryOp(op, size, result, address, state));
        return result;
    }

    protected Value emitZeroExtendMemory(AMD64Kind memoryKind, int resultBits, AMD64AddressValue address, LIRFrameState state) {
        Variable result = this.getLIRGen().newVariable(LIRKind.value((PlatformKind)(resultBits <= 32 ? AMD64Kind.DWORD : AMD64Kind.QWORD)));
        switch (memoryKind) {
            case BYTE: {
                this.getLIRGen().append(new AMD64Unary.MemoryOp(AMD64Assembler.AMD64RMOp.MOVZXB, AMD64BaseAssembler.OperandSize.DWORD, result, address, state));
                break;
            }
            case WORD: {
                this.getLIRGen().append(new AMD64Unary.MemoryOp(AMD64Assembler.AMD64RMOp.MOVZX, AMD64BaseAssembler.OperandSize.DWORD, result, address, state));
                break;
            }
            case DWORD: {
                this.getLIRGen().append(new AMD64Unary.MemoryOp(AMD64Assembler.AMD64RMOp.MOV, AMD64BaseAssembler.OperandSize.DWORD, result, address, state));
                break;
            }
            case QWORD: {
                this.getLIRGen().append(new AMD64Unary.MemoryOp(AMD64Assembler.AMD64RMOp.MOV, AMD64BaseAssembler.OperandSize.QWORD, result, address, state));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return result;
    }

    private AMD64MulDivOp emitIDIV(AMD64BaseAssembler.OperandSize size, Value a, Value b, LIRFrameState state) {
        LIRKind kind = LIRKind.combine(a, b);
        AMD64SignExtendOp sx = this.getLIRGen().append(new AMD64SignExtendOp(size, kind, (AllocatableValue)this.moveToReg(AMD64.rax, a)));
        return this.getLIRGen().append(new AMD64MulDivOp(AMD64Assembler.AMD64MOp.IDIV, size, kind, sx.getHighResult(), sx.getLowResult(), this.asAllocatable(b), state));
    }

    private AMD64MulDivOp emitDIV(AMD64BaseAssembler.OperandSize size, Value a, Value b, LIRFrameState state) {
        LIRKind kind = LIRKind.combine(a, b);
        RegisterValue rax = this.moveToReg(AMD64.rax, a);
        RegisterValue rdx = AMD64.rdx.asValue((ValueKind)kind);
        this.getLIRGen().append(new AMD64ClearRegisterOp(size, (AllocatableValue)rdx));
        return this.getLIRGen().append(new AMD64MulDivOp(AMD64Assembler.AMD64MOp.DIV, size, kind, (AllocatableValue)rdx, (AllocatableValue)rax, this.asAllocatable(b), state));
    }

    public Value[] emitSignedDivRem(Value a, Value b, LIRFrameState state) {
        AMD64MulDivOp op;
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                op = this.emitIDIV(AMD64BaseAssembler.OperandSize.DWORD, a, b, state);
                break;
            }
            case QWORD: {
                op = this.emitIDIV(AMD64BaseAssembler.OperandSize.QWORD, a, b, state);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return new Value[]{this.getLIRGen().emitMove((Value)op.getQuotient()), this.getLIRGen().emitMove((Value)op.getRemainder())};
    }

    public Value[] emitUnsignedDivRem(Value a, Value b, LIRFrameState state) {
        AMD64MulDivOp op;
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                op = this.emitDIV(AMD64BaseAssembler.OperandSize.DWORD, a, b, state);
                break;
            }
            case QWORD: {
                op = this.emitDIV(AMD64BaseAssembler.OperandSize.QWORD, a, b, state);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return new Value[]{this.getLIRGen().emitMove((Value)op.getQuotient()), this.getLIRGen().emitMove((Value)op.getRemainder())};
    }

    @Override
    public Value emitDiv(Value a, Value b, LIRFrameState state) {
        boolean isAvx = this.supportAVX();
        LIRKind resultKind = LIRKind.combine(a, b);
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                AMD64MulDivOp op = this.emitIDIV(AMD64BaseAssembler.OperandSize.DWORD, a, b, state);
                return this.getLIRGen().emitMove((Value)op.getQuotient());
            }
            case QWORD: {
                AMD64MulDivOp lop = this.emitIDIV(AMD64BaseAssembler.OperandSize.QWORD, a, b, state);
                return this.getLIRGen().emitMove((Value)lop.getQuotient());
            }
            case SINGLE: {
                if (isAvx) {
                    return this.emitBinary(resultKind, AMD64Assembler.VexRVMOp.VDIVSS, a, b);
                }
                return this.emitBinary(resultKind, AMD64Assembler.SSEOp.DIV, AMD64BaseAssembler.OperandSize.SS, false, a, b);
            }
            case DOUBLE: {
                if (isAvx) {
                    return this.emitBinary(resultKind, AMD64Assembler.VexRVMOp.VDIVSD, a, b);
                }
                return this.emitBinary(resultKind, AMD64Assembler.SSEOp.DIV, AMD64BaseAssembler.OperandSize.SD, false, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public Value emitRem(Value a, Value b, LIRFrameState state) {
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                AMD64MulDivOp op = this.emitIDIV(AMD64BaseAssembler.OperandSize.DWORD, a, b, state);
                return this.getLIRGen().emitMove((Value)op.getRemainder());
            }
            case QWORD: {
                AMD64MulDivOp lop = this.emitIDIV(AMD64BaseAssembler.OperandSize.QWORD, a, b, state);
                return this.getLIRGen().emitMove((Value)lop.getRemainder());
            }
            case SINGLE: {
                Variable result = this.getLIRGen().newVariable(LIRKind.combine(a, b));
                this.getLIRGen().append(new AMD64Arithmetic.FPDivRemOp(AMD64Arithmetic.FREM, result, this.getLIRGen().load(a), this.getLIRGen().load(b)));
                return result;
            }
            case DOUBLE: {
                Variable result = this.getLIRGen().newVariable(LIRKind.combine(a, b));
                this.getLIRGen().append(new AMD64Arithmetic.FPDivRemOp(AMD64Arithmetic.DREM, result, this.getLIRGen().load(a), this.getLIRGen().load(b)));
                return result;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public Variable emitUDiv(Value a, Value b, LIRFrameState state) {
        AMD64MulDivOp op;
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                op = this.emitDIV(AMD64BaseAssembler.OperandSize.DWORD, a, b, state);
                break;
            }
            case QWORD: {
                op = this.emitDIV(AMD64BaseAssembler.OperandSize.QWORD, a, b, state);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return this.getLIRGen().emitMove((Value)op.getQuotient());
    }

    public Variable emitURem(Value a, Value b, LIRFrameState state) {
        AMD64MulDivOp op;
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                op = this.emitDIV(AMD64BaseAssembler.OperandSize.DWORD, a, b, state);
                break;
            }
            case QWORD: {
                op = this.emitDIV(AMD64BaseAssembler.OperandSize.QWORD, a, b, state);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return this.getLIRGen().emitMove((Value)op.getRemainder());
    }

    public Variable emitAnd(Value a, Value b) {
        LIRKind resultKind = LIRKind.combine(a, b);
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                return this.emitBinary(resultKind, AMD64Assembler.AMD64BinaryArithmetic.AND, AMD64BaseAssembler.OperandSize.DWORD, true, a, b, false);
            }
            case QWORD: {
                return this.emitBinary(resultKind, AMD64Assembler.AMD64BinaryArithmetic.AND, AMD64BaseAssembler.OperandSize.QWORD, true, a, b, false);
            }
            case SINGLE: {
                return this.emitBinary(resultKind, AMD64Assembler.SSEOp.AND, AMD64BaseAssembler.OperandSize.PS, true, a, b);
            }
            case DOUBLE: {
                return this.emitBinary(resultKind, AMD64Assembler.SSEOp.AND, AMD64BaseAssembler.OperandSize.PD, true, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public Variable emitOr(Value a, Value b) {
        boolean isAvx = this.supportAVX();
        LIRKind resultKind = LIRKind.combine(a, b);
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                return this.emitBinary(resultKind, AMD64Assembler.AMD64BinaryArithmetic.OR, AMD64BaseAssembler.OperandSize.DWORD, true, a, b, false);
            }
            case QWORD: {
                return this.emitBinary(resultKind, AMD64Assembler.AMD64BinaryArithmetic.OR, AMD64BaseAssembler.OperandSize.QWORD, true, a, b, false);
            }
            case SINGLE: {
                if (isAvx) {
                    return this.emitBinary(resultKind, AMD64Assembler.VexRVMOp.VORPS, a, b);
                }
                return this.emitBinary(resultKind, AMD64Assembler.SSEOp.OR, AMD64BaseAssembler.OperandSize.PS, true, a, b);
            }
            case DOUBLE: {
                if (isAvx) {
                    return this.emitBinary(resultKind, AMD64Assembler.VexRVMOp.VORPD, a, b);
                }
                return this.emitBinary(resultKind, AMD64Assembler.SSEOp.OR, AMD64BaseAssembler.OperandSize.PD, true, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public Variable emitXor(Value a, Value b) {
        boolean isAvx = this.supportAVX();
        LIRKind resultKind = LIRKind.combine(a, b);
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                return this.emitBinary(resultKind, AMD64Assembler.AMD64BinaryArithmetic.XOR, AMD64BaseAssembler.OperandSize.DWORD, true, a, b, false);
            }
            case QWORD: {
                return this.emitBinary(resultKind, AMD64Assembler.AMD64BinaryArithmetic.XOR, AMD64BaseAssembler.OperandSize.QWORD, true, a, b, false);
            }
            case SINGLE: {
                if (isAvx) {
                    return this.emitBinary(resultKind, AMD64Assembler.VexRVMOp.VXORPS, a, b);
                }
                return this.emitBinary(resultKind, AMD64Assembler.SSEOp.XOR, AMD64BaseAssembler.OperandSize.PS, true, a, b);
            }
            case DOUBLE: {
                if (isAvx) {
                    return this.emitBinary(resultKind, AMD64Assembler.VexRVMOp.VXORPD, a, b);
                }
                return this.emitBinary(resultKind, AMD64Assembler.SSEOp.XOR, AMD64BaseAssembler.OperandSize.PD, true, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    private Variable emitShift(AMD64Assembler.AMD64Shift op, AMD64BaseAssembler.OperandSize size, Value a, Value b) {
        if (LIRValueUtil.isJavaConstant(b)) {
            return this.emitShiftConst(op, size, a, LIRValueUtil.asJavaConstant(b));
        }
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(a, b).changeType(a.getPlatformKind()));
        AllocatableValue input = this.asAllocatable(a);
        this.getLIRGen().emitMove((AllocatableValue)RCX_I, b);
        this.getLIRGen().append(new AMD64ShiftOp(op.mcOp, size, result, input, (AllocatableValue)RCX_I));
        return result;
    }

    public Variable emitShiftConst(AMD64Assembler.AMD64Shift op, AMD64BaseAssembler.OperandSize size, Value a, JavaConstant b) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(a).changeType(a.getPlatformKind()));
        AllocatableValue input = this.asAllocatable(a);
        if (b.asLong() == 1L) {
            this.getLIRGen().append(new AMD64Unary.MOp(op.m1Op, size, result, input));
        } else {
            this.getLIRGen().append(new AMD64Binary.ConstOp(op.miOp, size, (AllocatableValue)result, input, (int)((byte)b.asLong())));
        }
        return result;
    }

    public Variable emitShl(Value a, Value b) {
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                return this.emitShift(AMD64Assembler.AMD64Shift.SHL, AMD64BaseAssembler.OperandSize.DWORD, a, b);
            }
            case QWORD: {
                return this.emitShift(AMD64Assembler.AMD64Shift.SHL, AMD64BaseAssembler.OperandSize.QWORD, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public Variable emitShr(Value a, Value b) {
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                return this.emitShift(AMD64Assembler.AMD64Shift.SAR, AMD64BaseAssembler.OperandSize.DWORD, a, b);
            }
            case QWORD: {
                return this.emitShift(AMD64Assembler.AMD64Shift.SAR, AMD64BaseAssembler.OperandSize.QWORD, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public Variable emitUShr(Value a, Value b) {
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                return this.emitShift(AMD64Assembler.AMD64Shift.SHR, AMD64BaseAssembler.OperandSize.DWORD, a, b);
            }
            case QWORD: {
                return this.emitShift(AMD64Assembler.AMD64Shift.SHR, AMD64BaseAssembler.OperandSize.QWORD, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public Variable emitRol(Value a, Value b) {
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                return this.emitShift(AMD64Assembler.AMD64Shift.ROL, AMD64BaseAssembler.OperandSize.DWORD, a, b);
            }
            case QWORD: {
                return this.emitShift(AMD64Assembler.AMD64Shift.ROL, AMD64BaseAssembler.OperandSize.QWORD, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public Variable emitRor(Value a, Value b) {
        switch ((AMD64Kind)a.getPlatformKind()) {
            case DWORD: {
                return this.emitShift(AMD64Assembler.AMD64Shift.ROR, AMD64BaseAssembler.OperandSize.DWORD, a, b);
            }
            case QWORD: {
                return this.emitShift(AMD64Assembler.AMD64Shift.ROR, AMD64BaseAssembler.OperandSize.QWORD, a, b);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    private AllocatableValue emitConvertOp(LIRKind kind, AMD64Assembler.AMD64RMOp op, AMD64BaseAssembler.OperandSize size, Value input) {
        Variable result = this.getLIRGen().newVariable(kind);
        this.getLIRGen().append(new AMD64Unary.RMOp(op, size, result, this.asAllocatable(input)));
        return result;
    }

    private AllocatableValue emitConvertOp(LIRKind kind, AMD64Assembler.AMD64MROp op, AMD64BaseAssembler.OperandSize size, Value input) {
        Variable result = this.getLIRGen().newVariable(kind);
        this.getLIRGen().append(new AMD64Unary.MROp(op, size, result, this.asAllocatable(input)));
        return result;
    }

    @Override
    public Value emitReinterpret(LIRKind to, Value inputVal) {
        ValueKind from = inputVal.getValueKind();
        if (to.equals(from)) {
            return inputVal;
        }
        AllocatableValue input = this.asAllocatable(inputVal);
        AMD64Kind fromKind = AMD64ArithmeticLIRGenerator.scalarKind((AMD64Kind)from.getPlatformKind());
        AMD64Kind toKind = AMD64ArithmeticLIRGenerator.scalarKind((AMD64Kind)to.getPlatformKind());
        switch (toKind) {
            case DWORD: {
                switch (fromKind) {
                    case SINGLE: {
                        return this.emitConvertOp(to, AMD64Assembler.AMD64MROp.MOVD, AMD64BaseAssembler.OperandSize.DWORD, (Value)input);
                    }
                }
                break;
            }
            case QWORD: {
                switch (fromKind) {
                    case DOUBLE: {
                        return this.emitConvertOp(to, AMD64Assembler.AMD64MROp.MOVQ, AMD64BaseAssembler.OperandSize.QWORD, (Value)input);
                    }
                }
                break;
            }
            case SINGLE: {
                switch (fromKind) {
                    case DWORD: {
                        return this.emitConvertOp(to, AMD64Assembler.AMD64RMOp.MOVD, AMD64BaseAssembler.OperandSize.DWORD, (Value)input);
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (fromKind) {
                    case QWORD: {
                        return this.emitConvertOp(to, AMD64Assembler.AMD64RMOp.MOVQ, AMD64BaseAssembler.OperandSize.QWORD, (Value)input);
                    }
                }
            }
        }
        throw GraalError.shouldNotReachHere(toKind + " " + fromKind);
    }

    private static AMD64Kind scalarKind(AMD64Kind kind) {
        AMD64Kind resultKind = kind;
        if (kind.isXMM() && kind.getVectorLength() > 1) {
            if (kind.getSizeInBytes() == AMD64Kind.SINGLE.getSizeInBytes()) {
                resultKind = AMD64Kind.SINGLE;
            } else if (kind.getSizeInBytes() == AMD64Kind.DOUBLE.getSizeInBytes()) {
                resultKind = AMD64Kind.DOUBLE;
            } else {
                GraalError.shouldNotReachHere("no equal size scalar kind for " + kind);
            }
        }
        return resultKind;
    }

    @Override
    public Value emitFloatConvert(FloatConvert op, Value input) {
        switch (op) {
            case D2F: {
                return this.emitConvertOp(LIRKind.combine(input).changeType((PlatformKind)AMD64Kind.SINGLE), AMD64Assembler.SSEOp.CVTSD2SS, AMD64BaseAssembler.OperandSize.SD, input);
            }
            case D2I: {
                return this.emitConvertOp(LIRKind.combine(input).changeType((PlatformKind)AMD64Kind.DWORD), AMD64Assembler.SSEOp.CVTTSD2SI, AMD64BaseAssembler.OperandSize.DWORD, input);
            }
            case D2L: {
                return this.emitConvertOp(LIRKind.combine(input).changeType((PlatformKind)AMD64Kind.QWORD), AMD64Assembler.SSEOp.CVTTSD2SI, AMD64BaseAssembler.OperandSize.QWORD, input);
            }
            case F2D: {
                return this.emitConvertOp(LIRKind.combine(input).changeType((PlatformKind)AMD64Kind.DOUBLE), AMD64Assembler.SSEOp.CVTSS2SD, AMD64BaseAssembler.OperandSize.SS, input);
            }
            case F2I: {
                return this.emitConvertOp(LIRKind.combine(input).changeType((PlatformKind)AMD64Kind.DWORD), AMD64Assembler.SSEOp.CVTTSS2SI, AMD64BaseAssembler.OperandSize.DWORD, input);
            }
            case F2L: {
                return this.emitConvertOp(LIRKind.combine(input).changeType((PlatformKind)AMD64Kind.QWORD), AMD64Assembler.SSEOp.CVTTSS2SI, AMD64BaseAssembler.OperandSize.QWORD, input);
            }
            case I2D: {
                return this.emitConvertOp(LIRKind.combine(input).changeType((PlatformKind)AMD64Kind.DOUBLE), AMD64Assembler.SSEOp.CVTSI2SD, AMD64BaseAssembler.OperandSize.DWORD, input);
            }
            case I2F: {
                return this.emitConvertOp(LIRKind.combine(input).changeType((PlatformKind)AMD64Kind.SINGLE), AMD64Assembler.SSEOp.CVTSI2SS, AMD64BaseAssembler.OperandSize.DWORD, input);
            }
            case L2D: {
                return this.emitConvertOp(LIRKind.combine(input).changeType((PlatformKind)AMD64Kind.DOUBLE), AMD64Assembler.SSEOp.CVTSI2SD, AMD64BaseAssembler.OperandSize.QWORD, input);
            }
            case L2F: {
                return this.emitConvertOp(LIRKind.combine(input).changeType((PlatformKind)AMD64Kind.SINGLE), AMD64Assembler.SSEOp.CVTSI2SS, AMD64BaseAssembler.OperandSize.QWORD, input);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public Value emitNarrow(Value inputVal, int bits) {
        if (inputVal.getPlatformKind() == AMD64Kind.QWORD && bits <= 32) {
            return this.emitConvertOp(LIRKind.combine(inputVal).changeType((PlatformKind)AMD64Kind.DWORD), AMD64Assembler.AMD64RMOp.MOV, AMD64BaseAssembler.OperandSize.DWORD, inputVal);
        }
        return inputVal;
    }

    @Override
    public Value emitSignExtend(Value inputVal, int fromBits, int toBits) {
        assert (fromBits <= toBits && toBits <= 64);
        if (fromBits == toBits) {
            return inputVal;
        }
        if (toBits > 32) {
            switch (fromBits) {
                case 8: {
                    return this.emitConvertOp(LIRKind.combine(inputVal).changeType((PlatformKind)AMD64Kind.QWORD), AMD64Assembler.AMD64RMOp.MOVSXB, AMD64BaseAssembler.OperandSize.QWORD, inputVal);
                }
                case 16: {
                    return this.emitConvertOp(LIRKind.combine(inputVal).changeType((PlatformKind)AMD64Kind.QWORD), AMD64Assembler.AMD64RMOp.MOVSX, AMD64BaseAssembler.OperandSize.QWORD, inputVal);
                }
                case 32: {
                    return this.emitConvertOp(LIRKind.combine(inputVal).changeType((PlatformKind)AMD64Kind.QWORD), AMD64Assembler.AMD64RMOp.MOVSXD, AMD64BaseAssembler.OperandSize.QWORD, inputVal);
                }
            }
            throw GraalError.unimplemented("unsupported sign extension (" + fromBits + " bit -> " + toBits + " bit)");
        }
        switch (fromBits) {
            case 8: {
                return this.emitConvertOp(LIRKind.combine(inputVal).changeType((PlatformKind)AMD64Kind.DWORD), AMD64Assembler.AMD64RMOp.MOVSXB, AMD64BaseAssembler.OperandSize.DWORD, inputVal);
            }
            case 16: {
                return this.emitConvertOp(LIRKind.combine(inputVal).changeType((PlatformKind)AMD64Kind.DWORD), AMD64Assembler.AMD64RMOp.MOVSX, AMD64BaseAssembler.OperandSize.DWORD, inputVal);
            }
            case 32: {
                return inputVal;
            }
        }
        throw GraalError.unimplemented("unsupported sign extension (" + fromBits + " bit -> " + toBits + " bit)");
    }

    @Override
    public Value emitZeroExtend(Value inputVal, int fromBits, int toBits) {
        assert (fromBits <= toBits && toBits <= 64);
        if (fromBits == toBits) {
            return inputVal;
        }
        if (fromBits > 32) {
            assert (inputVal.getPlatformKind() == AMD64Kind.QWORD);
            Variable result = this.getLIRGen().newVariable(LIRKind.combine(inputVal));
            long mask = CodeUtil.mask((int)fromBits);
            this.getLIRGen().append(new AMD64Binary.DataTwoOp(AMD64Assembler.AMD64BinaryArithmetic.AND.getRMOpcode(AMD64BaseAssembler.OperandSize.QWORD), AMD64BaseAssembler.OperandSize.QWORD, result, this.asAllocatable(inputVal), (JavaConstant)JavaConstant.forLong((long)mask)));
            return result;
        }
        LIRKind resultKind = LIRKind.combine(inputVal);
        resultKind = toBits > 32 ? resultKind.changeType((PlatformKind)AMD64Kind.QWORD) : resultKind.changeType((PlatformKind)AMD64Kind.DWORD);
        switch (fromBits) {
            case 8: {
                return this.emitConvertOp(resultKind, AMD64Assembler.AMD64RMOp.MOVZXB, AMD64BaseAssembler.OperandSize.DWORD, inputVal);
            }
            case 16: {
                return this.emitConvertOp(resultKind, AMD64Assembler.AMD64RMOp.MOVZX, AMD64BaseAssembler.OperandSize.DWORD, inputVal);
            }
            case 32: {
                return this.emitConvertOp(resultKind, AMD64Assembler.AMD64RMOp.MOV, AMD64BaseAssembler.OperandSize.DWORD, inputVal);
            }
        }
        Variable result = this.getLIRGen().newVariable(resultKind);
        PrimitiveConstant mask = toBits > 32 ? JavaConstant.forLong((long)CodeUtil.mask((int)fromBits)) : JavaConstant.forInt((int)((int)CodeUtil.mask((int)fromBits)));
        this.getLIRGen().append(new AMD64Binary.DataTwoOp(AMD64Assembler.AMD64BinaryArithmetic.AND.getRMOpcode(AMD64BaseAssembler.OperandSize.DWORD), AMD64BaseAssembler.OperandSize.DWORD, result, this.asAllocatable(inputVal), (JavaConstant)mask));
        return result;
    }

    public Variable emitBitCount(Value value) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value).changeType((PlatformKind)AMD64Kind.DWORD));
        assert (((AMD64Kind)value.getPlatformKind()).isInteger());
        if (value.getPlatformKind() == AMD64Kind.QWORD) {
            this.getLIRGen().append(new AMD64Unary.RMOp(AMD64Assembler.AMD64RMOp.POPCNT, AMD64BaseAssembler.OperandSize.QWORD, result, this.asAllocatable(value)));
        } else {
            this.getLIRGen().append(new AMD64Unary.RMOp(AMD64Assembler.AMD64RMOp.POPCNT, AMD64BaseAssembler.OperandSize.DWORD, result, this.asAllocatable(value)));
        }
        return result;
    }

    public Variable emitBitScanForward(Value value) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value).changeType((PlatformKind)AMD64Kind.DWORD));
        this.getLIRGen().append(new AMD64Unary.RMOp(AMD64Assembler.AMD64RMOp.BSF, AMD64BaseAssembler.OperandSize.QWORD, result, this.asAllocatable(value)));
        return result;
    }

    public Variable emitBitScanReverse(Value value) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value).changeType((PlatformKind)AMD64Kind.DWORD));
        assert (((AMD64Kind)value.getPlatformKind()).isInteger());
        if (value.getPlatformKind() == AMD64Kind.QWORD) {
            this.getLIRGen().append(new AMD64Unary.RMOp(AMD64Assembler.AMD64RMOp.BSR, AMD64BaseAssembler.OperandSize.QWORD, result, this.asAllocatable(value)));
        } else {
            this.getLIRGen().append(new AMD64Unary.RMOp(AMD64Assembler.AMD64RMOp.BSR, AMD64BaseAssembler.OperandSize.DWORD, result, this.asAllocatable(value)));
        }
        return result;
    }

    public Variable emitFusedMultiplyAdd(Value a, Value b, Value c) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(a, b, c));
        assert (((AMD64Kind)a.getPlatformKind()).isXMM() && ((AMD64Kind)b.getPlatformKind()).isXMM() && ((AMD64Kind)c.getPlatformKind()).isXMM());
        assert (a.getPlatformKind().equals(b.getPlatformKind()));
        assert (b.getPlatformKind().equals(c.getPlatformKind()));
        if (a.getPlatformKind() == AMD64Kind.DOUBLE) {
            this.getLIRGen().append(new AMD64Ternary.ThreeOp(AMD64Assembler.VexRVMOp.VFMADD231SD, AVXKind.AVXSize.XMM, result, this.asAllocatable(c), this.asAllocatable(a), this.asAllocatable(b)));
        } else {
            assert (a.getPlatformKind() == AMD64Kind.SINGLE);
            this.getLIRGen().append(new AMD64Ternary.ThreeOp(AMD64Assembler.VexRVMOp.VFMADD231SS, AVXKind.AVXSize.XMM, result, this.asAllocatable(c), this.asAllocatable(a), this.asAllocatable(b)));
        }
        return result;
    }

    @Override
    public Value emitCountLeadingZeros(Value value) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value).changeType((PlatformKind)AMD64Kind.DWORD));
        assert (((AMD64Kind)value.getPlatformKind()).isInteger());
        if (value.getPlatformKind() == AMD64Kind.QWORD) {
            this.getLIRGen().append(new AMD64Unary.RMOp(AMD64Assembler.AMD64RMOp.LZCNT, AMD64BaseAssembler.OperandSize.QWORD, result, this.asAllocatable(value)));
        } else {
            this.getLIRGen().append(new AMD64Unary.RMOp(AMD64Assembler.AMD64RMOp.LZCNT, AMD64BaseAssembler.OperandSize.DWORD, result, this.asAllocatable(value)));
        }
        return result;
    }

    @Override
    public Value emitCountTrailingZeros(Value value) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value).changeType((PlatformKind)AMD64Kind.DWORD));
        assert (((AMD64Kind)value.getPlatformKind()).isInteger());
        if (value.getPlatformKind() == AMD64Kind.QWORD) {
            this.getLIRGen().append(new AMD64Unary.RMOp(AMD64Assembler.AMD64RMOp.TZCNT, AMD64BaseAssembler.OperandSize.QWORD, result, this.asAllocatable(value)));
        } else {
            this.getLIRGen().append(new AMD64Unary.RMOp(AMD64Assembler.AMD64RMOp.TZCNT, AMD64BaseAssembler.OperandSize.DWORD, result, this.asAllocatable(value)));
        }
        return result;
    }

    @Override
    public Value emitLogicalAndNot(Value value1, Value value2) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value1, value2));
        if (value1.getPlatformKind() == AMD64Kind.QWORD) {
            this.getLIRGen().append(new AMD64VectorBinary.AVXBinaryOp(AMD64Assembler.VexGeneralPurposeRVMOp.ANDN, AVXKind.AVXSize.QWORD, result, this.asAllocatable(value1), this.asAllocatable(value2)));
        } else {
            this.getLIRGen().append(new AMD64VectorBinary.AVXBinaryOp(AMD64Assembler.VexGeneralPurposeRVMOp.ANDN, AVXKind.AVXSize.DWORD, result, this.asAllocatable(value1), this.asAllocatable(value2)));
        }
        return result;
    }

    @Override
    public Value emitLowestSetIsolatedBit(Value value) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value));
        if (value.getPlatformKind() == AMD64Kind.QWORD) {
            this.getLIRGen().append(new AMD64VectorUnary.AVXUnaryOp(AMD64Assembler.VexGeneralPurposeRMOp.BLSI, AVXKind.AVXSize.QWORD, result, this.asAllocatable(value)));
        } else {
            this.getLIRGen().append(new AMD64VectorUnary.AVXUnaryOp(AMD64Assembler.VexGeneralPurposeRMOp.BLSI, AVXKind.AVXSize.DWORD, result, this.asAllocatable(value)));
        }
        return result;
    }

    @Override
    public Value emitGetMaskUpToLowestSetBit(Value value) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value));
        if (value.getPlatformKind() == AMD64Kind.QWORD) {
            this.getLIRGen().append(new AMD64VectorUnary.AVXUnaryOp(AMD64Assembler.VexGeneralPurposeRMOp.BLSMSK, AVXKind.AVXSize.QWORD, result, this.asAllocatable(value)));
        } else {
            this.getLIRGen().append(new AMD64VectorUnary.AVXUnaryOp(AMD64Assembler.VexGeneralPurposeRMOp.BLSMSK, AVXKind.AVXSize.DWORD, result, this.asAllocatable(value)));
        }
        return result;
    }

    @Override
    public Value emitResetLowestSetBit(Value value) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value));
        if (value.getPlatformKind() == AMD64Kind.QWORD) {
            this.getLIRGen().append(new AMD64VectorUnary.AVXUnaryOp(AMD64Assembler.VexGeneralPurposeRMOp.BLSR, AVXKind.AVXSize.QWORD, result, this.asAllocatable(value)));
        } else {
            this.getLIRGen().append(new AMD64VectorUnary.AVXUnaryOp(AMD64Assembler.VexGeneralPurposeRMOp.BLSR, AVXKind.AVXSize.DWORD, result, this.asAllocatable(value)));
        }
        return result;
    }

    @Override
    public Value emitMathAbs(Value input) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(input));
        switch ((AMD64Kind)input.getPlatformKind()) {
            case SINGLE: {
                this.getLIRGen().append(new AMD64Binary.DataTwoOp(AMD64Assembler.SSEOp.AND, AMD64BaseAssembler.OperandSize.PS, result, this.asAllocatable(input), (JavaConstant)JavaConstant.forFloat((float)Float.intBitsToFloat(Integer.MAX_VALUE)), 16));
                break;
            }
            case DOUBLE: {
                this.getLIRGen().append(new AMD64Binary.DataTwoOp(AMD64Assembler.SSEOp.AND, AMD64BaseAssembler.OperandSize.PD, result, this.asAllocatable(input), (JavaConstant)JavaConstant.forDouble((double)Double.longBitsToDouble(Long.MAX_VALUE)), 16));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return result;
    }

    @Override
    public Value emitMathSqrt(Value input) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(input));
        switch ((AMD64Kind)input.getPlatformKind()) {
            case SINGLE: {
                this.getLIRGen().append(new AMD64Unary.RMOp(AMD64Assembler.SSEOp.SQRT, AMD64BaseAssembler.OperandSize.SS, result, this.asAllocatable(input)));
                break;
            }
            case DOUBLE: {
                this.getLIRGen().append(new AMD64Unary.RMOp(AMD64Assembler.SSEOp.SQRT, AMD64BaseAssembler.OperandSize.SD, result, this.asAllocatable(input)));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return result;
    }

    @Override
    public Value emitMathLog(Value input, boolean base10) {
        if (base10) {
            return new AMD64MathLog10Op().emitLIRWrapper(this.getLIRGen(), input);
        }
        return new AMD64MathLogOp().emitLIRWrapper(this.getLIRGen(), input);
    }

    @Override
    public Value emitMathCos(Value input) {
        return new AMD64MathCosOp().emitLIRWrapper(this.getLIRGen(), input);
    }

    @Override
    public Value emitMathSin(Value input) {
        return new AMD64MathSinOp().emitLIRWrapper(this.getLIRGen(), input);
    }

    @Override
    public Value emitMathTan(Value input) {
        return new AMD64MathTanOp().emitLIRWrapper(this.getLIRGen(), input);
    }

    @Override
    public Value emitMathExp(Value input) {
        return new AMD64MathExpOp().emitLIRWrapper(this.getLIRGen(), input);
    }

    @Override
    public Value emitMathPow(Value x, Value y) {
        return new AMD64MathPowOp().emitLIRWrapper(this.getLIRGen(), x, y);
    }

    protected AMD64LIRGenerator getAMD64LIRGen() {
        return (AMD64LIRGenerator)this.getLIRGen();
    }

    @Override
    public Variable emitLoad(LIRKind kind, Value address, LIRFrameState state) {
        AMD64AddressValue loadAddress = this.getAMD64LIRGen().asAddressValue(address);
        Variable result = this.getLIRGen().newVariable(this.getLIRGen().toRegisterKind(kind));
        switch ((AMD64Kind)kind.getPlatformKind()) {
            case BYTE: {
                this.getLIRGen().append(new AMD64Unary.MemoryOp(AMD64Assembler.AMD64RMOp.MOVSXB, AMD64BaseAssembler.OperandSize.DWORD, result, loadAddress, state));
                break;
            }
            case WORD: {
                this.getLIRGen().append(new AMD64Unary.MemoryOp(AMD64Assembler.AMD64RMOp.MOVSX, AMD64BaseAssembler.OperandSize.DWORD, result, loadAddress, state));
                break;
            }
            case DWORD: {
                this.getLIRGen().append(new AMD64Unary.MemoryOp(AMD64Assembler.AMD64RMOp.MOV, AMD64BaseAssembler.OperandSize.DWORD, result, loadAddress, state));
                break;
            }
            case QWORD: {
                this.getLIRGen().append(new AMD64Unary.MemoryOp(AMD64Assembler.AMD64RMOp.MOV, AMD64BaseAssembler.OperandSize.QWORD, result, loadAddress, state));
                break;
            }
            case SINGLE: {
                this.getLIRGen().append(new AMD64Unary.MemoryOp(AMD64Assembler.AMD64RMOp.MOVSS, AMD64BaseAssembler.OperandSize.SS, result, loadAddress, state));
                break;
            }
            case DOUBLE: {
                this.getLIRGen().append(new AMD64Unary.MemoryOp(AMD64Assembler.AMD64RMOp.MOVSD, AMD64BaseAssembler.OperandSize.SD, result, loadAddress, state));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        return result;
    }

    @Override
    public Variable emitVolatileLoad(LIRKind kind, Value address, LIRFrameState state) {
        throw GraalError.shouldNotReachHere();
    }

    @Override
    public void emitVolatileStore(ValueKind<?> kind, Value address, Value input, LIRFrameState state) {
        throw GraalError.shouldNotReachHere();
    }

    protected void emitStoreConst(AMD64Kind kind, AMD64AddressValue address, ConstantValue value, LIRFrameState state) {
        Constant c = value.getConstant();
        if (JavaConstant.isNull((Constant)c)) {
            assert (kind == AMD64Kind.DWORD || kind == AMD64Kind.QWORD);
            AMD64BaseAssembler.OperandSize size = kind == AMD64Kind.DWORD ? AMD64BaseAssembler.OperandSize.DWORD : AMD64BaseAssembler.OperandSize.QWORD;
            this.getLIRGen().append(new AMD64BinaryConsumer.MemoryConstOp(AMD64Assembler.AMD64MIOp.MOV, size, address, 0, state));
            return;
        }
        if (c instanceof VMConstant) {
            if (kind == AMD64Kind.DWORD && (this.getLIRGen().target().inlineObjects || !(c instanceof JavaConstant))) {
                assert (!(c instanceof JavaConstant) || ((JavaConstant)c).getJavaKind() == JavaKind.Object);
                this.getLIRGen().append(new AMD64BinaryConsumer.MemoryVMConstOp(AMD64Assembler.AMD64MIOp.MOV, address, (VMConstant)c, state));
                return;
            }
        } else {
            long imm;
            AMD64BaseAssembler.OperandSize size;
            JavaConstant jc = (JavaConstant)c;
            assert (jc.getJavaKind().isPrimitive());
            AMD64Assembler.AMD64MIOp op = AMD64Assembler.AMD64MIOp.MOV;
            switch (kind) {
                case BYTE: {
                    op = AMD64Assembler.AMD64MIOp.MOVB;
                    size = AMD64BaseAssembler.OperandSize.BYTE;
                    imm = jc.asInt();
                    break;
                }
                case WORD: {
                    size = AMD64BaseAssembler.OperandSize.WORD;
                    imm = jc.asInt();
                    break;
                }
                case DWORD: {
                    size = AMD64BaseAssembler.OperandSize.DWORD;
                    imm = jc.asInt();
                    break;
                }
                case QWORD: {
                    size = AMD64BaseAssembler.OperandSize.QWORD;
                    imm = jc.asLong();
                    break;
                }
                case SINGLE: {
                    size = AMD64BaseAssembler.OperandSize.DWORD;
                    imm = Float.floatToRawIntBits(jc.asFloat());
                    break;
                }
                case DOUBLE: {
                    size = AMD64BaseAssembler.OperandSize.QWORD;
                    imm = Double.doubleToRawLongBits(jc.asDouble());
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("unexpected kind " + kind);
                }
            }
            if (NumUtil.isInt(imm)) {
                this.getLIRGen().append(new AMD64BinaryConsumer.MemoryConstOp(op, size, address, (int)imm, state));
                return;
            }
        }
        this.emitStore(kind, address, this.asAllocatable(value), state);
    }

    protected void emitStore(AMD64Kind kind, AMD64AddressValue address, AllocatableValue value, LIRFrameState state) {
        switch (kind) {
            case BYTE: {
                this.getLIRGen().append(new AMD64BinaryConsumer.MemoryMROp(AMD64Assembler.AMD64MROp.MOVB, AMD64BaseAssembler.OperandSize.BYTE, address, value, state));
                break;
            }
            case WORD: {
                this.getLIRGen().append(new AMD64BinaryConsumer.MemoryMROp(AMD64Assembler.AMD64MROp.MOV, AMD64BaseAssembler.OperandSize.WORD, address, value, state));
                break;
            }
            case DWORD: {
                this.getLIRGen().append(new AMD64BinaryConsumer.MemoryMROp(AMD64Assembler.AMD64MROp.MOV, AMD64BaseAssembler.OperandSize.DWORD, address, value, state));
                break;
            }
            case QWORD: {
                this.getLIRGen().append(new AMD64BinaryConsumer.MemoryMROp(AMD64Assembler.AMD64MROp.MOV, AMD64BaseAssembler.OperandSize.QWORD, address, value, state));
                break;
            }
            case SINGLE: {
                this.getLIRGen().append(new AMD64BinaryConsumer.MemoryMROp(AMD64Assembler.AMD64MROp.MOVSS, AMD64BaseAssembler.OperandSize.SS, address, value, state));
                break;
            }
            case DOUBLE: {
                this.getLIRGen().append(new AMD64BinaryConsumer.MemoryMROp(AMD64Assembler.AMD64MROp.MOVSD, AMD64BaseAssembler.OperandSize.SD, address, value, state));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    @Override
    public void emitStore(ValueKind<?> lirKind, Value address, Value input, LIRFrameState state) {
        AMD64AddressValue storeAddress = this.getAMD64LIRGen().asAddressValue(address);
        AMD64Kind kind = (AMD64Kind)lirKind.getPlatformKind();
        if (LIRValueUtil.isConstantValue(input)) {
            this.emitStoreConst(kind, storeAddress, LIRValueUtil.asConstantValue(input), state);
        } else {
            this.emitStore(kind, storeAddress, this.asAllocatable(input), state);
        }
    }

    public boolean mustReplaceNullWithNullRegister(Constant nullConstant) {
        return this.nullRegisterValue != null && JavaConstant.NULL_POINTER.equals(nullConstant);
    }

    public AllocatableValue getNullRegisterValue() {
        return this.nullRegisterValue;
    }

    @Override
    public void emitCompareOp(AMD64Kind cmpKind, Variable left, Value right) {
        AMD64BaseAssembler.OperandSize size;
        switch (cmpKind) {
            case BYTE: {
                size = AMD64BaseAssembler.OperandSize.BYTE;
                break;
            }
            case WORD: {
                size = AMD64BaseAssembler.OperandSize.WORD;
                break;
            }
            case DWORD: {
                size = AMD64BaseAssembler.OperandSize.DWORD;
                break;
            }
            case QWORD: {
                size = AMD64BaseAssembler.OperandSize.QWORD;
                break;
            }
            case SINGLE: {
                this.getLIRGen().append(new AMD64BinaryConsumer.Op(AMD64Assembler.SSEOp.UCOMIS, AMD64BaseAssembler.OperandSize.PS, left, this.asAllocatable(right)));
                return;
            }
            case DOUBLE: {
                this.getLIRGen().append(new AMD64BinaryConsumer.Op(AMD64Assembler.SSEOp.UCOMIS, AMD64BaseAssembler.OperandSize.PD, left, this.asAllocatable(right)));
                return;
            }
            default: {
                throw GraalError.shouldNotReachHere("unexpected kind: " + cmpKind);
            }
        }
        if (LIRValueUtil.isConstantValue(right)) {
            Constant c = LIRValueUtil.asConstant(right);
            if (JavaConstant.isNull((Constant)c)) {
                if (this.mustReplaceNullWithNullRegister(c)) {
                    this.getLIRGen().append(new AMD64BinaryConsumer.Op(AMD64Assembler.AMD64RMOp.CMP, size, left, this.nullRegisterValue));
                } else {
                    this.getLIRGen().append(new AMD64BinaryConsumer.Op(AMD64Assembler.AMD64RMOp.TEST, size, left, left));
                }
                return;
            }
            if (c instanceof VMConstant) {
                VMConstant vc = (VMConstant)c;
                if (size == AMD64BaseAssembler.OperandSize.DWORD && !GraalOptions.GeneratePIC.getValue(this.getOptions()).booleanValue() && this.getLIRGen().target().inlineObjects) {
                    this.getLIRGen().append(new AMD64BinaryConsumer.VMConstOp(AMD64Assembler.AMD64BinaryArithmetic.CMP.getMIOpcode(AMD64BaseAssembler.OperandSize.DWORD, false), left, vc));
                } else {
                    this.getLIRGen().append(new AMD64BinaryConsumer.DataOp(AMD64Assembler.AMD64BinaryArithmetic.CMP.getRMOpcode(size), size, left, (Constant)vc));
                }
                return;
            }
            if (c instanceof JavaConstant) {
                JavaConstant jc = (JavaConstant)c;
                if (jc.isDefaultForKind()) {
                    AMD64Assembler.AMD64RMOp op = size == AMD64BaseAssembler.OperandSize.BYTE ? AMD64Assembler.AMD64RMOp.TESTB : AMD64Assembler.AMD64RMOp.TEST;
                    this.getLIRGen().append(new AMD64BinaryConsumer.Op(op, size, left, left));
                    return;
                }
                if (NumUtil.is32bit(jc.asLong())) {
                    this.getLIRGen().append(new AMD64BinaryConsumer.ConstOp(AMD64Assembler.AMD64BinaryArithmetic.CMP, size, (AllocatableValue)left, (int)jc.asLong()));
                    return;
                }
            }
        }
        this.getLIRGen().append(new AMD64BinaryConsumer.Op(AMD64Assembler.AMD64BinaryArithmetic.CMP.getRMOpcode(size), size, left, this.asAllocatable(right)));
    }

    @Override
    public Value emitRound(Value value, AMD64ArithmeticLIRGeneratorTool.RoundingMode mode) {
        Variable result = this.getLIRGen().newVariable(LIRKind.combine(value));
        assert (((AMD64Kind)value.getPlatformKind()).isXMM());
        if (value.getPlatformKind() == AMD64Kind.SINGLE) {
            this.getLIRGen().append(new AMD64Binary.RMIOp(AMD64Assembler.AMD64RMIOp.ROUNDSS, AMD64BaseAssembler.OperandSize.PD, result, this.asAllocatable(value), mode.encoding));
        } else {
            this.getLIRGen().append(new AMD64Binary.RMIOp(AMD64Assembler.AMD64RMIOp.ROUNDSD, AMD64BaseAssembler.OperandSize.PD, result, this.asAllocatable(value), mode.encoding));
        }
        return result;
    }

    public boolean supportAVX() {
        TargetDescription target = this.getLIRGen().target();
        return ((AMD64)target.arch).getFeatures().contains(AMD64.CPUFeature.AVX);
    }

    private static AVXKind.AVXSize getRegisterSize(Value a) {
        AMD64Kind kind = (AMD64Kind)a.getPlatformKind();
        if (kind.isXMM()) {
            return AVXKind.getRegisterSize(kind);
        }
        return AVXKind.AVXSize.XMM;
    }

    protected Variable emitBinary(LIRKind resultKind, AMD64Assembler.VexRVMOp op, Value a, Value b) {
        Variable result = this.getLIRGen().newVariable(resultKind);
        if (b instanceof ConstantValue && (b.getPlatformKind() == AMD64Kind.SINGLE || b.getPlatformKind() == AMD64Kind.DOUBLE)) {
            this.getLIRGen().append(new AMD64VectorBinary.AVXBinaryConstFloatOp(op, AMD64ArithmeticLIRGenerator.getRegisterSize((Value)result), result, this.asAllocatable(a), (ConstantValue)b));
        } else {
            this.getLIRGen().append(new AMD64VectorBinary.AVXBinaryOp(op, AMD64ArithmeticLIRGenerator.getRegisterSize((Value)result), result, this.asAllocatable(a), this.asAllocatable(b)));
        }
        return result;
    }
}

