/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.aarch64;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.aarch64.AArch64ArithmeticLIRGenerator;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.aarch64.AArch64ArithmeticOp;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(nameTemplate="AArch64PointerAdd", cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public class AArch64PointerAddNode
extends FloatingNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<AArch64PointerAddNode> TYPE = NodeClass.create(AArch64PointerAddNode.class);
    @Node.Input
    ValueNode base;
    @Node.Input
    ValueNode offset;

    public AArch64PointerAddNode(ValueNode base, ValueNode offset) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.pointer());
        this.base = base;
        this.offset = offset;
        assert (base != null && (base.stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp || IntegerStamp.getBits(base.stamp(NodeView.DEFAULT)) == 64));
        assert (offset != null && offset.getStackKind().isNumericInteger());
    }

    public ValueNode getBase() {
        return this.base;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        LIRGeneratorTool tool = builder.getLIRGeneratorTool();
        Value x = builder.operand(this.base);
        Value y = builder.operand(this.offset);
        AllocatableValue baseValue = tool.asAllocatable(x);
        AllocatableValue baseReference = LIRKind.derivedBaseFromValue(baseValue);
        LIRKind kind = LIRKind.combineDerived(tool.getLIRKind(this.stamp(NodeView.DEFAULT)), baseReference, null);
        builder.setResult(this, (Value)((AArch64ArithmeticLIRGenerator)gen).emitBinary(kind, AArch64ArithmeticOp.ADD, true, x, y));
    }
}

