/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.core.aarch64.AArch64ArithmeticLIRGenerator;
import org.graalvm.compiler.core.aarch64.AArch64LIRGenerator;
import org.graalvm.compiler.core.aarch64.AArch64PointerAddNode;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.gen.NodeMatchRules;
import org.graalvm.compiler.core.match.ComplexMatchResult;
import org.graalvm.compiler.core.match.MatchRule;
import org.graalvm.compiler.core.match.MatchRules;
import org.graalvm.compiler.core.match.MatchableNode;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.aarch64.AArch64ArithmeticOp;
import org.graalvm.compiler.lir.aarch64.AArch64BitFieldOp;
import org.graalvm.compiler.lir.aarch64.AArch64ControlFlow;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.BinaryNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.calc.NotNode;
import org.graalvm.compiler.nodes.calc.OrNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.memory.MemoryAccess;

@MatchableNode(nodeClass=AArch64PointerAddNode.class, inputs={"base", "offset"})
public class AArch64NodeMatchRules
extends NodeMatchRules {
    private static final EconomicMap<Class<? extends BinaryNode>, AArch64ArithmeticOp> binaryOpMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)9);
    private static final EconomicMap<Class<? extends BinaryNode>, AArch64BitFieldOp.BitFieldOpCode> bitFieldOpMap;
    private static final EconomicMap<Class<? extends BinaryNode>, AArch64Assembler.ShiftType> shiftTypeMap;
    private static final EconomicMap<Class<? extends BinaryNode>, AArch64ArithmeticOp> logicalNotOpMap;

    public AArch64NodeMatchRules(LIRGeneratorTool gen) {
        super(gen);
    }

    protected LIRFrameState getState(MemoryAccess access) {
        if (access instanceof DeoptimizingNode) {
            return this.state((DeoptimizingNode)((Object)access));
        }
        return null;
    }

    protected AArch64Kind getMemoryKind(MemoryAccess access) {
        return (AArch64Kind)this.gen.getLIRKind(((ValueNode)((Object)access)).stamp(NodeView.DEFAULT)).getPlatformKind();
    }

    private static AArch64Assembler.ExtendType getZeroExtendType(int fromBits) {
        switch (fromBits) {
            case 8: {
                return AArch64Assembler.ExtendType.UXTB;
            }
            case 16: {
                return AArch64Assembler.ExtendType.UXTH;
            }
            case 32: {
                return AArch64Assembler.ExtendType.UXTW;
            }
            case 64: {
                return AArch64Assembler.ExtendType.UXTX;
            }
        }
        GraalError.shouldNotReachHere("extended from " + fromBits + "bits is not supported!");
        return null;
    }

    private static AArch64Assembler.ExtendType getSignExtendType(int fromBits) {
        switch (fromBits) {
            case 8: {
                return AArch64Assembler.ExtendType.SXTB;
            }
            case 16: {
                return AArch64Assembler.ExtendType.SXTH;
            }
            case 32: {
                return AArch64Assembler.ExtendType.SXTW;
            }
            case 64: {
                return AArch64Assembler.ExtendType.SXTX;
            }
        }
        GraalError.shouldNotReachHere("extended from " + fromBits + "bits is not supported!");
        return null;
    }

    private AllocatableValue moveSp(AllocatableValue value) {
        return this.getLIRGeneratorTool().moveSp(value);
    }

    private ComplexMatchResult emitBinaryShift(AArch64ArithmeticOp op, ValueNode value, BinaryNode shift) {
        AArch64Assembler.ShiftType shiftType = (AArch64Assembler.ShiftType)((Object)shiftTypeMap.get(shift.getClass()));
        assert (shiftType != null);
        assert (value.getStackKind().isNumericInteger());
        assert (shift.getX().getStackKind().isNumericInteger());
        assert (shift.getY() instanceof ConstantNode);
        return builder -> {
            Value a = this.operand(value);
            Value b = this.operand(shift.getX());
            Variable result = this.gen.newVariable(LIRKind.combine(a, b));
            AllocatableValue x = this.moveSp(this.gen.asAllocatable(a));
            AllocatableValue y = this.moveSp(this.gen.asAllocatable(b));
            int shiftAmount = shift.getY().asJavaConstant().asInt();
            this.gen.append(new AArch64ArithmeticOp.BinaryShiftOp(op, result, x, y, shiftType, shiftAmount));
            return result;
        };
    }

    private ComplexMatchResult emitBitTestAndBranch(FixedNode trueSuccessor, FixedNode falseSuccessor, ValueNode value, double trueProbability, int nbits) {
        return builder -> {
            LabelRef trueDestination = this.getLIRBlock(trueSuccessor);
            LabelRef falseDestination = this.getLIRBlock(falseSuccessor);
            AllocatableValue src = this.moveSp(this.gen.asAllocatable(this.operand(value)));
            this.gen.append(new AArch64ControlFlow.BitTestAndBranchOp(trueDestination, falseDestination, src, trueProbability, nbits));
            return null;
        };
    }

    private ComplexMatchResult emitBitField(JavaKind kind, AArch64BitFieldOp.BitFieldOpCode op, ValueNode value, int lsb, int width) {
        assert (op != null);
        assert (value.getStackKind().isNumericInteger());
        return builder -> {
            Value a = this.operand(value);
            LIRKind resultKind = LIRKind.fromJavaKind(this.gen.target().arch, kind);
            Variable result = this.gen.newVariable(resultKind);
            AllocatableValue src = this.moveSp(this.gen.asAllocatable(a));
            this.gen.append(new AArch64BitFieldOp(op, result, src, lsb, width));
            return result;
        };
    }

    private ComplexMatchResult emitUnsignedBitField(JavaKind kind, BinaryNode shift, ValueNode value, ConstantNode scale, ConstantNode mask) {
        int srcBits;
        assert (kind.isNumericInteger());
        AArch64BitFieldOp.BitFieldOpCode op = (AArch64BitFieldOp.BitFieldOpCode)((Object)bitFieldOpMap.get(shift.getClass()));
        assert (op != null);
        JavaKind srcKind = shift.getStackKind();
        int distance = scale.asJavaConstant().asInt();
        int lsb = distance & (srcKind == JavaKind.Int ? 31 : 63);
        long maskValue = mask.asJavaConstant().asLong();
        if (!CodeUtil.isPowerOf2((long)(maskValue + 1L))) {
            return null;
        }
        int width = CodeUtil.log2((long)(maskValue + 1L));
        if (width >= (srcBits = srcKind.getBitCount()) - 1) {
            return null;
        }
        if (width + distance > srcBits) {
            return null;
        }
        return this.emitBitField(kind, op, value, lsb, width);
    }

    private static boolean isNarrowingLongToInt(NarrowNode narrow) {
        return narrow.getInputBits() == 64 && narrow.getResultBits() == 32;
    }

    private ComplexMatchResult emitExtendedAddSubShift(BinaryNode op, ValueNode x, ValueNode y, AArch64Assembler.ExtendType extType, int shiftAmt) {
        assert (op instanceof AddNode || op instanceof SubNode);
        return builder -> {
            AllocatableValue src1 = this.moveSp(this.gen.asAllocatable(this.operand(x)));
            AllocatableValue src2 = this.moveSp(this.gen.asAllocatable(this.operand(y)));
            Variable result = this.gen.newVariable(LIRKind.combine(this.operand(x), this.operand(y)));
            AArch64ArithmeticOp arithmeticOp = op instanceof AddNode ? AArch64ArithmeticOp.ADD : AArch64ArithmeticOp.SUB;
            this.gen.append(new AArch64ArithmeticOp.ExtendedAddSubShiftOp(arithmeticOp, result, src1, src2, extType, shiftAmt));
            return result;
        };
    }

    @MatchRules(value={@MatchRule(value="(Add=op x (LeftShift (SignExtend=ext y) Constant=lshift))"), @MatchRule(value="(Sub=op x (LeftShift (SignExtend=ext y) Constant=lshift))"), @MatchRule(value="(Add=op x (LeftShift (ZeroExtend=ext y) Constant=lshift))"), @MatchRule(value="(Sub=op x (LeftShift (ZeroExtend=ext y) Constant=lshift))")})
    public ComplexMatchResult mergeSignExtendByShiftIntoAddSub(BinaryNode op, UnaryNode ext, ValueNode x, ValueNode y, ConstantNode lshift) {
        assert (lshift.getStackKind().isNumericInteger());
        int shiftAmt = lshift.asJavaConstant().asInt();
        if (shiftAmt > 4 || shiftAmt < 0) {
            return null;
        }
        AArch64Assembler.ExtendType extType = ext instanceof SignExtendNode ? AArch64NodeMatchRules.getSignExtendType(((SignExtendNode)ext).getInputBits()) : AArch64NodeMatchRules.getZeroExtendType(((ZeroExtendNode)ext).getInputBits());
        return this.emitExtendedAddSubShift(op, x, y, extType, shiftAmt);
    }

    @MatchRules(value={@MatchRule(value="(Add=op x (LeftShift (And y Constant=constant) Constant=lshift))"), @MatchRule(value="(Sub=op x (LeftShift (And y Constant=constant) Constant=lshift))")})
    public ComplexMatchResult mergeShiftDowncastIntoAddSub(BinaryNode op, ValueNode x, ValueNode y, ConstantNode constant, ConstantNode lshift) {
        assert (lshift.getStackKind().isNumericInteger());
        assert (constant.getStackKind().isNumericInteger());
        int shiftAmt = lshift.asJavaConstant().asInt();
        long mask = constant.asJavaConstant().asLong();
        if (shiftAmt > 4 || shiftAmt < 0) {
            return null;
        }
        if (mask != 255L && mask != 65535L && mask != 0xFFFFFFFFL) {
            return null;
        }
        AArch64Assembler.ExtendType extType = AArch64NodeMatchRules.getZeroExtendType(Long.toBinaryString(mask).length());
        return this.emitExtendedAddSubShift(op, x, y, extType, shiftAmt);
    }

    @MatchRules(value={@MatchRule(value="(Add=op x (RightShift (LeftShift y Constant=shiftConst) Constant=shiftConst))"), @MatchRule(value="(Sub=op x (RightShift (LeftShift y Constant=shiftConst) Constant=shiftConst))")})
    public ComplexMatchResult mergePairShiftIntoAddSub(BinaryNode op, ValueNode x, ValueNode y, ConstantNode shiftConst) {
        assert (shiftConst.getStackKind().isNumericInteger());
        int shift = shiftConst.asJavaConstant().asInt();
        if (shift != 16 && shift != 24 && shift != 32 && shift != 48 && shift != 56) {
            return null;
        }
        int extractBits = shift >= 32 ? 64 - shift : 32 - shift;
        return this.emitExtendedAddSubShift(op, x, y, AArch64NodeMatchRules.getSignExtendType(extractBits), 0);
    }

    @MatchRules(value={@MatchRule(value="(Add=op x (LeftShift (RightShift (LeftShift y Constant=shiftConst) Constant=shiftConst) Constant=lshift))"), @MatchRule(value="(Sub=op x (LeftShift (RightShift (LeftShift y Constant=shiftConst) Constant=shiftConst) Constant=lshift))")})
    public ComplexMatchResult mergeShiftedPairShiftIntoAddSub(BinaryNode op, ValueNode x, ValueNode y, ConstantNode shiftConst, ConstantNode lshift) {
        assert (shiftConst.getStackKind().isNumericInteger());
        int shift = shiftConst.asJavaConstant().asInt();
        int shiftAmt = lshift.asJavaConstant().asInt();
        if (shiftAmt > 4 || shiftAmt < 0) {
            return null;
        }
        if (shift != 16 && shift != 24 && shift != 32 && shift != 48 && shift != 56) {
            return null;
        }
        int extractBits = shift >= 32 ? 64 - shift : 32 - shift;
        return this.emitExtendedAddSubShift(op, x, y, AArch64NodeMatchRules.getSignExtendType(extractBits), shiftAmt);
    }

    @MatchRules(value={@MatchRule(value="(AArch64PointerAdd=addP base ZeroExtend)"), @MatchRule(value="(AArch64PointerAdd=addP base (LeftShift ZeroExtend Constant))")})
    public ComplexMatchResult extendedPointerAddShift(AArch64PointerAddNode addP) {
        int shiftNum;
        ZeroExtendNode zeroExtend;
        ValueNode offset = addP.getOffset();
        if (offset instanceof ZeroExtendNode) {
            zeroExtend = (ZeroExtendNode)offset;
            shiftNum = 0;
        } else {
            LeftShiftNode shift = (LeftShiftNode)offset;
            zeroExtend = (ZeroExtendNode)shift.getX();
            shiftNum = shift.getY().asJavaConstant().asInt();
        }
        int fromBits = zeroExtend.getInputBits();
        int toBits = zeroExtend.getResultBits();
        if (toBits != 64) {
            return null;
        }
        assert (fromBits <= toBits);
        AArch64Assembler.ExtendType extendType = AArch64NodeMatchRules.getZeroExtendType(fromBits);
        if (shiftNum >= 0 && shiftNum <= 4) {
            ValueNode base = addP.getBase();
            return builder -> {
                AllocatableValue x = this.gen.asAllocatable(this.operand(base));
                AllocatableValue y = this.gen.asAllocatable(this.operand(zeroExtend.getValue()));
                AllocatableValue baseReference = LIRKind.derivedBaseFromValue(x);
                LIRKind kind = LIRKind.combineDerived(this.gen.getLIRKind(addP.stamp(NodeView.DEFAULT)), baseReference, null);
                Variable result = this.gen.newVariable(kind);
                this.gen.append(new AArch64ArithmeticOp.ExtendedAddSubShiftOp(AArch64ArithmeticOp.ADD, result, x, this.moveSp(y), extendType, shiftNum));
                return result;
            };
        }
        return null;
    }

    @MatchRules(value={@MatchRule(value="(And (UnsignedRightShift=shift value Constant=a) Constant=b)"), @MatchRule(value="(LeftShift=shift (And value Constant=b) Constant=a)")})
    public ComplexMatchResult unsignedBitField(BinaryNode shift, ValueNode value, ConstantNode a, ConstantNode b) {
        JavaKind kind = shift.getStackKind();
        return this.emitUnsignedBitField(kind, shift, value, a, b);
    }

    @MatchRules(value={@MatchRule(value="(LeftShift=shift (ZeroExtend=extend (And value Constant=b)) Constant=a)"), @MatchRule(value="(ZeroExtend=extend (And (UnsignedRightShift=shift value Constant=a) Constant=b))"), @MatchRule(value="(ZeroExtend=extend (LeftShift=shift (And value Constant=b) Constant=a))")})
    public ComplexMatchResult unsignedExtBitField(ZeroExtendNode extend, BinaryNode shift, ValueNode value, ConstantNode a, ConstantNode b) {
        JavaKind kind = extend.getStackKind();
        return this.emitUnsignedBitField(kind, shift, value, a, b);
    }

    @MatchRule(value="(LeftShift=shift (SignExtend value) Constant)")
    public ComplexMatchResult signedBitField(LeftShiftNode shift) {
        JavaKind kind = shift.getStackKind();
        assert (kind.isNumericInteger());
        SignExtendNode extend = (SignExtendNode)shift.getX();
        int srcBits = extend.getInputBits();
        int resultBits = extend.getResultBits();
        assert (kind.getBitCount() == resultBits);
        int lsb = shift.getY().asJavaConstant().asInt() & resultBits - 1;
        int width = Math.min(srcBits, resultBits - lsb);
        assert (width >= 1 && width <= resultBits - lsb);
        ValueNode value = extend.getValue();
        return this.emitBitField(kind, AArch64BitFieldOp.BitFieldOpCode.SBFIZ, value, lsb, width);
    }

    @MatchRules(value={@MatchRule(value="(RightShift=rshift (LeftShift=lshift value Constant) Constant)"), @MatchRule(value="(UnsignedRightShift=rshift (LeftShift=lshift value Constant) Constant)")})
    public ComplexMatchResult bitFieldMove(BinaryNode rshift, LeftShiftNode lshift) {
        AArch64BitFieldOp.BitFieldOpCode op;
        boolean bitFieldInsert;
        JavaKind srcKind = rshift.getStackKind();
        assert (srcKind.isNumericInteger());
        int srcBits = srcKind.getBitCount();
        int lshiftNum = lshift.getY().asJavaConstant().asInt() & srcBits - 1;
        int rshiftNum = rshift.getY().asJavaConstant().asInt() & srcBits - 1;
        int lsb = Math.abs(lshiftNum - rshiftNum);
        assert (lsb >= 0 && lsb <= srcBits - 1);
        int width = srcBits - Math.max(lshiftNum, rshiftNum);
        if (width > srcBits - lsb || width < 1) {
            return null;
        }
        boolean bl = bitFieldInsert = lshiftNum > rshiftNum;
        if (rshift instanceof RightShiftNode) {
            op = bitFieldInsert ? AArch64BitFieldOp.BitFieldOpCode.SBFIZ : AArch64BitFieldOp.BitFieldOpCode.SBFX;
        } else {
            assert (rshift instanceof UnsignedRightShiftNode);
            op = bitFieldInsert ? AArch64BitFieldOp.BitFieldOpCode.UBFIZ : AArch64BitFieldOp.BitFieldOpCode.UBFX;
        }
        return this.emitBitField(srcKind, op, lshift.getX(), lsb, width);
    }

    @MatchRules(value={@MatchRule(value="(Or=op (LeftShift=x src Constant=shiftAmt1) (UnsignedRightShift src Constant=shiftAmt2))"), @MatchRule(value="(Or=op (UnsignedRightShift=x src Constant=shiftAmt1) (LeftShift src Constant=shiftAmt2))"), @MatchRule(value="(Add=op (LeftShift=x src Constant=shiftAmt1) (UnsignedRightShift src Constant=shiftAmt2))"), @MatchRule(value="(Add=op (UnsignedRightShift=x src Constant=shiftAmt1) (LeftShift src Constant=shiftAmt2))")})
    public ComplexMatchResult rotationConstant(ValueNode op, ValueNode x, ValueNode src, ConstantNode shiftAmt1, ConstantNode shiftAmt2) {
        assert (src.getStackKind().isNumericInteger());
        assert (shiftAmt1.getStackKind().getBitCount() == 32);
        assert (shiftAmt2.getStackKind().getBitCount() == 32);
        int shift1 = shiftAmt1.asJavaConstant().asInt();
        int shift2 = shiftAmt2.asJavaConstant().asInt();
        if (op instanceof AddNode && (0 == shift1 || 0 == shift2)) {
            return null;
        }
        if (0 == shift1 + shift2 || src.getStackKind().getBitCount() == shift1 + shift2) {
            return builder -> {
                AllocatableValue a = this.gen.asAllocatable(this.operand(src));
                JavaConstant b = x instanceof LeftShiftNode ? shiftAmt2.asJavaConstant() : shiftAmt1.asJavaConstant();
                Variable result = this.gen.newVariable(LIRKind.combine(new Value[]{a}));
                this.getArithmeticLIRGenerator().emitBinaryConst(result, AArch64ArithmeticOp.ROR, a, b);
                return result;
            };
        }
        return null;
    }

    @MatchRules(value={@MatchRule(value="(Or (LeftShift=x src shiftAmount) (UnsignedRightShift src (Sub=y Constant shiftAmount)))"), @MatchRule(value="(Or (UnsignedRightShift=x src shiftAmount) (LeftShift src (Sub=y Constant shiftAmount)))"), @MatchRule(value="(Or (LeftShift=x src (Negate shiftAmount)) (UnsignedRightShift src (Add=y Constant shiftAmount)))"), @MatchRule(value="(Or (UnsignedRightShift=x src (Negate shiftAmount)) (LeftShift src (Add=y Constant shiftAmount)))"), @MatchRule(value="(Or (LeftShift=x src shiftAmount) (UnsignedRightShift src (Negate=y shiftAmount)))"), @MatchRule(value="(Or (UnsignedRightShift=x src shiftAmount) (LeftShift src (Negate=y shiftAmount)))")})
    public ComplexMatchResult rotationExpander(ValueNode src, ValueNode shiftAmount, ValueNode x, ValueNode y) {
        BinaryNode binary;
        ConstantNode delta;
        assert (src.getStackKind().isNumericInteger());
        assert (shiftAmount.getStackKind().getBitCount() == 32);
        if ((y instanceof SubNode || y instanceof AddNode) && (delta = (ConstantNode)((binary = (BinaryNode)y).getX() instanceof ConstantNode ? binary.getX() : binary.getY())).asJavaConstant().asInt() != src.getStackKind().getBitCount()) {
            return null;
        }
        return builder -> {
            Value a = this.operand(src);
            Value b = y instanceof AddNode ? (x instanceof LeftShiftNode ? this.operand(shiftAmount) : this.getArithmeticLIRGenerator().emitNegate(this.operand(shiftAmount))) : (x instanceof LeftShiftNode ? this.getArithmeticLIRGenerator().emitNegate(this.operand(shiftAmount)) : this.operand(shiftAmount));
            return this.getArithmeticLIRGenerator().emitBinary(LIRKind.combine(a, b), AArch64ArithmeticOp.RORV, false, a, b);
        };
    }

    @MatchRules(value={@MatchRule(value="(Add=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(Add=binary a (RightShift=shift b Constant))"), @MatchRule(value="(Add=binary a (UnsignedRightShift=shift b Constant))"), @MatchRule(value="(Sub=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(Sub=binary a (RightShift=shift b Constant))"), @MatchRule(value="(Sub=binary a (UnsignedRightShift=shift b Constant))")})
    public ComplexMatchResult addSubShift(BinaryNode binary, ValueNode a, BinaryNode shift) {
        AArch64ArithmeticOp op = (AArch64ArithmeticOp)((Object)binaryOpMap.get(binary.getClass()));
        assert (op != null);
        return this.emitBinaryShift(op, a, shift);
    }

    @MatchRules(value={@MatchRule(value="(And=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(And=binary a (RightShift=shift b Constant))"), @MatchRule(value="(And=binary a (UnsignedRightShift=shift b Constant))"), @MatchRule(value="(Or=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(Or=binary a (RightShift=shift b Constant))"), @MatchRule(value="(Or=binary a (UnsignedRightShift=shift b Constant))"), @MatchRule(value="(Xor=binary a (LeftShift=shift b Constant))"), @MatchRule(value="(Xor=binary a (RightShift=shift b Constant))"), @MatchRule(value="(Xor=binary a (UnsignedRightShift=shift b Constant))"), @MatchRule(value="(And=binary a (Not (LeftShift=shift b Constant)))"), @MatchRule(value="(And=binary a (Not (RightShift=shift b Constant)))"), @MatchRule(value="(And=binary a (Not (UnsignedRightShift=shift b Constant)))"), @MatchRule(value="(Or=binary a (Not (LeftShift=shift b Constant)))"), @MatchRule(value="(Or=binary a (Not (RightShift=shift b Constant)))"), @MatchRule(value="(Or=binary a (Not (UnsignedRightShift=shift b Constant)))"), @MatchRule(value="(Xor=binary a (Not (LeftShift=shift b Constant)))"), @MatchRule(value="(Xor=binary a (Not (RightShift=shift b Constant)))"), @MatchRule(value="(Xor=binary a (Not (UnsignedRightShift=shift b Constant)))")})
    public ComplexMatchResult logicShift(BinaryNode binary, ValueNode a, BinaryNode shift) {
        ValueNode operand = binary.getX() == a ? binary.getY() : binary.getX();
        AArch64ArithmeticOp op = operand instanceof NotNode ? (AArch64ArithmeticOp)((Object)logicalNotOpMap.get(binary.getClass())) : (AArch64ArithmeticOp)((Object)binaryOpMap.get(binary.getClass()));
        assert (op != null);
        return this.emitBinaryShift(op, a, shift);
    }

    @MatchRules(value={@MatchRule(value="(And=logic value1 (Not=not value2))"), @MatchRule(value="(Or=logic value1 (Not=not value2))"), @MatchRule(value="(Xor=logic value1 (Not=not value2))")})
    public ComplexMatchResult bitwiseLogicNot(BinaryNode logic, NotNode not) {
        assert (logic.getStackKind().isNumericInteger());
        AArch64ArithmeticOp op = (AArch64ArithmeticOp)((Object)logicalNotOpMap.get(logic.getClass()));
        assert (op != null);
        ValueNode src1 = logic.getX() == not ? logic.getY() : logic.getX();
        ValueNode src2 = not.getValue();
        return builder -> {
            Value a = this.operand(src1);
            Value b = this.operand(src2);
            LIRKind resultKind = LIRKind.combine(a, b);
            return this.getArithmeticLIRGenerator().emitBinary(resultKind, op, false, a, b);
        };
    }

    @MatchRule(value="(Not=not (Xor value1 value2))")
    public ComplexMatchResult bitwiseNotXor(NotNode not) {
        assert (not.getStackKind().isNumericInteger());
        return builder -> {
            XorNode xor = (XorNode)not.getValue();
            Value a = this.operand(xor.getX());
            Value b = this.operand(xor.getY());
            LIRKind resultKind = LIRKind.combine(a, b);
            return this.getArithmeticLIRGenerator().emitBinary(resultKind, AArch64ArithmeticOp.EON, false, a, b);
        };
    }

    @MatchRules(value={@MatchRule(value="(Add=binary (Mul (SignExtend a) (SignExtend b)) c)"), @MatchRule(value="(Sub=binary c (Mul (SignExtend a) (SignExtend b)))")})
    public ComplexMatchResult signedMultiplyAddSubLong(BinaryNode binary, ValueNode a, ValueNode b, ValueNode c) {
        assert (a.getStackKind() == JavaKind.Int && b.getStackKind() == JavaKind.Int && c.getStackKind() == JavaKind.Long);
        if (binary instanceof AddNode) {
            return builder -> this.getArithmeticLIRGenerator().emitIntegerMAdd(this.operand(a), this.operand(b), this.operand(c), true);
        }
        return builder -> this.getArithmeticLIRGenerator().emitIntegerMSub(this.operand(a), this.operand(b), this.operand(c), true);
    }

    @MatchRules(value={@MatchRule(value="(Negate (Mul=mul (SignExtend a) (SignExtend b)))"), @MatchRule(value="(Mul=mul (Negate (SignExtend a)) (SignExtend b))")})
    public ComplexMatchResult signedMultiplyNegLong(MulNode mul, ValueNode a, ValueNode b) {
        assert (a.getStackKind() == JavaKind.Int && b.getStackKind() == JavaKind.Int);
        LIRKind resultKind = LIRKind.fromJavaKind(this.gen.target().arch, mul.getStackKind());
        return builder -> this.getArithmeticLIRGenerator().emitBinary(resultKind, AArch64ArithmeticOp.SMNEGL, true, this.operand(a), this.operand(b));
    }

    @MatchRule(value="(Mul=mul (SignExtend a) (SignExtend b))")
    public ComplexMatchResult signedMultiplyLong(MulNode mul, ValueNode a, ValueNode b) {
        assert (a.getStackKind() == JavaKind.Int && b.getStackKind() == JavaKind.Int);
        LIRKind resultKind = LIRKind.fromJavaKind(this.gen.target().arch, mul.getStackKind());
        return builder -> this.getArithmeticLIRGenerator().emitBinary(resultKind, AArch64ArithmeticOp.SMULL, true, this.operand(a), this.operand(b));
    }

    @MatchRules(value={@MatchRule(value="(Add=binary (Narrow=narrow a) (Narrow b))"), @MatchRule(value="(Sub=binary (Narrow=narrow a) (Narrow b))"), @MatchRule(value="(Mul=binary (Narrow=narrow a) (Narrow b))"), @MatchRule(value="(And=binary (Narrow=narrow a) (Narrow b))"), @MatchRule(value="(Or=binary (Narrow=narrow a) (Narrow b))"), @MatchRule(value="(Xor=binary (Narrow=narrow a) (Narrow b))"), @MatchRule(value="(LeftShift=binary (Narrow=narrow a) (Narrow b))"), @MatchRule(value="(RightShift=binary (Narrow=narrow a) (Narrow b))"), @MatchRule(value="(UnsignedRightShift=binary (Narrow=narrow a) (Narrow b))"), @MatchRule(value="(Add=binary a (Narrow=narrow b))"), @MatchRule(value="(Sub=binary a (Narrow=narrow b))"), @MatchRule(value="(Mul=binary a (Narrow=narrow b))"), @MatchRule(value="(And=binary a (Narrow=narrow b))"), @MatchRule(value="(Or=binary a (Narrow=narrow b))"), @MatchRule(value="(Xor=binary a (Narrow=narrow b))"), @MatchRule(value="(LeftShift=binary a (Narrow=narrow b))"), @MatchRule(value="(RightShift=binary a (Narrow=narrow b))"), @MatchRule(value="(UnsignedRightShift=binary a (Narrow=narrow b))"), @MatchRule(value="(Sub=binary (Narrow=narrow a) b)"), @MatchRule(value="(LeftShift=binary (Narrow=narrow a) b)"), @MatchRule(value="(RightShift=binary (Narrow=narrow a) b)"), @MatchRule(value="(UnsignedRightShift=binary (Narrow=narrow a) b)")})
    public ComplexMatchResult elideL2IForBinary(BinaryNode binary, NarrowNode narrow) {
        boolean isL2Ib;
        assert (binary.getStackKind().isNumericInteger());
        NarrowNode a = narrow;
        ValueNode b = binary.getX() == narrow ? binary.getY() : binary.getX();
        boolean isL2Ia = AArch64NodeMatchRules.isNarrowingLongToInt(a);
        boolean bl = isL2Ib = b instanceof NarrowNode && AArch64NodeMatchRules.isNarrowingLongToInt((NarrowNode)b);
        if (!isL2Ia && !isL2Ib) {
            return null;
        }
        NarrowNode src1 = isL2Ia ? a.getValue() : a;
        ValueNode src2 = isL2Ib ? ((NarrowNode)b).getValue() : b;
        AArch64ArithmeticOp op = (AArch64ArithmeticOp)((Object)binaryOpMap.get(binary.getClass()));
        assert (op != null);
        boolean commutative = binary.getNodeClass().isCommutative();
        LIRKind resultKind = LIRKind.fromJavaKind(this.gen.target().arch, binary.getStackKind());
        if (a == binary.getX()) {
            return builder -> this.getArithmeticLIRGenerator().emitBinary(resultKind, op, commutative, this.operand(src1), this.operand(src2));
        }
        return builder -> this.getArithmeticLIRGenerator().emitBinary(resultKind, op, commutative, this.operand(src2), this.operand(src1));
    }

    @MatchRules(value={@MatchRule(value="(Add=op x (And y Constant=constant))"), @MatchRule(value="(Sub=op x (And y Constant=constant))")})
    public ComplexMatchResult mergeDowncastIntoAddSub(BinaryNode op, ValueNode x, ValueNode y, ConstantNode constant) {
        assert (constant.getStackKind().isNumericInteger());
        long mask = constant.asJavaConstant().asLong();
        if (mask != 255L && mask != 65535L && mask != 0xFFFFFFFFL) {
            return null;
        }
        AArch64Assembler.ExtendType extType = AArch64NodeMatchRules.getZeroExtendType(Long.toBinaryString(mask).length());
        return this.emitExtendedAddSubShift(op, x, y, extType, 0);
    }

    @MatchRules(value={@MatchRule(value="(Add=op x (SignExtend=ext y))"), @MatchRule(value="(Sub=op x (SignExtend=ext y))"), @MatchRule(value="(Add=op x (ZeroExtend=ext y))"), @MatchRule(value="(Sub=op x (ZeroExtend=ext y))")})
    public ComplexMatchResult mergeSignExtendIntoAddSub(BinaryNode op, UnaryNode ext, ValueNode x, ValueNode y) {
        AArch64Assembler.ExtendType extType = ext instanceof SignExtendNode ? AArch64NodeMatchRules.getSignExtendType(((SignExtendNode)ext).getInputBits()) : AArch64NodeMatchRules.getZeroExtendType(((ZeroExtendNode)ext).getInputBits());
        return this.emitExtendedAddSubShift(op, x, y, extType, 0);
    }

    @MatchRules(value={@MatchRule(value="(Negate=unary (Narrow=narrow value))"), @MatchRule(value="(Not=unary (Narrow=narrow value))")})
    public ComplexMatchResult elideL2IForUnary(UnaryNode unary, NarrowNode narrow) {
        assert (unary.getStackKind().isNumericInteger());
        if (!AArch64NodeMatchRules.isNarrowingLongToInt(narrow)) {
            return null;
        }
        AArch64ArithmeticOp op = unary instanceof NegateNode ? AArch64ArithmeticOp.NEG : AArch64ArithmeticOp.NOT;
        return builder -> {
            AllocatableValue input = this.gen.asAllocatable(this.operand(narrow.getValue()));
            LIRKind resultKind = LIRKind.fromJavaKind(this.gen.target().arch, unary.getStackKind());
            Variable result = this.gen.newVariable(resultKind);
            this.gen.append(new AArch64ArithmeticOp.UnaryOp(op, result, this.moveSp(input)));
            return result;
        };
    }

    @MatchRules(value={@MatchRule(value="(Mul (Negate a) b)"), @MatchRule(value="(Negate (Mul a b))")})
    public ComplexMatchResult multiplyNegate(ValueNode a, ValueNode b) {
        if (a.getStackKind().isNumericInteger() && b.getStackKind().isNumericInteger()) {
            return builder -> this.getArithmeticLIRGenerator().emitMNeg(this.operand(a), this.operand(b));
        }
        return null;
    }

    @MatchRules(value={@MatchRule(value="(Add=binary (Mul a b) c)"), @MatchRule(value="(Sub=binary c (Mul a b))")})
    public ComplexMatchResult multiplyAddSub(BinaryNode binary, ValueNode a, ValueNode b, ValueNode c) {
        JavaKind kindA = a.getStackKind();
        JavaKind kindB = b.getStackKind();
        JavaKind kindC = c.getStackKind();
        if (!(kindA.isNumericInteger() && kindB.isNumericInteger() && kindC.isNumericInteger())) {
            return null;
        }
        if (binary instanceof AddNode) {
            return builder -> this.getArithmeticLIRGenerator().emitIntegerMAdd(this.operand(a), this.operand(b), this.operand(c), false);
        }
        return builder -> this.getArithmeticLIRGenerator().emitIntegerMSub(this.operand(a), this.operand(b), this.operand(c), false);
    }

    @MatchRule(value="(If (IntegerTest value Constant=a))")
    public ComplexMatchResult testBitAndBranch(IfNode root, ValueNode value, ConstantNode a) {
        long constant;
        if (value.getStackKind().isNumericInteger() && Long.bitCount(constant = a.asJavaConstant().asLong()) == 1) {
            return this.emitBitTestAndBranch(root.trueSuccessor(), root.falseSuccessor(), value, root.getTrueSuccessorProbability(), Long.numberOfTrailingZeros(constant));
        }
        return null;
    }

    @MatchRule(value="(If (IntegerLessThan=lessNode x Constant=y))")
    public ComplexMatchResult checkNegativeAndBranch(IfNode root, IntegerLessThanNode lessNode, ValueNode x, ConstantNode y) {
        JavaKind xKind = x.getStackKind();
        assert (xKind.isNumericInteger());
        if (y.isJavaConstant() && 0L == y.asJavaConstant().asLong() && lessNode.condition().equals((Object)CanonicalCondition.LT)) {
            return this.emitBitTestAndBranch(root.falseSuccessor(), root.trueSuccessor(), x, 1.0 - root.getTrueSuccessorProbability(), xKind.getBitCount() - 1);
        }
        return null;
    }

    @MatchRule(value="(FloatConvert=a (Sqrt (FloatConvert=b c)))")
    public ComplexMatchResult floatSqrt(FloatConvertNode a, FloatConvertNode b, ValueNode c) {
        if (c.getStackKind().isNumericFloat() && a.getStackKind().isNumericFloat() && a.getFloatConvert() == FloatConvert.D2F && b.getFloatConvert() == FloatConvert.F2D) {
            return builder -> this.getArithmeticLIRGenerator().emitMathSqrt(this.operand(c));
        }
        return null;
    }

    @MatchRules(value={@MatchRule(value="(SignExtend=extend (Narrow value))"), @MatchRule(value="(ZeroExtend=extend (Narrow value))")})
    public ComplexMatchResult mergeNarrowExtend(UnaryNode extend, ValueNode value) {
        if (extend instanceof SignExtendNode) {
            SignExtendNode sxt = (SignExtendNode)extend;
            return builder -> this.getArithmeticLIRGenerator().emitSignExtend(this.operand(value), sxt.getInputBits(), sxt.getResultBits());
        }
        assert (extend instanceof ZeroExtendNode);
        ZeroExtendNode zxt = (ZeroExtendNode)extend;
        return builder -> this.getArithmeticLIRGenerator().emitZeroExtend(this.operand(value), zxt.getInputBits(), zxt.getResultBits());
    }

    @Override
    public AArch64LIRGenerator getLIRGeneratorTool() {
        return (AArch64LIRGenerator)this.gen;
    }

    protected AArch64ArithmeticLIRGenerator getArithmeticLIRGenerator() {
        return (AArch64ArithmeticLIRGenerator)this.getLIRGeneratorTool().getArithmetic();
    }

    static {
        binaryOpMap.put(AddNode.class, (Object)AArch64ArithmeticOp.ADD);
        binaryOpMap.put(SubNode.class, (Object)AArch64ArithmeticOp.SUB);
        binaryOpMap.put(MulNode.class, (Object)AArch64ArithmeticOp.MUL);
        binaryOpMap.put(AndNode.class, (Object)AArch64ArithmeticOp.AND);
        binaryOpMap.put(OrNode.class, (Object)AArch64ArithmeticOp.OR);
        binaryOpMap.put(XorNode.class, (Object)AArch64ArithmeticOp.XOR);
        binaryOpMap.put(LeftShiftNode.class, (Object)AArch64ArithmeticOp.SHL);
        binaryOpMap.put(RightShiftNode.class, (Object)AArch64ArithmeticOp.ASHR);
        binaryOpMap.put(UnsignedRightShiftNode.class, (Object)AArch64ArithmeticOp.LSHR);
        bitFieldOpMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)2);
        bitFieldOpMap.put(UnsignedRightShiftNode.class, (Object)AArch64BitFieldOp.BitFieldOpCode.UBFX);
        bitFieldOpMap.put(LeftShiftNode.class, (Object)AArch64BitFieldOp.BitFieldOpCode.UBFIZ);
        logicalNotOpMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)3);
        logicalNotOpMap.put(AndNode.class, (Object)AArch64ArithmeticOp.BIC);
        logicalNotOpMap.put(OrNode.class, (Object)AArch64ArithmeticOp.ORN);
        logicalNotOpMap.put(XorNode.class, (Object)AArch64ArithmeticOp.EON);
        shiftTypeMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY, (int)3);
        shiftTypeMap.put(LeftShiftNode.class, (Object)AArch64Assembler.ShiftType.LSL);
        shiftTypeMap.put(RightShiftNode.class, (Object)AArch64Assembler.ShiftType.ASR);
        shiftTypeMap.put(UnsignedRightShiftNode.class, (Object)AArch64Assembler.ShiftType.LSR);
    }
}

