/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.aarch64;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.aarch64.AArch64AddressValue;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo
public class AArch64AddressNode
extends AddressNode
implements LIRLowerable {
    public static final NodeClass<AArch64AddressNode> TYPE = NodeClass.create(AArch64AddressNode.class);
    @Node.OptionalInput
    private ValueNode base;
    @Node.OptionalInput
    private ValueNode index;
    private AArch64Address.AddressingMode addressingMode;
    private long displacement;
    private int scaleFactor;

    public AArch64AddressNode(ValueNode base) {
        this(base, null);
    }

    public AArch64AddressNode(ValueNode base, ValueNode index) {
        super((NodeClass<? extends AddressNode>)TYPE);
        this.base = base;
        this.index = index;
        this.addressingMode = AArch64Address.AddressingMode.REGISTER_OFFSET;
        this.displacement = 0L;
        this.scaleFactor = 1;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        assert (this.verify());
        LIRGeneratorTool tool = gen.getLIRGeneratorTool();
        AllocatableValue baseValue = this.base == null ? Value.ILLEGAL : tool.asAllocatable(gen.operand(this.base));
        AllocatableValue indexValue = this.index == null ? Value.ILLEGAL : tool.asAllocatable(gen.operand(this.index));
        AllocatableValue baseReference = LIRKind.derivedBaseFromValue(baseValue);
        AllocatableValue indexReference = this.index == null || LIRKind.isValue(indexValue.getValueKind()) ? null : Value.ILLEGAL;
        LIRKind kind = LIRKind.combineDerived(tool.getLIRKind(this.stamp(NodeView.DEFAULT)), baseReference, indexReference);
        gen.setResult(this, new AArch64AddressValue(kind, baseValue, indexValue, (int)this.displacement, this.scaleFactor, this.addressingMode));
    }

    @Override
    public boolean verify() {
        assert (super.verify());
        switch (this.addressingMode) {
            case IMMEDIATE_SIGNED_UNSCALED: 
            case IMMEDIATE_UNSIGNED_SCALED: {
                assert (this.index == null);
                break;
            }
            case BASE_REGISTER_ONLY: {
                assert (this.displacement == 0L && this.index == null);
                break;
            }
            case REGISTER_OFFSET: 
            case EXTENDED_REGISTER_OFFSET: {
                assert (this.displacement == 0L && this.index != null);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return true;
    }

    @Override
    public ValueNode getBase() {
        return this.base;
    }

    public void setBase(ValueNode base) {
        if (this.isAlive()) {
            this.updateUsages(this.base, base);
        }
        this.base = base;
    }

    @Override
    public ValueNode getIndex() {
        return this.index;
    }

    public void setIndex(ValueNode index) {
        if (this.isAlive()) {
            this.updateUsages(this.index, index);
        }
        this.index = index;
    }

    public long getDisplacement() {
        return this.displacement;
    }

    public void setDisplacement(long displacement, int scaleFactor, AArch64Address.AddressingMode addressingMode) {
        this.displacement = displacement;
        this.scaleFactor = scaleFactor;
        this.addressingMode = addressingMode;
    }

    @Override
    public long getMaxConstantDisplacement() {
        return this.displacement;
    }

    public AArch64Address.AddressingMode getAddressingMode() {
        return this.addressingMode;
    }
}

