/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.bytecode;

import java.util.Objects;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecodeProvider;

public class ResolvedJavaMethodBytecode
implements Bytecode {
    private final ResolvedJavaMethod method;
    private final BytecodeProvider origin;

    public ResolvedJavaMethodBytecode(ResolvedJavaMethod method) {
        this(method, ResolvedJavaMethodBytecodeProvider.INSTANCE);
    }

    public ResolvedJavaMethodBytecode(ResolvedJavaMethod method, BytecodeProvider origin) {
        this.method = method;
        this.origin = origin;
    }

    @Override
    public BytecodeProvider getOrigin() {
        return this.origin;
    }

    @Override
    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    @Override
    public byte[] getCode() {
        return this.method.getCode();
    }

    @Override
    public int getCodeSize() {
        return this.method.getCodeSize();
    }

    @Override
    public int getMaxStackSize() {
        return this.method.getMaxStackSize();
    }

    @Override
    public int getMaxLocals() {
        return this.method.getMaxLocals();
    }

    @Override
    public ConstantPool getConstantPool() {
        return this.method.getConstantPool();
    }

    @Override
    public LineNumberTable getLineNumberTable() {
        return this.method.getLineNumberTable();
    }

    @Override
    public LocalVariableTable getLocalVariableTable() {
        return this.method.getLocalVariableTable();
    }

    @Override
    public ExceptionHandler[] getExceptionHandlers() {
        return this.method.getExceptionHandlers();
    }

    @Override
    public StackTraceElement asStackTraceElement(int bci) {
        return this.method.asStackTraceElement(bci);
    }

    @Override
    public ProfilingInfo getProfilingInfo() {
        return this.method.getProfilingInfo();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.method.format("<%h.%n(%p)>");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedJavaMethodBytecode that = (ResolvedJavaMethodBytecode)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.origin, that.origin);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.origin);
    }
}

