/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.asm.AbstractAddress;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.sparc.SPARCAddress;
import org.graalvm.compiler.asm.sparc.SPARCAssembler;

public class SPARCMacroAssembler
extends SPARCAssembler {
    private static final SPARCAddress Placeholder = new SPARCAddress(SPARC.g0, 0);
    private final ScratchRegister[] scratchRegister = new ScratchRegister[]{new ScratchRegister(SPARC.g3), new ScratchRegister(SPARC.o7)};
    private int nextFreeScratchRegister = 0;
    private boolean immediateConstantLoad;

    public SPARCMacroAssembler(TargetDescription target) {
        super(target);
    }

    public void setImmediateConstantLoad(boolean immediateConstantLoad) {
        this.immediateConstantLoad = immediateConstantLoad;
    }

    @Override
    public void align(int modulus) {
        while (this.position() % modulus != 0) {
            this.nop();
        }
    }

    @Override
    public void jmp(Label l) {
        BPCC.emit(this, SPARCAssembler.CC.Xcc, SPARCAssembler.ConditionFlag.Always, SPARCAssembler.Annul.NOT_ANNUL, SPARCAssembler.BranchPredict.PREDICT_NOT_TAKEN, l);
        this.nop();
    }

    public void bz(Label l) {
        BPCC.emit(this, SPARCAssembler.CC.Xcc, SPARCAssembler.ConditionFlag.Zero, SPARCAssembler.Annul.NOT_ANNUL, SPARCAssembler.BranchPredict.PREDICT_NOT_TAKEN, l);
    }

    @Override
    protected final void patchJumpTarget(int branch, int branchTarget) {
        int disp = (branchTarget - branch) / 4;
        int inst = this.getInt(branch);
        SPARCAssembler.ControlTransferOp op = (SPARCAssembler.ControlTransferOp)SPARCMacroAssembler.getSPARCOp(inst);
        int newInst = op.setDisp(inst, disp);
        this.emitInt(newInst, branch);
    }

    @Override
    public AbstractAddress makeAddress(Register base, int displacement) {
        return new SPARCAddress(base, displacement);
    }

    @Override
    public AbstractAddress getPlaceholder(int instructionStartPosition) {
        return Placeholder;
    }

    @Override
    public final void ensureUniquePC() {
        this.nop();
    }

    public void cas(Register rs1, Register rs2, Register rd) {
        this.casa(rs1, rs2, rd, SPARCAssembler.Asi.ASI_PRIMARY);
    }

    public void casx(Register rs1, Register rs2, Register rd) {
        this.casxa(rs1, rs2, rd, SPARCAssembler.Asi.ASI_PRIMARY);
    }

    public void clr(Register dst) {
        this.or(SPARC.g0, SPARC.g0, dst);
    }

    public void clrb(SPARCAddress addr) {
        this.stb(SPARC.g0, addr);
    }

    public void clrh(SPARCAddress addr) {
        this.sth(SPARC.g0, addr);
    }

    public void clrx(SPARCAddress addr) {
        this.stx(SPARC.g0, addr);
    }

    public void cmp(Register rs1, Register rs2) {
        this.subcc(rs1, rs2, SPARC.g0);
    }

    public void cmp(Register rs1, int simm13) {
        this.subcc(rs1, simm13, SPARC.g0);
    }

    public void dec(Register rd) {
        this.sub(rd, 1, rd);
    }

    public void dec(int simm13, Register rd) {
        this.sub(rd, simm13, rd);
    }

    public void jmp(SPARCAddress address) {
        this.jmpl(address.getBase(), address.getDisplacement(), SPARC.g0);
    }

    public void jmp(Register rd) {
        this.jmpl(rd, 0, SPARC.g0);
    }

    public void neg(Register rs1, Register rd) {
        this.sub(SPARC.g0, rs1, rd);
    }

    public void neg(Register rd) {
        this.sub(SPARC.g0, rd, rd);
    }

    public void mov(Register rs, Register rd) {
        this.or(SPARC.g0, rs, rd);
    }

    public void mov(int simm13, Register rd) {
        this.or(SPARC.g0, simm13, rd);
    }

    public void not(Register rs1, Register rd) {
        this.xnor(rs1, SPARC.g0, rd);
    }

    public void not(Register rd) {
        this.xnor(rd, SPARC.g0, rd);
    }

    public void restoreWindow() {
        this.restore(SPARC.g0, SPARC.g0, SPARC.g0);
    }

    public void ret() {
        this.jmpl(SPARC.i7, 8, SPARC.g0);
    }

    public void setw(int value, Register dst, boolean forceRelocatable) {
        if (!forceRelocatable && SPARCMacroAssembler.isSimm13(value)) {
            this.or(SPARC.g0, value, dst);
        } else {
            this.sethi(SPARCMacroAssembler.hi22(value), dst);
            this.or(dst, SPARCMacroAssembler.lo10(value), dst);
        }
    }

    public void setx(long value, Register dst, boolean forceRelocatable) {
        int lo = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        this.sethix(value, dst, forceRelocatable);
        if (SPARCMacroAssembler.lo10(lo) != 0 || forceRelocatable) {
            this.add(dst, SPARCMacroAssembler.lo10(lo), dst);
        }
    }

    public void sethix(long value, Register dst, boolean forceRelocatable) {
        int hi = (int)(value >> 32);
        int lo = (int)(value & 0xFFFFFFFFFFFFFFFFL);
        int startPc = this.position();
        if (hi == 0 && lo >= 0) {
            this.sethi(SPARCMacroAssembler.hi22(lo), dst);
        } else if (hi == -1) {
            this.sethi(SPARCMacroAssembler.hi22(~lo), dst);
            this.xor(dst, ~SPARCMacroAssembler.lo10(-1), dst);
        } else {
            this.sethi(SPARCMacroAssembler.hi22(hi), dst);
            if ((hi & 0x3FF) != 0) {
                this.or(dst, hi & 0x3FF, dst);
            }
            if ((lo & 0xFFFFFC00) != 0) {
                int shiftcnt2;
                int shiftcnt;
                if ((lo >> 20 & 0xFFF) != 0) {
                    this.sllx(dst, 12, dst);
                    this.or(dst, lo >> 20 & 0xFFF, dst);
                    shiftcnt = 0;
                } else {
                    shiftcnt = 12;
                }
                if ((lo >> 10 & 0x3FF) != 0) {
                    this.sllx(dst, shiftcnt + 10, dst);
                    this.or(dst, lo >> 10 & 0x3FF, dst);
                    shiftcnt2 = 0;
                } else {
                    shiftcnt2 = 10;
                }
                this.sllx(dst, shiftcnt2 + 10, dst);
            } else {
                this.sllx(dst, 32, dst);
            }
        }
        if (forceRelocatable) {
            while (this.position() < startPc + 28) {
                this.nop();
            }
        }
    }

    public void signx(Register rs, Register rd) {
        this.sra(rs, SPARC.g0, rd);
    }

    public void signx(Register rd) {
        this.sra(rd, SPARC.g0, rd);
    }

    public boolean isImmediateConstantLoad() {
        return this.immediateConstantLoad;
    }

    public ScratchRegister getScratchRegister() {
        return this.scratchRegister[this.nextFreeScratchRegister++];
    }

    public void compareBranch(Register rs1, Register rs2, SPARCAssembler.ConditionFlag cond, SPARCAssembler.CC ccRegister, Label label, SPARCAssembler.BranchPredict predict, Runnable delaySlotInstruction) {
        assert (SPARCMacroAssembler.isCPURegister(rs1, rs2));
        assert (ccRegister == SPARCAssembler.CC.Icc || ccRegister == SPARCAssembler.CC.Xcc);
        if (this.hasFeature(SPARC.CPUFeature.CBCOND)) {
            if (delaySlotInstruction != null) {
                delaySlotInstruction.run();
            }
            CBCOND.emit(this, cond, ccRegister == SPARCAssembler.CC.Xcc, rs1, rs2, label);
        } else {
            if (cond == SPARCAssembler.ConditionFlag.Equal && rs1.equals((Object)SPARC.g0)) {
                BPR.emit(this, SPARCAssembler.RCondition.Rc_z, SPARCAssembler.Annul.NOT_ANNUL, predict, rs1, label);
            } else {
                this.cmp(rs1, rs2);
                BPCC.emit(this, ccRegister, cond, SPARCAssembler.Annul.NOT_ANNUL, predict, label);
            }
            if (delaySlotInstruction != null) {
                int positionBefore = this.position();
                delaySlotInstruction.run();
                int positionAfter = this.position();
                assert (positionBefore - positionAfter > 4) : "Emitted more than one instruction into delay slot";
            } else {
                this.nop();
            }
        }
    }

    public void compareBranch(Register rs1, int simm, SPARCAssembler.ConditionFlag cond, SPARCAssembler.CC ccRegister, Label label, SPARCAssembler.BranchPredict predict, Runnable delaySlotInstruction) {
        assert (SPARCMacroAssembler.isCPURegister(rs1));
        assert (ccRegister == SPARCAssembler.CC.Icc || ccRegister == SPARCAssembler.CC.Xcc);
        if (this.hasFeature(SPARC.CPUFeature.CBCOND)) {
            if (delaySlotInstruction != null) {
                delaySlotInstruction.run();
            }
            CBCOND.emit(this, cond, ccRegister == SPARCAssembler.CC.Xcc, rs1, simm, label);
        } else {
            if (cond == SPARCAssembler.ConditionFlag.Equal && simm == 0) {
                BPR.emit(this, SPARCAssembler.RCondition.Rc_z, SPARCAssembler.Annul.NOT_ANNUL, SPARCAssembler.BranchPredict.PREDICT_NOT_TAKEN, rs1, label);
            } else {
                this.cmp(rs1, simm);
                BPCC.emit(this, ccRegister, cond, SPARCAssembler.Annul.NOT_ANNUL, predict, label);
            }
            if (delaySlotInstruction != null) {
                int positionBefore = this.position();
                delaySlotInstruction.run();
                int positionAfter = this.position();
                assert (positionBefore - positionAfter > 4) : "Emitted more than one instruction into delay slot";
            } else {
                this.nop();
            }
        }
    }

    public class ScratchRegister
    implements AutoCloseable {
        private final Register register;

        public ScratchRegister(Register register) {
            this.register = register;
        }

        public Register getRegister() {
            return this.register;
        }

        @Override
        public void close() {
            assert (SPARCMacroAssembler.this.nextFreeScratchRegister > 0) : "Close called too often";
            SPARCMacroAssembler.this.nextFreeScratchRegister--;
        }
    }
}

