/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.sparc;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.sparc.SPARC;
import org.graalvm.compiler.asm.AbstractAddress;

public class SPARCAddress
extends AbstractAddress {
    private final Register base;
    private final Register index;
    private final int displacement;

    public SPARCAddress(Register base, int displacement) {
        this.base = base;
        this.index = Register.None;
        this.displacement = displacement;
    }

    public SPARCAddress(Register base, Register index) {
        this.base = base;
        this.index = index;
        this.displacement = 0;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        String sep = "";
        if (!this.getBase().equals((Object)Register.None)) {
            s.append(this.getBase());
            sep = " + ";
        }
        if (!this.getIndex().equals((Object)Register.None)) {
            s.append(sep).append(this.getIndex());
            sep = " + ";
        } else if (this.getDisplacement() < 0) {
            s.append(" - ").append(-this.getDisplacement());
        } else if (this.getDisplacement() > 0) {
            s.append(sep).append(this.getDisplacement());
        }
        s.append("]");
        return s.toString();
    }

    public Register getBase() {
        return this.base;
    }

    public Register getIndex() {
        return this.index;
    }

    public boolean hasIndex() {
        return !this.getIndex().equals((Object)Register.None);
    }

    public int getDisplacement() {
        if (this.hasIndex()) {
            throw new InternalError("address has index register");
        }
        if (this.getBase().equals((Object)SPARC.sp) || this.getBase().equals((Object)SPARC.fp)) {
            return this.displacement + 2047;
        }
        return this.displacement;
    }
}

