/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.PlatformKind;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.GraalError;

public abstract class AMD64BaseAssembler
extends Assembler {
    private final SIMDEncoder simdEncoder = this.supports(AMD64.CPUFeature.AVX) ? new VEXEncoderImpl() : new SSEEncoderImpl();
    private static final int MinEncodingNeedsRex = 8;
    public static final int DEFAULT_DISP8_SCALE = 1;
    private static final int NOT_SUPPORTED_VECTOR_LENGTH = -1;

    public AMD64BaseAssembler(TargetDescription target) {
        super(target);
    }

    protected void annotatePatchingImmediate(int operandOffset, int operandSize) {
        if (this.codePatchingAnnotationConsumer != null) {
            int pos = this.position();
            this.codePatchingAnnotationConsumer.accept(new OperandDataAnnotation(pos, pos + operandOffset, operandSize, pos + operandOffset + operandSize));
        }
    }

    public final boolean supports(AMD64.CPUFeature feature) {
        return ((AMD64)this.target.arch).getFeatures().contains(feature);
    }

    protected static boolean inRC(Register.RegisterCategory rc, Register r) {
        return r.getRegisterCategory().equals((Object)rc);
    }

    protected static int encode(Register r) {
        assert (r.encoding >= 0 && (!AMD64BaseAssembler.inRC(AMD64.XMM, r) ? r.encoding < 16 : r.encoding < 32)) : "encoding out of range: " + r.encoding;
        return r.encoding & 7;
    }

    protected final void rexw() {
        this.emitByte(72);
    }

    private static boolean isInvalidEncoding(Register reg) {
        return Register.None.equals((Object)reg) || AMD64.rip.equals((Object)reg);
    }

    protected final void prefix(Register reg) {
        this.prefix(reg, false);
    }

    protected final void prefix(Register reg, boolean byteinst) {
        assert (!AMD64BaseAssembler.isInvalidEncoding(reg));
        int regEnc = reg.encoding;
        if (regEnc >= 8) {
            this.emitByte(65);
        } else if (byteinst && regEnc >= 4) {
            this.emitByte(64);
        }
    }

    protected final void prefixq(Register reg) {
        assert (!AMD64BaseAssembler.isInvalidEncoding(reg));
        if (reg.encoding < 8) {
            this.emitByte(72);
        } else {
            this.emitByte(73);
        }
    }

    protected final void prefix(Register dst, Register src) {
        this.prefix(dst, false, src, false);
    }

    protected final void prefix(Register dst, boolean dstIsByte, Register src, boolean srcIsByte) {
        assert (!AMD64BaseAssembler.isInvalidEncoding(dst) && !AMD64BaseAssembler.isInvalidEncoding(src));
        int dstEnc = dst.encoding;
        int srcEnc = src.encoding;
        if (dstEnc < 8) {
            if (srcEnc >= 8) {
                this.emitByte(65);
            } else if (srcIsByte && srcEnc >= 4 || dstIsByte && dstEnc >= 4) {
                this.emitByte(64);
            }
        } else if (srcEnc < 8) {
            this.emitByte(68);
        } else {
            this.emitByte(69);
        }
    }

    protected final void prefixq(Register reg, Register rm) {
        assert (!AMD64BaseAssembler.isInvalidEncoding(reg) && !AMD64BaseAssembler.isInvalidEncoding(rm));
        int regEnc = reg.encoding;
        int rmEnc = rm.encoding;
        if (regEnc < 8) {
            if (rmEnc < 8) {
                this.emitByte(72);
            } else {
                this.emitByte(73);
            }
        } else if (rmEnc < 8) {
            this.emitByte(76);
        } else {
            this.emitByte(77);
        }
    }

    protected static boolean needsRex(Register reg) {
        return reg.encoding >= 8;
    }

    protected static boolean needsRex(Register src, boolean srcIsByte) {
        return srcIsByte ? src.encoding >= 4 : AMD64BaseAssembler.needsRex(src);
    }

    protected final void prefix(AMD64Address adr) {
        if (AMD64BaseAssembler.needsRex(adr.getBase())) {
            if (AMD64BaseAssembler.needsRex(adr.getIndex())) {
                this.emitByte(67);
            } else {
                this.emitByte(65);
            }
        } else if (AMD64BaseAssembler.needsRex(adr.getIndex())) {
            this.emitByte(66);
        }
    }

    protected final void prefixq(AMD64Address adr) {
        if (AMD64BaseAssembler.needsRex(adr.getBase())) {
            if (AMD64BaseAssembler.needsRex(adr.getIndex())) {
                this.emitByte(75);
            } else {
                this.emitByte(73);
            }
        } else if (AMD64BaseAssembler.needsRex(adr.getIndex())) {
            this.emitByte(74);
        } else {
            this.emitByte(72);
        }
    }

    protected void prefixb(AMD64Address adr, Register reg) {
        this.prefix(adr, reg, true);
    }

    protected void prefix(AMD64Address adr, Register reg) {
        this.prefix(adr, reg, false);
    }

    protected void prefix(AMD64Address adr, Register reg, boolean byteinst) {
        assert (!AMD64BaseAssembler.isInvalidEncoding(reg));
        if (reg.encoding < 8) {
            if (AMD64BaseAssembler.needsRex(adr.getBase())) {
                if (AMD64BaseAssembler.needsRex(adr.getIndex())) {
                    this.emitByte(67);
                } else {
                    this.emitByte(65);
                }
            } else if (AMD64BaseAssembler.needsRex(adr.getIndex())) {
                this.emitByte(66);
            } else if (byteinst && reg.encoding >= 4) {
                this.emitByte(64);
            }
        } else if (AMD64BaseAssembler.needsRex(adr.getBase())) {
            if (AMD64BaseAssembler.needsRex(adr.getIndex())) {
                this.emitByte(71);
            } else {
                this.emitByte(69);
            }
        } else if (AMD64BaseAssembler.needsRex(adr.getIndex())) {
            this.emitByte(70);
        } else {
            this.emitByte(68);
        }
    }

    protected void prefixq(AMD64Address adr, Register src) {
        assert (!AMD64BaseAssembler.isInvalidEncoding(src));
        if (src.encoding < 8) {
            if (AMD64BaseAssembler.needsRex(adr.getBase())) {
                if (AMD64BaseAssembler.needsRex(adr.getIndex())) {
                    this.emitByte(75);
                } else {
                    this.emitByte(73);
                }
            } else if (AMD64BaseAssembler.needsRex(adr.getIndex())) {
                this.emitByte(74);
            } else {
                this.emitByte(72);
            }
        } else if (AMD64BaseAssembler.needsRex(adr.getBase())) {
            if (AMD64BaseAssembler.needsRex(adr.getIndex())) {
                this.emitByte(79);
            } else {
                this.emitByte(77);
            }
        } else if (AMD64BaseAssembler.needsRex(adr.getIndex())) {
            this.emitByte(78);
        } else {
            this.emitByte(76);
        }
    }

    protected static int getRXB(Register reg, Register rm) {
        assert (!AMD64BaseAssembler.isInvalidEncoding(rm) && !AMD64BaseAssembler.isInvalidEncoding(reg));
        int rxb = (reg == null ? 0 : reg.encoding & 8) >> 1;
        return rxb |= (rm == null ? 0 : rm.encoding & 8) >> 3;
    }

    protected static int getRXB(Register reg, AMD64Address rm) {
        assert (!AMD64BaseAssembler.isInvalidEncoding(reg));
        int rxb = (reg == null ? 0 : reg.encoding & 8) >> 1;
        if (!AMD64BaseAssembler.isInvalidEncoding(rm.getIndex())) {
            rxb |= (rm.getIndex().encoding & 8) >> 2;
        }
        if (!AMD64BaseAssembler.isInvalidEncoding(rm.getBase())) {
            rxb |= (rm.getBase().encoding & 8) >> 3;
        }
        return rxb;
    }

    protected final void emitModRM(int reg, Register rm) {
        assert ((reg & 7) == reg);
        assert (!AMD64BaseAssembler.isInvalidEncoding(rm));
        this.emitByte(0xC0 | reg << 3 | rm.encoding & 7);
    }

    protected final void emitModRM(Register reg, Register rm) {
        assert (!AMD64BaseAssembler.isInvalidEncoding(reg));
        this.emitModRM(reg.encoding & 7, rm);
    }

    protected final void emitOperandHelper(Register reg, AMD64Address addr, boolean force4Byte, int additionalInstructionSize) {
        assert (!AMD64BaseAssembler.isInvalidEncoding(reg));
        this.emitOperandHelper(AMD64BaseAssembler.encode(reg), addr, force4Byte, additionalInstructionSize, 1);
    }

    protected final void emitOperandHelper(int reg, AMD64Address addr, int additionalInstructionSize) {
        this.emitOperandHelper(reg, addr, false, additionalInstructionSize, 1);
    }

    protected final void emitOperandHelper(Register reg, AMD64Address addr, int additionalInstructionSize) {
        assert (!AMD64BaseAssembler.isInvalidEncoding(reg));
        this.emitOperandHelper(AMD64BaseAssembler.encode(reg), addr, false, additionalInstructionSize, 1);
    }

    protected final void emitOperandHelper(Register reg, AMD64Address addr, int additionalInstructionSize, int evexDisp8Scale) {
        assert (!AMD64BaseAssembler.isInvalidEncoding(reg));
        this.emitOperandHelper(AMD64BaseAssembler.encode(reg), addr, false, additionalInstructionSize, evexDisp8Scale);
    }

    private void emitOperandHelper(int reg, AMD64Address addr, boolean force4Byte, int additionalInstructionSize, int evexDisp8Scale) {
        assert ((reg & 7) == reg);
        int regenc = reg << 3;
        Register base = addr.getBase();
        Register index = addr.getIndex();
        AMD64Address.Scale scale = addr.getScale();
        int disp = addr.getDisplacement();
        Object dispAnnotation = addr.getDisplacementAnnotation();
        if (base.equals((Object)AMD64.rip)) {
            assert (index.equals((Object)Register.None)) : "cannot use RIP relative addressing with index register";
            this.emitByte(5 | regenc);
            if (this.codePatchingAnnotationConsumer != null && addr.instructionStartPosition >= 0) {
                this.codePatchingAnnotationConsumer.accept(new OperandDataAnnotation(addr.instructionStartPosition, this.position(), 4, this.position() + 4 + additionalInstructionSize));
            }
            this.emitDisplacementInt(disp, dispAnnotation);
        } else if (base.isValid()) {
            int baseenc;
            boolean overriddenForce4Byte = force4Byte || dispAnnotation != null;
            int n = baseenc = base.isValid() ? AMD64BaseAssembler.encode(base) : 0;
            if (index.isValid()) {
                int indexenc = AMD64BaseAssembler.encode(index) << 3;
                if (dispAnnotation == null && disp == 0 && !base.equals((Object)AMD64.rbp) && !base.equals((Object)AMD64.r13)) {
                    assert (!index.equals((Object)AMD64.rsp)) : "illegal addressing mode";
                    this.emitByte(4 | regenc);
                    this.emitByte(scale.log2 << 6 | indexenc | baseenc);
                } else {
                    if (evexDisp8Scale > 1 && !overriddenForce4Byte) {
                        if (disp % evexDisp8Scale == 0) {
                            int newDisp = disp / evexDisp8Scale;
                            if (NumUtil.isByte(newDisp)) {
                                disp = newDisp;
                                assert (NumUtil.isByte(disp) && !overriddenForce4Byte);
                            }
                        } else {
                            overriddenForce4Byte = true;
                        }
                    }
                    if (NumUtil.isByte(disp) && !overriddenForce4Byte) {
                        assert (!index.equals((Object)AMD64.rsp)) : "illegal addressing mode";
                        this.emitByte(0x44 | regenc);
                        this.emitByte(scale.log2 << 6 | indexenc | baseenc);
                        assert (dispAnnotation == null);
                        this.emitByte(disp & 0xFF);
                    } else {
                        assert (!index.equals((Object)AMD64.rsp)) : "illegal addressing mode";
                        this.emitByte(0x84 | regenc);
                        this.emitByte(scale.log2 << 6 | indexenc | baseenc);
                        this.emitDisplacementInt(disp, dispAnnotation);
                    }
                }
            } else if (base.equals((Object)AMD64.rsp) || base.equals((Object)AMD64.r12)) {
                if (dispAnnotation == null && disp == 0) {
                    this.emitByte(4 | regenc);
                    this.emitByte(36);
                } else {
                    if (evexDisp8Scale > 1 && !overriddenForce4Byte) {
                        if (disp % evexDisp8Scale == 0) {
                            int newDisp = disp / evexDisp8Scale;
                            if (NumUtil.isByte(newDisp)) {
                                disp = newDisp;
                                assert (NumUtil.isByte(disp) && !overriddenForce4Byte);
                            }
                        } else {
                            overriddenForce4Byte = true;
                        }
                    }
                    if (NumUtil.isByte(disp) && !overriddenForce4Byte) {
                        this.emitByte(0x44 | regenc);
                        this.emitByte(36);
                        assert (dispAnnotation == null);
                        this.emitByte(disp & 0xFF);
                    } else {
                        this.emitByte(0x84 | regenc);
                        this.emitByte(36);
                        this.emitDisplacementInt(disp, dispAnnotation);
                    }
                }
            } else {
                assert (!base.equals((Object)AMD64.rsp) && !base.equals((Object)AMD64.r12)) : "illegal addressing mode";
                if (dispAnnotation == null && disp == 0 && !base.equals((Object)AMD64.rbp) && !base.equals((Object)AMD64.r13)) {
                    this.emitByte(0 | regenc | baseenc);
                } else {
                    if (evexDisp8Scale > 1 && !overriddenForce4Byte) {
                        if (disp % evexDisp8Scale == 0) {
                            int newDisp = disp / evexDisp8Scale;
                            if (NumUtil.isByte(newDisp)) {
                                disp = newDisp;
                                assert (NumUtil.isByte(disp) && !overriddenForce4Byte);
                            }
                        } else {
                            overriddenForce4Byte = true;
                        }
                    }
                    if (NumUtil.isByte(disp) && !overriddenForce4Byte) {
                        this.emitByte(0x40 | regenc | baseenc);
                        assert (dispAnnotation == null);
                        this.emitByte(disp & 0xFF);
                    } else {
                        this.emitByte(0x80 | regenc | baseenc);
                        this.emitDisplacementInt(disp, dispAnnotation);
                    }
                }
            }
        } else if (index.isValid()) {
            int indexenc = AMD64BaseAssembler.encode(index) << 3;
            assert (!index.equals((Object)AMD64.rsp)) : "illegal addressing mode";
            this.emitByte(4 | regenc);
            this.emitByte(scale.log2 << 6 | indexenc | 5);
            this.emitDisplacementInt(disp, dispAnnotation);
        } else {
            this.emitByte(4 | regenc);
            this.emitByte(37);
            this.emitDisplacementInt(disp, dispAnnotation);
        }
    }

    private void emitDisplacementInt(int disp, Object dispAnnotation) {
        if (dispAnnotation != null && this.codePatchingAnnotationConsumer != null) {
            this.codePatchingAnnotationConsumer.accept(new AddressDisplacementAnnotation(this.position(), dispAnnotation));
        }
        this.emitInt(disp);
    }

    protected final void simdPrefix(Register xreg, Register nds, AMD64Address adr, OperandSize size, int overriddenSizePrefix, int opcodeEscapePrefix, boolean isRexW) {
        this.simdEncoder.simdPrefix(xreg, nds, adr, overriddenSizePrefix != 0 ? overriddenSizePrefix : size.sizePrefix, opcodeEscapePrefix, isRexW);
    }

    protected final void simdPrefix(Register xreg, Register nds, AMD64Address adr, OperandSize size, int opcodeEscapePrefix, boolean isRexW) {
        this.simdEncoder.simdPrefix(xreg, nds, adr, size.sizePrefix, opcodeEscapePrefix, isRexW);
    }

    protected final void simdPrefix(Register dst, Register nds, Register src, OperandSize size, int overriddenSizePrefix, int opcodeEscapePrefix, boolean isRexW) {
        this.simdEncoder.simdPrefix(dst, nds, src, overriddenSizePrefix != 0 ? overriddenSizePrefix : size.sizePrefix, opcodeEscapePrefix, isRexW);
    }

    protected final void simdPrefix(Register dst, Register nds, Register src, OperandSize size, int opcodeEscapePrefix, boolean isRexW) {
        this.simdEncoder.simdPrefix(dst, nds, src, size.sizePrefix, opcodeEscapePrefix, isRexW);
    }

    protected final void emitVEX(int l, int pp, int mmmmm, int w, int rxb, int vvvv, boolean checkAVX) {
        assert (!checkAVX || ((AMD64)this.target.arch).getFeatures().contains(AMD64.CPUFeature.AVX)) : "emitting VEX prefix on a CPU without AVX support";
        assert (l == 0 || l == 1) : "invalid value for VEX.L";
        assert (pp == 0 || pp == 1 || pp == 2 || pp == 3) : "invalid value for VEX.pp";
        assert (mmmmm == 1 || mmmmm == 2 || mmmmm == 3) : "invalid value for VEX.m-mmmm";
        assert (w == 0 || w == 1) : "invalid value for VEX.W";
        assert ((rxb & 7) == rxb) : "invalid value for VEX.RXB";
        assert ((vvvv & 0xF) == vvvv) : "invalid value for VEX.vvvv";
        int rxb1s = rxb ^ 7;
        int vvvv1s = vvvv ^ 0xF;
        if ((rxb & 3) == 0 && w == 0 && mmmmm == 1) {
            int byte2 = 0;
            byte2 |= (rxb1s & 4) << 5;
            byte2 |= vvvv1s << 3;
            byte2 |= l << 2;
            this.emitByte(197);
            this.emitByte(byte2 |= pp);
        } else {
            int byte2 = 0;
            byte2 = (rxb1s & 7) << 5;
            byte2 |= mmmmm;
            int byte3 = 0;
            byte3 |= w << 7;
            byte3 |= vvvv1s << 3;
            byte3 |= l << 2;
            this.emitByte(196);
            this.emitByte(byte2);
            this.emitByte(byte3 |= pp);
        }
    }

    public static int getLFlag(AVXKind.AVXSize size) {
        switch (size) {
            case XMM: {
                return 0;
            }
            case YMM: {
                return 1;
            }
            case ZMM: {
                return 2;
            }
        }
        return 0;
    }

    public static boolean isAVX512Register(Register reg) {
        return reg != null && reg.isValid() && AMD64.XMM.equals((Object)reg.getRegisterCategory()) && reg.encoding > 15;
    }

    public final boolean vexPrefix(Register dst, Register nds, Register src, AVXKind.AVXSize size, int pp, int mmmmm, int w, int wEvex, boolean checkAVX) {
        if (AMD64BaseAssembler.isAVX512Register(dst) || AMD64BaseAssembler.isAVX512Register(nds) || AMD64BaseAssembler.isAVX512Register(src) || size == AVXKind.AVXSize.ZMM) {
            this.evexPrefix(dst, Register.None, nds, src, size, pp, mmmmm, wEvex, 0, 0);
            return true;
        }
        this.emitVEX(AMD64BaseAssembler.getLFlag(size), pp, mmmmm, w, AMD64BaseAssembler.getRXB(dst, src), nds.isValid() ? nds.encoding() : 0, checkAVX);
        return false;
    }

    public final boolean vexPrefix(Register dst, Register nds, AMD64Address src, AVXKind.AVXSize size, int pp, int mmmmm, int w, int wEvex, boolean checkAVX) {
        if (AMD64BaseAssembler.isAVX512Register(dst) || AMD64BaseAssembler.isAVX512Register(nds) || size == AVXKind.AVXSize.ZMM) {
            this.evexPrefix(dst, Register.None, nds, src, size, pp, mmmmm, wEvex, 0, 0);
            return true;
        }
        this.emitVEX(AMD64BaseAssembler.getLFlag(size), pp, mmmmm, w, AMD64BaseAssembler.getRXB(dst, src), nds.isValid() ? nds.encoding() : 0, checkAVX);
        return false;
    }

    private void emitEVEX(int l, int pp, int mm, int w, int rxb, int reg, int vvvvv, int z, int b, int aaa) {
        assert (((AMD64)this.target.arch).getFeatures().contains(AMD64.CPUFeature.AVX512F)) : "emitting EVEX prefix on a CPU without AVX512 support";
        assert (l == 0 || l == 1 || l == 2) : "invalid value for EVEX.L'L";
        assert (pp == 0 || pp == 1 || pp == 2 || pp == 3) : "invalid value for EVEX.pp";
        assert (mm == 1 || mm == 2 || mm == 3) : "invalid value for EVEX.mm";
        assert (w == 0 || w == 1) : "invalid value for EVEX.W";
        assert ((rxb & 7) == rxb) : "invalid value for EVEX.RXB";
        assert ((reg & 0x1F) == reg) : "invalid value for EVEX.R'";
        assert ((vvvvv & 0x1F) == vvvvv) : "invalid value for EVEX.V'vvvv";
        assert (z == 0 || z == 1) : "invalid value for EVEX.z";
        assert (b == 0 || b == 1) : "invalid value for EVEX.b";
        assert ((aaa & 7) == aaa) : "invalid value for EVEX.aaa";
        this.emitByte(98);
        int p1 = 0;
        p1 |= ((rxb ^ 7) & 7) << 5;
        p1 |= reg < 16 ? 16 : 0;
        this.emitByte(p1 |= mm);
        int p2 = 0;
        p2 |= w << 7;
        p2 |= ((vvvvv ^ 0xF) & 0xF) << 3;
        p2 |= 4;
        this.emitByte(p2 |= pp);
        int p3 = 0;
        p3 |= z << 7;
        p3 |= l << 5;
        p3 |= b << 4;
        p3 |= vvvvv < 16 ? 8 : 0;
        this.emitByte(p3 |= aaa);
    }

    private static int getRXBForEVEX(Register reg, Register rm) {
        int rxb = (reg == null ? 0 : reg.encoding & 8) >> 1;
        return rxb |= (rm == null ? 0 : rm.encoding & 0x18) >> 3;
    }

    protected final void evexPrefix(Register dst, Register mask, Register nds, Register src, AVXKind.AVXSize size, int pp, int mm, int w, int z, int b) {
        assert (!mask.isValid() || AMD64BaseAssembler.inRC(AMD64.MASK, mask));
        this.emitEVEX(AMD64BaseAssembler.getLFlag(size), pp, mm, w, AMD64BaseAssembler.getRXBForEVEX(dst, src), dst.encoding, nds.isValid() ? nds.encoding() : 0, z, b, mask.isValid() ? mask.encoding : 0);
    }

    protected final void evexPrefix(Register dst, Register mask, Register nds, AMD64Address src, AVXKind.AVXSize size, int pp, int mm, int w, int z, int b) {
        assert (!mask.isValid() || AMD64BaseAssembler.inRC(AMD64.MASK, mask));
        this.emitEVEX(AMD64BaseAssembler.getLFlag(size), pp, mm, w, AMD64BaseAssembler.getRXB(dst, src), dst.encoding, nds.isValid() ? nds.encoding() : 0, z, b, mask.isValid() ? mask.encoding : 0);
    }

    public static final class EVEXComparisonPredicate {
        public static final int EQ = 0;
        public static final int LT = 1;
        public static final int LE = 2;
        public static final int FALSE = 3;
        public static final int NEQ = 4;
        public static final int NLT = 5;
        public static final int NLE = 6;
        public static final int TRUE = 7;
    }

    protected static enum EVEXTuple {
        INVALID(-1, -1, -1),
        FV_NO_BROADCAST_32BIT(16, 32, 64),
        FV_BROADCAST_32BIT(4, 4, 4),
        FV_NO_BROADCAST_64BIT(16, 32, 64),
        FV_BROADCAST_64BIT(8, 8, 8),
        HV_NO_BROADCAST_32BIT(8, 16, 32),
        HV_BROADCAST_32BIT(4, 4, 4),
        FVM(16, 32, 64),
        T1S_8BIT(1, 1, 1),
        T1S_16BIT(2, 2, 2),
        T1S_32BIT(4, 4, 4),
        T1S_64BIT(8, 8, 8),
        T1F_32BIT(4, 4, 4),
        T1F_64BIT(8, 8, 8),
        T2_32BIT(8, 8, 8),
        T2_64BIT(-1, 16, 16),
        T4_32BIT(-1, 16, 16),
        T4_64BIT(-1, -1, 32),
        T8_32BIT(-1, -1, 32),
        HVM(8, 16, 32),
        QVM(4, 8, 16),
        OVM(2, 4, 8),
        M128(16, 16, 16),
        DUP(8, 32, 64);

        private final int scalingFactorVL128;
        private final int scalingFactorVL256;
        private final int scalingFactorVL512;

        private EVEXTuple(int scalingFactorVL128, int scalingFactorVL256, int scalingFactorVL512) {
            this.scalingFactorVL128 = scalingFactorVL128;
            this.scalingFactorVL256 = scalingFactorVL256;
            this.scalingFactorVL512 = scalingFactorVL512;
        }

        private static int verifyScalingFactor(int scalingFactor) {
            if (scalingFactor == -1) {
                throw GraalError.shouldNotReachHere("Invalid scaling factor.");
            }
            return scalingFactor;
        }

        public int getDisp8ScalingFactor(AVXKind.AVXSize size) {
            switch (size) {
                case XMM: {
                    return EVEXTuple.verifyScalingFactor(this.scalingFactorVL128);
                }
                case YMM: {
                    return EVEXTuple.verifyScalingFactor(this.scalingFactorVL256);
                }
                case ZMM: {
                    return EVEXTuple.verifyScalingFactor(this.scalingFactorVL512);
                }
            }
            throw GraalError.shouldNotReachHere("Unsupported vector size.");
        }
    }

    protected static final class EVEXPrefixConfig {
        public static final int Z0 = 0;
        public static final int Z1 = 1;
        public static final int B0 = 0;
        public static final int B1 = 1;

        private EVEXPrefixConfig() {
        }
    }

    private class VEXEncoderImpl
    implements SIMDEncoder {
        private VEXEncoderImpl() {
        }

        private int sizePrefixToPP(int sizePrefix) {
            switch (sizePrefix) {
                case 102: {
                    return 1;
                }
                case 242: {
                    return 3;
                }
                case 243: {
                    return 2;
                }
            }
            return 0;
        }

        private int opcodeEscapePrefixToMMMMM(int opcodeEscapePrefix) {
            switch (opcodeEscapePrefix) {
                case 15: {
                    return 1;
                }
                case 14351: {
                    return 2;
                }
                case 14863: {
                    return 3;
                }
            }
            return 0;
        }

        @Override
        public void simdPrefix(Register reg, Register nds, AMD64Address rm, int sizePrefix, int opcodeEscapePrefix, boolean isRexW) {
            assert (reg.encoding < 16) : "encoding out of range: " + reg.encoding;
            assert (nds.encoding < 16) : "encoding out of range: " + nds.encoding;
            AMD64BaseAssembler.this.emitVEX(0, this.sizePrefixToPP(sizePrefix), this.opcodeEscapePrefixToMMMMM(opcodeEscapePrefix), isRexW ? 1 : 0, AMD64BaseAssembler.getRXB(reg, rm), nds.isValid() ? nds.encoding : 0, true);
        }

        @Override
        public void simdPrefix(Register dst, Register nds, Register src, int sizePrefix, int opcodeEscapePrefix, boolean isRexW) {
            assert (dst.encoding < 16) : "encoding out of range: " + dst.encoding;
            assert (src.encoding < 16) : "encoding out of range: " + src.encoding;
            assert (nds.encoding < 16) : "encoding out of range: " + nds.encoding;
            AMD64BaseAssembler.this.emitVEX(0, this.sizePrefixToPP(sizePrefix), this.opcodeEscapePrefixToMMMMM(opcodeEscapePrefix), isRexW ? 1 : 0, AMD64BaseAssembler.getRXB(dst, src), nds.isValid() ? nds.encoding : 0, true);
        }
    }

    public static final class VEXPrefixConfig {
        public static final int L128 = 0;
        public static final int L256 = 1;
        public static final int L512 = 2;
        public static final int LZ = 0;
        public static final int W0 = 0;
        public static final int W1 = 1;
        public static final int WIG = 0;
        public static final int P_ = 0;
        public static final int P_66 = 1;
        public static final int P_F3 = 2;
        public static final int P_F2 = 3;
        public static final int M_0F = 1;
        public static final int M_0F38 = 2;
        public static final int M_0F3A = 3;

        private VEXPrefixConfig() {
        }
    }

    private class SSEEncoderImpl
    implements SIMDEncoder {
        private SSEEncoderImpl() {
        }

        @Override
        public void simdPrefix(Register xreg, Register nds, AMD64Address adr, int sizePrefix, int opcodeEscapePrefix, boolean isRexW) {
            assert (!nds.isValid() || nds.equals((Object)xreg));
            if (sizePrefix > 0) {
                AMD64BaseAssembler.this.emitByte(sizePrefix);
            }
            if (isRexW) {
                AMD64BaseAssembler.this.prefixq(adr, xreg);
            } else {
                AMD64BaseAssembler.this.prefix(adr, xreg);
            }
            if (opcodeEscapePrefix > 255) {
                AMD64BaseAssembler.this.emitShort(opcodeEscapePrefix);
            } else if (opcodeEscapePrefix > 0) {
                AMD64BaseAssembler.this.emitByte(opcodeEscapePrefix);
            }
        }

        @Override
        public void simdPrefix(Register dst, Register nds, Register src, int sizePrefix, int opcodeEscapePrefix, boolean isRexW) {
            assert (!nds.isValid() || nds.equals((Object)dst) || nds.equals((Object)src));
            if (sizePrefix > 0) {
                AMD64BaseAssembler.this.emitByte(sizePrefix);
            }
            if (isRexW) {
                AMD64BaseAssembler.this.prefixq(dst, src);
            } else {
                AMD64BaseAssembler.this.prefix(dst, src);
            }
            if (opcodeEscapePrefix > 255) {
                AMD64BaseAssembler.this.emitShort(opcodeEscapePrefix);
            } else if (opcodeEscapePrefix > 0) {
                AMD64BaseAssembler.this.emitByte(opcodeEscapePrefix);
            }
        }
    }

    private static interface SIMDEncoder {
        public void simdPrefix(Register var1, Register var2, AMD64Address var3, int var4, int var5, boolean var6);

        public void simdPrefix(Register var1, Register var2, Register var3, int var4, int var5, boolean var6);
    }

    private static class Prefix {
        private static final int REX = 64;
        private static final int REXB = 65;
        private static final int REXX = 66;
        private static final int REXXB = 67;
        private static final int REXR = 68;
        private static final int REXRB = 69;
        private static final int REXRX = 70;
        private static final int REXRXB = 71;
        private static final int REXW = 72;
        private static final int REXWB = 73;
        private static final int REXWX = 74;
        private static final int REXWXB = 75;
        private static final int REXWR = 76;
        private static final int REXWRB = 77;
        private static final int REXWRX = 78;
        private static final int REXWRXB = 79;
        private static final int VEX2 = 197;
        private static final int VEX3 = 196;
        private static final int EVEX = 98;

        private Prefix() {
        }
    }

    public static class OperandDataAnnotation
    extends Assembler.CodeAnnotation {
        public final int instructionPosition;
        public final int operandPosition;
        public final int operandSize;
        public final int nextInstructionPosition;

        OperandDataAnnotation(int instructionPosition, int operandPosition, int operandSize, int nextInstructionPosition) {
            this.instructionPosition = instructionPosition;
            this.operandPosition = operandPosition;
            this.operandSize = operandSize;
            this.nextInstructionPosition = nextInstructionPosition;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " instruction [" + this.instructionPosition + ", " + this.nextInstructionPosition + "[ operand at " + this.operandPosition + " size " + this.operandSize;
        }
    }

    public static class AddressDisplacementAnnotation
    extends Assembler.CodeAnnotation {
        public final int operandPosition;
        public final Object annotation;

        AddressDisplacementAnnotation(int operandPosition, Object annotation) {
            this.operandPosition = operandPosition;
            this.annotation = annotation;
        }
    }

    public static enum OperandSize {
        BYTE(1, AMD64Kind.BYTE){

            @Override
            protected void emitImmediate(AMD64BaseAssembler asm, int imm) {
                assert (imm == (byte)imm);
                asm.emitByte(imm);
            }

            @Override
            protected int immediateSize() {
                return 1;
            }
        }
        ,
        WORD(2, AMD64Kind.WORD, 102){

            @Override
            protected void emitImmediate(AMD64BaseAssembler asm, int imm) {
                assert (imm == (short)imm);
                asm.emitShort(imm);
            }

            @Override
            protected int immediateSize() {
                return 2;
            }
        }
        ,
        DWORD(4, AMD64Kind.DWORD){

            @Override
            protected void emitImmediate(AMD64BaseAssembler asm, int imm) {
                asm.emitInt(imm);
            }

            @Override
            protected int immediateSize() {
                return 4;
            }
        }
        ,
        QWORD(8, AMD64Kind.QWORD){

            @Override
            protected void emitImmediate(AMD64BaseAssembler asm, int imm) {
                asm.emitInt(imm);
            }

            @Override
            protected int immediateSize() {
                return 4;
            }
        }
        ,
        SS(4, AMD64Kind.SINGLE, 243, true),
        SD(8, AMD64Kind.DOUBLE, 242, true),
        PS(16, AMD64Kind.V128_SINGLE, true),
        PD(16, AMD64Kind.V128_DOUBLE, 102, true);

        private final int sizePrefix;
        private final int bytes;
        private final boolean xmm;
        private final AMD64Kind kind;

        private OperandSize(int bytes, AMD64Kind kind) {
            this(bytes, kind, 0);
        }

        private OperandSize(int bytes, AMD64Kind kind, int sizePrefix) {
            this(bytes, kind, sizePrefix, false);
        }

        private OperandSize(int bytes, AMD64Kind kind, boolean xmm) {
            this(bytes, kind, 0, xmm);
        }

        private OperandSize(int bytes, AMD64Kind kind, int sizePrefix, boolean xmm) {
            this.sizePrefix = sizePrefix;
            this.bytes = bytes;
            this.kind = kind;
            this.xmm = xmm;
        }

        public int getSizePrefix() {
            return this.sizePrefix;
        }

        public int getBytes() {
            return this.bytes;
        }

        public boolean isXmmType() {
            return this.xmm;
        }

        public AMD64Kind getKind() {
            return this.kind;
        }

        public static OperandSize get(PlatformKind kind) {
            for (OperandSize operandSize : OperandSize.values()) {
                if (!operandSize.kind.equals((Object)kind)) continue;
                return operandSize;
            }
            throw GraalError.shouldNotReachHere("Unexpected kind: " + kind.toString());
        }

        protected void emitImmediate(AMD64BaseAssembler asm, int imm) {
            throw new UnsupportedOperationException();
        }

        protected int immediateSize() {
            throw new UnsupportedOperationException();
        }
    }
}

