/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.serviceprovider.BufferUtil;

final class Buffer {
    protected ByteBuffer data = ByteBuffer.allocate(232);

    Buffer(ByteOrder order) {
        this.data.order(order);
    }

    public int position() {
        return this.data.position();
    }

    public void setPosition(int position) {
        assert (position >= 0 && position <= this.data.limit());
        BufferUtil.asBaseBuffer(this.data).position(position);
    }

    public byte[] close(boolean trimmedCopy) {
        byte[] result = this.data.array();
        if (trimmedCopy) {
            result = Arrays.copyOf(result, this.data.position());
        }
        this.data = null;
        return result;
    }

    public byte[] copyData(int start, int end) {
        if (this.data == null) {
            return null;
        }
        return Arrays.copyOfRange(this.data.array(), start, end);
    }

    public void copyInto(byte[] dst, int off, int len) {
        System.arraycopy(this.data.array(), 0, dst, off, len);
    }

    protected void ensureSize(int length) {
        if (length >= this.data.limit()) {
            byte[] newBuf = Arrays.copyOf(this.data.array(), length * 4);
            ByteBuffer newData = ByteBuffer.wrap(newBuf);
            newData.order(this.data.order());
            BufferUtil.asBaseBuffer(newData).position(this.data.position());
            this.data = newData;
        }
    }

    public void emitBytes(byte[] arr, int off, int len) {
        this.ensureSize(this.data.position() + len);
        this.data.put(arr, off, len);
    }

    public void emitByte(int b) {
        assert (NumUtil.isUByte(b) || NumUtil.isByte(b));
        this.ensureSize(this.data.position() + 1);
        this.data.put((byte)(b & 0xFF));
    }

    public void emitShort(int b) {
        assert (NumUtil.isUShort(b) || NumUtil.isShort(b));
        this.ensureSize(this.data.position() + 2);
        this.data.putShort((short)b);
    }

    public void emitInt(int b) {
        this.ensureSize(this.data.position() + 4);
        this.data.putInt(b);
    }

    public void emitLong(long b) {
        this.ensureSize(this.data.position() + 8);
        this.data.putLong(b);
    }

    public void emitBytes(byte[] arr, int pos) {
        int len = arr.length;
        this.ensureSize(pos + len);
        System.arraycopy(arr, 0, this.data.array(), pos, len);
    }

    public void emitByte(int b, int pos) {
        assert (NumUtil.isUByte(b) || NumUtil.isByte(b));
        this.ensureSize(pos + 1);
        this.data.put(pos, (byte)(b & 0xFF));
    }

    public void emitShort(int b, int pos) {
        assert (NumUtil.isUShort(b) || NumUtil.isShort(b));
        this.ensureSize(pos + 2);
        this.data.putShort(pos, (short)b).position();
    }

    public void emitInt(int b, int pos) {
        this.ensureSize(pos + 4);
        this.data.putInt(pos, b).position();
    }

    public void emitLong(long b, int pos) {
        this.ensureSize(pos + 8);
        this.data.putLong(pos, b).position();
    }

    public int getByte(int pos) {
        byte b = this.data.get(pos);
        return b & 0xFF;
    }

    public int getShort(int pos) {
        short s = this.data.getShort(pos);
        return s & 0xFFFF;
    }

    public int getInt(int pos) {
        return this.data.getInt(pos);
    }

    public void reset() {
        BufferUtil.asBaseBuffer(this.data).clear();
    }
}

