/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.nfa.PureNFATransition;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.util.BitSets;
import java.util.Arrays;

public final class TRegexBacktrackingNFAExecutorLocals
extends TRegexExecutorLocals {
    private final int stackFrameSize;
    private final int nQuantifierCounts;
    private final int nZeroWidthQuantifiers;
    private final int stackBase;
    private final Stack stack;
    private int sp;
    private final int[] result;
    private final long[] transitionBitSet;
    private int lastResultSp = -1;
    private int lastInnerLiteralIndex;
    private int lastInitialStateIndex;

    public TRegexBacktrackingNFAExecutorLocals(Object input, int fromIndex, int index, int maxIndex, int nCaptureGroups, int nQuantifiers, int nZeroWidthQuantifiers, int maxNTransitions) {
        this(input, fromIndex, index, maxIndex, nCaptureGroups, nQuantifiers, nZeroWidthQuantifiers, new Stack(new int[TRegexBacktrackingNFAExecutorLocals.getStackFrameSize(nCaptureGroups, nQuantifiers, nZeroWidthQuantifiers) * 4]), 0, BitSets.createBitSetArray(maxNTransitions));
        this.setIndex(fromIndex);
        this.clearCaptureGroups();
    }

    private TRegexBacktrackingNFAExecutorLocals(Object input, int fromIndex, int index, int maxIndex, int nCaptureGroups, int nQuantifiers, int nZeroWidthQuantifiers, Stack stack, int stackBase, long[] transitionBitSet) {
        super(input, fromIndex, maxIndex, index);
        this.stackFrameSize = TRegexBacktrackingNFAExecutorLocals.getStackFrameSize(nCaptureGroups, nQuantifiers, nZeroWidthQuantifiers);
        this.nQuantifierCounts = nQuantifiers;
        this.nZeroWidthQuantifiers = nZeroWidthQuantifiers;
        this.stack = stack;
        this.stackBase = stackBase;
        this.sp = stackBase;
        this.result = new int[nCaptureGroups * 2];
        this.transitionBitSet = transitionBitSet;
    }

    private int[] stack() {
        return this.stack.stack;
    }

    private static int getStackFrameSize(int nCaptureGroups, int nQuantifiers, int nZeroWidthQuantifiers) {
        return 2 + nCaptureGroups * 2 + nQuantifiers + nZeroWidthQuantifiers;
    }

    public TRegexBacktrackingNFAExecutorLocals createSubNFALocals() {
        this.dupFrame();
        return this.newSubLocals();
    }

    public TRegexBacktrackingNFAExecutorLocals createSubNFALocals(PureNFATransition t) {
        this.dupFrame();
        t.getGroupBoundaries().applyExploded(this.stack(), this.sp + this.stackFrameSize + 2, this.getIndex());
        return this.newSubLocals();
    }

    private TRegexBacktrackingNFAExecutorLocals newSubLocals() {
        return new TRegexBacktrackingNFAExecutorLocals(this.getInput(), this.getFromIndex(), this.getIndex(), this.getMaxIndex(), this.result.length / 2, this.nQuantifierCounts, this.nZeroWidthQuantifiers, this.stack, this.sp + this.stackFrameSize, this.transitionBitSet);
    }

    private int offsetIP() {
        return this.sp + 1;
    }

    private int offsetCaptureGroups() {
        return this.sp + 2;
    }

    private int offsetQuantifierCounts() {
        return this.sp + 2 + this.result.length;
    }

    private int offsetZeroWidthQuantifierIndices() {
        return this.sp + 2 + this.result.length + this.nQuantifierCounts;
    }

    private int offsetQuantifierCount(Token.Quantifier q) {
        CompilerDirectives.isPartialEvaluationConstant((Object)q.getIndex());
        return this.offsetQuantifierCounts() + q.getIndex();
    }

    private int offsetZeroWidthQuantifierIndex(Token.Quantifier q) {
        CompilerDirectives.isPartialEvaluationConstant((Object)q.getZeroWidthIndex());
        return this.offsetZeroWidthQuantifierIndices() + q.getZeroWidthIndex();
    }

    public void apply(PureNFATransition t, int index) {
        t.getGroupBoundaries().applyExploded(this.stack(), this.offsetCaptureGroups(), index);
    }

    public void resetToInitialState() {
        this.clearCaptureGroups();
        this.clearQuantifierCounts();
    }

    protected void clearCaptureGroups() {
        Arrays.fill(this.stack(), this.offsetCaptureGroups(), this.offsetCaptureGroups() + this.result.length, -1);
    }

    protected void clearQuantifierCounts() {
        Arrays.fill(this.stack(), this.offsetQuantifierCounts(), this.offsetQuantifierCounts() + this.nQuantifierCounts, 0);
    }

    public void push() {
        this.sp += this.stackFrameSize;
    }

    public void dupFrame() {
        this.dupFrame(1);
    }

    public void dupFrame(int n) {
        int minSize = this.sp + this.stackFrameSize * (n + 1);
        if (this.stack().length < minSize) {
            int newLength;
            for (newLength = this.stack().length << 1; newLength < minSize; newLength <<= 1) {
            }
            Stack.access$002(this.stack, Arrays.copyOf(this.stack(), newLength));
        }
        int targetFrame = this.sp;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(this.stack(), this.sp, this.stack(), targetFrame += this.stackFrameSize, this.stackFrameSize);
        }
    }

    public void pushResult(PureNFATransition t, int index) {
        t.getGroupBoundaries().applyExploded(this.result, 0, index);
        this.pushResult();
    }

    public void pushResult() {
        this.lastResultSp = this.sp;
    }

    public void setResult() {
        System.arraycopy(this.stack(), this.offsetCaptureGroups(), this.result, 0, this.result.length);
    }

    public boolean canPopResult() {
        return this.lastResultSp == this.sp;
    }

    public int[] popResult() {
        return this.lastResultSp < 0 ? null : this.result;
    }

    public boolean canPop() {
        return this.sp > this.stackBase;
    }

    public int pop() {
        assert (this.sp > this.stackBase);
        this.sp -= this.stackFrameSize;
        this.restoreIndex();
        return this.stack()[this.offsetIP()];
    }

    public void saveIndex(int index) {
        this.stack()[this.sp] = index;
    }

    public void restoreIndex() {
        this.setIndex(this.stack()[this.sp]);
    }

    public int setPc(int pc) {
        int n = pc;
        this.stack()[this.offsetIP()] = n;
        return n;
    }

    public int getCaptureGroupBoundary(int index) {
        return this.stack()[this.offsetCaptureGroups() + index];
    }

    public int getCaptureGroupStart(int groupNumber) {
        return this.getCaptureGroupBoundary(groupNumber * 2);
    }

    public int getCaptureGroupEnd(int groupNumber) {
        return this.getCaptureGroupBoundary(groupNumber * 2 + 1);
    }

    public void overwriteCaptureGroups(int[] captureGroups) {
        assert (captureGroups.length == this.result.length);
        System.arraycopy(captureGroups, 0, this.stack(), this.offsetCaptureGroups(), captureGroups.length);
    }

    public int getQuantifierCount(Token.Quantifier q) {
        return this.stack()[this.offsetQuantifierCount(q)];
    }

    public void setQuantifierCount(Token.Quantifier q, int count) {
        this.stack()[this.offsetQuantifierCount((Token.Quantifier)q)] = count;
    }

    public void resetQuantifierCount(Token.Quantifier q) {
        this.stack()[this.offsetQuantifierCount((Token.Quantifier)q)] = 0;
    }

    public void incQuantifierCount(Token.Quantifier q) {
        int[] nArray = this.stack();
        int n = this.offsetQuantifierCount(q);
        nArray[n] = nArray[n] + 1;
    }

    public int getZeroWidthQuantifierGuardIndex(Token.Quantifier q) {
        return this.stack()[this.offsetZeroWidthQuantifierIndex(q)];
    }

    public void setZeroWidthQuantifierGuardIndex(Token.Quantifier q) {
        this.stack()[this.offsetZeroWidthQuantifierIndex((Token.Quantifier)q)] = this.getIndex();
    }

    public long[] getTransitionBitSet() {
        return this.transitionBitSet;
    }

    public int getLastInnerLiteralIndex() {
        return this.lastInnerLiteralIndex;
    }

    public void setLastInnerLiteralIndex(int i) {
        this.lastInnerLiteralIndex = i;
    }

    public int getLastInitialStateIndex() {
        return this.lastInitialStateIndex;
    }

    public void setLastInitialStateIndex(int i) {
        this.lastInitialStateIndex = i;
    }

    @CompilerDirectives.TruffleBoundary
    public void printStack(int curPc) {
        for (int i = this.sp; i >= 0; i -= this.stackFrameSize) {
            System.out.print(String.format("pc: %3d, i: %3d, cg: [", i == this.sp ? curPc : this.stack()[i + 1], this.stack()[i]));
            for (int j = i + 2; j < i + this.stackFrameSize - 1; ++j) {
                System.out.print(String.format("%2d, ", this.stack()[j]));
            }
            System.out.println(String.format("%2d ]", this.stack()[i + this.stackFrameSize - 1]));
        }
    }

    private static final class Stack {
        private int[] stack;

        Stack(int[] stack) {
            this.stack = stack;
        }

        static /* synthetic */ int[] access$002(Stack x0, int[] x1) {
            x0.stack = x1;
            return x1;
        }
    }
}

