/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.Event;
import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class TerminatedEvent
extends Event {
    TerminatedEvent(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public EventBody getBody() {
        return this.jsonData.has("body") ? new EventBody(this.jsonData.optJSONObject("body")) : null;
    }

    public TerminatedEvent setBody(EventBody body) {
        this.jsonData.putOpt("body", body != null ? body.jsonData : null);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TerminatedEvent other = (TerminatedEvent)obj;
        if (!Objects.equals(this.getEvent(), other.getEvent())) {
            return false;
        }
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + Objects.hashCode(this.getEvent());
        if (this.getBody() != null) {
            hash = 17 * hash + Objects.hashCode(this.getBody());
        }
        hash = 17 * hash + Objects.hashCode(this.getType());
        hash = 17 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static TerminatedEvent create(Integer seq) {
        JSONObject json = new JSONObject();
        json.put("event", "terminated");
        json.put("type", "event");
        json.put("seq", seq);
        return new TerminatedEvent(json);
    }

    public static class EventBody
    extends JSONBase {
        EventBody(JSONObject jsonData) {
            super(jsonData);
        }

        public Object getRestart() {
            return this.jsonData.opt("restart");
        }

        public EventBody setRestart(Object restart) {
            this.jsonData.putOpt("restart", restart);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventBody other = (EventBody)obj;
            return Objects.equals(this.getRestart(), other.getRestart());
        }

        public int hashCode() {
            int hash = 3;
            if (this.getRestart() != null) {
                hash = 17 * hash + Objects.hashCode(this.getRestart());
            }
            return hash;
        }

        public static EventBody create() {
            JSONObject json = new JSONObject();
            return new EventBody(json);
        }
    }
}

