/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.types;

import com.oracle.truffle.tools.dap.types.JSONBase;
import com.oracle.truffle.tools.dap.types.Message;
import com.oracle.truffle.tools.dap.types.Response;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.Objects;

public class ErrorResponse
extends Response {
    ErrorResponse(JSONObject jsonData) {
        super(jsonData);
    }

    @Override
    public ResponseBody getBody() {
        return new ResponseBody(this.jsonData.getJSONObject("body"));
    }

    public ErrorResponse setBody(ResponseBody body) {
        this.jsonData.put("body", body.jsonData);
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorResponse other = (ErrorResponse)obj;
        if (!Objects.equals(this.getBody(), other.getBody())) {
            return false;
        }
        if (!Objects.equals(this.getType(), other.getType())) {
            return false;
        }
        if (this.getRequestSeq() != other.getRequestSeq()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (!Objects.equals(this.getCommand(), other.getCommand())) {
            return false;
        }
        if (!Objects.equals(this.getMessage(), other.getMessage())) {
            return false;
        }
        return this.getSeq() == other.getSeq();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.getBody());
        hash = 29 * hash + Objects.hashCode(this.getType());
        hash = 29 * hash + Integer.hashCode(this.getRequestSeq());
        hash = 29 * hash + Boolean.hashCode(this.isSuccess());
        hash = 29 * hash + Objects.hashCode(this.getCommand());
        if (this.getMessage() != null) {
            hash = 29 * hash + Objects.hashCode(this.getMessage());
        }
        hash = 29 * hash + Integer.hashCode(this.getSeq());
        return hash;
    }

    public static ErrorResponse create(ResponseBody body, Integer requestSeq, Boolean success, String command, Integer seq) {
        JSONObject json = new JSONObject();
        json.put("body", body.jsonData);
        json.put("type", "response");
        json.put("request_seq", requestSeq);
        json.put("success", success);
        json.put("command", command);
        json.put("seq", seq);
        return new ErrorResponse(json);
    }

    public static class ResponseBody
    extends JSONBase {
        ResponseBody(JSONObject jsonData) {
            super(jsonData);
        }

        public Message getError() {
            return this.jsonData.has("error") ? new Message(this.jsonData.optJSONObject("error")) : null;
        }

        public ResponseBody setError(Message error) {
            this.jsonData.putOpt("error", error != null ? error.jsonData : null);
            return this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResponseBody other = (ResponseBody)obj;
            return Objects.equals(this.getError(), other.getError());
        }

        public int hashCode() {
            int hash = 7;
            if (this.getError() != null) {
                hash = 53 * hash + Objects.hashCode(this.getError());
            }
            return hash;
        }

        public static ResponseBody create() {
            JSONObject json = new JSONObject();
            return new ResponseBody(json);
        }
    }
}

