/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.dap.server;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SourceElement;
import com.oracle.truffle.api.debug.StepConfig;
import com.oracle.truffle.api.debug.SuspendAnchor;
import com.oracle.truffle.api.debug.SuspendedCallback;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.debug.SuspensionFilter;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.dap.server.Errors;
import com.oracle.truffle.tools.dap.server.ExecutionContext;
import com.oracle.truffle.tools.dap.server.StackFramesHandler;
import com.oracle.truffle.tools.dap.server.ThreadsHandler;
import com.oracle.truffle.tools.dap.server.VariablesHandler;
import com.oracle.truffle.tools.dap.types.AttachRequestArguments;
import com.oracle.truffle.tools.dap.types.BreakpointLocationsArguments;
import com.oracle.truffle.tools.dap.types.BreakpointLocationsResponse;
import com.oracle.truffle.tools.dap.types.Capabilities;
import com.oracle.truffle.tools.dap.types.ConfigurationDoneArguments;
import com.oracle.truffle.tools.dap.types.ContinueArguments;
import com.oracle.truffle.tools.dap.types.ContinueResponse;
import com.oracle.truffle.tools.dap.types.DebugProtocolClient;
import com.oracle.truffle.tools.dap.types.DebugProtocolServer;
import com.oracle.truffle.tools.dap.types.DisconnectArguments;
import com.oracle.truffle.tools.dap.types.EvaluateArguments;
import com.oracle.truffle.tools.dap.types.EvaluateResponse;
import com.oracle.truffle.tools.dap.types.ExceptionBreakpointsFilter;
import com.oracle.truffle.tools.dap.types.ExceptionInfoArguments;
import com.oracle.truffle.tools.dap.types.ExceptionInfoResponse;
import com.oracle.truffle.tools.dap.types.InitializeRequestArguments;
import com.oracle.truffle.tools.dap.types.LaunchRequestArguments;
import com.oracle.truffle.tools.dap.types.LoadedSourcesArguments;
import com.oracle.truffle.tools.dap.types.LoadedSourcesResponse;
import com.oracle.truffle.tools.dap.types.NextArguments;
import com.oracle.truffle.tools.dap.types.OutputEvent;
import com.oracle.truffle.tools.dap.types.PauseArguments;
import com.oracle.truffle.tools.dap.types.Scope;
import com.oracle.truffle.tools.dap.types.ScopesArguments;
import com.oracle.truffle.tools.dap.types.ScopesResponse;
import com.oracle.truffle.tools.dap.types.SetBreakpointsArguments;
import com.oracle.truffle.tools.dap.types.SetBreakpointsResponse;
import com.oracle.truffle.tools.dap.types.SetExceptionBreakpointsArguments;
import com.oracle.truffle.tools.dap.types.SetFunctionBreakpointsArguments;
import com.oracle.truffle.tools.dap.types.SetFunctionBreakpointsResponse;
import com.oracle.truffle.tools.dap.types.SetVariableArguments;
import com.oracle.truffle.tools.dap.types.SetVariableResponse;
import com.oracle.truffle.tools.dap.types.SourceArguments;
import com.oracle.truffle.tools.dap.types.SourceResponse;
import com.oracle.truffle.tools.dap.types.StackFrame;
import com.oracle.truffle.tools.dap.types.StackTraceArguments;
import com.oracle.truffle.tools.dap.types.StackTraceResponse;
import com.oracle.truffle.tools.dap.types.StepInArguments;
import com.oracle.truffle.tools.dap.types.StepOutArguments;
import com.oracle.truffle.tools.dap.types.ThreadsResponse;
import com.oracle.truffle.tools.dap.types.Variable;
import com.oracle.truffle.tools.dap.types.VariablesArguments;
import com.oracle.truffle.tools.dap.types.VariablesResponse;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public final class DebugProtocolServerImpl
extends DebugProtocolServer {
    private static final StepConfig STEP_CONFIG = StepConfig.newBuilder().suspendAnchors(SourceElement.ROOT, new SuspendAnchor[]{SuspendAnchor.AFTER}).build();
    private final ExecutionContext context;
    private volatile DebugProtocolClient client;
    private volatile ExecutorService clientConnectionExecutor;
    private volatile DebuggerSession debuggerSession;

    private DebugProtocolServerImpl(final ExecutionContext context, boolean debugBreak, boolean waitAttached, final boolean inspectInitialization) {
        this.context = context;
        if (debugBreak) {
            this.startDebuggerSession();
            context.initSession(this.debuggerSession);
            this.debuggerSession.suspendNextExecution();
        }
        if (debugBreak || waitAttached) {
            final AtomicReference<EventBinding> execEnter = new AtomicReference<EventBinding>();
            final AtomicBoolean disposeBinding = new AtomicBoolean(false);
            execEnter.set(context.getEnv().getInstrumenter().attachContextsListener(new ContextsListener(){

                public void onContextCreated(TruffleContext ctx) {
                }

                public void onLanguageContextCreated(TruffleContext ctx, LanguageInfo language) {
                    if (inspectInitialization) {
                        this.waitForRunPermission();
                    }
                }

                public void onLanguageContextInitialized(TruffleContext ctx, LanguageInfo language) {
                    if (!inspectInitialization) {
                        this.waitForRunPermission();
                    }
                }

                public void onLanguageContextFinalized(TruffleContext ctx, LanguageInfo language) {
                }

                public void onLanguageContextDisposed(TruffleContext ctx, LanguageInfo language) {
                }

                public void onContextClosed(TruffleContext ctx) {
                }

                @CompilerDirectives.TruffleBoundary
                private void waitForRunPermission() {
                    try {
                        context.waitForRunPermission();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    EventBinding binding = execEnter.getAndSet(null);
                    if (binding != null) {
                        binding.dispose();
                    } else {
                        disposeBinding.set(true);
                    }
                }
            }, true));
            if (disposeBinding.get()) {
                ((EventBinding)execEnter.get()).dispose();
            }
        }
    }

    public static DebugProtocolServerImpl create(ExecutionContext context, boolean debugBreak, boolean waitAttached, boolean inspectInitialization) {
        return new DebugProtocolServerImpl(context, debugBreak, waitAttached, inspectInitialization);
    }

    @Override
    public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
        this.context.setLinesStartAt1(args.getLinesStartAt1());
        this.context.setColumnsStartAt1(args.getColumnsStartAt1());
        ExceptionBreakpointsFilter[] exceptionBreakpointFilters = new ExceptionBreakpointsFilter[]{ExceptionBreakpointsFilter.create("all", "All Exceptions"), ExceptionBreakpointsFilter.create("uncaught", "Uncaught Exceptions")};
        CompletableFuture<Capabilities> future = CompletableFuture.completedFuture(Capabilities.create().setExceptionBreakpointFilters(Arrays.asList(exceptionBreakpointFilters)).setSupportsConfigurationDoneRequest(true).setSupportsFunctionBreakpoints(true).setSupportsConditionalBreakpoints(true).setSupportsHitConditionalBreakpoints(true).setSupportsSetVariable(true).setSupportsExceptionInfoRequest(true).setSupportsLoadedSourcesRequest(true).setSupportsLogPoints(true).setSupportsBreakpointLocationsRequest(true));
        future.thenRunAsync(() -> this.client.initialized());
        return future;
    }

    @Override
    public CompletableFuture<Void> configurationDone(ConfigurationDoneArguments args) {
        return CompletableFuture.runAsync(() -> this.context.doRunIfWaitingForDebugger());
    }

    @Override
    public CompletableFuture<Void> launch(LaunchRequestArguments args) {
        return CompletableFuture.runAsync(() -> {
            JSONObject info = (JSONObject)args.get("graalVMLaunchInfo");
            if (info != null) {
                StringBuilder sb = new StringBuilder(info.getString("exec"));
                JSONArray argsInfo = info.getJSONArray("args");
                for (int i = 0; i < argsInfo.length(); ++i) {
                    sb.append(' ').append(argsInfo.getString(i));
                }
                this.client.output(OutputEvent.EventBody.create(sb.toString()));
            }
            this.client.output(OutputEvent.EventBody.create("Debugger attached.").setCategory("stderr"));
        });
    }

    @Override
    public CompletableFuture<Void> attach(AttachRequestArguments args) {
        return CompletableFuture.runAsync(() -> this.client.output(OutputEvent.EventBody.create("Debugger attached.").setCategory("stderr")));
    }

    @Override
    public CompletableFuture<Void> disconnect(DisconnectArguments args) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<BreakpointLocationsResponse.ResponseBody> breakpointLocations(BreakpointLocationsArguments args) {
        return CompletableFuture.completedFuture(BreakpointLocationsResponse.ResponseBody.create(this.context.getBreakpointsHandler().breakpointLocations(args)));
    }

    @Override
    public CompletableFuture<SetBreakpointsResponse.ResponseBody> setBreakpoints(SetBreakpointsArguments args) {
        return CompletableFuture.completedFuture(SetBreakpointsResponse.ResponseBody.create(this.context.getBreakpointsHandler().setBreakpoints(args)));
    }

    @Override
    public CompletableFuture<SetFunctionBreakpointsResponse.ResponseBody> setFunctionBreakpoints(SetFunctionBreakpointsArguments args) {
        return CompletableFuture.completedFuture(SetFunctionBreakpointsResponse.ResponseBody.create(this.context.getBreakpointsHandler().setFunctionBreakpoints(args)));
    }

    @Override
    public CompletableFuture<Void> setExceptionBreakpoints(SetExceptionBreakpointsArguments args) {
        if (args.getFilters().indexOf("all") >= 0) {
            this.context.getBreakpointsHandler().setExceptionBreakpoint(true, true);
        } else if (args.getFilters().indexOf("uncaught") >= 0) {
            this.context.getBreakpointsHandler().setExceptionBreakpoint(false, true);
        } else {
            this.context.getBreakpointsHandler().setExceptionBreakpoint(false, false);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<ContinueResponse.ResponseBody> doContinue(ContinueArguments args) {
        CompletableFuture<ContinueResponse.ResponseBody> future = new CompletableFuture<ContinueResponse.ResponseBody>();
        this.context.getThreadsHandler().executeInSuspendedThread(args.getThreadId(), info -> {
            if (info == null) {
                future.completeExceptionally(Errors.invalidThread(args.getThreadId()));
                return false;
            }
            future.complete(ContinueResponse.ResponseBody.create().setAllThreadsContinued(false));
            return true;
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> next(NextArguments args) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.context.getThreadsHandler().executeInSuspendedThread(args.getThreadId(), info -> {
            if (info == null) {
                future.completeExceptionally(Errors.invalidThread(args.getThreadId()));
                return false;
            }
            info.getSuspendedEvent().prepareStepOver(STEP_CONFIG);
            future.complete(null);
            return true;
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> stepIn(StepInArguments args) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.context.getThreadsHandler().executeInSuspendedThread(args.getThreadId(), info -> {
            if (info == null) {
                future.completeExceptionally(Errors.invalidThread(args.getThreadId()));
                return false;
            }
            info.getSuspendedEvent().prepareStepInto(STEP_CONFIG);
            future.complete(null);
            return true;
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> stepOut(StepOutArguments args) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.context.getThreadsHandler().executeInSuspendedThread(args.getThreadId(), info -> {
            if (info == null) {
                future.completeExceptionally(Errors.invalidThread(args.getThreadId()));
                return false;
            }
            info.getSuspendedEvent().prepareStepOut(STEP_CONFIG);
            future.complete(null);
            return true;
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> pause(PauseArguments args) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.context.getThreadsHandler().pause(args.getThreadId())) {
            future.complete(null);
        } else {
            future.completeExceptionally(Errors.invalidThread(args.getThreadId()));
        }
        return future;
    }

    @Override
    public CompletableFuture<StackTraceResponse.ResponseBody> stackTrace(StackTraceArguments args) {
        CompletableFuture<StackTraceResponse.ResponseBody> future = new CompletableFuture<StackTraceResponse.ResponseBody>();
        this.context.getThreadsHandler().executeInSuspendedThread(args.getThreadId(), info -> {
            if (info == null) {
                future.completeExceptionally(Errors.noCallStackAvailable());
            } else {
                List<StackFrame> stackTrace = this.context.getStackFramesHandler().getStackTrace((ThreadsHandler.SuspendedThreadInfo)info);
                int startIdx = args.getStartFrame() != null ? args.getStartFrame() : 0;
                int endIdx = startIdx + (args.getLevels() != null ? args.getLevels().intValue() : stackTrace.size());
                if (startIdx > 0 || endIdx < stackTrace.size()) {
                    stackTrace = stackTrace.subList(startIdx, endIdx);
                }
                future.complete(StackTraceResponse.ResponseBody.create(stackTrace).setTotalFrames(stackTrace.size()));
            }
            return false;
        });
        return future;
    }

    @Override
    public CompletableFuture<ScopesResponse.ResponseBody> scopes(ScopesArguments args) {
        CompletableFuture<ScopesResponse.ResponseBody> future = new CompletableFuture<ScopesResponse.ResponseBody>();
        this.context.getThreadsHandler().executeInSuspendedThread(args.getFrameId(), info -> {
            List<Scope> scopes;
            List<Scope> list = scopes = info != null ? this.context.getStackFramesHandler().getScopes((ThreadsHandler.SuspendedThreadInfo)info, args.getFrameId()) : null;
            if (scopes == null) {
                future.completeExceptionally(Errors.stackFrameNotValid());
            } else {
                future.complete(ScopesResponse.ResponseBody.create(scopes));
            }
            return false;
        });
        return future;
    }

    @Override
    public CompletableFuture<VariablesResponse.ResponseBody> variables(VariablesArguments args) {
        CompletableFuture<VariablesResponse.ResponseBody> future = new CompletableFuture<VariablesResponse.ResponseBody>();
        this.context.getThreadsHandler().executeInSuspendedThread(args.getVariablesReference(), info -> {
            List<Variable> variables;
            List<Variable> list = variables = info != null ? this.context.getVariablesHandler().getVariables((ThreadsHandler.SuspendedThreadInfo)info, args) : null;
            if (variables == null) {
                variables = Collections.emptyList();
            }
            future.complete(VariablesResponse.ResponseBody.create(variables));
            return false;
        });
        return future;
    }

    @Override
    public CompletableFuture<SetVariableResponse.ResponseBody> setVariable(SetVariableArguments args) {
        CompletableFuture<SetVariableResponse.ResponseBody> future = new CompletableFuture<SetVariableResponse.ResponseBody>();
        this.context.getThreadsHandler().executeInSuspendedThread(args.getVariablesReference(), info -> {
            try {
                Variable var;
                Variable variable = var = info != null ? VariablesHandler.setVariable(info, args) : null;
                if (var == null) {
                    future.completeExceptionally(Errors.setValueNotSupported());
                } else {
                    future.complete(SetVariableResponse.ResponseBody.create(var.getValue()).setType(var.getType()).setVariablesReference(var.getVariablesReference()).setIndexedVariables(var.getIndexedVariables()).setNamedVariables(var.getNamedVariables()));
                }
            }
            catch (Exception e) {
                future.completeExceptionally(Errors.errorFromEvaluate(e.getMessage()));
            }
            return false;
        });
        return future;
    }

    @Override
    public CompletableFuture<SourceResponse.ResponseBody> source(SourceArguments args) {
        CompletableFuture<SourceResponse.ResponseBody> future = new CompletableFuture<SourceResponse.ResponseBody>();
        Integer sourceReference = args.getSource().getSourceReference();
        Source source = sourceReference != null && sourceReference > 0 ? this.context.getLoadedSourcesHandler().getSource(sourceReference) : this.context.getLoadedSourcesHandler().getSource(args.getSource().getPath());
        if (source == null) {
            future.completeExceptionally(Errors.sourceRequestIllegalHandle());
        } else if (!source.hasCharacters()) {
            future.completeExceptionally(Errors.sourceRequestCouldNotRetrieveContent());
        } else {
            future.complete(SourceResponse.ResponseBody.create(source.getCharacters().toString()).setMimeType(source.getMimeType()));
        }
        return future;
    }

    @Override
    public CompletableFuture<ThreadsResponse.ResponseBody> threads() {
        return CompletableFuture.completedFuture(ThreadsResponse.ResponseBody.create(this.context.getThreadsHandler().getThreads()));
    }

    @Override
    public CompletableFuture<LoadedSourcesResponse.ResponseBody> loadedSources(LoadedSourcesArguments args) {
        return CompletableFuture.completedFuture(LoadedSourcesResponse.ResponseBody.create(this.context.getLoadedSourcesHandler().getLoadedSources()));
    }

    @Override
    public CompletableFuture<EvaluateResponse.ResponseBody> evaluate(EvaluateArguments args) {
        CompletableFuture<EvaluateResponse.ResponseBody> future = new CompletableFuture<EvaluateResponse.ResponseBody>();
        Integer frameId = args.getFrameId();
        this.context.getThreadsHandler().executeInSuspendedThread(frameId != null ? frameId : 0, info -> {
            if (info == null) {
                future.completeExceptionally(Errors.stackFrameNotValid());
            } else {
                try {
                    Variable var = StackFramesHandler.evaluateOnStackFrame(info, args.getFrameId(), args.getExpression());
                    if (var == null) {
                        future.completeExceptionally(Errors.stackFrameNotValid());
                    } else {
                        future.complete(EvaluateResponse.ResponseBody.create(var.getValue(), var.getVariablesReference()).setType(var.getType()).setIndexedVariables(var.getIndexedVariables()).setNamedVariables(var.getNamedVariables()));
                    }
                }
                catch (Exception e) {
                    future.completeExceptionally(Errors.errorFromEvaluate(e.getMessage()));
                }
            }
            return false;
        });
        return future;
    }

    @Override
    public CompletableFuture<ExceptionInfoResponse.ResponseBody> exceptionInfo(ExceptionInfoArguments args) {
        CompletableFuture<ExceptionInfoResponse.ResponseBody> future = new CompletableFuture<ExceptionInfoResponse.ResponseBody>();
        this.context.getThreadsHandler().executeInSuspendedThread(args.getThreadId(), info -> {
            if (info == null) {
                future.completeExceptionally(Errors.invalidThread(args.getThreadId()));
            } else {
                DebugException exception = info.getSuspendedEvent().getException();
                if (exception == null) {
                    future.completeExceptionally(Errors.noStoredException());
                } else {
                    DebugValue exceptionObject = exception.getExceptionObject();
                    String description = exceptionObject != null && exceptionObject.isReadable() ? exceptionObject.toDisplayString() : null;
                    DebugValue metaObject = exceptionObject != null ? exceptionObject.getMetaObject() : null;
                    String exceptionId = metaObject != null ? metaObject.getMetaSimpleName() : null;
                    future.complete(ExceptionInfoResponse.ResponseBody.create(exceptionId != null ? exceptionId : "Error", "unhandled").setDescription(description));
                }
            }
            return false;
        });
        return future;
    }

    @Override
    protected void connect(DebugProtocolClient clnt) {
        this.client = clnt;
        if (this.debuggerSession == null) {
            this.startDebuggerSession();
            this.context.initSession(this.debuggerSession);
        }
        this.context.initClient(this.client);
    }

    @Override
    public DebugProtocolServer.LoggerProxy getLogger() {
        return new DebugProtocolServer.LoggerProxy(){

            @Override
            public boolean isLoggable(Level level) {
                return DebugProtocolServerImpl.this.context.getLogger().isLoggable(level);
            }

            @Override
            public void log(Level level, String msg) {
                DebugProtocolServerImpl.this.context.getLogger().log(level, msg);
            }

            @Override
            public void log(Level level, String msg, Throwable thrown) {
                DebugProtocolServerImpl.this.context.getLogger().log(level, msg, thrown);
            }
        };
    }

    public CompletableFuture<?> start(final ServerSocket serverSocket, final Runnable onConnectCallback) {
        this.clientConnectionExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setName("DAP client connection thread");
                return thread;
            }
        });
        return CompletableFuture.runAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (serverSocket.isClosed()) {
                        DebugProtocolServerImpl.this.context.getErr().println("[Graal DAP] Server socket is closed.");
                        return;
                    }
                    DebugProtocolServerImpl.this.context.getInfo().println("[Graal DAP] Starting server and listening on " + serverSocket.getLocalSocketAddress());
                    try (Socket clientSocket = serverSocket.accept();){
                        onConnectCallback.run();
                        DebugProtocolServerImpl.this.context.getInfo().println("[Graal DAP] Client connected on " + clientSocket.getRemoteSocketAddress());
                        ExecutorService dapRequestExecutor = Executors.newCachedThreadPool(new ThreadFactory(){
                            private final ThreadFactory factory = Executors.defaultThreadFactory();

                            @Override
                            public Thread newThread(Runnable r) {
                                Thread thread = this.factory.newThread(r);
                                thread.setName("DAP request handler " + thread.getName());
                                return thread;
                            }
                        });
                        Future<?> listenFuture = DebugProtocolServer.Session.connect(DebugProtocolServerImpl.this, clientSocket.getInputStream(), clientSocket.getOutputStream(), dapRequestExecutor);
                        try {
                            listenFuture.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            DebugProtocolServerImpl.this.context.getErr().println("[Graal DAP] Error: " + e.getLocalizedMessage());
                        }
                        finally {
                            dapRequestExecutor.shutdown();
                        }
                    }
                }
                catch (IOException e) {
                    DebugProtocolServerImpl.this.context.getErr().println("[Graal DAP] Error while connecting to client: " + e.getLocalizedMessage());
                }
            }
        }, this.clientConnectionExecutor);
    }

    private void startDebuggerSession() {
        Debugger tdbg = (Debugger)this.context.getEnv().lookup((InstrumentInfo)this.context.getEnv().getInstruments().get("debugger"), Debugger.class);
        this.debuggerSession = tdbg.startSession((SuspendedCallback)new SuspendedCallbackImpl(), new SourceElement[]{SourceElement.ROOT, SourceElement.STATEMENT});
        this.debuggerSession.setSteppingFilter(SuspensionFilter.newBuilder().ignoreLanguageContextInitialization(!this.context.isInspectInitialization()).includeInternal(this.context.isInspectInternal()).build());
    }

    private class SuspendedCallbackImpl
    implements SuspendedCallback {
        private SuspendedCallbackImpl() {
        }

        public void onSuspend(SuspendedEvent event) {
            try {
                DebugProtocolServerImpl.this.context.waitForRunPermission();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SourceSection ss = event.getSourceSection();
            if (DebugProtocolServerImpl.this.debuggerSession == null) {
                return;
            }
            if (event.hasSourceElement(SourceElement.ROOT) && !event.hasSourceElement(SourceElement.STATEMENT) && event.getSuspendAnchor() == SuspendAnchor.BEFORE && event.getBreakpoints().isEmpty()) {
                DebugProtocolServerImpl.this.debuggerSession.suspendNextExecution();
                return;
            }
            DebugProtocolServerImpl.this.context.getLoadedSourcesHandler().assureLoaded(ss.getSource());
            DebugProtocolServerImpl.this.context.getThreadsHandler().threadSuspended(Thread.currentThread(), event);
        }
    }
}

