/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management.libgraal;

import java.util.function.Supplier;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.graalvm.compiler.core.GraalServiceThread;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalManagementRegistration;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.hotspot.management.HotSpotGraalRuntimeMBean;
import org.graalvm.compiler.hotspot.management.libgraal.MBeanProxy;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;

public final class LibGraalHotSpotGraalManagement
extends MBeanProxy<HotSpotGraalRuntimeMBean>
implements HotSpotGraalManagementRegistration {
    public void initialize(final HotSpotGraalRuntime runtime, final GraalHotSpotVMConfig config) {
        final int delay = (Integer)Options.LibGraalManagementDelay.getValue(runtime.getOptions());
        if (delay < 0) {
            return;
        }
        if (delay == 0) {
            this.initialize0(runtime, config);
        } else {
            GraalServiceThread t = new GraalServiceThread(LibGraalHotSpotGraalManagement.class.getSimpleName() + "-init", new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(delay);
                        LibGraalHotSpotGraalManagement.this.initialize0(runtime, config);
                    }
                    catch (Throwable error) {
                        runtime.handleManagementInitializationFailure(error);
                    }
                }
            });
            t.setDaemon(true);
            t.start();
        }
    }

    private void initialize0(HotSpotGraalRuntime runtime, GraalHotSpotVMConfig config) {
        if (!LibGraalHotSpotGraalManagement.initializeJNI(config)) {
            return;
        }
        HotSpotGraalRuntimeMBean mbean = (HotSpotGraalRuntimeMBean)this.getBean();
        if (mbean == null) {
            if (runtime.getManagement() != this) {
                throw new IllegalArgumentException("Cannot initialize a second management object for runtime " + runtime.getName());
            }
            try {
                String beanName = LibGraalHotSpotGraalManagement.nameWithIsolateId("org.graalvm.compiler.hotspot:type=" + runtime.getName().replace(':', '_'));
                ObjectName objectName = new ObjectName(beanName);
                mbean = new HotSpotGraalRuntimeMBean(objectName, runtime);
                this.initialize(mbean, beanName, objectName);
                LibGraalHotSpotGraalManagement.enqueueForRegistrationAndNotify(this, runtime);
            }
            catch (MalformedObjectNameException err) {
                err.printStackTrace(TTY.out);
            }
        } else if (mbean.getRuntime() != runtime) {
            throw new IllegalArgumentException("Cannot change the runtime a management interface is associated with");
        }
    }

    public ObjectName poll(boolean sync) {
        return this.poll();
    }

    static final class Factory
    implements Supplier<HotSpotGraalManagementRegistration> {
        Factory() {
        }

        @Override
        public HotSpotGraalManagementRegistration get() {
            return new LibGraalHotSpotGraalManagement();
        }
    }

    static class Options {
        @Option(help={"Milliseconds to delay initialization of the libgraal JMX interface. Specify a negative value to disable the interface altogether."}, type=OptionType.Expert)
        static final OptionKey<Integer> LibGraalManagementDelay = new OptionKey((Object)1000);

        Options() {
        }
    }
}

