/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.compiler;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.CompressedReadStream;
import sun.jvm.hotspot.code.VMRegImpl;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMReg;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;

public class OopMapValue {
    private short value;
    private short contentReg;
    static int TYPE_BITS;
    static int REGISTER_BITS;
    static int TYPE_SHIFT;
    static int REGISTER_SHIFT;
    static int TYPE_MASK;
    static int TYPE_MASK_IN_PLACE;
    static int REGISTER_MASK;
    static int REGISTER_MASK_IN_PLACE;
    static int OOP_VALUE;
    static int NARROWOOP_VALUE;
    static int CALLEE_SAVED_VALUE;
    static int DERIVED_OOP_VALUE;

    private static void initialize(TypeDataBase db) {
        TYPE_BITS = db.lookupIntConstant("OopMapValue::type_bits");
        REGISTER_BITS = db.lookupIntConstant("OopMapValue::register_bits");
        TYPE_SHIFT = db.lookupIntConstant("OopMapValue::type_shift");
        REGISTER_SHIFT = db.lookupIntConstant("OopMapValue::register_shift");
        TYPE_MASK = db.lookupIntConstant("OopMapValue::type_mask");
        TYPE_MASK_IN_PLACE = db.lookupIntConstant("OopMapValue::type_mask_in_place");
        REGISTER_MASK = db.lookupIntConstant("OopMapValue::register_mask");
        REGISTER_MASK_IN_PLACE = db.lookupIntConstant("OopMapValue::register_mask_in_place");
        OOP_VALUE = db.lookupIntConstant("OopMapValue::oop_value");
        NARROWOOP_VALUE = db.lookupIntConstant("OopMapValue::narrowoop_value");
        CALLEE_SAVED_VALUE = db.lookupIntConstant("OopMapValue::callee_saved_value");
        DERIVED_OOP_VALUE = db.lookupIntConstant("OopMapValue::derived_oop_value");
    }

    public OopMapValue() {
        this.setValue((short)0);
        this.setContentReg(new VMReg(0));
    }

    public OopMapValue(VMReg reg, OopTypes t) {
        this.setReg(reg);
        this.setType(t);
    }

    public OopMapValue(VMReg reg, OopTypes t, VMReg reg2) {
        this.setReg(reg);
        this.setType(t);
        this.setContentReg(reg2);
    }

    public OopMapValue(CompressedReadStream stream) {
        this.readFrom(stream);
    }

    public void readFrom(CompressedReadStream stream) {
        this.setValue((short)stream.readInt());
        if (this.isCalleeSaved() || this.isDerivedOop()) {
            this.setContentReg(new VMReg(stream.readInt()));
        }
    }

    public boolean isOop() {
        return (this.getValue() & TYPE_MASK_IN_PLACE) == OOP_VALUE;
    }

    public boolean isNarrowOop() {
        return (this.getValue() & TYPE_MASK_IN_PLACE) == NARROWOOP_VALUE;
    }

    public boolean isCalleeSaved() {
        return (this.getValue() & TYPE_MASK_IN_PLACE) == CALLEE_SAVED_VALUE;
    }

    public boolean isDerivedOop() {
        return (this.getValue() & TYPE_MASK_IN_PLACE) == DERIVED_OOP_VALUE;
    }

    public VMReg getReg() {
        return new VMReg((this.getValue() & REGISTER_MASK_IN_PLACE) >> REGISTER_SHIFT);
    }

    public void setReg(VMReg r) {
        this.setValue((short)(r.getValue() << REGISTER_SHIFT | this.getValue() & TYPE_MASK_IN_PLACE));
    }

    public OopTypes getType() {
        int which = this.getValue() & TYPE_MASK_IN_PLACE;
        if (which == OOP_VALUE) {
            return OopTypes.OOP_VALUE;
        }
        if (which == NARROWOOP_VALUE) {
            return OopTypes.NARROWOOP_VALUE;
        }
        if (which == CALLEE_SAVED_VALUE) {
            return OopTypes.CALLEE_SAVED_VALUE;
        }
        if (which == DERIVED_OOP_VALUE) {
            return OopTypes.DERIVED_OOP_VALUE;
        }
        throw new InternalError("unknown which " + which + " (TYPE_MASK_IN_PLACE = " + TYPE_MASK_IN_PLACE + ")");
    }

    public void setType(OopTypes t) {
        this.setValue((short)(this.getValue() & REGISTER_MASK_IN_PLACE | t.getValue()));
    }

    public VMReg getContentReg() {
        return new VMReg(this.contentReg);
    }

    public void setContentReg(VMReg r) {
        this.contentReg = (short)r.getValue();
    }

    public boolean isRegisterLoc() {
        VMReg vMReg = this.getReg();
        VM.getVM().getVMRegImplInfo();
        return vMReg.lessThan(VMRegImpl.getStack0());
    }

    public boolean isStackLoc() {
        VMReg vMReg = this.getReg();
        VM.getVM().getVMRegImplInfo();
        return vMReg.greaterThanOrEqual(VMRegImpl.getStack0());
    }

    public int getStackOffset() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isStackLoc(), "must be stack location");
        }
        VMReg vMReg = this.getReg();
        VM.getVM().getVMRegImplInfo();
        return vMReg.minus(VMRegImpl.getStack0());
    }

    private void setValue(short value) {
        this.value = value;
    }

    private int getValue() {
        return this.value;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                OopMapValue.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    public static abstract class OopTypes {
        public static final OopTypes OOP_VALUE = new OopTypes(){

            @Override
            int getValue() {
                return OopMapValue.OOP_VALUE;
            }
        };
        public static final OopTypes NARROWOOP_VALUE = new OopTypes(){

            @Override
            int getValue() {
                return OopMapValue.NARROWOOP_VALUE;
            }
        };
        public static final OopTypes CALLEE_SAVED_VALUE = new OopTypes(){

            @Override
            int getValue() {
                return OopMapValue.CALLEE_SAVED_VALUE;
            }
        };
        public static final OopTypes DERIVED_OOP_VALUE = new OopTypes(){

            @Override
            int getValue() {
                return OopMapValue.DERIVED_OOP_VALUE;
            }
        };

        abstract int getValue();

        protected OopTypes() {
        }
    }
}

