/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hotspot.libgraal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.graal.hotspot.libgraal.LibGraalEntryPoints;
import com.oracle.svm.graal.hotspot.libgraal.LibGraalFeature;
import java.lang.reflect.Constructor;
import java.util.function.Supplier;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.HotSpotGraalManagementRegistration;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.serviceprovider.IsolateUtil;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIExceptionWrapper;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.VMRuntime;
import org.graalvm.word.WordFactory;

@TargetClass(className="org.graalvm.compiler.hotspot.HotSpotGraalRuntime", onlyWith={LibGraalFeature.IsEnabled.class})
final class Target_org_graalvm_compiler_hotspot_HotSpotGraalRuntime {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=InjectedManagementComputer.class, isFinal=true)
    private static Supplier<HotSpotGraalManagementRegistration> AOT_INJECTED_MANAGEMENT;

    Target_org_graalvm_compiler_hotspot_HotSpotGraalRuntime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    private static void shutdownLibGraal(HotSpotGraalRuntime runtime) {
        try {
            if (LibGraalEntryPoints.hasLibGraalIsolatePeer()) {
                long offset = runtime.getVMConfig().jniEnvironmentOffset;
                long javaThreadAddr = HotSpotJVMCIRuntime.runtime().getCurrentJavaThread();
                JNI.JNIEnv env = (JNI.JNIEnv)WordFactory.unsigned((long)javaThreadAddr).add(WordFactory.unsigned((long)offset));
                JNI.JClass libGraalIsolateClass = JNIUtil.findClass((JNI.JNIEnv)env, (JNI.JObject)JNIUtil.getJVMCIClassLoader((JNI.JNIEnv)env), (String)JNIUtil.getBinaryName((String)"org.graalvm.libgraal.LibGraalIsolate"), (boolean)true);
                JNI.JMethodID unregisterMethod = JNIUtil.findMethod((JNI.JNIEnv)env, (JNI.JClass)libGraalIsolateClass, (boolean)true, (String)"unregister", (String)"(J)V");
                JNI.JValue args = (JNI.JValue)StackValue.get(JNI.JValue.class);
                args.setLong(IsolateUtil.getIsolateID());
                env.getFunctions().getCallStaticVoidMethodA().call(env, libGraalIsolateClass, unregisterMethod, args);
                JNIExceptionWrapper.wrapAndThrowPendingJNIException((JNI.JNIEnv)env, (Class[])new Class[0]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(TTY.out);
        }
        finally {
            VMRuntime.shutdown();
        }
    }

    private static final class InjectedManagementComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        private InjectedManagementComputer() {
        }

        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.graalvm.compiler.hotspot.management.libgraal.LibGraalHotSpotGraalManagement$Factory");
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException cnf) {
                return null;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

