/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hotspot.libgraal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.log.FunctionPointerLogHandler;
import com.oracle.svm.graal.hotspot.libgraal.LibGraalFeature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.WordFactory;

@TargetClass(className="org.graalvm.compiler.core.GraalCompiler", onlyWith={LibGraalFeature.IsEnabled.class})
final class Target_org_graalvm_compiler_core_GraalCompiler {
    Target_org_graalvm_compiler_core_GraalCompiler() {
    }

    @Substitute
    private static void notifyCrash(String crashMessage) {
        if (((Boolean)LibGraalFeature.Options.CrashAtIsFatal.getValue()).booleanValue()) {
            FunctionPointerLogHandler fpHandler;
            LogHandler handler = (LogHandler)ImageSingletons.lookup(LogHandler.class);
            if (handler instanceof FunctionPointerLogHandler && (fpHandler = (FunctionPointerLogHandler)handler).getFatalErrorFunctionPointer().isNonNull()) {
                try (CTypeConversion.CCharPointerHolder holder = CTypeConversion.toCString((CharSequence)crashMessage);){
                    handler.log(holder.get(), WordFactory.unsigned((int)crashMessage.getBytes().length));
                }
                handler.fatalError();
            }
            System.out.println("CrashAtIsFatal: no fatalError function pointer installed");
        }
    }
}

