/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hotspot.libgraal;

import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.jni.hosted.JNIFeature;
import com.oracle.svm.reflect.hosted.ReflectionFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotSignature;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.EncodedSnippets;
import org.graalvm.compiler.hotspot.HotSpotCodeCacheListener;
import org.graalvm.compiler.hotspot.HotSpotGraalCompiler;
import org.graalvm.compiler.hotspot.HotSpotReplacementsImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedPluginFactory;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.MethodSubstitutionPlugin;
import org.graalvm.compiler.nodes.spi.SnippetParameterInfo;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionDescriptorsMap;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.compiler.phases.common.jmx.HotSpotMBeanOperationProvider;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.truffle.compiler.PartialEvaluatorConfiguration;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerBase;
import org.graalvm.compiler.truffle.compiler.hotspot.TruffleCallBoundaryInstrumentationFactory;
import org.graalvm.compiler.truffle.compiler.substitutions.GraphBuilderInvocationPluginProvider;
import org.graalvm.compiler.truffle.compiler.substitutions.GraphDecoderInvocationPluginProvider;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public final class LibGraalFeature
implements GraalFeature {
    private HotSpotReplacementsImpl hotSpotSubstrateReplacements;

    public void afterImageWrite(Feature.AfterImageWriteAccess access) {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        if (!LibGraal.isSupported()) {
            throw new InternalError("LibGraalFeature is not supported by the current JDK");
        }
        return true;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(JNIFeature.class, com.oracle.svm.graal.hosted.GraalFeature.class, ReflectionFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        JNIRuntimeAccess.JNIRuntimeAccessibilitySupport registry = (JNIRuntimeAccess.JNIRuntimeAccessibilitySupport)ImageSingletons.lookup(JNIRuntimeAccess.JNIRuntimeAccessibilitySupport.class);
        ImageClassLoader imageClassLoader = ((FeatureImpl.DuringSetupAccessImpl)access).getImageClassLoader();
        LibGraalFeature.registerJNIConfiguration(registry, imageClassLoader);
        EconomicMap descriptors = EconomicMap.create();
        for (Class optionsClass : imageClassLoader.findSubclasses(OptionDescriptors.class, false)) {
            if (Modifier.isAbstract(optionsClass.getModifiers()) || OptionDescriptorsMap.class.isAssignableFrom(optionsClass)) continue;
            try {
                for (OptionDescriptor d : (OptionDescriptors)optionsClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])) {
                    if (d.getOptionKey() instanceof HostedOptionKey) continue;
                    descriptors.put((Object)d.getName(), (Object)d);
                }
            }
            catch (ReflectiveOperationException ex) {
                throw VMError.shouldNotReachHere((Throwable)ex);
            }
        }
        OptionsParser.setCachedOptionDescriptors(Collections.singletonList(new OptionDescriptorsMap(descriptors)));
    }

    private static void registerJNIConfiguration(JNIRuntimeAccess.JNIRuntimeAccessibilitySupport registry, ImageClassLoader loader) {
        try (JNIConfigSource source = new JNIConfigSource(loader);){
            HashMap classes = new HashMap();
            block25: for (String line : source.lines) {
                ++source.lineNo;
                String[] tokens = line.split(" ");
                source.check(tokens.length >= 2, "Expected at least 2 tokens", new Object[0]);
                String className = tokens[1].replace('/', '.');
                Class<?> clazz = (Class<?>)classes.get(className);
                if (clazz == null) {
                    clazz = source.findClass(className);
                    registry.register(new Class[]{clazz});
                    registry.register(new Class[]{Array.newInstance(clazz, 0).getClass()});
                    classes.put(className, clazz);
                }
                switch (tokens[0]) {
                    case "field": {
                        source.check(tokens.length == 4, "Expected 4 tokens for a field", new Object[0]);
                        String fieldName = tokens[2];
                        try {
                            registry.register(false, false, new Field[]{clazz.getDeclaredField(fieldName)});
                            break;
                        }
                        catch (NoSuchFieldException e) {
                            throw source.error("Field %s.%s not found", clazz.getTypeName(), fieldName);
                        }
                        catch (NoClassDefFoundError e) {
                            throw source.error("Could not register field %s.%s: %s", clazz.getTypeName(), fieldName, e);
                        }
                    }
                    case "method": {
                        source.check(tokens.length == 4, "Expected 4 tokens for a method", new Object[0]);
                        String methodName = tokens[2];
                        HotSpotSignature descriptor = new HotSpotSignature(HotSpotJVMCIRuntime.runtime(), tokens[3]);
                        Class[] parameters = Arrays.asList(descriptor.toParameterTypes(null)).stream().map(JavaType::toClassName).map(source::findClass).collect(Collectors.toList()).toArray(new Class[descriptor.getParameterCount(false)]);
                        try {
                            if ("<init>".equals(methodName)) {
                                Constructor<?> cons = clazz.getDeclaredConstructor(parameters);
                                registry.register(new Executable[]{cons});
                                if (!Throwable.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers()) || !LibGraalFeature.usedInTranslatedException(parameters)) continue block25;
                                RuntimeReflection.register((Class[])new Class[]{clazz});
                                RuntimeReflection.register((Executable[])new Executable[]{cons});
                                break;
                            }
                            registry.register(new Executable[]{clazz.getDeclaredMethod(methodName, parameters)});
                            break;
                        }
                        catch (NoSuchMethodException e) {
                            throw source.error("Method %s.%s%s not found: %e", clazz.getTypeName(), methodName, descriptor, e);
                        }
                        catch (NoClassDefFoundError e) {
                            throw source.error("Could not register method %s.%s%s: %e", clazz.getTypeName(), methodName, descriptor, e);
                        }
                    }
                    case "class": {
                        source.check(tokens.length == 2, "Expected 2 tokens for a class", new Object[0]);
                        break;
                    }
                    default: {
                        throw source.error("Unexpected token: " + tokens[0], new Object[0]);
                    }
                }
            }
        }
    }

    private static boolean usedInTranslatedException(Class<?>[] parameters) {
        return parameters.length == 0 || parameters.length == 1 && parameters[0] == String.class;
    }

    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers substrateProviders, SnippetReflectionProvider substrateSnippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        this.hotSpotSubstrateReplacements = LibGraalFeature.getReplacements();
    }

    private void registerMethodSubstitutions(DebugContext debug, InvocationPlugins invocationPlugins, MetaAccessProvider metaAccess) {
        MapCursor cursor = invocationPlugins.getBindings(true).getEntries();
        while (cursor.advance()) {
            String className = (String)cursor.getKey();
            for (InvocationPlugins.Binding binding : (List)cursor.getValue()) {
                if (!(binding.plugin instanceof MethodSubstitutionPlugin)) continue;
                MethodSubstitutionPlugin plugin = (MethodSubstitutionPlugin)binding.plugin;
                ResolvedJavaMethod original = plugin.getOriginalMethod(metaAccess);
                if (original != null) {
                    ResolvedJavaMethod method = plugin.getSubstitute(metaAccess);
                    debug.log("Method substitution %s %s", (Object)method, (Object)original);
                    this.hotSpotSubstrateReplacements.checkRegistered(plugin);
                    continue;
                }
                throw new GraalError("Can't find original method for " + plugin + " with class " + className);
            }
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        GraalServices.load(TruffleCallBoundaryInstrumentationFactory.class);
        GraalServices.load(GraphBuilderInvocationPluginProvider.class);
        GraalServices.load(GraphDecoderInvocationPluginProvider.class);
        GraalServices.load(PartialEvaluatorConfiguration.class);
        GraalServices.load(HotSpotCodeCacheListener.class);
        GraalServices.load(HotSpotMBeanOperationProvider.class);
        FeatureImpl.BeforeAnalysisAccessImpl impl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        DebugContext debug = impl.getBigBang().getDebug();
        try (DebugContext.Scope scope = debug.scope((Object)"SnippetSupportEncode");){
            InvocationPlugins compilerPlugins = this.hotSpotSubstrateReplacements.getGraphBuilderPlugins().getInvocationPlugins();
            MetaAccessProvider metaAccess = this.hotSpotSubstrateReplacements.getProviders().getMetaAccess();
            this.registerMethodSubstitutions(debug, compilerPlugins, metaAccess);
            TruffleCompilerBase truffleCompiler = (TruffleCompilerBase)GraalTruffleRuntime.getRuntime().newTruffleCompiler();
            InvocationPlugins trufflePlugins = truffleCompiler.getPartialEvaluator().getConfigPrototype().getPlugins().getInvocationPlugins();
            this.registerMethodSubstitutions(debug, trufflePlugins, metaAccess);
        }
        catch (Throwable t) {
            throw debug.handle(t);
        }
        try {
            HotSpotGraalCompiler compiler = (HotSpotGraalCompiler)HotSpotJVMCIRuntime.runtime().getCompiler();
            String osArch = compiler.getGraalRuntime().getVMConfig().osArch;
            String archPackage = "." + (String)osArch + ".";
            Field servicesCacheField = ReflectionUtil.lookupField(Services.class, (String)"servicesCache");
            Map servicesCache = (Map)servicesCacheField.get(null);
            LibGraalFeature.filterArchitectureServices(archPackage, servicesCache);
            servicesCache.remove(GeneratedPluginFactory.class);
            if (JavaVersionUtil.JAVA_SPEC > 8) {
                Field graalServicesCacheField = ReflectionUtil.lookupField(GraalServices.class, (String)"servicesCache");
                Map graalServicesCache = (Map)graalServicesCacheField.get(null);
                LibGraalFeature.filterArchitectureServices(archPackage, graalServicesCache);
                graalServicesCache.remove(GeneratedPluginFactory.class);
            }
            Field cachedHotSpotJVMCIBackendFactoriesField = ReflectionUtil.lookupField(HotSpotJVMCIRuntime.class, (String)"cachedHotSpotJVMCIBackendFactories");
            List cachedHotSpotJVMCIBackendFactories = (List)cachedHotSpotJVMCIBackendFactoriesField.get(null);
            cachedHotSpotJVMCIBackendFactories.removeIf(factory -> !factory.getArchitecture().equalsIgnoreCase(osArch));
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere((Throwable)ex);
        }
        HotSpotHostForeignCallsProvider foreignCalls = LibGraalFeature.getReplacements().getProviders().getForeignCalls();
        for (Stub stub : foreignCalls.getStubs()) {
            foreignCalls.lookupForeignCall((ForeignCallDescriptor)stub.getLinkage().getDescriptor());
        }
        this.hotSpotSubstrateReplacements.encode(impl.getBigBang().getOptions());
        if (!RuntimeAssertionsSupport.singleton().desiredAssertionStatus(SnippetParameterInfo.class)) {
            this.hotSpotSubstrateReplacements.clearSnippetParameterNames();
        }
        EncodedSnippets encodedSnippets = HotSpotReplacementsImpl.getEncodedSnippets();
        for (NodeClass nodeClass : encodedSnippets.getSnippetNodeClasses()) {
            impl.getMetaAccess().lookupJavaType(nodeClass.getClazz()).registerAsInHeap();
        }
    }

    private static void filterArchitectureServices(String archPackage, Map<Class<?>, List<?>> services) {
        for (List<?> list : services.values()) {
            list.removeIf(o -> {
                String name = o.getClass().getName();
                if (name.contains(".aarch64.") || name.contains(".sparc.") || name.contains(".amd64.")) {
                    return !name.contains(archPackage);
                }
                return false;
            });
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        LibGraalFeature.verifyReachableTruffleClasses(access);
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        EncodedSnippets encodedSnippets = HotSpotReplacementsImpl.getEncodedSnippets();
        encodedSnippets.visitImmutable(arg_0 -> ((Feature.AfterCompilationAccess)access).registerAsImmutable(arg_0));
    }

    private static void verifyReachableTruffleClasses(Feature.AfterAnalysisAccess access) {
        AnalysisUniverse universe = ((FeatureImpl.AfterAnalysisAccessImpl)access).getUniverse();
        HashSet<AnalysisMethod> seen = new HashSet<AnalysisMethod>();
        universe.getMethods().stream().filter(AnalysisMethod::isRootMethod).forEach(seen::add);
        ArrayDeque<AnalysisMethod> todo = new ArrayDeque<AnalysisMethod>(seen);
        TreeSet<String> disallowedTypes = new TreeSet<String>();
        while (!todo.isEmpty()) {
            AnalysisMethod m = (AnalysisMethod)todo.removeFirst();
            String className = m.getDeclaringClass().toClassName();
            if (!LibGraalFeature.isAllowedType(className)) {
                disallowedTypes.add(className);
            }
            for (InvokeTypeFlow invoke : m.getTypeFlow().getInvokes()) {
                for (AnalysisMethod callee : invoke.getCallees()) {
                    if (!seen.add(callee)) continue;
                    todo.add(callee);
                }
            }
        }
        if (!disallowedTypes.isEmpty()) {
            throw UserError.abort((String)"Following non allowed Truffle types are reachable on heap: %s", (Object[])new Object[]{String.join((CharSequence)", ", disallowedTypes)});
        }
    }

    private static boolean isAllowedType(String className) {
        if (className.startsWith("com.oracle.truffle.")) {
            return className.startsWith("com.oracle.truffle.api.nodes.") || className.startsWith("com.oracle.truffle.compiler.enterprise.");
        }
        return true;
    }

    static HotSpotReplacementsImpl getReplacements() {
        HotSpotGraalCompiler compiler = (HotSpotGraalCompiler)HotSpotJVMCIRuntime.runtime().getCompiler();
        HotSpotProviders originalProvider = compiler.getGraalRuntime().getHostProviders();
        return (HotSpotReplacementsImpl)originalProvider.getReplacements();
    }

    static class JNIConfigSource
    implements AutoCloseable {
        private final String quotedCommand;
        private final List<String> lines;
        private final ImageClassLoader loader;
        private Path configFilePath;
        int lineNo;

        JNIConfigSource(ImageClassLoader loader) {
            int exitValue;
            Process p;
            this.loader = loader;
            Path javaHomePath = Paths.get(System.getProperty("java.home"), new String[0]);
            Path binJava = Paths.get("bin", OS.getCurrent() == OS.WINDOWS ? "java.exe" : "java");
            Path javaExe = javaHomePath.resolve(binJava);
            if (!Files.isExecutable(javaExe)) {
                throw UserError.abort((String)"Java launcher %s does not exist or is not executable", (Object[])new Object[]{javaExe});
            }
            this.configFilePath = Paths.get("libgraal_jniconfig.txt", new String[0]);
            String[] command = new String[]{javaExe.toFile().getAbsolutePath(), "-XX:+UnlockExperimentalVMOptions", "-XX:+EnableJVMCI", "-XX:JVMCILibDumpJNIConfig=" + this.configFilePath};
            this.quotedCommand = Arrays.asList(command).stream().map(e -> e.indexOf(32) == -1 ? e : '\'' + e + '\'').collect(Collectors.joining(" "));
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.redirectErrorStream(true);
            try {
                p = pb.start();
            }
            catch (IOException e2) {
                throw UserError.abort((String)"Could not run command: %s%n%s", (Object[])new Object[]{this.quotedCommand, e2});
            }
            String nl = System.getProperty("line.separator");
            String out = new BufferedReader(new InputStreamReader(p.getInputStream())).lines().collect(Collectors.joining(nl));
            try {
                exitValue = p.waitFor();
            }
            catch (InterruptedException e3) {
                throw UserError.abort((String)"Interrupted waiting for command: %s%n%s", (Object[])new Object[]{this.quotedCommand, out});
            }
            if (exitValue != 0) {
                throw UserError.abort((String)"Command finished with exit value %d: %s%n%s", (Object[])new Object[]{exitValue, this.quotedCommand, out});
            }
            try {
                this.lines = Files.readAllLines(this.configFilePath);
            }
            catch (IOException e4) {
                this.configFilePath = null;
                throw UserError.abort((String)"Reading JNI config in %s dumped by command: %s%n%s", (Object[])new Object[]{this.configFilePath, this.quotedCommand, out});
            }
        }

        @Override
        public void close() {
            if (this.configFilePath != null && Files.exists(this.configFilePath, new LinkOption[0])) {
                try {
                    Files.delete(this.configFilePath);
                    this.configFilePath = null;
                }
                catch (IOException e) {
                    System.out.printf("WARNING: Cound not delete %s: %s%n", this.configFilePath, e);
                }
            }
        }

        Class<?> findClass(String name) {
            Class c = (Class)this.loader.findClass(name).get();
            if (c == null) {
                throw this.error("Class " + name + " not found", new Object[0]);
            }
            return c;
        }

        void check(boolean condition, String format, Object ... args) {
            if (!condition) {
                this.error(format, args);
            }
        }

        UserError.UserException error(String format, Object ... args) {
            Path path = this.configFilePath;
            this.configFilePath = null;
            String errorMessage = String.format(format, args);
            String errorLine = this.lines.get(this.lineNo - 1);
            throw UserError.abort((String)"Line %d of %s: %s%n%s%n%s generated by command: %s", (Object[])new Object[]{this.lineNo, path.toAbsolutePath(), errorMessage, errorLine, path, this.quotedCommand});
        }
    }

    public static final class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(LibGraalFeature.class);
        }
    }

    static class Options {
        @Option(help={"Converts an exception triggered by the CrashAt option into a fatal error if a non-null pointer was passed in the _fatal option to JNI_CreateJavaVM. This option exists for the purpose of testing fatal error handling in libgraal."})
        static final RuntimeOptionKey<Boolean> CrashAtIsFatal = new RuntimeOptionKey((Object)false);

        Options() {
        }
    }
}

