/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.util;

import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SectionName;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.graal.llvm.LLVMNativeImageCodeCache;
import com.oracle.svm.core.graal.llvm.util.LLVMStackMapInfo;
import com.oracle.svm.core.graal.llvm.util.LLVMTargetSpecific;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.BytePointer;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMMemoryBufferRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMObjectFileRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMSectionIteratorRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMSymbolIteratorRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.global.LLVM;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.ReferenceMap;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.GraalError;

public class LLVMObjectFileReader {
    private static final String SYMBOL_PREFIX = ObjectFile.getNativeFormat() == ObjectFile.Format.MACH_O ? "_" : "";
    private final LLVMNativeImageCodeCache.StackMapDumper stackMapDumper;

    public LLVMObjectFileReader(LLVMNativeImageCodeCache.StackMapDumper stackMapDumper) {
        this.stackMapDumper = stackMapDumper;
    }

    private static <SectionInfo, SymbolInfo> LLVMSectionInfo<SectionInfo, SymbolInfo> readSection(Path path, SectionName sectionName, SectionReader<SectionInfo> sectionReader, SymbolReader<SymbolInfo> symbolReader) {
        byte[] bytes;
        try {
            bytes = Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new GraalError((Throwable)e);
        }
        LLVMMemoryBufferRef buffer = LLVM.LLVMCreateMemoryBufferWithMemoryRangeCopy((BytePointer)new BytePointer(bytes), (long)bytes.length, (BytePointer)new BytePointer(""));
        LLVMObjectFileRef objectFile = LLVM.LLVMCreateObjectFile((LLVMMemoryBufferRef)buffer);
        LLVMSectionInfo result = new LLVMSectionInfo();
        LLVMSectionIteratorRef sectionIterator = LLVM.LLVMGetSections((LLVMObjectFileRef)objectFile);
        while (LLVM.LLVMIsSectionIteratorAtEnd((LLVMObjectFileRef)objectFile, (LLVMSectionIteratorRef)sectionIterator) == 0) {
            String currentSectionName;
            BytePointer sectionNamePointer = LLVM.LLVMGetSectionName((LLVMSectionIteratorRef)sectionIterator);
            String string = currentSectionName = sectionNamePointer != null ? sectionNamePointer.getString() : "";
            if (currentSectionName.startsWith(sectionName.getFormatDependentName(ObjectFile.getNativeFormat()))) {
                result.sectionInfo = sectionReader.apply(sectionIterator);
                if (symbolReader == null) break;
                LLVMSymbolIteratorRef symbolIterator = LLVM.LLVMGetSymbols((LLVMObjectFileRef)objectFile);
                while (LLVM.LLVMIsSymbolIteratorAtEnd((LLVMObjectFileRef)objectFile, (LLVMSymbolIteratorRef)symbolIterator) == 0) {
                    if (LLVM.LLVMGetSectionContainsSymbol((LLVMSectionIteratorRef)sectionIterator, (LLVMSymbolIteratorRef)symbolIterator) == 1) {
                        result.symbolInfo.add(symbolReader.apply(symbolIterator, sectionIterator));
                    }
                    LLVM.LLVMMoveToNextSymbol((LLVMSymbolIteratorRef)symbolIterator);
                }
                LLVM.LLVMDisposeSymbolIterator((LLVMSymbolIteratorRef)symbolIterator);
                break;
            }
            LLVM.LLVMMoveToNextSection((LLVMSectionIteratorRef)sectionIterator);
        }
        LLVM.LLVMDisposeSectionIterator((LLVMSectionIteratorRef)sectionIterator);
        LLVM.LLVMDisposeObjectFile((LLVMObjectFileRef)objectFile);
        return result;
    }

    public LLVMTextSectionInfo parseCode(Path objectFile) {
        LLVMSectionInfo<Long, SymbolOffset> sectionInfo = LLVMObjectFileReader.readSection(objectFile, SectionName.TEXT, this::parseTextSection, this::handleTextSymbol);
        return new LLVMTextSectionInfo(sectionInfo);
    }

    private Long parseTextSection(LLVMSectionIteratorRef sectionIterator) {
        return LLVM.LLVMGetSectionSize((LLVMSectionIteratorRef)sectionIterator);
    }

    private SymbolOffset handleTextSymbol(LLVMSymbolIteratorRef symbolIterator, LLVMSectionIteratorRef sectionIterator) {
        long sectionAddress = LLVM.LLVMGetSectionAddress((LLVMSectionIteratorRef)sectionIterator);
        int offset = NumUtil.safeToInt((long)(LLVM.LLVMGetSymbolAddress((LLVMSymbolIteratorRef)symbolIterator) - sectionAddress));
        String symbolName = LLVM.LLVMGetSymbolName((LLVMSymbolIteratorRef)symbolIterator).getString();
        return new SymbolOffset(symbolName, offset);
    }

    public LLVMStackMapInfo parseStackMap(Path objectFile) {
        LLVMSectionInfo sectionInfo = LLVMObjectFileReader.readSection(objectFile, SectionName.LLVM_STACKMAPS, this::readStackMapSection, null);
        return (LLVMStackMapInfo)sectionInfo.sectionInfo;
    }

    private LLVMStackMapInfo readStackMapSection(LLVMSectionIteratorRef sectionIterator) {
        BytePointer stackMap = LLVM.LLVMGetSectionContents((LLVMSectionIteratorRef)sectionIterator).limit(LLVM.LLVMGetSectionSize((LLVMSectionIteratorRef)sectionIterator));
        return new LLVMStackMapInfo(stackMap.asByteBuffer());
    }

    public void readStackMap(LLVMStackMapInfo info, CompilationResult compilation, ResolvedJavaMethod method, int id) {
        String methodSymbolName = SYMBOL_PREFIX + SubstrateUtil.uniqueShortName((ResolvedJavaMethod)method);
        long startPatchpointID = compilation.getInfopoints().stream().filter((Predicate<Infopoint>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$readStackMap$0(jdk.vm.ci.code.site.Infopoint ), (Ljdk/vm/ci/code/site/Infopoint;)Z)()).findFirst().orElseThrow((Supplier<GraalError>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$readStackMap$1(java.lang.String ), ()Lorg/graalvm/compiler/debug/GraalError;)((String)methodSymbolName)).pcOffset;
        int totalFrameSize = NumUtil.safeToInt((long)(info.getFunctionStackSize(startPatchpointID) + (long)LLVMTargetSpecific.get().getCallFrameSeparation()));
        compilation.setTotalFrameSize(totalFrameSize);
        this.stackMapDumper.startDumpingFunction(methodSymbolName, id, totalFrameSize);
        ArrayList<Call> newInfopoints = new ArrayList<Call>();
        for (Infopoint infopoint : compilation.getInfopoints()) {
            if (!(infopoint instanceof Call)) continue;
            Call call = (Call)infopoint;
            for (int actualPcOffset : info.getPatchpointOffsets(call.pcOffset)) {
                SubstrateReferenceMap referenceMap = new SubstrateReferenceMap();
                info.forEachStatepointOffset(call.pcOffset, actualPcOffset, (arg_0, arg_1, arg_2) -> ((SubstrateReferenceMap)referenceMap).markReferenceAtOffset(arg_0, arg_1, arg_2));
                this.stackMapDumper.dumpCallSite(call, actualPcOffset, referenceMap);
                newInfopoints.add(new Call(call.target, actualPcOffset, call.size, call.direct, LLVMObjectFileReader.copyWithReferenceMap(call.debugInfo, (ReferenceMap)referenceMap)));
            }
        }
        this.stackMapDumper.endDumpingFunction();
        compilation.clearInfopoints();
        newInfopoints.forEach(arg_0 -> ((CompilationResult)compilation).addInfopoint(arg_0));
    }

    private static DebugInfo copyWithReferenceMap(DebugInfo debugInfo, ReferenceMap referenceMap) {
        if (debugInfo == null) {
            return null;
        }
        DebugInfo newInfo = new DebugInfo(debugInfo.getBytecodePosition(), debugInfo.getVirtualObjectMapping());
        newInfo.setCalleeSaveInfo(debugInfo.getCalleeSaveInfo());
        newInfo.setReferenceMap(referenceMap);
        return newInfo;
    }

    private static /* synthetic */ GraalError lambda$readStackMap$1(String methodSymbolName) {
        return new GraalError("no method start infopoint: " + methodSymbolName);
    }

    private static /* synthetic */ boolean lambda$readStackMap$0(Infopoint ip) {
        return ip.reason == InfopointReason.METHOD_START;
    }

    public static final class LLVMTextSectionInfo {
        private final long codeSize;
        private final Map<Integer, String> offsetToSymbol = new TreeMap<Integer, String>();
        private final Map<String, Integer> symbolToOffset = new HashMap<String, Integer>();
        private final List<Integer> sortedMethodOffsets;

        private LLVMTextSectionInfo(LLVMSectionInfo<Long, SymbolOffset> sectionInfo) {
            this.codeSize = (Long)((LLVMSectionInfo)sectionInfo).sectionInfo;
            for (SymbolOffset symbolOffset : ((LLVMSectionInfo)sectionInfo).symbolInfo) {
                this.offsetToSymbol.put(symbolOffset.offset, symbolOffset.symbol);
                this.symbolToOffset.put(symbolOffset.symbol, symbolOffset.offset);
            }
            this.sortedMethodOffsets = this.computeSortedMethodOffsets();
        }

        public long getCodeSize() {
            return this.codeSize;
        }

        public String getSymbol(int offset) {
            return this.offsetToSymbol.get(offset);
        }

        public int getOffset(String methodName) {
            return this.symbolToOffset.get(SYMBOL_PREFIX + methodName);
        }

        public int getNextOffset(int offset) {
            return this.sortedMethodOffsets.get(this.sortedMethodOffsets.indexOf(offset) + 1);
        }

        public void forEachOffsetRange(OffsetRangeConsumer consumer) {
            for (int i = 0; i < this.sortedMethodOffsets.size() - 1; ++i) {
                consumer.apply(this.sortedMethodOffsets.get(i), this.sortedMethodOffsets.get(i + 1));
            }
        }

        private List<Integer> computeSortedMethodOffsets() {
            List<Integer> sortedOffsets = this.offsetToSymbol.keySet().stream().distinct().sorted().collect(Collectors.toList());
            this.symbolToOffset.forEach((symbol, offset) -> {
                if (symbol.startsWith(SYMBOL_PREFIX + "__llvm_jni_wrapper_")) {
                    sortedOffsets.remove(offset);
                }
            });
            sortedOffsets.add(NumUtil.safeToInt((long)this.codeSize));
            return sortedOffsets;
        }

        @FunctionalInterface
        public static interface OffsetRangeConsumer {
            public void apply(int var1, int var2);
        }
    }

    private static final class SymbolOffset {
        private final String symbol;
        private final int offset;

        private SymbolOffset(String symbol, int offset) {
            this.symbol = symbol;
            this.offset = offset;
        }
    }

    private static class LLVMSectionInfo<Section, Symbol> {
        private Section sectionInfo;
        private List<Symbol> symbolInfo = new ArrayList<Symbol>();

        private LLVMSectionInfo() {
        }
    }

    @FunctionalInterface
    private static interface SymbolReader<Symbol> {
        public Symbol apply(LLVMSymbolIteratorRef var1, LLVMSectionIteratorRef var2);
    }

    @FunctionalInterface
    private static interface SectionReader<Result> {
        public Result apply(LLVMSectionIteratorRef var1);
    }
}

