/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.util;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.graal.llvm.util.LLVMHelperFunctions;
import com.oracle.svm.core.graal.llvm.util.LLVMUtils;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.BytePointer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.Pointer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.PointerPointer;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMAttributeRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMBasicBlockRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMBuilderRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMContextRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMMemoryBufferRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMModuleRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMTypeRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.LLVMValueRef;
import com.oracle.svm.shadowed.org.bytedeco.llvm.global.LLVM;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.debug.GraalError;

public class LLVMIRBuilder
implements AutoCloseable {
    private static final String DEFAULT_INSTR_NAME = "";
    private LLVMContextRef context;
    private LLVMBuilderRef builder;
    private LLVMModuleRef module;
    private LLVMValueRef function;
    private boolean primary;
    private LLVMHelperFunctions helpers;
    private static final int UNTRACKED_POINTER_ADDRESS_SPACE = 0;
    private static final int TRACKED_POINTER_ADDRESS_SPACE = 1;
    private static final int COMPRESSED_POINTER_ADDRESS_SPACE = 2;
    private static final int LLVM_CMPXCHG_VALUE = 0;
    private static final int LLVM_CMPXCHG_SUCCESS = 1;

    public LLVMIRBuilder(String name) {
        this.context = LLVM.LLVMContextCreate();
        this.builder = LLVM.LLVMCreateBuilderInContext((LLVMContextRef)this.context);
        this.module = LLVM.LLVMModuleCreateWithNameInContext((String)name, (LLVMContextRef)this.context);
        this.primary = true;
        this.helpers = new LLVMHelperFunctions(this);
    }

    public LLVMIRBuilder(LLVMIRBuilder primary) {
        this.context = primary.context;
        this.builder = LLVM.LLVMCreateBuilderInContext((LLVMContextRef)this.context);
        this.module = primary.module;
        this.function = null;
        this.primary = false;
        this.helpers = null;
    }

    public void setMainFunction(String functionName, LLVMTypeRef functionType) {
        assert (this.function == null);
        this.function = this.addFunction(functionName, functionType);
    }

    public byte[] getBitcode() {
        LLVMMemoryBufferRef buffer = LLVM.LLVMWriteBitcodeToMemoryBuffer((LLVMModuleRef)this.module);
        BytePointer start = LLVM.LLVMGetBufferStart((LLVMMemoryBufferRef)buffer);
        int size = NumUtil.safeToInt((long)LLVM.LLVMGetBufferSize((LLVMMemoryBufferRef)buffer));
        byte[] bitcode = new byte[size];
        start.get(bitcode, 0, size);
        LLVM.LLVMDisposeMemoryBuffer((LLVMMemoryBufferRef)buffer);
        return bitcode;
    }

    public boolean verifyBitcode() {
        if (LLVM.LLVMVerifyModule((LLVMModuleRef)this.module, (int)1, (BytePointer)new BytePointer((Pointer)null)) == 1) {
            LLVM.LLVMDumpModule((LLVMModuleRef)this.module);
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        LLVM.LLVMDisposeBuilder((LLVMBuilderRef)this.builder);
        this.builder = null;
        if (this.primary) {
            LLVM.LLVMDisposeModule((LLVMModuleRef)this.module);
            this.module = null;
            LLVM.LLVMContextDispose((LLVMContextRef)this.context);
            this.context = null;
        }
    }

    public LLVMValueRef addFunction(String name, LLVMTypeRef type) {
        return LLVM.LLVMAddFunction((LLVMModuleRef)this.module, (String)name, (LLVMTypeRef)type);
    }

    public LLVMValueRef getFunction(String name, LLVMTypeRef type) {
        LLVMValueRef func = this.getNamedFunction(name);
        if (func == null) {
            func = this.addFunction(name, type);
            LLVMIRBuilder.setLinkage(func, LinkageType.External);
        }
        return func;
    }

    public LLVMValueRef getNamedFunction(String name) {
        return LLVM.LLVMGetNamedFunction((LLVMModuleRef)this.module, (String)name);
    }

    public void addAlias(String alias) {
        LLVM.LLVMAddAlias((LLVMModuleRef)this.module, (LLVMTypeRef)LLVM.LLVMTypeOf((LLVMValueRef)this.function), (LLVMValueRef)this.function, (String)alias);
    }

    public void setFunctionLinkage(LinkageType linkage) {
        LLVMIRBuilder.setLinkage(this.function, linkage);
    }

    public static void setLinkage(LLVMValueRef global, LinkageType linkage) {
        LLVM.LLVMSetLinkage((LLVMValueRef)global, (int)linkage.code);
    }

    public void setFunctionAttribute(Attribute attribute) {
        this.setFunctionAttribute(this.function, attribute);
    }

    public void setFunctionAttribute(LLVMValueRef func, Attribute attribute) {
        LLVMAttributeRef attr;
        int kind = LLVM.LLVMGetEnumAttributeKindForName((String)attribute.name, (long)attribute.name.length());
        if (kind != 0) {
            attr = LLVM.LLVMCreateEnumAttribute((LLVMContextRef)this.context, (int)kind, (long)1L);
        } else {
            String value = "true";
            attr = LLVM.LLVMCreateStringAttribute((LLVMContextRef)this.context, (String)attribute.name, (int)attribute.name.length(), (String)value, (int)value.length());
        }
        LLVM.LLVMAddAttributeAtIndex((LLVMValueRef)func, (int)-1, (LLVMAttributeRef)attr);
    }

    public void setPersonalityFunction(LLVMValueRef personality) {
        LLVM.LLVMSetPersonalityFn((LLVMValueRef)this.function, (LLVMValueRef)personality);
    }

    public void setGarbageCollector(GCStrategy gc) {
        this.setGarbageCollector(this.function, gc);
    }

    public void setGarbageCollector(LLVMValueRef func, GCStrategy gc) {
        LLVM.LLVMSetGC((LLVMValueRef)func, (String)gc.name);
    }

    public LLVMBasicBlockRef appendBasicBlock(String name) {
        return this.appendBasicBlock(this.function, name);
    }

    public LLVMBasicBlockRef appendBasicBlock(LLVMValueRef func, String name) {
        return LLVM.LLVMAppendBasicBlockInContext((LLVMContextRef)this.context, (LLVMValueRef)func, (String)name);
    }

    public void positionAtStart() {
        LLVMBasicBlockRef firstBlock = LLVM.LLVMGetFirstBasicBlock((LLVMValueRef)this.function);
        LLVMValueRef firstInstruction = LLVM.LLVMGetFirstInstruction((LLVMBasicBlockRef)firstBlock);
        if (firstInstruction != null) {
            LLVM.LLVMPositionBuilderBefore((LLVMBuilderRef)this.builder, (LLVMValueRef)firstInstruction);
        }
    }

    public void positionAtEnd(LLVMBasicBlockRef block) {
        LLVM.LLVMPositionBuilderAtEnd((LLVMBuilderRef)this.builder, (LLVMBasicBlockRef)block);
    }

    public void positionBeforeTerminator(LLVMBasicBlockRef block) {
        LLVM.LLVMPositionBuilderBefore((LLVMBuilderRef)this.builder, (LLVMValueRef)this.blockTerminator(block));
    }

    public LLVMValueRef blockTerminator(LLVMBasicBlockRef block) {
        return LLVM.LLVMGetBasicBlockTerminator((LLVMBasicBlockRef)block);
    }

    public static LLVMTypeRef typeOf(LLVMValueRef value) {
        return LLVM.LLVMTypeOf((LLVMValueRef)value);
    }

    public LLVMTypeRef booleanType() {
        return this.integerType(1);
    }

    public static boolean isBooleanType(LLVMTypeRef type) {
        return LLVMIRBuilder.isIntegerType(type) && LLVMIRBuilder.integerTypeWidth(type) == 1;
    }

    public LLVMTypeRef byteType() {
        return this.integerType(8);
    }

    public static boolean isByteType(LLVMTypeRef type) {
        return LLVMIRBuilder.isIntegerType(type) && LLVMIRBuilder.integerTypeWidth(type) == 8;
    }

    public LLVMTypeRef shortType() {
        return this.integerType(16);
    }

    public static boolean isShortType(LLVMTypeRef type) {
        return LLVMIRBuilder.isIntegerType(type) && LLVMIRBuilder.integerTypeWidth(type) == 16;
    }

    public LLVMTypeRef charType() {
        return this.integerType(16);
    }

    public static boolean isCharType(LLVMTypeRef type) {
        return LLVMIRBuilder.isIntegerType(type) && LLVMIRBuilder.integerTypeWidth(type) == 16;
    }

    public LLVMTypeRef intType() {
        return this.integerType(32);
    }

    public static boolean isIntType(LLVMTypeRef type) {
        return LLVMIRBuilder.isIntegerType(type) && LLVMIRBuilder.integerTypeWidth(type) == 32;
    }

    public LLVMTypeRef longType() {
        return this.integerType(64);
    }

    public static boolean isLongType(LLVMTypeRef type) {
        return LLVMIRBuilder.isIntegerType(type) && LLVMIRBuilder.integerTypeWidth(type) == 64;
    }

    LLVMTypeRef integerType(int bits) {
        return LLVM.LLVMIntTypeInContext((LLVMContextRef)this.context, (int)bits);
    }

    public static boolean isIntegerType(LLVMTypeRef type) {
        return LLVM.LLVMGetTypeKind((LLVMTypeRef)type) == 8;
    }

    public static int integerTypeWidth(LLVMTypeRef intType) {
        return LLVM.LLVMGetIntTypeWidth((LLVMTypeRef)intType);
    }

    public LLVMTypeRef wordType() {
        return this.integerType(FrameAccess.wordSize() * 8);
    }

    public static boolean isWordType(LLVMTypeRef type) {
        return LLVMIRBuilder.isIntegerType(type) && LLVMIRBuilder.integerTypeWidth(type) == FrameAccess.wordSize() * 8;
    }

    public LLVMTypeRef floatType() {
        return LLVM.LLVMFloatTypeInContext((LLVMContextRef)this.context);
    }

    public static boolean isFloatType(LLVMTypeRef type) {
        return LLVM.LLVMGetTypeKind((LLVMTypeRef)type) == 2;
    }

    public LLVMTypeRef doubleType() {
        return LLVM.LLVMDoubleTypeInContext((LLVMContextRef)this.context);
    }

    public static boolean isDoubleType(LLVMTypeRef type) {
        return LLVM.LLVMGetTypeKind((LLVMTypeRef)type) == 3;
    }

    private static int pointerAddressSpace(boolean tracked, boolean compressed) {
        assert (tracked || !compressed);
        return tracked ? (compressed ? 2 : 1) : 0;
    }

    public LLVMTypeRef objectType(boolean compressed) {
        return this.pointerType(this.byteType(), true, compressed);
    }

    public LLVMTypeRef rawPointerType() {
        return this.pointerType(this.byteType());
    }

    public LLVMTypeRef pointerType(LLVMTypeRef type) {
        return this.pointerType(type, false, false);
    }

    public LLVMTypeRef pointerType(LLVMTypeRef type, boolean tracked, boolean compressed) {
        return LLVM.LLVMPointerType((LLVMTypeRef)type, (int)LLVMIRBuilder.pointerAddressSpace(tracked, compressed));
    }

    public static LLVMTypeRef getElementType(LLVMTypeRef pointerType) {
        return LLVM.LLVMGetElementType((LLVMTypeRef)pointerType);
    }

    public static boolean isObjectType(LLVMTypeRef type) {
        return LLVMIRBuilder.isPointerType(type) && LLVMIRBuilder.isTrackedPointerType(type);
    }

    static boolean isPointerType(LLVMTypeRef type) {
        return LLVM.LLVMGetTypeKind((LLVMTypeRef)type) == 12;
    }

    static boolean isTrackedPointerType(LLVMTypeRef pointerType) {
        int addressSpace = LLVM.LLVMGetPointerAddressSpace((LLVMTypeRef)pointerType);
        return addressSpace == 1 || addressSpace == 2;
    }

    public static boolean isCompressedPointerType(LLVMTypeRef pointerType) {
        int addressSpace = LLVM.LLVMGetPointerAddressSpace((LLVMTypeRef)pointerType);
        assert (addressSpace == 2 || addressSpace == 1);
        return addressSpace == 2;
    }

    public LLVMTypeRef arrayType(LLVMTypeRef type, int length) {
        return LLVM.LLVMArrayType((LLVMTypeRef)type, (int)length);
    }

    public LLVMTypeRef structType(LLVMTypeRef ... types) {
        return LLVM.LLVMStructTypeInContext((LLVMContextRef)this.context, (PointerPointer)new PointerPointer((Pointer[])types), (int)types.length, (int)0);
    }

    public static int countElementTypes(LLVMTypeRef structType) {
        return LLVM.LLVMCountStructElementTypes((LLVMTypeRef)structType);
    }

    private static LLVMTypeRef getTypeAtIndex(LLVMTypeRef structType, int index) {
        return LLVM.LLVMStructGetTypeAtIndex((LLVMTypeRef)structType, (int)index);
    }

    private static LLVMTypeRef[] getElementTypes(LLVMTypeRef structType) {
        LLVMTypeRef[] types = new LLVMTypeRef[LLVMIRBuilder.countElementTypes(structType)];
        for (int i = 0; i < types.length; ++i) {
            types[i] = LLVMIRBuilder.getTypeAtIndex(structType, i);
        }
        return types;
    }

    public LLVMTypeRef vectorType(LLVMTypeRef type, int count) {
        return LLVM.LLVMVectorType((LLVMTypeRef)type, (int)count);
    }

    public LLVMTypeRef functionType(LLVMTypeRef returnType, LLVMTypeRef ... argTypes) {
        return this.functionType(returnType, false, argTypes);
    }

    public LLVMTypeRef functionType(LLVMTypeRef returnType, boolean varargs, LLVMTypeRef ... argTypes) {
        return LLVM.LLVMFunctionType((LLVMTypeRef)returnType, (PointerPointer)new PointerPointer((Pointer[])argTypes), (int)argTypes.length, (int)(varargs ? 1 : 0));
    }

    public LLVMTypeRef functionPointerType(LLVMTypeRef returnType, LLVMTypeRef ... argTypes) {
        return this.pointerType(this.functionType(returnType, argTypes), false, false);
    }

    public static LLVMTypeRef getReturnType(LLVMTypeRef functionType) {
        return LLVM.LLVMGetReturnType((LLVMTypeRef)functionType);
    }

    public static LLVMTypeRef[] getParamTypes(LLVMTypeRef functionType) {
        int numParams = LLVM.LLVMCountParamTypes((LLVMTypeRef)functionType);
        PointerPointer argTypesPointer = new PointerPointer((long)numParams);
        LLVM.LLVMGetParamTypes((LLVMTypeRef)functionType, (PointerPointer)argTypesPointer);
        return (LLVMTypeRef[])IntStream.range(0, numParams).mapToObj(i -> (LLVMTypeRef)argTypesPointer.get(LLVMTypeRef.class, (long)i)).toArray(LLVMTypeRef[]::new);
    }

    public static boolean isFunctionVarArg(LLVMTypeRef functionType) {
        return LLVM.LLVMIsFunctionVarArg((LLVMTypeRef)functionType) == 1;
    }

    public LLVMTypeRef voidType() {
        return LLVM.LLVMVoidTypeInContext((LLVMContextRef)this.context);
    }

    public static boolean isVoidType(LLVMTypeRef type) {
        return LLVM.LLVMGetTypeKind((LLVMTypeRef)type) == 0;
    }

    private LLVMTypeRef tokenType() {
        return LLVM.LLVMTokenTypeInContext((LLVMContextRef)this.context);
    }

    private LLVMTypeRef metadataType() {
        return LLVM.LLVMMetadataTypeInContext((LLVMContextRef)this.context);
    }

    public static boolean compatibleTypes(LLVMTypeRef a, LLVMTypeRef b) {
        int bKind;
        int aKind = LLVM.LLVMGetTypeKind((LLVMTypeRef)a);
        if (aKind != (bKind = LLVM.LLVMGetTypeKind((LLVMTypeRef)b))) {
            return false;
        }
        if (aKind == 8) {
            return LLVM.LLVMGetIntTypeWidth((LLVMTypeRef)a) == LLVM.LLVMGetIntTypeWidth((LLVMTypeRef)b);
        }
        if (aKind == 12) {
            return LLVM.LLVMGetPointerAddressSpace((LLVMTypeRef)a) == LLVM.LLVMGetPointerAddressSpace((LLVMTypeRef)b) && LLVMIRBuilder.compatibleTypes(LLVM.LLVMGetElementType((LLVMTypeRef)a), LLVM.LLVMGetElementType((LLVMTypeRef)b));
        }
        return true;
    }

    public static String intrinsicType(LLVMTypeRef type) {
        switch (LLVM.LLVMGetTypeKind((LLVMTypeRef)type)) {
            case 8: {
                return "i" + LLVMIRBuilder.integerTypeWidth(type);
            }
            case 2: {
                return "f32";
            }
            case 3: {
                return "f64";
            }
            case 0: {
                return "isVoid";
            }
            case 12: {
                return "p" + LLVM.LLVMGetPointerAddressSpace((LLVMTypeRef)type) + LLVMIRBuilder.intrinsicType(LLVM.LLVMGetElementType((LLVMTypeRef)type));
            }
            case 9: {
                String args = Arrays.stream(LLVMIRBuilder.getParamTypes(type)).map(LLVMIRBuilder::intrinsicType).collect(Collectors.joining(DEFAULT_INSTR_NAME));
                return "f_" + LLVMIRBuilder.intrinsicType(LLVMIRBuilder.getReturnType(type)) + args + "f";
            }
            case 10: {
                String types = Arrays.stream(LLVMIRBuilder.getElementTypes(type)).map(LLVMIRBuilder::intrinsicType).collect(Collectors.joining(DEFAULT_INSTR_NAME));
                return "sl_" + types + "s";
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public LLVMValueRef constantBoolean(boolean x) {
        return this.constantInteger(x ? 1L : 0L, 1);
    }

    public LLVMValueRef constantByte(byte x) {
        return this.constantInteger(x, 8);
    }

    public LLVMValueRef constantShort(short x) {
        return this.constantInteger(x, 16);
    }

    public LLVMValueRef constantChar(char x) {
        return this.constantInteger(x, 16);
    }

    public LLVMValueRef constantInt(int x) {
        return this.constantInteger(x, 32);
    }

    public LLVMValueRef constantLong(long x) {
        return this.constantInteger(x, 64);
    }

    public LLVMValueRef constantInteger(long value, int bits) {
        return LLVM.LLVMConstInt((LLVMTypeRef)this.integerType(bits), (long)value, (int)0);
    }

    public LLVMValueRef constantFloat(float x) {
        return LLVM.LLVMConstReal((LLVMTypeRef)this.floatType(), (double)x);
    }

    public LLVMValueRef constantDouble(double x) {
        return LLVM.LLVMConstReal((LLVMTypeRef)this.doubleType(), (double)x);
    }

    public LLVMValueRef constantNull(LLVMTypeRef type) {
        return LLVM.LLVMConstNull((LLVMTypeRef)type);
    }

    public LLVMValueRef buildGlobalStringPtr(String name) {
        return LLVM.LLVMBuildGlobalStringPtr((LLVMBuilderRef)this.builder, (String)name, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef constantString(String string) {
        return LLVM.LLVMConstStringInContext((LLVMContextRef)this.context, (String)string, (int)string.length(), (int)0);
    }

    public LLVMValueRef constantVector(LLVMValueRef ... values) {
        return LLVM.LLVMConstVector((PointerPointer)new PointerPointer((Pointer[])values), (int)values.length);
    }

    public LLVMValueRef getFunctionParam(int index) {
        return LLVMIRBuilder.getParam(this.function, index);
    }

    public static LLVMValueRef getParam(LLVMValueRef func, int index) {
        return LLVM.LLVMGetParam((LLVMValueRef)func, (int)index);
    }

    public LLVMValueRef buildPhi(LLVMTypeRef phiType, LLVMValueRef[] incomingValues, LLVMBasicBlockRef[] incomingBlocks) {
        LLVMValueRef phi = LLVM.LLVMBuildPhi((LLVMBuilderRef)this.builder, (LLVMTypeRef)phiType, (String)DEFAULT_INSTR_NAME);
        this.addIncoming(phi, incomingValues, incomingBlocks);
        return phi;
    }

    public void addIncoming(LLVMValueRef phi, LLVMValueRef[] values, LLVMBasicBlockRef[] blocks) {
        assert (values.length == blocks.length);
        LLVM.LLVMAddIncoming((LLVMValueRef)phi, (PointerPointer)new PointerPointer((Pointer[])values), (PointerPointer)new PointerPointer((Pointer[])blocks), (int)blocks.length);
    }

    public LLVMValueRef getExternalObject(String name, boolean compressed) {
        LLVMValueRef val = this.getGlobal(name);
        if (val == null) {
            val = LLVM.LLVMAddGlobalInAddressSpace((LLVMModuleRef)this.module, (LLVMTypeRef)this.objectType(compressed), (String)name, (int)LLVMIRBuilder.pointerAddressSpace(true, false));
            LLVMIRBuilder.setLinkage(val, LinkageType.External);
        }
        return val;
    }

    public LLVMValueRef getExternalSymbol(String name) {
        LLVMValueRef val = this.getGlobal(name);
        if (val == null) {
            val = LLVM.LLVMAddGlobalInAddressSpace((LLVMModuleRef)this.module, (LLVMTypeRef)this.rawPointerType(), (String)name, (int)0);
            LLVMIRBuilder.setLinkage(val, LinkageType.External);
        }
        return val;
    }

    public LLVMValueRef getUniqueGlobal(String name, LLVMTypeRef type, boolean zeroInitialized) {
        LLVMValueRef global = this.getGlobal(name);
        if (global == null) {
            global = LLVM.LLVMAddGlobalInAddressSpace((LLVMModuleRef)this.module, (LLVMTypeRef)type, (String)name, (int)LLVMIRBuilder.pointerAddressSpace(LLVMIRBuilder.isObjectType(type), false));
            if (zeroInitialized) {
                this.setInitializer(global, LLVM.LLVMConstNull((LLVMTypeRef)type));
            }
            LLVMIRBuilder.setLinkage(global, LinkageType.LinkOnceODR);
        }
        return global;
    }

    private LLVMValueRef getGlobal(String name) {
        return LLVM.LLVMGetNamedGlobal((LLVMModuleRef)this.module, (String)name);
    }

    public void setInitializer(LLVMValueRef global, LLVMValueRef value) {
        LLVM.LLVMSetInitializer((LLVMValueRef)global, (LLVMValueRef)value);
    }

    public LLVMValueRef register(String name) {
        String nameEncoding = name + "\u0000";
        LLVMValueRef[] vals = new LLVMValueRef[]{LLVM.LLVMMDStringInContext((LLVMContextRef)this.context, (String)nameEncoding, (int)nameEncoding.length())};
        return LLVM.LLVMMDNodeInContext((LLVMContextRef)this.context, (PointerPointer)new PointerPointer((Pointer[])vals), (int)vals.length);
    }

    public LLVMValueRef buildReadRegister(LLVMValueRef register) {
        LLVMTypeRef readRegisterType = this.functionType(this.wordType(), this.metadataType());
        return this.buildIntrinsicCall("llvm.read_register." + LLVMIRBuilder.intrinsicType(this.wordType()), readRegisterType, register);
    }

    public LLVMValueRef buildExtractValue(LLVMValueRef struct, int i) {
        return LLVM.LLVMBuildExtractValue((LLVMBuilderRef)this.builder, (LLVMValueRef)struct, (int)i, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildInsertValue(LLVMValueRef struct, int i, LLVMValueRef value) {
        return LLVM.LLVMBuildInsertValue((LLVMBuilderRef)this.builder, (LLVMValueRef)struct, (LLVMValueRef)value, (int)i, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildExtractElement(LLVMValueRef vector, LLVMValueRef index) {
        return LLVM.LLVMBuildExtractElement((LLVMBuilderRef)this.builder, (LLVMValueRef)vector, (LLVMValueRef)index, (String)DEFAULT_INSTR_NAME);
    }

    public void setFunctionMetadata(String kind, LLVMValueRef metadata) {
        this.setMetadata(this.function, kind, metadata);
    }

    public void setMetadata(LLVMValueRef instr, String kind, LLVMValueRef metadata) {
        LLVM.LLVMSetMetadata((LLVMValueRef)instr, (int)LLVM.LLVMGetMDKindIDInContext((LLVMContextRef)this.context, (String)kind, (int)kind.length()), (LLVMValueRef)metadata);
    }

    public void setValueName(LLVMValueRef value, String name) {
        LLVM.LLVMSetValueName((LLVMValueRef)value, (String)name);
    }

    public LLVMValueRef buildCall(LLVMValueRef callee, LLVMValueRef ... args) {
        return LLVM.LLVMBuildCall((LLVMBuilderRef)this.builder, (LLVMValueRef)callee, (PointerPointer)new PointerPointer((Pointer[])args), (int)args.length, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildInvoke(LLVMValueRef callee, LLVMBasicBlockRef successor, LLVMBasicBlockRef handler, LLVMValueRef ... args) {
        return LLVM.LLVMBuildInvoke((LLVMBuilderRef)this.builder, (LLVMValueRef)callee, (PointerPointer)new PointerPointer((Pointer[])args), (int)args.length, (LLVMBasicBlockRef)successor, (LLVMBasicBlockRef)handler, (String)DEFAULT_INSTR_NAME);
    }

    private LLVMValueRef buildIntrinsicCall(String name, LLVMTypeRef type, LLVMValueRef ... args) {
        LLVMValueRef intrinsic = this.getFunction(name, type);
        return this.buildCall(intrinsic, args);
    }

    public LLVMValueRef buildInlineAsm(LLVMTypeRef functionType, String asm, boolean hasSideEffects, boolean alignStack, InlineAssemblyConstraint ... constraints) {
        CharSequence[] constraintStrings = new String[constraints.length];
        for (int i = 0; i < constraints.length; ++i) {
            constraintStrings[i] = constraints[i].toString();
        }
        String constraintString = String.join((CharSequence)",", constraintStrings);
        return LLVM.LLVMConstInlineAsm((LLVMTypeRef)functionType, (String)asm, (String)constraintString, (int)(hasSideEffects ? 1 : 0), (int)(alignStack ? 1 : 0));
    }

    public void setCallSiteAttribute(LLVMValueRef call, Attribute attribute, String value) {
        LLVMAttributeRef attr = LLVM.LLVMCreateStringAttribute((LLVMContextRef)this.context, (String)attribute.name, (int)attribute.name.length(), (String)value, (int)value.length());
        LLVM.LLVMAddCallSiteAttribute((LLVMValueRef)call, (int)-1, (LLVMAttributeRef)attr);
    }

    public void setCallSiteAttribute(LLVMValueRef call, Attribute attribute) {
        int kind = LLVM.LLVMGetEnumAttributeKindForName((String)attribute.name, (long)attribute.name.length());
        if (kind != 0) {
            LLVMAttributeRef attr = LLVM.LLVMCreateEnumAttribute((LLVMContextRef)this.context, (int)kind, (long)1L);
            LLVM.LLVMAddCallSiteAttribute((LLVMValueRef)call, (int)-1, (LLVMAttributeRef)attr);
        } else {
            this.setCallSiteAttribute(call, attribute, "true");
        }
    }

    public void buildRetVoid() {
        LLVM.LLVMBuildRetVoid((LLVMBuilderRef)this.builder);
    }

    public void buildRet(LLVMValueRef value) {
        LLVM.LLVMBuildRet((LLVMBuilderRef)this.builder, (LLVMValueRef)value);
    }

    public void buildBranch(LLVMBasicBlockRef block) {
        LLVM.LLVMBuildBr((LLVMBuilderRef)this.builder, (LLVMBasicBlockRef)block);
    }

    public LLVMValueRef buildIf(LLVMValueRef condition, LLVMBasicBlockRef thenBlock, LLVMBasicBlockRef elseBlock) {
        return LLVM.LLVMBuildCondBr((LLVMBuilderRef)this.builder, (LLVMValueRef)condition, (LLVMBasicBlockRef)thenBlock, (LLVMBasicBlockRef)elseBlock);
    }

    public LLVMValueRef buildSwitch(LLVMValueRef value, LLVMBasicBlockRef defaultBlock, LLVMValueRef[] switchValues, LLVMBasicBlockRef[] switchBlocks) {
        assert (switchValues.length == switchBlocks.length);
        LLVMValueRef switchVal = LLVM.LLVMBuildSwitch((LLVMBuilderRef)this.builder, (LLVMValueRef)value, (LLVMBasicBlockRef)defaultBlock, (int)switchBlocks.length);
        for (int i = 0; i < switchBlocks.length; ++i) {
            LLVM.LLVMAddCase((LLVMValueRef)switchVal, (LLVMValueRef)switchValues[i], (LLVMBasicBlockRef)switchBlocks[i]);
        }
        return switchVal;
    }

    public void buildLandingPad() {
        LLVMValueRef landingPad = LLVM.LLVMBuildLandingPad((LLVMBuilderRef)this.builder, (LLVMTypeRef)this.tokenType(), null, (int)1, (String)DEFAULT_INSTR_NAME);
        LLVM.LLVMAddClause((LLVMValueRef)landingPad, (LLVMValueRef)this.constantNull(this.rawPointerType()));
    }

    public void buildStackmap(LLVMValueRef patchpointId, LLVMValueRef ... liveValues) {
        LLVMTypeRef stackmapType = this.functionType(this.voidType(), true, this.longType(), this.intType());
        LLVMValueRef[] allArgs = new LLVMValueRef[2 + liveValues.length];
        allArgs[0] = patchpointId;
        allArgs[1] = this.constantInt(0);
        System.arraycopy(liveValues, 0, allArgs, 2, liveValues.length);
        this.buildIntrinsicCall("llvm.experimental.stackmap", stackmapType, allArgs);
    }

    public void buildUnreachable() {
        LLVM.LLVMBuildUnreachable((LLVMBuilderRef)this.builder);
    }

    public void buildDebugtrap() {
        this.buildIntrinsicCall("llvm.debugtrap", this.functionType(this.voidType(), new LLVMTypeRef[0]), new LLVMValueRef[0]);
    }

    public LLVMValueRef functionEntryCount(LLVMValueRef count) {
        String functionEntryCountName = "function_entry_count";
        LLVMValueRef[] values = new LLVMValueRef[]{LLVM.LLVMMDStringInContext((LLVMContextRef)this.context, (String)functionEntryCountName, (int)functionEntryCountName.length()), count};
        return LLVM.LLVMMDNodeInContext((LLVMContextRef)this.context, (PointerPointer)new PointerPointer((Pointer[])values), (int)values.length);
    }

    public LLVMValueRef branchWeights(LLVMValueRef ... weights) {
        String branchWeightsName = "branch_weights";
        LLVMValueRef[] values = new LLVMValueRef[weights.length + 1];
        values[0] = LLVM.LLVMMDStringInContext((LLVMContextRef)this.context, (String)branchWeightsName, (int)branchWeightsName.length());
        System.arraycopy(weights, 0, values, 1, weights.length);
        return LLVM.LLVMMDNodeInContext((LLVMContextRef)this.context, (PointerPointer)new PointerPointer((Pointer[])values), (int)values.length);
    }

    public LLVMValueRef buildIsNull(LLVMValueRef value) {
        return LLVM.LLVMBuildIsNull((LLVMBuilderRef)this.builder, (LLVMValueRef)value, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildCompare(Condition cond, LLVMValueRef a, LLVMValueRef b, boolean unordered) {
        LLVMTypeRef aType = LLVM.LLVMTypeOf((LLVMValueRef)a);
        LLVMTypeRef bType = LLVM.LLVMTypeOf((LLVMValueRef)b);
        assert (LLVMIRBuilder.compatibleTypes(aType, bType)) : LLVMUtils.dumpTypes("comparison", aType, bType);
        switch (LLVM.LLVMGetTypeKind((LLVMTypeRef)aType)) {
            case 8: 
            case 12: {
                return this.buildICmp(cond, a, b);
            }
            case 2: 
            case 3: {
                return this.buildFCmp(cond, a, b, unordered);
            }
        }
        throw GraalError.shouldNotReachHere((String)LLVMUtils.dumpTypes("comparison", aType, bType));
    }

    public LLVMValueRef buildICmp(Condition cond, LLVMValueRef a, LLVMValueRef b) {
        int conditionCode;
        switch (cond) {
            case EQ: {
                conditionCode = 32;
                break;
            }
            case NE: {
                conditionCode = 33;
                break;
            }
            case LT: {
                conditionCode = 40;
                break;
            }
            case LE: {
                conditionCode = 41;
                break;
            }
            case GT: {
                conditionCode = 38;
                break;
            }
            case GE: {
                conditionCode = 39;
                break;
            }
            case AE: {
                conditionCode = 35;
                break;
            }
            case BE: {
                conditionCode = 37;
                break;
            }
            case AT: {
                conditionCode = 34;
                break;
            }
            case BT: {
                conditionCode = 36;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)"invalid condition");
            }
        }
        return LLVM.LLVMBuildICmp((LLVMBuilderRef)this.builder, (int)conditionCode, (LLVMValueRef)a, (LLVMValueRef)b, (String)DEFAULT_INSTR_NAME);
    }

    private LLVMValueRef buildFCmp(Condition cond, LLVMValueRef a, LLVMValueRef b, boolean unordered) {
        int conditionCode;
        switch (cond) {
            case EQ: {
                conditionCode = unordered ? 9 : 1;
                break;
            }
            case NE: {
                conditionCode = unordered ? 14 : 6;
                break;
            }
            case LT: {
                conditionCode = unordered ? 12 : 4;
                break;
            }
            case LE: {
                conditionCode = unordered ? 13 : 5;
                break;
            }
            case GT: {
                conditionCode = unordered ? 10 : 2;
                break;
            }
            case GE: {
                conditionCode = unordered ? 11 : 3;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)"invalid condition");
            }
        }
        return LLVM.LLVMBuildFCmp((LLVMBuilderRef)this.builder, (int)conditionCode, (LLVMValueRef)a, (LLVMValueRef)b, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildSelect(LLVMValueRef condition, LLVMValueRef trueVal, LLVMValueRef falseVal) {
        return LLVM.LLVMBuildSelect((LLVMBuilderRef)this.builder, (LLVMValueRef)condition, (LLVMValueRef)trueVal, (LLVMValueRef)falseVal, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildNeg(LLVMValueRef a) {
        UnaryBuilder unaryBuilder;
        LLVMTypeRef type = LLVM.LLVMTypeOf((LLVMValueRef)a);
        switch (LLVM.LLVMGetTypeKind((LLVMTypeRef)type)) {
            case 8: {
                unaryBuilder = LLVM::LLVMBuildNeg;
                break;
            }
            case 2: 
            case 3: {
                unaryBuilder = LLVM::LLVMBuildFNeg;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)LLVMUtils.dumpTypes("invalid negation type", type));
            }
        }
        return unaryBuilder.build(this.builder, a, DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildAdd(LLVMValueRef a, LLVMValueRef b) {
        return this.buildBinaryNumberOp(a, b, LLVM::LLVMBuildAdd, LLVM::LLVMBuildFAdd);
    }

    public LLVMValueRef buildSub(LLVMValueRef a, LLVMValueRef b) {
        return this.buildBinaryNumberOp(a, b, LLVM::LLVMBuildSub, LLVM::LLVMBuildFSub);
    }

    public LLVMValueRef buildMul(LLVMValueRef a, LLVMValueRef b) {
        return this.buildBinaryNumberOp(a, b, LLVM::LLVMBuildMul, LLVM::LLVMBuildFMul);
    }

    public LLVMValueRef buildDiv(LLVMValueRef a, LLVMValueRef b) {
        return this.buildBinaryNumberOp(a, b, LLVM::LLVMBuildSDiv, LLVM::LLVMBuildFDiv);
    }

    public LLVMValueRef buildRem(LLVMValueRef a, LLVMValueRef b) {
        return this.buildBinaryNumberOp(a, b, LLVM::LLVMBuildSRem, LLVM::LLVMBuildFRem);
    }

    public LLVMValueRef buildUDiv(LLVMValueRef a, LLVMValueRef b) {
        return this.buildBinaryNumberOp(a, b, LLVM::LLVMBuildUDiv, null);
    }

    public LLVMValueRef buildURem(LLVMValueRef a, LLVMValueRef b) {
        return this.buildBinaryNumberOp(a, b, LLVM::LLVMBuildURem, null);
    }

    private LLVMValueRef buildBinaryNumberOp(LLVMValueRef a, LLVMValueRef b, BinaryBuilder integerBuilder, BinaryBuilder realBuilder) {
        BinaryBuilder binaryBuilder;
        LLVMTypeRef aType = LLVM.LLVMTypeOf((LLVMValueRef)a);
        LLVMTypeRef bType = LLVM.LLVMTypeOf((LLVMValueRef)b);
        assert (LLVMIRBuilder.compatibleTypes(aType, bType)) : LLVMUtils.dumpValues("invalid binary operation arguments", a, b);
        switch (LLVM.LLVMGetTypeKind((LLVMTypeRef)aType)) {
            case 8: {
                binaryBuilder = integerBuilder;
                break;
            }
            case 2: 
            case 3: {
                binaryBuilder = realBuilder;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)LLVMUtils.dumpValues("invalid binary operation arguments", a, b));
            }
        }
        return binaryBuilder.build(this.builder, a, b, DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildAbs(LLVMValueRef a) {
        return this.buildIntrinsicOp("fabs", a);
    }

    public LLVMValueRef buildLog(LLVMValueRef a) {
        return this.buildIntrinsicOp("log", a);
    }

    public LLVMValueRef buildLog10(LLVMValueRef a) {
        return this.buildIntrinsicOp("log10", a);
    }

    public LLVMValueRef buildSqrt(LLVMValueRef a) {
        return this.buildIntrinsicOp("sqrt", a);
    }

    public LLVMValueRef buildCos(LLVMValueRef a) {
        return this.buildIntrinsicOp("cos", a);
    }

    public LLVMValueRef buildSin(LLVMValueRef a) {
        return this.buildIntrinsicOp("sin", a);
    }

    public LLVMValueRef buildExp(LLVMValueRef a) {
        return this.buildIntrinsicOp("exp", a);
    }

    public LLVMValueRef buildPow(LLVMValueRef a, LLVMValueRef b) {
        return this.buildIntrinsicOp("pow", a, b);
    }

    public LLVMValueRef buildCeil(LLVMValueRef a) {
        return this.buildIntrinsicOp("ceil", a);
    }

    public LLVMValueRef buildFloor(LLVMValueRef a) {
        return this.buildIntrinsicOp("floor", a);
    }

    public LLVMValueRef buildMin(LLVMValueRef a, LLVMValueRef b) {
        return this.buildIntrinsicOp("minimum", a, b);
    }

    public LLVMValueRef buildMax(LLVMValueRef a, LLVMValueRef b) {
        return this.buildIntrinsicOp("maximum", a, b);
    }

    public LLVMValueRef buildCopysign(LLVMValueRef a, LLVMValueRef b) {
        return this.buildIntrinsicOp("copysign", a, b);
    }

    public LLVMValueRef buildFma(LLVMValueRef a, LLVMValueRef b, LLVMValueRef c) {
        return this.buildIntrinsicOp("fma", a, b, c);
    }

    public LLVMValueRef buildBswap(LLVMValueRef a) {
        return this.buildIntrinsicOp("bswap", a);
    }

    private LLVMValueRef buildIntrinsicOp(String name, LLVMTypeRef retType, LLVMValueRef ... args) {
        String intrinsicName = "llvm." + name + "." + LLVMIRBuilder.intrinsicType(retType);
        LLVMTypeRef intrinsicType = this.functionType(retType, (LLVMTypeRef[])Arrays.stream(args).map(LLVM::LLVMTypeOf).toArray(LLVMTypeRef[]::new));
        return this.buildIntrinsicCall(intrinsicName, intrinsicType, args);
    }

    private LLVMValueRef buildIntrinsicOp(String name, LLVMValueRef ... args) {
        return this.buildIntrinsicOp(name, LLVM.LLVMTypeOf((LLVMValueRef)args[0]), args);
    }

    public LLVMValueRef buildNot(LLVMValueRef input) {
        return LLVM.LLVMBuildNot((LLVMBuilderRef)this.builder, (LLVMValueRef)input, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildAnd(LLVMValueRef a, LLVMValueRef b) {
        return LLVM.LLVMBuildAnd((LLVMBuilderRef)this.builder, (LLVMValueRef)a, (LLVMValueRef)b, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildOr(LLVMValueRef a, LLVMValueRef b) {
        return LLVM.LLVMBuildOr((LLVMBuilderRef)this.builder, (LLVMValueRef)a, (LLVMValueRef)b, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildXor(LLVMValueRef a, LLVMValueRef b) {
        return LLVM.LLVMBuildXor((LLVMBuilderRef)this.builder, (LLVMValueRef)a, (LLVMValueRef)b, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildShl(LLVMValueRef a, LLVMValueRef b) {
        return this.buildShift(LLVM::LLVMBuildShl, a, b);
    }

    public LLVMValueRef buildShr(LLVMValueRef a, LLVMValueRef b) {
        return this.buildShift(LLVM::LLVMBuildAShr, a, b);
    }

    public LLVMValueRef buildUShr(LLVMValueRef a, LLVMValueRef b) {
        return this.buildShift(LLVM::LLVMBuildLShr, a, b);
    }

    private LLVMValueRef buildShift(BinaryBuilder binaryBuilder, LLVMValueRef a, LLVMValueRef b) {
        return binaryBuilder.build(this.builder, a, b, DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildCtlz(LLVMValueRef a) {
        return this.buildIntrinsicOp("ctlz", a, this.constantBoolean(false));
    }

    public LLVMValueRef buildCttz(LLVMValueRef a) {
        return this.buildIntrinsicOp("cttz", a, this.constantBoolean(false));
    }

    public LLVMValueRef buildCtpop(LLVMValueRef a) {
        return this.buildIntrinsicOp("ctpop", a);
    }

    public LLVMValueRef buildBitcast(LLVMValueRef value, LLVMTypeRef type) {
        LLVMTypeRef valueType = LLVM.LLVMTypeOf((LLVMValueRef)value);
        if (LLVMIRBuilder.compatibleTypes(valueType, type)) {
            return value;
        }
        return LLVM.LLVMBuildBitCast((LLVMBuilderRef)this.builder, (LLVMValueRef)value, (LLVMTypeRef)type, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildAddrSpaceCast(LLVMValueRef value, LLVMTypeRef type) {
        return LLVM.LLVMBuildAddrSpaceCast((LLVMBuilderRef)this.builder, (LLVMValueRef)value, (LLVMTypeRef)type, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildIntToPtr(LLVMValueRef value, LLVMTypeRef type) {
        if (LLVMIRBuilder.isObjectType(type)) {
            return this.buildCall(this.helpers.getIntToObjectFunction(LLVMIRBuilder.isCompressedPointerType(type)), value);
        }
        return this.buildLLVMIntToPtr(value, type);
    }

    LLVMValueRef buildLLVMIntToPtr(LLVMValueRef value, LLVMTypeRef type) {
        return LLVM.LLVMBuildIntToPtr((LLVMBuilderRef)this.builder, (LLVMValueRef)value, (LLVMTypeRef)type, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildPtrToInt(LLVMValueRef value) {
        return LLVM.LLVMBuildPtrToInt((LLVMBuilderRef)this.builder, (LLVMValueRef)value, (LLVMTypeRef)this.wordType(), (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildFPToSI(LLVMValueRef value, LLVMTypeRef type) {
        return LLVM.LLVMBuildFPToSI((LLVMBuilderRef)this.builder, (LLVMValueRef)value, (LLVMTypeRef)type, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildSIToFP(LLVMValueRef value, LLVMTypeRef type) {
        return LLVM.LLVMBuildSIToFP((LLVMBuilderRef)this.builder, (LLVMValueRef)value, (LLVMTypeRef)type, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildFPCast(LLVMValueRef value, LLVMTypeRef type) {
        return LLVM.LLVMBuildFPCast((LLVMBuilderRef)this.builder, (LLVMValueRef)value, (LLVMTypeRef)type, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildTrunc(LLVMValueRef value, int toBits) {
        return LLVM.LLVMBuildTrunc((LLVMBuilderRef)this.builder, (LLVMValueRef)value, (LLVMTypeRef)this.integerType(toBits), (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildSExt(LLVMValueRef value, int toBits) {
        return LLVM.LLVMBuildSExt((LLVMBuilderRef)this.builder, (LLVMValueRef)value, (LLVMTypeRef)this.integerType(toBits), (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildZExt(LLVMValueRef value, int toBits) {
        return LLVM.LLVMBuildZExt((LLVMBuilderRef)this.builder, (LLVMValueRef)value, (LLVMTypeRef)this.integerType(toBits), (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildCompress(LLVMValueRef uncompressed, LLVMValueRef heapBase, boolean nonNull, int shift) {
        return this.buildCall(this.helpers.getCompressFunction(nonNull, shift), uncompressed, heapBase);
    }

    public LLVMValueRef buildUncompress(LLVMValueRef compressed, LLVMValueRef heapBase, boolean nonNull, int shift) {
        return this.buildCall(this.helpers.getUncompressFunction(nonNull, shift), compressed, heapBase);
    }

    public LLVMValueRef buildGEP(LLVMValueRef base, LLVMValueRef ... indices) {
        return LLVM.LLVMBuildGEP((LLVMBuilderRef)this.builder, (LLVMValueRef)base, (PointerPointer)new PointerPointer((Pointer[])indices), (int)indices.length, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildLoad(LLVMValueRef address, LLVMTypeRef type) {
        LLVMTypeRef addressType = LLVM.LLVMTypeOf((LLVMValueRef)address);
        if (LLVMIRBuilder.isObjectType(type) && !LLVMIRBuilder.isObjectType(addressType)) {
            boolean compressed = LLVMIRBuilder.isCompressedPointerType(type);
            return this.buildCall(this.helpers.getLoadObjectFromUntrackedPointerFunction(compressed), address);
        }
        LLVMValueRef castedAddress = this.buildBitcast(address, this.pointerType(type, LLVMIRBuilder.isObjectType(addressType), false));
        return this.buildLoad(castedAddress);
    }

    public LLVMValueRef buildLoad(LLVMValueRef address) {
        return LLVM.LLVMBuildLoad((LLVMBuilderRef)this.builder, (LLVMValueRef)address, (String)DEFAULT_INSTR_NAME);
    }

    public void buildStore(LLVMValueRef value, LLVMValueRef address) {
        LLVM.LLVMBuildStore((LLVMBuilderRef)this.builder, (LLVMValueRef)value, (LLVMValueRef)address);
    }

    public void buildVolatileStore(LLVMValueRef value, LLVMValueRef address, int alignment) {
        LLVMValueRef store = LLVM.LLVMBuildStore((LLVMBuilderRef)this.builder, (LLVMValueRef)value, (LLVMValueRef)address);
        LLVM.LLVMSetOrdering((LLVMValueRef)store, (int)5);
        LLVM.LLVMSetAlignment((LLVMValueRef)store, (int)alignment);
    }

    public LLVMValueRef buildAlloca(LLVMTypeRef type) {
        return LLVM.LLVMBuildAlloca((LLVMBuilderRef)this.builder, (LLVMTypeRef)type, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildArrayAlloca(LLVMTypeRef type, int slots) {
        return LLVM.LLVMBuildArrayAlloca((LLVMBuilderRef)this.builder, (LLVMTypeRef)type, (LLVMValueRef)this.constantInt(slots), (String)DEFAULT_INSTR_NAME);
    }

    public void buildPrefetch(LLVMValueRef address) {
        LLVMTypeRef prefetchType = this.functionType(this.voidType(), LLVM.LLVMTypeOf((LLVMValueRef)address), this.intType(), this.intType(), this.intType());
        this.buildIntrinsicCall("llvm.prefetch", prefetchType, address, this.constantInt(1), this.constantInt(0), this.constantInt(1));
    }

    public LLVMValueRef buildReturnAddress(LLVMValueRef level) {
        LLVMTypeRef returnAddressType = this.functionType(this.rawPointerType(), this.intType());
        return this.buildIntrinsicCall("llvm.returnaddress", returnAddressType, level);
    }

    public LLVMValueRef buildFrameAddress(LLVMValueRef level) {
        LLVMTypeRef frameAddressType = this.functionType(this.rawPointerType(), this.intType());
        return this.buildIntrinsicCall("llvm.frameaddress", frameAddressType, level);
    }

    public void buildFence() {
        LLVM.LLVMBuildFence((LLVMBuilderRef)this.builder, (int)7, (int)0, (String)DEFAULT_INSTR_NAME);
    }

    public LLVMValueRef buildCmpxchg(LLVMValueRef address, LLVMValueRef expectedValue, LLVMValueRef newValue, boolean returnValue) {
        LLVMTypeRef exchangeType = LLVMIRBuilder.typeOf(expectedValue);
        if (returnValue && LLVMIRBuilder.isObjectType(LLVMIRBuilder.typeOf(expectedValue))) {
            return this.buildCall(this.helpers.getCmpxchgFunction(LLVMIRBuilder.isCompressedPointerType(exchangeType)), address, expectedValue, newValue);
        }
        return this.buildAtomicCmpXchg(address, expectedValue, newValue, returnValue);
    }

    LLVMValueRef buildAtomicCmpXchg(LLVMValueRef addr, LLVMValueRef expected, LLVMValueRef newVal, boolean returnValue) {
        LLVMValueRef cas = LLVM.LLVMBuildAtomicCmpXchg((LLVMBuilderRef)this.builder, (LLVMValueRef)addr, (LLVMValueRef)expected, (LLVMValueRef)newVal, (int)2, (int)2, (int)0);
        return this.buildExtractValue(cas, returnValue ? 0 : 1);
    }

    public LLVMValueRef buildAtomicXchg(LLVMValueRef address, LLVMValueRef value) {
        if (LLVMIRBuilder.isObjectType(LLVMIRBuilder.typeOf(value))) {
            boolean compressed = LLVMIRBuilder.isCompressedPointerType(LLVMIRBuilder.typeOf(value));
            return this.buildCall(this.helpers.getAtomicObjectXchgFunction(compressed), address, value);
        }
        return this.buildLLVMAtomicXchg(address, value);
    }

    LLVMValueRef buildLLVMAtomicXchg(LLVMValueRef address, LLVMValueRef value) {
        return this.buildAtomicRMW(0, address, value);
    }

    public LLVMValueRef buildAtomicAdd(LLVMValueRef address, LLVMValueRef value) {
        return this.buildAtomicRMW(1, address, value);
    }

    private LLVMValueRef buildAtomicRMW(int operation, LLVMValueRef address, LLVMValueRef value) {
        LLVMTypeRef valueType = LLVM.LLVMTypeOf((LLVMValueRef)value);
        LLVMValueRef castedAddress = this.buildBitcast(address, this.pointerType(valueType, LLVMIRBuilder.isObjectType(LLVMIRBuilder.typeOf(address)), false));
        return LLVM.LLVMBuildAtomicRMW((LLVMBuilderRef)this.builder, (int)operation, (LLVMValueRef)castedAddress, (LLVMValueRef)value, (int)2, (int)0);
    }

    private static interface BinaryBuilder {
        public LLVMValueRef build(LLVMBuilderRef var1, LLVMValueRef var2, LLVMValueRef var3, String var4);
    }

    private static interface UnaryBuilder {
        public LLVMValueRef build(LLVMBuilderRef var1, LLVMValueRef var2, String var3);
    }

    public static class InlineAssemblyConstraint {
        private Type type;
        private Location location;

        public InlineAssemblyConstraint(Type type, Location location) {
            this.type = type;
            this.location = location;
        }

        public String toString() {
            return this.type.repr + this.location.repr;
        }

        public static final class Location {
            private String repr;

            private Location(String repr) {
                this.repr = repr;
            }

            public static Location register() {
                return new Location("r");
            }

            public static Location namedRegister(String register) {
                return new Location("{" + register + "}");
            }
        }

        public static enum Type {
            Output("="),
            Input("");

            private String repr;

            private Type(String repr) {
                this.repr = repr;
            }
        }
    }

    public static enum GCStrategy {
        CompressedPointers("compressed-pointer");

        private String name;

        private GCStrategy(String name) {
            this.name = name;
        }
    }

    public static enum Attribute {
        AlwaysInline("alwaysinline"),
        GCLeafFunction("gc-leaf-function"),
        Naked("naked"),
        NoInline("noinline"),
        NoRealignStack("no-realign-stack"),
        NoRedZone("noredzone"),
        StatepointID("statepoint-id");

        private String name;

        private Attribute(String name) {
            this.name = name;
        }
    }

    public static enum LinkageType {
        External(0),
        LinkOnce(2),
        LinkOnceODR(3);

        private int code;

        private LinkageType(int code) {
            this.code = code;
        }
    }
}

