/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.runtime;

import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.VMError;
import java.util.Arrays;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.Pointer;

class GCCExceptionTable {
    GCCExceptionTable() {
    }

    static Long getHandlerOffset(Pointer buffer, long pcOffset) {
        Log log = Log.noopLog();
        CIntPointer offset = (CIntPointer)StackValue.get((int)4);
        offset.write(0);
        int header = Byte.toUnsignedInt(buffer.readByte(offset.read()));
        offset.write(offset.read() + 1);
        log.string("header: ").hex(header).newline();
        assert (header == 255);
        int typeEncodingEncoding = Byte.toUnsignedInt(buffer.readByte(offset.read()));
        offset.write(offset.read() + 1);
        log.string("typeEncodingEncoding: ").hex(typeEncodingEncoding).newline();
        long typeBaseOffset = GCCExceptionTable.getULSB(buffer, offset);
        long typeEnd = typeBaseOffset + (long)offset.read();
        log.string("typeBaseOffset: ").unsigned(typeBaseOffset).string(", typeEnd: ").unsigned(typeEnd).newline();
        int siteEncodingEncoding = Byte.toUnsignedInt(buffer.readByte(offset.read()));
        offset.write(offset.read() + 1);
        log.string("siteEncodingEncoding: ").hex(siteEncodingEncoding).newline();
        Encoding siteEncoding = Encoding.parse(siteEncodingEncoding);
        long siteTableLength = GCCExceptionTable.getULSB(buffer, offset);
        log.string("siteTableLength: ").signed(siteTableLength).newline();
        long siteTableEnd = (long)offset.read() + siteTableLength;
        log.string("siteTableEnd: ").signed(siteTableEnd).newline();
        while ((long)offset.read() < siteTableEnd) {
            long startOffset = GCCExceptionTable.get(buffer, siteEncoding, offset);
            long size = GCCExceptionTable.get(buffer, siteEncoding, offset);
            long handlerOffset = GCCExceptionTable.get(buffer, siteEncoding, offset);
            log.string("start: ").unsigned(startOffset).string(", size: ").unsigned(size).string(", handlerOffset: ").unsigned(handlerOffset).newline();
            if (startOffset <= pcOffset && startOffset + size >= pcOffset) {
                return handlerOffset;
            }
            int action = Byte.toUnsignedInt(buffer.readByte(offset.read()));
            offset.write(offset.read() + 1);
            log.string("action: ").unsigned(action).newline();
            assert (action == 0 || action == 1);
            assert ((long)offset.read() <= siteTableEnd);
        }
        return null;
    }

    private static long getULSB(Pointer buffer, CIntPointer offset) {
        byte read;
        long result = 0L;
        int shift = 0;
        do {
            read = buffer.readByte(offset.read());
            offset.write(offset.read() + 1);
            result |= (long)((read & 0x7F) << shift);
            shift += 7;
        } while ((read & 0x80) != 0);
        return result;
    }

    private static long get(Pointer buffer, Encoding encoding, CIntPointer offset) {
        switch (encoding) {
            case ULEB128: {
                return GCCExceptionTable.getULSB(buffer, offset);
            }
            case UDATA4: {
                int result = buffer.readInt(offset.read());
                offset.write(offset.read() + 4);
                return result;
            }
        }
        throw VMError.shouldNotReachHere();
    }

    static enum Encoding {
        ULEB128(1),
        UDATA2(2),
        UDATA4(3),
        UDATA8(4),
        SLEB128(9),
        SDATA2(10),
        SDATA4(11),
        SDATA8(12);

        byte encoding;
        static Encoding[] lookupTable;

        private Encoding(byte encoding) {
            this.encoding = encoding;
        }

        static Encoding parse(int encodingEncoding) {
            if (encodingEncoding < 0 || encodingEncoding >= lookupTable.length) {
                return null;
            }
            return lookupTable[encodingEncoding];
        }

        static {
            lookupTable = new Encoding[16];
            Arrays.stream(Encoding.values()).forEach(value -> {
                Encoding.lookupTable[value.encoding] = value;
            });
        }
    }
}

