/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.replacements;

import com.oracle.svm.core.graal.llvm.replacements.LLVMCopySignNode;
import com.oracle.svm.core.graal.llvm.replacements.LLVMIntrinsicGenerator;
import com.oracle.svm.core.graal.llvm.replacements.LLVMIntrinsicNode;
import com.oracle.svm.core.graal.llvm.replacements.LLVMMaxNode;
import com.oracle.svm.core.graal.llvm.replacements.LLVMMinNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo
public abstract class LLVMBinaryIntrinsicNode
extends LLVMIntrinsicNode {
    public static final NodeClass<LLVMBinaryIntrinsicNode> TYPE = NodeClass.create(LLVMBinaryIntrinsicNode.class);
    @Node.Input
    private ValueNode arg1;
    @Node.Input
    private ValueNode arg2;

    public LLVMBinaryIntrinsicNode(NodeClass<? extends LLVMIntrinsicNode> c, LLVMIntrinsicNode.LLVMIntrinsicOperation op, JavaKind kind, ValueNode arg1, ValueNode arg2) {
        super(c, op, kind);
        this.arg1 = arg1;
        this.arg2 = arg2;
    }

    public static ConstantNode tryFold(LLVMIntrinsicNode.LLVMIntrinsicOperation op, ValueNode arg1, ValueNode arg2) {
        if (arg1.isConstant() && arg2.isConstant()) {
            JavaConstant constantArg1 = arg1.asJavaConstant();
            JavaConstant constantArg2 = arg2.asJavaConstant();
            switch (op) {
                case MIN: {
                    return LLVMMinNode.fold(constantArg1, constantArg2);
                }
                case MAX: {
                    return LLVMMaxNode.fold(constantArg1, constantArg2);
                }
                case COPYSIGN: {
                    return LLVMCopySignNode.fold(constantArg1, constantArg2);
                }
            }
        }
        return null;
    }

    static LLVMBinaryIntrinsicNode factory(LLVMIntrinsicNode.LLVMIntrinsicOperation op, JavaKind kind, ValueNode arg1, ValueNode arg2) {
        switch (op) {
            case MIN: {
                return new LLVMMinNode(kind, arg1, arg2);
            }
            case MAX: {
                return new LLVMMaxNode(kind, arg1, arg2);
            }
            case COPYSIGN: {
                return new LLVMCopySignNode(kind, arg1, arg2);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public Node canonical(CanonicalizerTool tool) {
        ConstantNode folded = LLVMBinaryIntrinsicNode.tryFold(this.op, this.arg1, this.arg2);
        return folded != null ? folded : this;
    }

    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult((ValueNode)this, this.emitIntrinsic((LLVMIntrinsicGenerator)gen, builder.operand((Node)this.arg1), builder.operand((Node)this.arg2)));
    }

    protected abstract Value emitIntrinsic(LLVMIntrinsicGenerator var1, Value var2, Value var3);
}

