/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm.lowering;

import com.oracle.svm.core.graal.nodes.ExceptionStateNode;
import com.oracle.svm.core.graal.nodes.ReadExceptionObjectNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.LoadExceptionObjectNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;

public class LLVMLoadExceptionObjectLowering
implements NodeLoweringProvider<LoadExceptionObjectNode> {
    public void lower(LoadExceptionObjectNode node, LoweringTool tool) {
        FrameState exceptionState = node.stateAfter();
        assert (exceptionState != null);
        StructuredGraph graph = node.graph();
        FixedWithNextNode readRegNode = (FixedWithNextNode)graph.add((Node)new ReadExceptionObjectNode(StampFactory.objectNonNull()));
        graph.replaceFixedWithFixed((FixedWithNextNode)node, readRegNode);
        CFunctionEpilogueNode cFunctionEpilogueNode = new CFunctionEpilogueNode(3);
        graph.add((Node)cFunctionEpilogueNode);
        graph.addAfterFixed(readRegNode, (FixedNode)cFunctionEpilogueNode);
        cFunctionEpilogueNode.setStateAfter(exceptionState);
        cFunctionEpilogueNode.lower(tool);
        graph.addAfterFixed(readRegNode, (FixedNode)graph.add((Node)new ExceptionStateNode(exceptionState)));
    }
}

