/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.llvm;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SectionName;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.graal.llvm.util.LLVMObjectFileReader;
import com.oracle.svm.core.graal.llvm.util.LLVMOptions;
import com.oracle.svm.core.graal.llvm.util.LLVMStackMapInfo;
import com.oracle.svm.core.graal.llvm.util.LLVMTargetSpecific;
import com.oracle.svm.core.graal.llvm.util.LLVMToolchain;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.NativeBootImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.MethodPointer;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class LLVMNativeImageCodeCache
extends NativeImageCodeCache {
    private HostedMethod[] methodIndex;
    private final Path basePath;
    private int batchSize;
    private final LLVMObjectFileReader objectFileReader;
    private final List<ObjectFile.Symbol> globalSymbols = new ArrayList<ObjectFile.Symbol>();
    private final StackMapDumper stackMapDumper;

    LLVMNativeImageCodeCache(Map<HostedMethod, CompilationResult> compilations, NativeImageHeap imageHeap, Platform targetPlatform, Path tempDir) {
        super(compilations, imageHeap, targetPlatform);
        try {
            this.basePath = tempDir.resolve("llvm");
            Files.createDirectory(this.basePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new GraalError((Throwable)e);
        }
        this.stackMapDumper = this.getStackMapDumper(LLVMOptions.DumpLLVMStackMap.hasBeenSet());
        this.objectFileReader = new LLVMObjectFileReader(this.stackMapDumper);
    }

    public int getCodeCacheSize() {
        return 0;
    }

    public void layoutMethods(DebugContext debug, String imageName, BigBang bb, ForkJoinPool threadPool) {
        try (Indent indent = debug.logAndIndent("layout methods");){
            int numBatches;
            BatchExecutor executor = new BatchExecutor(bb, threadPool);
            try (Timer.StopTimer t = new Timer(imageName, "(bitcode)").start();){
                this.writeBitcode(executor);
            }
            try (Timer.StopTimer t = new Timer(imageName, "(prelink)").start();){
                numBatches = this.createBitcodeBatches(executor, debug);
            }
            t = new Timer(imageName, "(llvm)").start();
            var10_15 = null;
            try {
                this.compileBitcodeBatches(executor, debug, numBatches);
            }
            catch (Throwable throwable) {
                var10_15 = throwable;
                throw throwable;
            }
            finally {
                if (t != null) {
                    if (var10_15 != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable) {
                            var10_15.addSuppressed(throwable);
                        }
                    } else {
                        t.close();
                    }
                }
            }
            t = new Timer(imageName, "(postlink)").start();
            var10_15 = null;
            try {
                this.linkCompiledBatches(executor, debug, numBatches);
            }
            catch (Throwable throwable) {
                var10_15 = throwable;
                throw throwable;
            }
            finally {
                if (t != null) {
                    if (var10_15 != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable) {
                            var10_15.addSuppressed(throwable);
                        }
                    } else {
                        t.close();
                    }
                }
            }
        }
    }

    private void writeBitcode(BatchExecutor executor) {
        this.methodIndex = new HostedMethod[this.compilations.size()];
        UninterruptibleUtils.AtomicInteger num = new UninterruptibleUtils.AtomicInteger(-1);
        executor.forEach(this.compilations.entrySet(), entry -> debugContext -> {
            int id = num.incrementAndGet();
            this.methodIndex[id] = (HostedMethod)entry.getKey();
            try (FileOutputStream fos = new FileOutputStream(this.getBitcodePath(id).toString());){
                fos.write(((CompilationResult)entry.getValue()).getTargetCode());
            }
            catch (IOException e) {
                throw new GraalError((Throwable)e);
            }
        });
    }

    private int createBitcodeBatches(BatchExecutor executor, DebugContext debug) {
        this.batchSize = (Integer)LLVMOptions.LLVMMaxFunctionsPerBatch.getValue();
        int numThreads = executor.executor.getExecutorService().getParallelism();
        int idealSize = NumUtil.divideAndRoundUp((int)this.methodIndex.length, (int)numThreads);
        if (idealSize < this.batchSize) {
            this.batchSize = idealSize;
        }
        if (this.batchSize == 0) {
            this.batchSize = this.methodIndex.length;
        }
        int numBatches = NumUtil.divideAndRoundUp((int)this.methodIndex.length, (int)this.batchSize);
        if (this.batchSize > 1) {
            numBatches -= (numBatches * this.batchSize - this.methodIndex.length) / this.batchSize;
            executor.forEach(numBatches, batchId -> debugContext -> {
                List<String> batchInputs = IntStream.range(this.getBatchStart(batchId), this.getBatchEnd(batchId)).mapToObj(this::getBitcodeFilename).collect(Collectors.toList());
                this.llvmLink(debug, this.getBatchBitcodeFilename(batchId), batchInputs);
            });
        }
        return numBatches;
    }

    private void compileBitcodeBatches(BatchExecutor executor, DebugContext debug, int numBatches) {
        this.stackMapDumper.startDumpingFunctions();
        executor.forEach(numBatches, batchId -> debugContext -> {
            this.llvmOptimize(debug, this.getBatchOptimizedFilename(batchId), this.getBatchBitcodeFilename(batchId));
            this.llvmCompile(debug, this.getBatchCompiledFilename(batchId), this.getBatchOptimizedFilename(batchId));
            LLVMStackMapInfo stackMap = this.objectFileReader.parseStackMap(this.getBatchCompiledPath(batchId));
            IntStream.range(this.getBatchStart(batchId), this.getBatchEnd(batchId)).forEach(id -> this.objectFileReader.readStackMap(stackMap, (CompilationResult)this.compilations.get(this.methodIndex[id]), (ResolvedJavaMethod)this.methodIndex[id], id));
        });
    }

    private void linkCompiledBatches(BatchExecutor executor, DebugContext debug, int numBatches) {
        List<String> compiledBatches = IntStream.range(0, numBatches).mapToObj(this::getBatchCompiledFilename).collect(Collectors.toList());
        this.nativeLink(debug, LLVMNativeImageCodeCache.getLinkedFilename(), compiledBatches);
        LLVMObjectFileReader.LLVMTextSectionInfo textSectionInfo = this.objectFileReader.parseCode(this.getLinkedPath());
        executor.forEach(this.compilations.entrySet(), entry -> debugContext -> {
            HostedMethod method = (HostedMethod)entry.getKey();
            int offset = textSectionInfo.getOffset(SubstrateUtil.uniqueShortName((ResolvedJavaMethod)method));
            int nextFunctionStartOffset = textSectionInfo.getNextOffset(offset);
            int functionSize = nextFunctionStartOffset - offset;
            CompilationResult compilation = (CompilationResult)entry.getValue();
            compilation.setTargetCode(null, functionSize);
            method.setCodeAddressOffset(offset);
        });
        this.compilations.forEach((method, compilation) -> this.compilationsByStart.put(method.getCodeAddressOffset(), compilation));
        this.stackMapDumper.dumpOffsets(textSectionInfo);
        this.stackMapDumper.close();
        HostedMethod firstMethod = (HostedMethod)this.getFirstCompilation().getMethods()[0];
        this.buildRuntimeMetadata(MethodPointer.factory((ResolvedJavaMethod)firstMethod), (UnsignedWord)WordFactory.signed((long)textSectionInfo.getCodeSize()));
    }

    private void llvmOptimize(DebugContext debug, String outputPath, String inputPath) {
        ArrayList<String> args = new ArrayList<String>();
        if (((Boolean)LLVMOptions.BitcodeOptimizations.getValue()).booleanValue()) {
            args.add("-disable-inlining");
            args.add("-O2");
        } else {
            args.add("-mem2reg");
        }
        args.add("-rewrite-statepoints-for-gc");
        args.add("-always-inline");
        args.add("-o");
        args.add(outputPath);
        args.add(inputPath);
        try {
            LLVMToolchain.runLLVMCommand("opt", this.basePath, args);
        }
        catch (LLVMToolchain.RunFailureException e) {
            debug.log("%s", (Object)e.getOutput());
            throw new GraalError("LLVM optimization failed for " + this.getFunctionName(inputPath) + ": " + e.getStatus() + "\nCommand: opt " + String.join((CharSequence)" ", args));
        }
    }

    private void llvmCompile(DebugContext debug, String outputPath, String inputPath) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-relocation-model=pic");
        args.add("--trap-unreachable");
        args.add("-march=" + LLVMTargetSpecific.get().getLLVMArchName());
        args.addAll(LLVMTargetSpecific.get().getLLCAdditionalOptions());
        args.add("-O" + SubstrateOptions.Optimize.getValue());
        args.add("-filetype=obj");
        args.add("-o");
        args.add(outputPath);
        args.add(inputPath);
        try {
            LLVMToolchain.runLLVMCommand("llc", this.basePath, args);
        }
        catch (LLVMToolchain.RunFailureException e) {
            debug.log("%s", (Object)e.getOutput());
            throw new GraalError("LLVM compilation failed for " + this.getFunctionName(inputPath) + ": " + e.getStatus() + "\nCommand: llc " + String.join((CharSequence)" ", args));
        }
    }

    private void llvmLink(DebugContext debug, String outputPath, List<String> inputPaths) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-o");
        args.add(outputPath);
        args.addAll(inputPaths);
        try {
            LLVMToolchain.runLLVMCommand("llvm-link", this.basePath, args);
        }
        catch (LLVMToolchain.RunFailureException e) {
            debug.log("%s", (Object)e.getOutput());
            throw new GraalError("LLVM linking failed into " + this.getFunctionName(outputPath) + ": " + e.getStatus());
        }
    }

    private void nativeLink(DebugContext debug, String outputPath, List<String> inputPaths) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(LLVMOptions.CustomLD.hasBeenSet() ? (String)LLVMOptions.CustomLD.getValue() : "ld");
        cmd.add("-r");
        cmd.add("-o");
        cmd.add(outputPath);
        cmd.addAll(inputPaths);
        try {
            LLVMToolchain.runCommand(this.basePath, cmd);
        }
        catch (LLVMToolchain.RunFailureException e) {
            debug.log("%s", (Object)e.getOutput());
            throw new GraalError("Native linking failed into " + this.getFunctionName(outputPath) + ": " + e.getStatus());
        }
    }

    private Path getBitcodePath(int id) {
        return this.basePath.resolve(this.getBitcodeFilename(id));
    }

    private String getBitcodeFilename(int id) {
        return "f" + id + ".bc";
    }

    private String getBatchBitcodeFilename(int id) {
        return (this.batchSize == 1 ? "f" : "b") + id + ".bc";
    }

    private String getBatchOptimizedFilename(int id) {
        return (this.batchSize == 1 ? "f" : "b") + id + "o.bc";
    }

    private Path getBatchCompiledPath(int id) {
        return this.basePath.resolve(this.getBatchCompiledFilename(id));
    }

    private String getBatchCompiledFilename(int id) {
        return (this.batchSize == 1 ? "f" : "b") + id + ".o";
    }

    private Path getLinkedPath() {
        return this.basePath.resolve(LLVMNativeImageCodeCache.getLinkedFilename());
    }

    private static String getLinkedFilename() {
        return "llvm.o";
    }

    private int getBatchStart(int id) {
        return id * this.batchSize;
    }

    private int getBatchEnd(int id) {
        return Math.min((id + 1) * this.batchSize, this.methodIndex.length);
    }

    private String getFunctionName(String fileName) {
        String function;
        if (fileName.equals("llvm.o")) {
            function = "the final object file";
        } else {
            char type = fileName.charAt(0);
            String idString = fileName.substring(1, fileName.indexOf(46));
            if (idString.charAt(idString.length() - 1) == 'o') {
                idString = idString.substring(0, idString.length() - 1);
            }
            int id = Integer.parseInt(idString);
            switch (type) {
                case 'f': {
                    function = this.methodIndex[id].getQualifiedName();
                    break;
                }
                case 'b': {
                    function = "batch " + id + " (f" + this.getBatchStart(id) + "-f" + this.getBatchEnd(id) + "). Use -H:LLVMMaxFunctionsPerBatch=1 to compile each method individually.";
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere();
                }
            }
        }
        return function + " (" + this.basePath.resolve(fileName).toString() + ")";
    }

    public void patchMethods(DebugContext debug, RelocatableBuffer relocs, ObjectFile objectFile) {
        ObjectFile.Element rodataSection = objectFile.elementForName(SectionName.RODATA.getFormatDependentName(objectFile.getFormat()));
        ObjectFile.Element dataSection = objectFile.elementForName(SectionName.DATA.getFormatDependentName(objectFile.getFormat()));
        for (CompilationResult result : this.getCompilations().values()) {
            for (DataPatch dataPatch : result.getDataPatches()) {
                String symbolName;
                int offset;
                CGlobalDataReference reference;
                if (dataPatch.reference instanceof CGlobalDataReference) {
                    reference = (CGlobalDataReference)dataPatch.reference;
                    if (reference.getDataInfo().isSymbolReference()) {
                        objectFile.createUndefinedSymbol(reference.getDataInfo().getData().symbolName, 0, true);
                    }
                    offset = reference.getDataInfo().getOffset();
                    symbolName = (String)dataPatch.note;
                    if (reference.getDataInfo().getData().symbolName != null || objectFile.getOrCreateSymbolTable().getSymbol(symbolName) != null) continue;
                    objectFile.createDefinedSymbol(symbolName, dataSection, (long)offset + 0L, 0, false, true);
                    continue;
                }
                if (!(dataPatch.reference instanceof DataSectionReference)) continue;
                reference = (DataSectionReference)dataPatch.reference;
                offset = reference.getOffset();
                symbolName = (String)dataPatch.note;
                if (objectFile.getOrCreateSymbolTable().getSymbol(symbolName) != null) continue;
                objectFile.createDefinedSymbol(symbolName, rodataSection, (long)offset, 0, false, true);
            }
        }
    }

    public NativeBootImage.NativeTextSectionImpl getTextSectionImpl(RelocatableBuffer buffer, ObjectFile objectFile, NativeImageCodeCache codeCache) {
        return new NativeBootImage.NativeTextSectionImpl(buffer, objectFile, codeCache){

            protected void defineMethodSymbol(String name, boolean global, ObjectFile.Element section, HostedMethod method, CompilationResult result) {
                ObjectFile.Symbol symbol = this.objectFile.createUndefinedSymbol(name, 0, true);
                if (global) {
                    LLVMNativeImageCodeCache.this.globalSymbols.add(symbol);
                }
            }
        };
    }

    public void writeCode(RelocatableBuffer buffer) {
    }

    public Path[] getCCInputFiles(Path tempDirectory, String imageName) {
        Path bitcodeFileName;
        Path[] nativeImageFiles = super.getCCInputFiles(tempDirectory, imageName);
        Path[] allInputFiles = Arrays.copyOf(nativeImageFiles, nativeImageFiles.length + 1);
        allInputFiles[nativeImageFiles.length] = bitcodeFileName = this.getLinkedPath();
        return allInputFiles;
    }

    public List<ObjectFile.Symbol> getSymbols(ObjectFile objectFile, boolean onlyGlobal) {
        return this.globalSymbols;
    }

    private StackMapDumper getStackMapDumper(boolean enable) {
        if (enable) {
            return new EnabledStackMapDumper();
        }
        return new DisabledStackMapDumper();
    }

    private static class DisabledStackMapDumper
    implements StackMapDumper {
        private DisabledStackMapDumper() {
        }

        @Override
        public void dumpOffsets(LLVMObjectFileReader.LLVMTextSectionInfo textSectionInfo) {
        }

        @Override
        public void startDumpingFunctions() {
        }

        @Override
        public void startDumpingFunction(String methodSymbolName, int id, int totalFrameSize) {
        }

        @Override
        public void dumpCallSite(Call call, int actualPcOffset, SubstrateReferenceMap referenceMap) {
        }

        @Override
        public void endDumpingFunction() {
        }

        @Override
        public void close() {
        }
    }

    private class EnabledStackMapDumper
    implements StackMapDumper {
        private final FileWriter stackMapDump;
        private ThreadLocal<StringBuilder> functionDump;

        private EnabledStackMapDumper() {
            try {
                this.stackMapDump = new FileWriter((String)LLVMOptions.DumpLLVMStackMap.getValue());
            }
            catch (IOException e) {
                throw new GraalError((Throwable)e);
            }
            this.functionDump = new ThreadLocal();
        }

        @Override
        public void dumpOffsets(LLVMObjectFileReader.LLVMTextSectionInfo textSectionInfo) {
            this.dump("\nOffsets\n=======\n");
            textSectionInfo.forEachOffsetRange((startOffset, endOffset) -> {
                CompilationResult compilationResult = (CompilationResult)LLVMNativeImageCodeCache.this.compilationsByStart.get(startOffset);
                assert (startOffset + compilationResult.getTargetCodeSize() == endOffset) : compilationResult.getName();
                String methodName = textSectionInfo.getSymbol(startOffset);
                this.dump("[" + startOffset + "] " + methodName + " (" + compilationResult.getTargetCodeSize() + ")\n");
            });
        }

        @Override
        public void startDumpingFunctions() {
            this.dump("Patchpoints\n===========\n");
        }

        @Override
        public void startDumpingFunction(String methodSymbolName, int id, int totalFrameSize) {
            StringBuilder builder = new StringBuilder();
            builder.append(methodSymbolName);
            builder.append(" -> f");
            builder.append(id);
            builder.append(" (");
            builder.append(totalFrameSize);
            builder.append(")\n");
            this.functionDump.set(builder);
        }

        @Override
        public void dumpCallSite(Call call, int actualPcOffset, SubstrateReferenceMap referenceMap) {
            StringBuilder builder = this.functionDump.get();
            builder.append("  [");
            builder.append(actualPcOffset);
            builder.append("] -> ");
            builder.append(call.target != null ? ((HostedMethod)call.target).format("%H.%n") : "???");
            builder.append(" (");
            builder.append(call.pcOffset);
            builder.append(") ");
            referenceMap.dump(builder);
            builder.append("\n");
        }

        @Override
        public void endDumpingFunction() {
            this.dump(this.functionDump.get().toString());
        }

        @Override
        public void close() {
            try {
                this.stackMapDump.close();
            }
            catch (IOException e) {
                throw new GraalError((Throwable)e);
            }
        }

        private void dump(String str) {
            try {
                this.stackMapDump.write(str);
            }
            catch (IOException e) {
                throw new GraalError((Throwable)e);
            }
        }
    }

    public static interface StackMapDumper {
        public void dumpOffsets(LLVMObjectFileReader.LLVMTextSectionInfo var1);

        public void startDumpingFunctions();

        public void startDumpingFunction(String var1, int var2, int var3);

        public void dumpCallSite(Call var1, int var2, SubstrateReferenceMap var3);

        public void endDumpingFunction();

        public void close();
    }

    private static final class BatchExecutor {
        private CompletionExecutor executor;

        private BatchExecutor(BigBang bb, ForkJoinPool threadPool) {
            this.executor = new CompletionExecutor(bb, threadPool, bb.getHeartbeatCallback());
            this.executor.init();
        }

        private void forEach(int num, IntFunction<CompletionExecutor.DebugContextRunnable> callback) {
            try {
                this.executor.start();
                for (int i = 0; i < num; ++i) {
                    this.executor.execute(callback.apply(i));
                }
                this.executor.complete();
                this.executor.init();
            }
            catch (InterruptedException e) {
                throw new GraalError((Throwable)e);
            }
        }

        private <T> void forEach(Set<T> set, Function<T, CompletionExecutor.DebugContextRunnable> callback) {
            try {
                this.executor.start();
                for (T elem : set) {
                    this.executor.execute(callback.apply(elem));
                }
                this.executor.complete();
                this.executor.init();
            }
            catch (InterruptedException e) {
                throw new GraalError((Throwable)e);
            }
        }
    }
}

