/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.services;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.services.JVMCIPermission;
import jdk.vm.ci.services.Services;

public abstract class JVMCIServiceLocator {
    private static Void checkPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JVMCIPermission());
        }
        return null;
    }

    private JVMCIServiceLocator(Void ignore) {
    }

    protected JVMCIServiceLocator() {
        this(JVMCIServiceLocator.checkPermission());
        Services.exportJVMCITo(this.getClass());
    }

    public abstract <S> S getProvider(Class<S> var1);

    public static <S> List<S> getProviders(Class<S> service) {
        ArrayList<S> providers = new ArrayList<S>();
        for (JVMCIServiceLocator access : Services.load(JVMCIServiceLocator.class)) {
            S provider = access.getProvider(service);
            if (provider == null) continue;
            providers.add(provider);
        }
        return providers;
    }
}

