/*
 * Decompiled with CFR 0.152.
 */
package jdk.vm.ci.services;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import jdk.vm.ci.services.Services;
import jdk.vm.ci.services.SuppressFBWarnings;

class JVMCIClassLoaderFactory {
    JVMCIClassLoaderFactory() {
    }

    private static native void init(ClassLoader var0);

    private static ClassLoader newClassLoader() {
        Path jvmciDir = Paths.get(Services.getSavedProperty("java.home"), "lib", "jvmci");
        if (!Files.isDirectory(jvmciDir, new LinkOption[0])) {
            throw new InternalError(jvmciDir + " does not exist or is not a directory");
        }
        URL[] urls = JVMCIClassLoaderFactory.getJVMCIJarsUrls(jvmciDir);
        ClassLoader parent = JVMCIClassLoaderFactory.getJVMCIParentClassLoader(jvmciDir);
        return URLClassLoader.newInstance(urls, parent);
    }

    private static ClassLoader getJVMCIParentClassLoader(Path jvmciDir) {
        Path parentClassPathFile = jvmciDir.resolve("parentClassLoader.classpath");
        if (Files.exists(parentClassPathFile, new LinkOption[0])) {
            String[] entries;
            try {
                entries = new String(Files.readAllBytes(parentClassPathFile)).trim().split(File.pathSeparator);
            }
            catch (IOException e) {
                throw new InternalError("Error reading " + parentClassPathFile.toAbsolutePath(), e);
            }
            URL[] urls = new URL[entries.length];
            for (int i = 0; i < entries.length; ++i) {
                try {
                    if (entries[i].isEmpty()) {
                        throw new InternalError("Class path entry " + i + " in " + parentClassPathFile + " is empty");
                    }
                    Path path = jvmciDir.resolve(entries[i]);
                    if (!Files.exists(path, new LinkOption[0])) {
                        String errorMsg = "Class path entry " + i + " in " + parentClassPathFile + " refers to a file or directory that does not exist: \"" + entries[i] + "\"";
                        if (!path.toString().equals(entries[i])) {
                            errorMsg = errorMsg + " (resolved: \"" + path + "\")";
                        }
                        throw new InternalError(errorMsg);
                    }
                    urls[i] = path.toUri().toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new InternalError(e);
                }
            }
            ClassLoader parent = null;
            return URLClassLoader.newInstance(urls, parent);
        }
        return null;
    }

    private static Path ensureExists(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new InternalError("Required JVMCI jar is missing: " + path);
        }
        return path;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="jvmciDir is guaranteed by the caller to be a directory")
    private static URL[] getJVMCIJarsUrls(Path jvmciDir) {
        String[] dirEntries = jvmciDir.toFile().list();
        String append = Services.getSavedProperty("jvmci.class.path.append");
        String[] appendEntries = append != null ? append.split(File.pathSeparator) : new String[]{};
        ArrayList<URL> urls = new ArrayList<URL>(dirEntries.length + appendEntries.length);
        try {
            urls.add(JVMCIClassLoaderFactory.ensureExists(jvmciDir.resolve("jvmci-api.jar")).toUri().toURL());
            urls.add(JVMCIClassLoaderFactory.ensureExists(jvmciDir.resolve("jvmci-hotspot.jar")).toUri().toURL());
            for (String e : dirEntries) {
                if (!e.endsWith(".jar") || e.equals("jvmci-api.jar") || e.equals("jvmci-hotspot.jar")) continue;
                urls.add(jvmciDir.resolve(e).toUri().toURL());
            }
            for (int i = 0; i < appendEntries.length; ++i) {
                Path path = Paths.get(appendEntries[i], new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    String errorMsg = "Entry " + i + " of class path specified by jvmci.class.path.append system property refers to a file or directory that does not exist: \"" + appendEntries[i] + "\"";
                    throw new InternalError(errorMsg);
                }
                urls.add(path.toUri().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new InternalError(e);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    static {
        JVMCIClassLoaderFactory.init(JVMCIClassLoaderFactory.newClassLoader());
    }
}

