/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.ShortPointer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.Indexer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.Raw;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.ShortArrayIndexer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.ShortBufferIndexer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.ShortRawIndexer;
import java.nio.ShortBuffer;

public abstract class ShortIndexer
extends Indexer {
    public static final int VALUE_BYTES = 2;

    protected ShortIndexer(long[] sizes, long[] strides) {
        super(sizes, strides);
    }

    public static ShortIndexer create(short[] array) {
        return new ShortArrayIndexer(array);
    }

    public static ShortIndexer create(ShortBuffer buffer) {
        return new ShortBufferIndexer(buffer);
    }

    public static ShortIndexer create(ShortPointer pointer) {
        return ShortIndexer.create(pointer, new long[]{pointer.limit() - pointer.position()}, ONE_STRIDE);
    }

    public static ShortIndexer create(short[] array, long ... sizes) {
        return new ShortArrayIndexer(array, sizes);
    }

    public static ShortIndexer create(ShortBuffer buffer, long ... sizes) {
        return new ShortBufferIndexer(buffer, sizes);
    }

    public static ShortIndexer create(ShortPointer pointer, long ... sizes) {
        return ShortIndexer.create(pointer, sizes, ShortIndexer.strides(sizes));
    }

    public static ShortIndexer create(short[] array, long[] sizes, long[] strides) {
        return new ShortArrayIndexer(array, sizes, strides);
    }

    public static ShortIndexer create(ShortBuffer buffer, long[] sizes, long[] strides) {
        return new ShortBufferIndexer(buffer, sizes, strides);
    }

    public static ShortIndexer create(ShortPointer pointer, long[] sizes, long[] strides) {
        return ShortIndexer.create(pointer, sizes, strides, true);
    }

    public static ShortIndexer create(final ShortPointer pointer, long[] sizes, long[] strides, boolean direct) {
        if (direct) {
            return Raw.getInstance() != null ? new ShortRawIndexer(pointer, sizes, strides) : new ShortBufferIndexer(pointer.asBuffer(), sizes, strides);
        }
        final long position = pointer.position();
        short[] array = new short[(int)Math.min(pointer.limit() - position, Integer.MAX_VALUE)];
        pointer.get(array);
        return new ShortArrayIndexer(array, sizes, strides){

            @Override
            public void release() {
                pointer.position(position).put(this.array);
                super.release();
            }
        };
    }

    public abstract short get(long var1);

    public ShortIndexer get(long i, short[] s) {
        return this.get(i, s, 0, s.length);
    }

    public abstract ShortIndexer get(long var1, short[] var3, int var4, int var5);

    public abstract short get(long var1, long var3);

    public ShortIndexer get(long i, long j, short[] s) {
        return this.get(i, j, s, 0, s.length);
    }

    public abstract ShortIndexer get(long var1, long var3, short[] var5, int var6, int var7);

    public abstract short get(long var1, long var3, long var5);

    public abstract short get(long ... var1);

    public ShortIndexer get(long[] indices, short[] s) {
        return this.get(indices, s, 0, s.length);
    }

    public abstract ShortIndexer get(long[] var1, short[] var2, int var3, int var4);

    public abstract ShortIndexer put(long var1, short var3);

    public ShortIndexer put(long i, short ... s) {
        return this.put(i, s, 0, s.length);
    }

    public abstract ShortIndexer put(long var1, short[] var3, int var4, int var5);

    public abstract ShortIndexer put(long var1, long var3, short var5);

    public ShortIndexer put(long i, long j, short ... s) {
        return this.put(i, j, s, 0, s.length);
    }

    public abstract ShortIndexer put(long var1, long var3, short[] var5, int var6, int var7);

    public abstract ShortIndexer put(long var1, long var3, long var5, short var7);

    public abstract ShortIndexer put(long[] var1, short var2);

    public ShortIndexer put(long[] indices, short ... s) {
        return this.put(indices, s, 0, s.length);
    }

    public abstract ShortIndexer put(long[] var1, short[] var2, int var3, int var4);

    @Override
    public double getDouble(long ... indices) {
        return this.get(indices);
    }

    @Override
    public ShortIndexer putDouble(long[] indices, double s) {
        return this.put(indices, (short)s);
    }
}

