/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.IntIndexer;

public class IntArrayIndexer
extends IntIndexer {
    protected int[] array;

    public IntArrayIndexer(int[] array) {
        this(array, new long[]{array.length}, ONE_STRIDE);
    }

    public IntArrayIndexer(int[] array, long ... sizes) {
        this(array, sizes, IntArrayIndexer.strides(sizes));
    }

    public IntArrayIndexer(int[] array, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public int[] array() {
        return this.array;
    }

    @Override
    public int get(long i) {
        return this.array[(int)i];
    }

    @Override
    public IntIndexer get(long i, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.array[(int)i * (int)this.strides[0] + n];
        }
        return this;
    }

    @Override
    public int get(long i, long j) {
        return this.array[(int)i * (int)this.strides[0] + (int)j];
    }

    @Override
    public IntIndexer get(long i, long j, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n];
        }
        return this;
    }

    @Override
    public int get(long i, long j, long k) {
        return this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k];
    }

    @Override
    public int get(long ... indices) {
        return this.array[(int)this.index(indices)];
    }

    @Override
    public IntIndexer get(long[] indices, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.array[(int)this.index(indices) + n];
        }
        return this;
    }

    @Override
    public IntIndexer put(long i, int n) {
        this.array[(int)i] = n;
        return this;
    }

    @Override
    public IntIndexer put(long i, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + n] = m[offset + n];
        }
        return this;
    }

    @Override
    public IntIndexer put(long i, long j, int n) {
        this.array[(int)i * (int)this.strides[0] + (int)j] = n;
        return this;
    }

    @Override
    public IntIndexer put(long i, long j, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] = m[offset + n];
        }
        return this;
    }

    @Override
    public IntIndexer put(long i, long j, long k, int n) {
        this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] = n;
        return this;
    }

    @Override
    public IntIndexer put(long[] indices, int n) {
        this.array[(int)this.index((long[])indices)] = n;
        return this;
    }

    @Override
    public IntIndexer put(long[] indices, int[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)this.index((long[])indices) + n] = m[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

