/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.BooleanIndexer;

public class BooleanArrayIndexer
extends BooleanIndexer {
    protected boolean[] array;

    public BooleanArrayIndexer(boolean[] array) {
        this(array, new long[]{array.length}, ONE_STRIDE);
    }

    public BooleanArrayIndexer(boolean[] array, long ... sizes) {
        this(array, sizes, BooleanArrayIndexer.strides(sizes));
    }

    public BooleanArrayIndexer(boolean[] array, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public boolean[] array() {
        return this.array;
    }

    @Override
    public boolean get(long i) {
        return this.array[(int)i];
    }

    @Override
    public BooleanIndexer get(long i, boolean[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[(int)i * (int)this.strides[0] + n];
        }
        return this;
    }

    @Override
    public boolean get(long i, long j) {
        return this.array[(int)i * (int)this.strides[0] + (int)j];
    }

    @Override
    public BooleanIndexer get(long i, long j, boolean[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n];
        }
        return this;
    }

    @Override
    public boolean get(long i, long j, long k) {
        return this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k];
    }

    @Override
    public boolean get(long ... indices) {
        return this.array[(int)this.index(indices)];
    }

    @Override
    public BooleanIndexer get(long[] indices, boolean[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[(int)this.index(indices) + n];
        }
        return this;
    }

    @Override
    public BooleanIndexer put(long i, boolean b) {
        this.array[(int)i] = b;
        return this;
    }

    @Override
    public BooleanIndexer put(long i, boolean[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + n] = b[offset + n];
        }
        return this;
    }

    @Override
    public BooleanIndexer put(long i, long j, boolean b) {
        this.array[(int)i * (int)this.strides[0] + (int)j] = b;
        return this;
    }

    @Override
    public BooleanIndexer put(long i, long j, boolean[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] = b[offset + n];
        }
        return this;
    }

    @Override
    public BooleanIndexer put(long i, long j, long k, boolean b) {
        this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] = b;
        return this;
    }

    @Override
    public BooleanIndexer put(long[] indices, boolean b) {
        this.array[(int)this.index((long[])indices)] = b;
        return this;
    }

    @Override
    public BooleanIndexer put(long[] indices, boolean[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)this.index((long[])indices) + n] = b[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

