/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.graalvm.visualvm.heapviewer.java.Bundle;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.lib.jfluid.heap.GCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;

public class InstanceNode
extends HeapViewerNode {
    private final Instance instance;
    private String name;
    private String logicalValue;
    private boolean isGCRoot;

    public InstanceNode(Instance instance) {
        this.instance = instance;
    }

    public String toString() {
        return this.getName(null);
    }

    public Mode getMode() {
        return Mode.NONE;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public JavaClass getJavaClass() {
        return this.instance.getJavaClass();
    }

    public String getName(Heap heap) {
        if (this.name == null) {
            if (heap == null) {
                return InstanceNode.computeName(heap, this.instance, Collections.EMPTY_LIST);
            }
            Collection gcRoots = heap.getGCRoots(this.instance);
            this.isGCRoot = !gcRoots.isEmpty();
            this.name = InstanceNode.computeName(heap, this.instance, gcRoots);
        }
        return this.name;
    }

    public String getLogicalValue(Heap heap) {
        if (this.logicalValue == null) {
            this.logicalValue = InstanceNode.computeLogicalValue(this.instance, heap);
        }
        return this.logicalValue;
    }

    public long getOwnSize() {
        return this.instance.getSize();
    }

    public long getRetainedSize(Heap heap) {
        return DataType.RETAINED_SIZE.valuesAvailable(heap) ? this.instance.getRetainedSize() : DataType.RETAINED_SIZE.getNotAvailableValue().longValue();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceNode)) {
            return false;
        }
        return this.instance.equals(((InstanceNode)((Object)o)).instance);
    }

    public int hashCode() {
        return this.instance.hashCode();
    }

    boolean isGCRoot() {
        return this.isGCRoot;
    }

    static String computeName(Instance instance, Heap heap) {
        List gcroots = heap == null ? Collections.EMPTY_LIST : heap.getGCRoots(instance);
        return InstanceNode.computeName(heap, instance, gcroots);
    }

    private static String computeName(Heap heap, Instance instance, Collection<GCRoot> gcroots) {
        JavaClass jcls;
        String name = null;
        String className = instance.getJavaClass().getName();
        if (heap != null && Class.class.getName().equals(className) && (jcls = heap.getJavaClassByID(instance.getInstanceId())) != null) {
            name = "class " + jcls.getName();
        }
        if (name == null) {
            name = className + "#" + instance.getInstanceNumber();
        }
        if (!gcroots.isEmpty()) {
            HashSet<String> gcKinds = new HashSet<String>();
            for (GCRoot gcroot : gcroots) {
                gcKinds.add(gcroot.getKind());
            }
            String kind = String.join((CharSequence)", ", gcKinds);
            name = Bundle.InstanceNode_GCRootFlag(name, kind);
        }
        return name;
    }

    static String computeLogicalValue(Instance instance, Heap heap) {
        String detail = DetailsSupport.getDetailsString((Instance)instance, (Heap)heap);
        return detail == null ? "" : detail;
    }

    protected Object getValue(DataType type, Heap heap) {
        if (type == DataType.NAME) {
            return this.getName(heap);
        }
        if (type == DataType.OWN_SIZE) {
            return this.getOwnSize();
        }
        if (type == DataType.RETAINED_SIZE) {
            return this.getRetainedSize(heap);
        }
        if (type == DataType.INSTANCE) {
            return this.getInstance();
        }
        if (type == DataType.CLASS) {
            return this.getJavaClass();
        }
        if (type == DataType.LOGICAL_VALUE) {
            return this.getLogicalValue(heap);
        }
        if (type == DataType.OBJECT_ID) {
            Instance i = this.getInstance();
            return i == null ? DataType.OBJECT_ID.getNoValue() : Long.valueOf(i.getInstanceId());
        }
        return super.getValue(type, heap);
    }

    @Override
    public InstanceNode createCopy() {
        if (this.instance == null) {
            return null;
        }
        InstanceNode copy = new InstanceNode(this.instance);
        this.setupCopy(copy);
        return copy;
    }

    protected void setupCopy(InstanceNode copy) {
        super.setupCopy(copy);
        copy.name = this.name;
        copy.logicalValue = this.logicalValue;
    }

    public static class IncludingNull
    extends InstanceNode {
        public IncludingNull(Instance instance) {
            super(instance);
        }

        @Override
        public JavaClass getJavaClass() {
            if (this.getInstance() == null) {
                return null;
            }
            return super.getJavaClass();
        }

        @Override
        public String getName(Heap heap) {
            if (this.getInstance() == null) {
                return "null";
            }
            return super.getName(heap);
        }

        @Override
        public String getLogicalValue(Heap heap) {
            if (this.getInstance() == null) {
                return DataType.LOGICAL_VALUE.getNoValue();
            }
            return super.getLogicalValue(heap);
        }

        @Override
        public long getOwnSize() {
            if (this.getInstance() == null) {
                return DataType.OWN_SIZE.getNoValue();
            }
            return super.getOwnSize();
        }

        @Override
        public long getRetainedSize(Heap heap) {
            if (this.getInstance() == null) {
                return DataType.RETAINED_SIZE.valuesAvailable(heap) ? DataType.RETAINED_SIZE.getNoValue().longValue() : DataType.RETAINED_SIZE.getNotAvailableValue().longValue();
            }
            return super.getRetainedSize(heap);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceNode)) {
                return false;
            }
            return Objects.equals(this.getInstance(), ((InstanceNode)((Object)o)).getInstance());
        }

        @Override
        public int hashCode() {
            return this.getInstance() == null ? 37 : super.hashCode();
        }

        @Override
        public boolean isLeaf() {
            return this.getInstance() == null ? true : super.isLeaf();
        }
    }

    public static enum Mode {
        NONE,
        OUTGOING_REFERENCE,
        INCOMING_REFERENCE;

    }
}

