/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.component.installer.remote;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graalvm.component.installer.Archive;
import org.graalvm.component.installer.ComponentParam;
import org.graalvm.component.installer.Feedback;
import org.graalvm.component.installer.InstallerStopException;
import org.graalvm.component.installer.model.ComponentInfo;
import org.graalvm.component.installer.persist.MetadataLoader;
import org.graalvm.component.installer.remote.FileDownloader;

public abstract class RemoteComponentParam
implements ComponentParam,
MetadataLoader {
    private final URL remoteURL;
    private final String dispName;
    private final String spec;
    private final Feedback feedback;
    private final ComponentInfo catalogInfo;
    private ComponentInfo fileInfo;
    private final boolean progress;
    private boolean verifyJars;
    private MetadataLoader fileLoader;
    private boolean complete;
    private Path localPath;
    private FileDownloader downloader;

    protected RemoteComponentParam(ComponentInfo catalogInfo, String dispName, String spec, Feedback feedback, boolean progress) {
        this.catalogInfo = catalogInfo;
        this.dispName = dispName;
        this.spec = spec;
        this.feedback = feedback.withBundle(RemoteComponentParam.class);
        this.progress = progress;
        this.remoteURL = catalogInfo.getRemoteURL();
    }

    protected RemoteComponentParam(URL remoteURL, String dispName, String spec, Feedback feedback, boolean progress) {
        this.catalogInfo = null;
        this.dispName = dispName;
        this.spec = spec;
        this.feedback = feedback.withBundle(RemoteComponentParam.class);
        this.remoteURL = remoteURL;
        this.progress = progress;
    }

    @Override
    public String getSpecification() {
        return this.spec;
    }

    @Override
    public String getDisplayName() {
        return this.dispName;
    }

    protected ComponentInfo getCatalogInfo() {
        return this.catalogInfo;
    }

    @Override
    public MetadataLoader createMetaLoader() throws IOException {
        if (this.catalogInfo != null) {
            return this;
        }
        return this.createFileLoader();
    }

    public void setVerifyJars(boolean verifyJars) {
        this.verifyJars = verifyJars;
    }

    @Override
    public MetadataLoader createFileLoader() throws IOException {
        if (this.fileLoader != null) {
            return this.fileLoader;
        }
        this.fileLoader = this.doCreateFileLoader(this.metadataFromLocal(this.downloadLocalFile()));
        return this.fileLoader;
    }

    protected MetadataLoader doCreateFileLoader(MetadataLoader delegate) {
        return new DelegateMetaLoader(delegate);
    }

    protected abstract MetadataLoader metadataFromLocal(Path var1) throws IOException;

    protected final FileDownloader getDownloader() {
        return this.downloader;
    }

    protected Path downloadLocalFile() throws IOException {
        if (this.localPath != null && Files.isReadable(this.localPath)) {
            return this.localPath;
        }
        try {
            FileDownloader dn = this.createDownloader();
            if (this.catalogInfo != null) {
                dn.setShaDigest(this.catalogInfo.getShaDigest());
            }
            dn.setDisplayProgress(this.progress);
            dn.download();
            this.localPath = dn.getLocalFile().toPath();
            this.downloader = dn;
        }
        catch (FileNotFoundException ex) {
            throw this.feedback.failure("REMOTE_ErrorDownloadingNotExist", ex, this.spec, this.remoteURL);
        }
        return this.localPath;
    }

    protected FileDownloader createDownloader() {
        FileDownloader dn = new FileDownloader(this.feedback.l10n("REMOTE_ComponentFileLabel", this.getDisplayName(), this.getSpecification()), this.remoteURL, this.feedback);
        return dn;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void close() throws IOException {
        if (this.fileLoader != null) {
            this.fileLoader.close();
        }
        if (this.localPath != null) {
            try {
                Files.deleteIfExists(this.localPath);
            }
            catch (IOException ex) {
                this.feedback.error("REMOTE_CannotDeleteLocalFile", ex, this.localPath.toString(), ex.getLocalizedMessage());
            }
        }
    }

    @Override
    public ComponentInfo getComponentInfo() {
        return this.fileInfo != null ? this.fileInfo : this.catalogInfo;
    }

    @Override
    public List<InstallerStopException> getErrors() {
        return Collections.emptyList();
    }

    @Override
    public Archive getArchive() {
        try {
            return this.createFileLoader().getArchive();
        }
        catch (IOException ex) {
            throw this.feedback.failure("REMOTE_ErrorDownloadingComponent", ex, this.spec, this.remoteURL, ex.getLocalizedMessage());
        }
    }

    @Override
    public String getLicenseType() {
        if (this.catalogInfo != null) {
            return this.catalogInfo.getLicenseType();
        }
        return null;
    }

    @Override
    public String getLicenseID() {
        String s = this.getLicensePath();
        if (s != null && s.contains("://")) {
            return s;
        }
        try {
            return this.createFileLoader().getLicenseID();
        }
        catch (IOException ex) {
            throw this.feedback.failure("REMOTE_ErrorDownloadingComponent", ex, this.spec, this.remoteURL, ex.getLocalizedMessage());
        }
    }

    @Override
    public String getLicensePath() {
        if (this.catalogInfo != null) {
            String lt = this.catalogInfo.getLicenseType();
            String path = this.catalogInfo.getLicensePath();
            if (lt == null || path != null) {
                return path;
            }
        }
        try {
            return this.createFileLoader().getLicensePath();
        }
        catch (IOException ex) {
            throw this.feedback.failure("REMOTE_ErrorDownloadingComponent", ex, this.spec, this.remoteURL, ex.getLocalizedMessage());
        }
    }

    @Override
    public MetadataLoader infoOnly(boolean only) {
        return this;
    }

    @Override
    public boolean isNoVerifySymlinks() {
        return true;
    }

    @Override
    public void loadPaths() {
    }

    @Override
    public Map<String, String> loadPermissions() throws IOException {
        return null;
    }

    @Override
    public Map<String, String> loadSymlinks() throws IOException {
        return null;
    }

    @Override
    public void setNoVerifySymlinks(boolean noVerifySymlinks) {
    }

    @Override
    public String getFullPath() {
        return this.remoteURL.toString();
    }

    @Override
    public String getShortName() {
        return this.getComponentInfo().getId();
    }

    protected String getSpec() {
        return this.spec;
    }

    protected Feedback getFeedback() {
        return this.feedback;
    }

    protected boolean isProgress() {
        return this.progress;
    }

    protected boolean isVerifyJars() {
        return this.verifyJars;
    }

    protected Path getLocalPath() {
        return this.localPath;
    }

    class DelegateMetaLoader
    implements MetadataLoader {
        private final MetadataLoader delegate;

        DelegateMetaLoader(MetadataLoader delegate) {
            this.delegate = delegate;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        protected final ComponentInfo catalogInfo() {
            return RemoteComponentParam.this.catalogInfo;
        }

        @Override
        public ComponentInfo getComponentInfo() {
            RemoteComponentParam.this.fileInfo = this.configureComponentInfo(this.delegate.getComponentInfo());
            RemoteComponentParam.this.complete = true;
            return RemoteComponentParam.this.fileInfo;
        }

        protected ComponentInfo configureComponentInfo(ComponentInfo info) {
            if (RemoteComponentParam.this.remoteURL != null) {
                info.setRemoteURL(RemoteComponentParam.this.remoteURL);
            }
            return info;
        }

        @Override
        public List<InstallerStopException> getErrors() {
            return this.delegate.getErrors();
        }

        @Override
        public Archive getArchive() throws IOException {
            return this.delegate.getArchive();
        }

        @Override
        public String getLicenseType() {
            return this.delegate.getLicenseType();
        }

        @Override
        public String getLicenseID() {
            String catalogLicense;
            if (RemoteComponentParam.this.catalogInfo != null && (catalogLicense = RemoteComponentParam.this.catalogInfo.getLicensePath()) != null && catalogLicense.contains("://")) {
                return catalogLicense;
            }
            return this.delegate.getLicenseID();
        }

        @Override
        public String getLicensePath() {
            return this.delegate.getLicensePath();
        }

        @Override
        public MetadataLoader infoOnly(boolean only) {
            return this.delegate.infoOnly(only);
        }

        @Override
        public boolean isNoVerifySymlinks() {
            return this.delegate.isNoVerifySymlinks();
        }

        @Override
        public void loadPaths() throws IOException {
            this.delegate.loadPaths();
        }

        @Override
        public Map<String, String> loadPermissions() throws IOException {
            return this.delegate.loadPermissions();
        }

        @Override
        public Map<String, String> loadSymlinks() throws IOException {
            return this.delegate.loadSymlinks();
        }

        @Override
        public void setNoVerifySymlinks(boolean noVerifySymlinks) {
            this.delegate.setNoVerifySymlinks(noVerifySymlinks);
        }

        @Override
        public ComponentInfo completeMetadata() throws IOException {
            return this.delegate.completeMetadata();
        }
    }
}

